/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.editor;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public class RecentFile
extends HashStructureAdapter {
    private static final String EXPLICIT = "explicit";
    private static final String WORKSPACE_URL = "workspaceURL";
    private static final String PROJECT_URL = "projectURL";
    private static final String NODE_URL = "nodeURL";
    private static final String EDITOR = "editor";
    private static final String NODE_CLASS = "nodeClass";
    private static final String RECENT_TIME = "recentTime";

    public RecentFile() {
        this(HashStructure.newInstance());
    }

    public RecentFile(Context context) {
        this();
        this.loadFromContext(context);
    }

    RecentFile(HashStructure hash) {
        super(hash);
    }

    public boolean isExplicit() {
        return this._hash.getBoolean(EXPLICIT);
    }

    public void setExplicit(boolean explicit) {
        this._hash.putBoolean(EXPLICIT, explicit);
    }

    public URL getWorkspaceURL() {
        return this._hash.getURL(WORKSPACE_URL);
    }

    public void setWorkspaceURL(URL workspaceURL) {
        this._hash.putURL(WORKSPACE_URL, workspaceURL);
    }

    public URL getProjectURL() {
        return this._hash.getURL(PROJECT_URL);
    }

    public void setProjectURL(URL projectURL) {
        this._hash.putURL(PROJECT_URL, projectURL);
    }

    public URL getNodeURL() {
        return this._hash.getURL(NODE_URL);
    }

    public void setNodeURL(URL nodeURL) {
        this._hash.putURL(NODE_URL, nodeURL);
    }

    public String getEditor() {
        return this._hash.getString(EDITOR);
    }

    public void setEditor(String editor) {
        this._hash.putString(EDITOR, editor);
    }

    public void setNodeClass(String nodeClass) {
        this._hash.putString(NODE_CLASS, nodeClass);
    }

    public String getNodeClass() {
        return this._hash.getString(NODE_CLASS);
    }

    public long getRecentTime() {
        return this._hash.getLong(RECENT_TIME);
    }

    public void setRecentTime(long time) {
        this._hash.putLong(RECENT_TIME, time);
    }

    public Context getContext() {
        Context ret = null;
        Node node = this._getNode();
        if (node != null) {
            Context ideContext = Context.newIdeContext(node);
            Project project = this._getProject();
            ideContext.setProject(project);
            Workspace workspace = this._getWorkspace();
            ideContext.setWorkspace(workspace);
            ret = ideContext;
        }
        return ret;
    }

    public boolean isSameNode(Context otherContext) {
        boolean ret = false;
        Node otherNode = otherContext.getNode();
        if (otherNode != null) {
            URL otherNodeURL = otherNode.getURL();
            URL thisNodeURL = this.getNodeURL();
            ret = RecentFile.areEqual(thisNodeURL, otherNodeURL);
        }
        return ret;
    }

    public boolean isValidNode() {
        Node node;
        boolean ret = false;
        if (this.isValid() && (node = this._getNode()) != null) {
            ret = true;
        }
        return ret;
    }

    public boolean equals(Object o) {
        RecentFile otherRecentFile;
        URL otherNodeURL;
        URL thisNodeURL;
        boolean ret = false;
        if (o == this) {
            ret = true;
        } else if (o instanceof RecentFile && RecentFile.areEqual(thisNodeURL = this.getNodeURL(), otherNodeURL = (otherRecentFile = (RecentFile)((Object)o)).getNodeURL())) {
            ret = true;
        }
        return ret;
    }

    public int hashCode() {
        URL url = this.getNodeURL();
        int ret = url != null ? url.hashCode() : super.hashCode();
        return ret;
    }

    private static boolean areEqual(URL url_1, URL url_2) {
        boolean ret = url_1 == null || url_2 == null ? false : (url_1 == url_2 ? true : ModelUtil.areEqual((Object)url_1.getPath(), (Object)url_2.getPath()) && ModelUtil.areEqual((Object)url_1.getProtocol(), (Object)url_2.getProtocol()) && ModelUtil.areEqual((Object)url_1.getUserInfo(), (Object)url_2.getUserInfo()) && url_1.getPort() == url_2.getPort() && ModelUtil.areEqual((Object)url_1.getQuery(), (Object)url_2.getQuery()) && ModelUtil.areEqual((Object)url_1.getRef(), (Object)url_2.getRef()));
        return ret;
    }

    private void loadFromContext(Context context) {
        Project project = context.getProject();
        Workspace workspace = context.getWorkspace();
        Node node = context.getNode();
        this._setProject(project);
        this._setWorkspace(workspace);
        this._setNode(node);
    }

    private static Node getNode(URL url) {
        Node node = null;
        if (url != null) {
            try {
                node = NodeFactory.findOrCreate(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return node;
    }

    private Workspace _getWorkspace() {
        Workspace workspace = null;
        URL workspaceURL = this.getWorkspaceURL();
        Node node = RecentFile.getNode(workspaceURL);
        if (node instanceof Workspace) {
            workspace = (Workspace)node;
        }
        return workspace;
    }

    private void _setWorkspace(Workspace workspace) {
        this.setWorkspaceURL(workspace != null ? workspace.getURL() : null);
    }

    private Project _getProject() {
        Project project = null;
        URL projectURL = this.getProjectURL();
        Node node = RecentFile.getNode(projectURL);
        if (node instanceof Project) {
            project = (Project)node;
        }
        return project;
    }

    private void _setProject(Project project) {
        this.setProjectURL(project != null ? project.getURL() : null);
    }

    private Node _getNode() {
        URL nodeURL = this.getNodeURL();
        Node node = null;
        try {
            node = RecentFile.getNode(nodeURL);
        }
        catch (Exception e) {
            System.err.println("RecentFile._getNode() fails for " + nodeURL);
        }
        return node;
    }

    private void _setNode(Node node) {
        this.setNodeURL(node != null ? node.getURL() : null);
    }

    boolean isValid() {
        return this.getNodeURL() != null;
    }
}

