/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.explorer;

import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.view.View;

public abstract class Explorer
extends View {
    public static final int SHOWN = 0;
    public static final int HIDDEN = 1;
    public static final int CLOSED = 2;
    protected Workspace defaultWorkspace;
    protected Project defaultProject;
    protected Node defaultNode;
    private String _defaultTitle;

    @Override
    public Controller getController() {
        return ExplorerManager.getExplorerManager();
    }

    @Override
    public void setOwner(View host) {
        super.setOwner(host);
    }

    public void setContext(Context context) {
        if (context != null) {
            this.defaultProject = context.getProject();
            this.defaultWorkspace = context.getWorkspace();
            this.defaultNode = context.getNode();
            this._defaultTitle = this.defaultNode != null ? this.defaultNode.getShortLabel() : null;
        }
    }

    public void stateChanged(int state) {
    }

    public String getTitle() {
        return this._defaultTitle;
    }

    @Override
    public ContextMenu getContextMenu() {
        View owner = this.owner();
        return owner != null ? owner.getContextMenu() : null;
    }
}

