/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension.rules.functions.util;

import java.lang.reflect.Field;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;

public final class ElementAttributeUtils {
    public static final String ELEMENT_ATTRIBUTE_PARAM_NAME = "element-attribute";

    public static final boolean isAttributeSet(Element[] elements, String attributeName, boolean mustBeSetOnAll) {
        int elementAttribute = ElementAttributeUtils.getElementAttribute(attributeName);
        if (elementAttribute < 0) {
            return false;
        }
        if (elements == null || elements.length == 0) {
            return false;
        }
        if (mustBeSetOnAll) {
            for (Element element : elements) {
                if (element.getAttributes().isSet(elementAttribute)) continue;
                return false;
            }
            return true;
        }
        for (Element element : elements) {
            if (!element.getAttributes().isSet(elementAttribute)) continue;
            return true;
        }
        return false;
    }

    public static final int getElementAttribute(String attributeName) {
        try {
            Field field = ElementAttributes.class.getField(attributeName);
            int fieldValue = field.getInt(ElementAttributes.class);
            return fieldValue;
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1;
    }
}

