/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.feedback;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import oracle.ide.Context;
import oracle.ide.ExitNotAllowedException;
import oracle.ide.feedback.FeedbackManagerCallback;
import oracle.ide.feedback.NullFeedbackManager;
import oracle.ide.feedback.shared.Feedback;
import oracle.ide.feedback.shared.MessageFeedback;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.view.View;
import oracle.javatools.jndi.Names;

public abstract class FeedbackManager {
    private static final String FEEDBACK_MANAGER_NAME = "ide/feedback-manager";
    private static FeedbackManager _nullManager;
    private static boolean _isOn;
    public static final String PROPERTY_EXCEPTIONS = "exceptions";
    public static final String PROPERTY_INTERNAL = "internal";
    private final PropertyChangeSupport _pcs;
    @GuardedBy(value="hasExceptionsLock")
    private boolean _hasExceptions;
    private final Object _hasExceptionsLock = new Object();
    private Collection<String> _apisToExcludeFromExceptionLogging = new HashSet<String>();
    private HashSet<String> _pkgsToExcludeFromLogHandler = new HashSet();
    private boolean _disableLogHandling = false;
    private List<String> _loggersToIgnore = new ArrayList<String>();
    List<FeedbackManagerCallback> feedbackParticipants = new ArrayList<FeedbackManagerCallback>();

    public FeedbackManager() {
        this._pcs = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._pcs.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this._pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this._pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this._pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        this._pcs.firePropertyChange(event);
    }

    protected abstract void addFeedbackImpl(Feedback var1);

    protected abstract void reportExceptionImpl(String var1, Throwable var2, boolean var3);

    protected abstract void reportExceptionImpl(String var1, Throwable var2, int var3, boolean var4);

    protected abstract void reportExceptionImpl(String var1, Throwable var2, int var3, boolean var4, String var5);

    protected abstract void reportApiExceptionImpl(String var1, Throwable var2, String var3, boolean var4);

    public static void addFeedback(String message) {
        if (FeedbackManager.isOn()) {
            MessageFeedback feedback = new MessageFeedback(message);
            FeedbackManager.getFeedbackManager().addFeedbackImpl(feedback);
        }
    }

    public static void addFeedback(String message, Context context) {
        if (FeedbackManager.isOn()) {
            if (context != null) {
                String contextMessage;
                View view = context.getView();
                if (view != null) {
                    Class<?> viewClass = view.getClass();
                    String viewName = viewClass.getSimpleName();
                    message = message + " [ from " + viewName + " ]";
                }
                if ((contextMessage = FeedbackManager.getContextMessage(context)) != null) {
                    message = message + " [ for " + contextMessage + " ]";
                }
            }
            MessageFeedback feedback = new MessageFeedback(message);
            FeedbackManager.getFeedbackManager().addFeedbackImpl(feedback);
        }
    }

    private static String getContextMessage(Context context) {
        Workspace workspace = context.getWorkspace();
        Project project = context.getProject();
        Node node = context.getNode();
        if (workspace != null || project != null || node != null) {
            String contextMessage = "( ";
            contextMessage = node != null ? contextMessage + node.getShortLabel() : contextMessage + "<none>";
            contextMessage = contextMessage + ", ";
            contextMessage = project != null ? contextMessage + project.getShortLabel() : contextMessage + "<none>";
            contextMessage = contextMessage + ", ";
            contextMessage = workspace != null ? contextMessage + workspace.getShortLabel() : contextMessage + "<none>";
            contextMessage = contextMessage + " )";
            return contextMessage;
        }
        return null;
    }

    public static boolean isOn() {
        return _isOn;
    }

    public static void reportException(String dialogHeader, String message, Throwable exception) {
        if (!(exception instanceof ExitNotAllowedException)) {
            FeedbackManager.getFeedbackManager().reportExceptionImpl(message, exception, 0, true, dialogHeader);
        }
    }

    public static void reportException(String message, Throwable exception) {
        FeedbackManager.reportException(null, message, exception);
    }

    public static void reportException(Throwable exception) {
        FeedbackManager.reportException("", exception);
    }

    public static void reportAPIException(String message, Throwable exception, String apiName) {
        FeedbackManager.getFeedbackManager().reportApiExceptionImpl(message, exception, apiName, true);
    }

    public static void reportAPIException(String message, Throwable exception, int apiDepth) {
        FeedbackManager.getFeedbackManager().reportExceptionImpl(message, exception, apiDepth, true);
    }

    public static FeedbackManager getFeedbackManager() {
        FeedbackManager feedbackManager = (FeedbackManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)FEEDBACK_MANAGER_NAME);
        if (feedbackManager == null) {
            return FeedbackManager.getNullFeedbackManager();
        }
        return feedbackManager;
    }

    private static FeedbackManager getNullFeedbackManager() {
        if (_nullManager == null) {
            _nullManager = new NullFeedbackManager();
        }
        return _nullManager;
    }

    protected static void setFeedbackManager(FeedbackManager feedbackManager) {
        _isOn = feedbackManager != null;
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)FEEDBACK_MANAGER_NAME, (Object)feedbackManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExceptions() {
        Object object = this._hasExceptionsLock;
        synchronized (object) {
            return this._hasExceptions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptions(boolean exceptions) {
        Object object = this._hasExceptionsLock;
        synchronized (object) {
            final boolean oldHasExceptions = this._hasExceptions;
            this._hasExceptions = exceptions;
            if (oldHasExceptions == exceptions) {
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FeedbackManager.this.firePropertyChange(FeedbackManager.PROPERTY_EXCEPTIONS, oldHasExceptions, FeedbackManager.this._hasExceptions);
                }
            });
        }
    }

    public void disableFeedbackOnLoggedExceptions(Collection<String> apinames) {
        if (apinames == null || apinames.size() == 0) {
            this._disableLogHandling = true;
        } else {
            for (String apiToExclude : apinames) {
                this._apisToExcludeFromExceptionLogging.add(apiToExclude);
            }
        }
    }

    public void disableFeedbackOnLoggingFromThesePackages(Set<String> packageNames) {
        for (String pkg : packageNames) {
            this._pkgsToExcludeFromLogHandler.add(pkg);
        }
    }

    public void enableFeedbackOnLoggedExceptions(Collection<String> apinames) {
        if (apinames == null || apinames.size() == 0) {
            return;
        }
        this._disableLogHandling = false;
        for (String apiToEnable : apinames) {
            this._apisToExcludeFromExceptionLogging.remove(apiToEnable);
        }
    }

    protected boolean isFeedbackLogHandlerDisabled() {
        return this._disableLogHandling;
    }

    protected Collection<String> getAPIsToExcludeFromLogHandling() {
        return this._apisToExcludeFromExceptionLogging;
    }

    public Set<String> getPackagesToExcludeFromLogHandling() {
        return this._pkgsToExcludeFromLogHandler;
    }

    public void registerCallback(FeedbackManagerCallback participant) {
        this.feedbackParticipants.add(participant);
    }

    public void unregisterCallback(FeedbackManagerCallback participant) {
        this.feedbackParticipants.remove(participant);
    }

    public List<FeedbackManagerCallback> getFeedbackParticipants() {
        return Collections.unmodifiableList(this.feedbackParticipants);
    }

    public boolean isIgnoredLogger(String loggerName) {
        for (String ignore : this._loggersToIgnore) {
            if (!loggerName.matches(ignore)) continue;
            return true;
        }
        return false;
    }

    public void setLoggersToIgnore(List<String> loggers) {
        this._loggersToIgnore = new ArrayList<String>();
        for (String logger : loggers) {
            this._loggersToIgnore.add(this.convertToRegex(logger));
        }
    }

    private String convertToRegex(String str) {
        StringBuffer result = new StringBuffer();
        int s = str.length();
        for (int i = 0; i < s; ++i) {
            char c = str.charAt(i);
            if (c == '.') {
                result.append("\\.");
                continue;
            }
            if (c == '*') {
                if (i + 1 < s) {
                    if (str.charAt(i + 1) == '*') {
                        result.append(".*");
                        ++i;
                        continue;
                    }
                    result.append("\\w*");
                    continue;
                }
                result.append("\\w*");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public void showFeedbackDialog(boolean reportEnabled) {
    }

    public void flush() throws IOException {
    }

    public void clearExceptions() {
    }
}

