/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.keyboard.KeyStrokeArb;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokeProfile;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

class KeyStrokeImporterExporter {
    private static final String SHORTCUT_FILE_EXTENSION = ".xml";
    private static final DefaultURLFilter URL_FILTER = new DefaultURLFilter(KeyStrokeArb.getString(39), ".xml");

    private KeyStrokeImporterExporter() {
    }

    static boolean importShortcuts(KeyStrokeOptions options) {
        int result;
        URLChooser chooser = DialogUtil.newURLChooser();
        chooser.clearChooseableURLFilters();
        chooser.addChooseableURLFilter((URLFilter)URL_FILTER);
        chooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
        chooser.setURLFilter((URLFilter)URL_FILTER);
        chooser.setHelpID("f1_idedimportshortcuts_html");
        URL homeDir = KeyStrokeImporterExporter.getUserHomeDirectory();
        if (homeDir != null) {
            chooser.setSelectedURL(homeDir);
        }
        if ((result = chooser.showOpenDialog((Component)((Object)Ide.getMainWindow()), KeyStrokeArb.getString(27))) == 0) {
            boolean success = true;
            try {
                URL url = chooser.getSelectedURL();
                KeyStrokeProfile imported = KeyStrokeProfile.importFrom(url);
                if (imported.getAllContexts().size() == 0) {
                    MessageDialog.information((Component)((Object)Ide.getMainWindow()), (Object)KeyStrokeArb.getString(29), (String)KeyStrokeArb.getString(28), null);
                    return false;
                }
                if (MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)KeyStrokeArb.getString(31), (String)KeyStrokeArb.getString(30), null)) {
                    KeyStrokeImporterExporter.doImport(options, imported);
                }
            }
            catch (IOException ioe) {
                ExceptionDialog.showExceptionDialog((Window)((Object)Ide.getMainWindow()), (Exception)ioe);
                success = false;
            }
            return success;
        }
        return false;
    }

    private static void doImport(KeyStrokeOptions options, KeyStrokeProfile profile) {
        KeyStrokeMap globalKeyMap = options.getGlobalKeyMap();
        HashMap localKeyMap = options.getLocalKeyMaps();
        globalKeyMap.removeAll();
        localKeyMap.clear();
        List<String> allContexts = profile.getAllContexts();
        for (String contextName : allContexts) {
            KeyStrokeMap localMap;
            KeyStrokeMap globalMap = profile.getKeyStrokeMapForContext(contextName, true);
            if (globalMap != null) {
                globalKeyMap.putAll(globalMap);
            }
            if ((localMap = profile.getKeyStrokeMapForContext(contextName, false)) != null) {
                localKeyMap.put(contextName, localMap);
                continue;
            }
            localKeyMap.remove(contextName);
        }
    }

    static void exportCurrentShortcuts(KeyStrokeContextRegistry registry, KeyStrokeOptions kso) {
        ExportURLChooser chooser = new ExportURLChooser();
        DialogUtil.initURLChooser(chooser, null);
        URL baseURL = KeyStrokeImporterExporter.getUserHomeDirectory();
        if (baseURL != null) {
            chooser.setSelectedURL(baseURL);
        }
        chooser.clearChooseableURLFilters();
        chooser.addChooseableURLFilter((URLFilter)URL_FILTER);
        chooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
        chooser.setURLFilter((URLFilter)URL_FILTER);
        int result = chooser.showSaveDialog((Component)((Object)Ide.getMainWindow()), KeyStrokeArb.getString(32));
        if (result == 0) {
            URL url = chooser.getSelectedURL();
            if ("".equals(URLFileSystem.getSuffix((URL)url))) {
                url = URLFileSystem.convertSuffix((URL)url, (String)"", (String)SHORTCUT_FILE_EXTENSION);
            }
            try {
                KeyStrokeProfile profile = KeyStrokeProfile.newProfileForExport(registry, kso);
                profile.exportTo(url);
            }
            catch (Exception e) {
                e.printStackTrace();
                String message = KeyStrokeArb.format(34, URLFileSystem.getPlatformPathName((URL)url), e.toString());
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)message, (String)KeyStrokeArb.getString(33), null);
            }
        }
    }

    private static URL getUserHomeDirectory() {
        URL url = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
        return URLFileSystem.exists((URL)url) ? url : null;
    }

    private static class ExportURLChooser
    extends URLChooser {
        public ExportURLChooser() {
            this.setHelpID("f1_idedexportshortcuts_html");
        }

        @Override
        public boolean approveSelection() {
            return super.approveSelection() && this.checkExistingFile() && this.checkReadOnlyFile();
        }

        private boolean checkExistingFile() {
            URL url = this.getSelectedURL();
            if (URLFileSystem.exists((URL)url)) {
                String message = KeyStrokeArb.format(36, URLFileSystem.getPlatformPathName((URL)url));
                String title = KeyStrokeArb.getString(35);
                return MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)message, (String)title, null, (boolean)true);
            }
            return true;
        }

        private boolean checkReadOnlyFile() {
            URL url = this.getSelectedURL();
            if (URLFileSystem.isReadOnly((URL)url)) {
                String message = KeyStrokeArb.format(38, URLFileSystem.getPlatformPathName((URL)url));
                String title = KeyStrokeArb.getString(37);
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)message, (String)title, null);
                return false;
            }
            return true;
        }
    }
}

