/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeArb;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.Colors;

public final class PresetsPanel
extends JPanel
implements MouseListener {
    private final DefaultListModel _presetModel = new DefaultListModel();
    private final JList _jlPresets = new JList(this._presetModel);
    private DismissableJEWTDialog _container;

    static String run(Frame frame, String sCurrentPreset) {
        DismissableJEWTDialog dlg;
        String sRet = null;
        PresetsPanel panel = new PresetsPanel();
        panel.setPreset(sCurrentPreset);
        HelpSystem.getHelpSystem().registerTopic(panel, "f1_idedloadpreset_html");
        panel._container = dlg = new DismissableJEWTDialog(frame);
        dlg.setInitialFocus(panel._jlPresets);
        dlg.setContent(panel);
        if (WizardLauncher.runDialog((JDialog)((Object)dlg))) {
            sRet = panel.getPreset();
        }
        return sRet;
    }

    private PresetsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        MultiLineLabel lblHint = new MultiLineLabel(WordWrapper.getTextWrapper(), KeyStrokeArb.getString(21));
        lblHint.setPreferredAspectRatio(8.0f);
        lblHint.setForeground(Colors.HINT_TEXT);
        JLabel lblPresets = new JLabel();
        ResourceUtils.resLabel((JLabel)lblPresets, (Component)this._jlPresets, (String)KeyStrokeArb.getString(22));
        JScrollPane sp = new JScrollPane(this._jlPresets);
        this.add((Component)lblHint, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)lblPresets, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)sp, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 167, 60));
        this.fillPresets();
        this._jlPresets.addMouseListener(this);
    }

    private String getPreset() {
        String sRet = null;
        Object oSel = this._jlPresets.getSelectedValue();
        if (oSel != null) {
            sRet = oSel.toString();
        }
        return sRet;
    }

    private void setPreset(String sPreset) {
        this._jlPresets.setSelectedValue(sPreset, true);
    }

    private void fillPresets() {
        HashSet presets = new HashSet(5);
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        Iterator iter = kscr.getAllContexts();
        while (iter.hasNext()) {
            KeyStrokeContext ksc = (KeyStrokeContext)iter.next();
            List lst = ksc.getAllPresets();
            if (lst == null) continue;
            for (int i = 0; i < lst.size(); ++i) {
                lst.set(i, lst.get(i).toString());
            }
            presets.addAll(lst);
        }
        int nPresets = presets.size();
        String[] sPresets = presets.toArray(new String[nPresets]);
        Arrays.sort(sPresets, String.CASE_INSENSITIVE_ORDER);
        this._presetModel.removeAllElements();
        for (int i = 0; i < nPresets; ++i) {
            String s = sPresets[i];
            this._presetModel.addElement(s);
        }
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
        int index;
        if (e.getClickCount() == 2 && (index = this._jlPresets.locationToIndex(e.getPoint())) != -1) {
            this._container.dismiss();
        }
    }

    @Override
    public final void mousePressed(MouseEvent e) {
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
    }

    @Override
    public final void mouseExited(MouseEvent e) {
    }

    private static final class DismissableJEWTDialog
    extends JEWTDialog {
        public DismissableJEWTDialog(Frame owner) {
            super(owner, KeyStrokeArb.getString(20), 7);
        }

        private void dismiss() {
            this.dismissDialog(false);
        }
    }
}

