/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.layout;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layout;
import oracle.ide.model.ElementAttributes;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.LayoutArb;
import oracle.ide.util.OrderedProperties;

public class SimpleLayout
extends Layout {
    private OrderedProperties _properties;
    private IdeLayout _owner;

    public SimpleLayout(URL url) {
        super(url);
        this.getAttributes().set(ElementAttributes.DELETEABLE);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        this.ensureOpen();
        return this._properties.getProperty(key, defaultValue);
    }

    @Override
    public Object setProperty(String key, String value) {
        this.ensureOpen();
        this.markDirty(true);
        if (value != null) {
            return this._properties.setProperty(key, value);
        }
        return this._properties.remove(key);
    }

    @Override
    public Object removeProperty(String key) {
        return this._properties.remove(key);
    }

    public boolean isPropertySet(String key, String value, String defaultValue) {
        String actualValue = this.getProperty(key, defaultValue);
        if (actualValue == null) {
            return false;
        }
        return actualValue.equalsIgnoreCase(value);
    }

    @Override
    public IdeLayout getOwner() {
        return this._owner;
    }

    @Override
    public void setOwner(IdeLayout owner) {
        this._owner = owner;
    }

    @Override
    public Icon getIcon() {
        return LayoutArb.getIcon(0);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URL url = this.getURL();
        return new BufferedInputStream(URLFileSystem.openInputStream((URL)url));
    }

    private OutputStream getOutputStream() throws IOException {
        URL url = this.getURL();
        return URLFileSystem.openOutputStream((URL)url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void openImpl() throws IOException {
        this._properties = new OrderedProperties();
        super.openImpl();
        InputStream bis = null;
        try {
            bis = this.getInputStream();
            this._properties.load(bis);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
    }

    @Override
    protected void closeImpl() throws IOException {
        super.closeImpl();
        this._properties = null;
        this._owner = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveImpl() throws IOException {
        if (this._properties != null) {
            OutputStream fos = this.getOutputStream();
            try {
                this._properties.store(fos, "Layout 5.0");
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((SimpleLayout)o);
    }

    protected final boolean equalsImpl(SimpleLayout other) {
        return super.equalsImpl(other);
    }
}

