/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.migration;

import java.util.List;
import javax.ide.util.MetaClass;
import net.jcip.annotations.GuardedBy;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.TechnologyScope;

public class NodeMigratorHelperReference
implements Comparable<NodeMigratorHelperReference> {
    private static final int MAX_WEIGHT = 100000;
    private static volatile int weight_counter = 0;
    private final String key;
    private final String version;
    private final MetaClass<NodeMigratorHelper> migratorType;
    private final Integer weight;
    private final TechnologyScope techScope;
    @GuardedBy(value="this")
    private NodeMigratorHelper migrator;

    public NodeMigratorHelperReference(String key, String version, MetaClass<NodeMigratorHelper> migratorType, Integer weight) {
        this(key, version, migratorType, weight, null);
    }

    NodeMigratorHelperReference(String key, String version, MetaClass<NodeMigratorHelper> migratorType, Integer weight, List<String> techKeys) {
        int n;
        this.key = key;
        this.version = version;
        this.migratorType = migratorType;
        if (weight != null) {
            n = weight;
        } else {
            int n2 = weight_counter;
            n = n2;
            weight_counter = n2 + 1;
        }
        this.weight = n % 100000;
        this.techScope = new TechnologyScope();
        if (techKeys != null) {
            this.techScope.setTechnologyKeys(techKeys.toArray(new String[techKeys.size()]));
        }
    }

    public NodeMigratorHelperReference(NodeMigratorHelper helper) {
        this.key = helper.getNodeMigratorHelperKey();
        this.version = helper.getNodeMigratorHelperVersion();
        this.migratorType = null;
        this.migrator = helper;
        this.weight = weight_counter++ % 100000;
        this.techScope = new TechnologyScope();
    }

    public String key() {
        return this.key;
    }

    public String version() {
        return this.version;
    }

    public Class<?> migratorClass() {
        if (this.migratorType != null) {
            try {
                return this.migratorType.toClass();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.migrator.getClass();
    }

    public String migratorClassName() {
        if (this.migratorType != null) {
            return this.migratorType.getClassName();
        }
        return this.migrator.getClass().getName();
    }

    public TechnologyScope getTechnologyScope() {
        return new TechnologyScope(this.techScope);
    }

    public synchronized NodeMigratorHelper migrator() {
        if (this.migrator != null) {
            return this.migrator;
        }
        try {
            this.migrator = (NodeMigratorHelper)this.migratorType.newInstance();
            return this.migrator;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(NodeMigratorHelperReference ref) {
        return this.weight.compareTo(ref.weight);
    }
}

