/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.text.Collator;
import java.util.Comparator;
import oracle.ide.explorer.CellRendererAttributes;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.util.BitField;

public class DefaultFilter
extends ChildFilter {
    public static final Comparator folderFirstComparator = new SortedFolderFirstComparator(false);
    private static final Comparator folderFirstComparator2 = new SortedFolderFirstComparator(true);

    @Override
    public Comparator getComparator() {
        return this.checkElementAttributes() ? folderFirstComparator2 : folderFirstComparator;
    }

    protected void refreshExplorerNode(TNode tnode) {
        TreeExplorer explorer;
        if (tnode != null && (explorer = tnode.getOwner()) != null) {
            explorer.refresh(tnode);
        }
    }

    private boolean checkElementAttributes() {
        TreeExplorer texp;
        if (this.getOwner() != null && (texp = this.getOwner().getOwner()) != null) {
            return texp.getCellRendererAttributes().isSet(CellRendererAttributes.HIDE_CHILDREN);
        }
        return false;
    }

    private static class SortedFolderFirstComparator
    extends SortedComparator {
        private boolean _checkAttributes;

        public SortedFolderFirstComparator() {
        }

        protected SortedFolderFirstComparator(boolean checkAttributes) {
            this._checkAttributes = checkAttributes;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.getClass() == obj.getClass() && this._checkAttributes == ((SortedFolderFirstComparator)obj)._checkAttributes;
        }

        @Override
        protected int compareElements(Element e1, Element e2) {
            if (this.isFolder(e1) != this.isFolder(e2)) {
                return this.isFolder(e1) ? this.compareUnlikeElementToElement(e1, e2) : -this.compareUnlikeElementToElement(e2, e1);
            }
            return super.compareElements(e1, e2);
        }

        protected int compareUnlikeElementToElement(Element f, Element e) {
            return -1;
        }

        protected boolean isFolder(Element e) {
            if (e == null || !e.mayHaveChildren()) {
                return false;
            }
            if (this._checkAttributes) {
                return !e.getAttributes().isSet(ElementAttributes.HIDE_CHILDREN);
            }
            return true;
        }
    }

    private static class SortedComparator
    implements Comparator {
        public static final int SORT_ALPHA = 1;
        public static final int SORT_BY_TYPE = 2;
        private int _options = 1;
        protected static final Collator collator = Collator.getInstance();

        private SortedComparator() {
        }

        public int getOptions() {
            return this._options;
        }

        public void setOptions(int options) {
            this._options = options;
        }

        public final int compare(Object o1, Object o2) {
            return this.compareTNodes((TNode)o1, (TNode)o2);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.getClass() == obj.getClass();
        }

        protected int compareTNodes(TNode t1, TNode t2) {
            return this.compareElements(t1.getData(), t2.getData());
        }

        protected int compareElements(Element e1, Element e2) {
            return this.compareElementToElement(e1, e2);
        }

        protected int compareElementToElement(Element e1, Element e2) {
            if (BitField.isSet(2, this.getOptions())) {
                return this.sortByType(e1, e2);
            }
            int result = this.compareStrings(e1.getShortLabel(), e2.getShortLabel());
            if (result != 0) {
                return result;
            }
            return this.compareStrings(e1.getLongLabel(), e2.getLongLabel());
        }

        protected int compareStrings(String s1, String s2) {
            if (s1 == null) {
                return s2 == null ? 0 : 1;
            }
            if (s2 == null) {
                return -1;
            }
            return collator.compare(s1, s2);
        }

        private String getPrefix(Element e) {
            if (e.getIcon() != null) {
                return e.getIcon().toString();
            }
            return "";
        }

        private int sortByType(Element e1, Element e2) {
            String p1 = this.getPrefix(e1);
            String p2 = this.getPrefix(e2);
            int result = this.compareStrings(p1 + e1.getShortLabel(), p2 + e2.getShortLabel());
            if (result != 0) {
                return result;
            }
            return this.compareStrings(p1 + e1.getLongLabel(), p2 + e2.getLongLabel());
        }
    }
}

