/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import javax.ide.util.MetaClass;
import oracle.ide.model.Node;
import oracle.ide.model.Recognizer;
import oracle.ide.model.RecognizersHook;
import oracle.ide.net.URLFileSystem;

public class FileContentPatternRecognizer
extends Recognizer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetaClass<? extends Node> recognizeAsMeta(URL url) {
        if (!URLFileSystem.canRead((URL)url)) {
            return null;
        }
        String extension = URLFileSystem.getSuffix((URL)url);
        if (extension == null || extension.length() == 0) {
            return null;
        }
        File fileExtension = new File(extension);
        RecognizersHook hook = RecognizersHook.getHook();
        for (FileContentPatternRule rule : hook.patternMappings().get(fileExtension)) {
            if (rule == null) continue;
            InputStream stream = null;
            try {
                stream = url.openStream();
                BufferedReader r = new BufferedReader(new InputStreamReader(stream));
                String line = r.readLine();
                for (int linesRead = 0; line != null && linesRead < rule.maxLines; ++linesRead) {
                    line = line.trim();
                    for (String pattern : rule.patterns) {
                        if (!line.startsWith(pattern)) continue;
                        MetaClass<Node> metaClass = rule.nodeType;
                        return metaClass;
                    }
                    line = r.readLine();
                }
            }
            catch (Exception ex) {}
            continue;
            finally {
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (Exception ex) {}
            }
        }
        return null;
    }

    public static class FileContentPatternRule {
        final int maxLines;
        final String[] patterns;
        final MetaClass<Node> nodeType;

        public FileContentPatternRule(int maxLines, String[] patterns, MetaClass<Node> nodeType) {
            this.maxLines = maxLines;
            this.patterns = patterns == null ? new String[0] : Arrays.copyOf(patterns, patterns.length);
            this.nodeType = nodeType;
        }
    }
}

