/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.net.URL;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.migration.XMLMigrator;
import oracle.ide.model.IdeSystem;
import oracle.ide.model.Preferences;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.ModelArb;

public final class IdeSystemMigrator
extends XMLMigrator {
    private static final String DEFAULT_WORKSPACE_DIR = "DefaultWorkspace";
    private static final String DEFAULT_WORKSPACE_NAME = "DefaultWorkspace.jws";
    private static final String DEFAULT_PROJECT_NAME = "Project1.jpr";
    private static final String DEFAULT_SYSTEM_FILE = "applications.xml";
    private static final String LEGACY_SYSTEM_FILE = "System.sys";
    public static final int SYSTEM_SETTINGS = 0;
    public static final int DEFAULT_PROJECT = 1;
    public static final int DEFAULT_WORKSPACE = 2;
    private static IdeSystem restoredSystem;
    private File jdevProdSourceRootDir;

    public IdeSystemMigrator() {
        super(new int[]{0, 1});
    }

    @Override
    public String getDescription(int category) {
        switch (category) {
            case 0: {
                return ModelArb.getString(51);
            }
            case 1: {
                return ModelArb.getString(52);
            }
            case 2: {
                return ModelArb.getString(53);
            }
        }
        return null;
    }

    @Override
    public boolean canMigrate(int category, File sourceDir) {
        this.jdevProdSourceRootDir = sourceDir;
        if (this.isValidCategory(category) && sourceDir != null) {
            File srcproddir = new File(sourceDir, "o.jdeveloper");
            File file = new File(srcproddir, DEFAULT_SYSTEM_FILE);
            if (file.exists() && file.canRead()) {
                return true;
            }
            this.jdevProdSourceRootDir = null;
            file = new File(sourceDir, DEFAULT_SYSTEM_FILE);
            if (file != null && file.exists() && file.canRead()) {
                return true;
            }
            file = new File(sourceDir, LEGACY_SYSTEM_FILE);
            if (file != null && file.exists() && file.canRead()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected File getSourceFile(File sourceDir, File destDir) {
        File srcproddir = new File(sourceDir, Ide.getProductID());
        File file = new File(srcproddir, DEFAULT_SYSTEM_FILE);
        if (file != null && file.exists() && file.canRead()) {
            return file;
        }
        file = new File(sourceDir, DEFAULT_SYSTEM_FILE);
        if (file != null && file.exists() && file.canRead()) {
            return file;
        }
        file = new File(sourceDir, LEGACY_SYSTEM_FILE);
        if (file != null && file.exists() && file.canRead()) {
            return file;
        }
        return null;
    }

    @Override
    protected String getFileName() {
        return DEFAULT_SYSTEM_FILE;
    }

    @Override
    protected String getNamespaceURI() {
        return IdeSystem.NAMESPACE_URI;
    }

    @Override
    protected String getRootTag() {
        return "system";
    }

    @Override
    protected void prepareToMigrate() {
        Class<IdeSystem> cls = IdeSystem.class;
    }

    @Override
    protected Object adjustObject(File sourceDir, File destDir, Object obj) throws Exception {
        Workspaces migratedWorkspaces;
        URL url;
        File dfltDir = new File(destDir, DEFAULT_WORKSPACE_DIR);
        if (!dfltDir.exists()) {
            dfltDir.mkdirs();
        }
        IdeSystem inSys = (IdeSystem)obj;
        Preferences inPrefs = inSys.getPreferences();
        Map inMap = inPrefs.getPreferencesMap();
        IdeSystem outSys = this.isSelected(0) ? inSys : this.getSettings(destDir);
        Preferences outPrefs = outSys.getPreferences();
        if (outPrefs == null) {
            outPrefs = (Preferences)outSys.getChild(Preferences.class);
        }
        Map outMap = outPrefs.getPreferencesMap();
        File file = new File(dfltDir, DEFAULT_PROJECT_NAME);
        if (this.isSelected(1)) {
            url = (URL)inMap.get("DefaultProject");
            URLFileSystem.copy((URL)url, (File)file);
        }
        outMap.put("DefaultProject", URLFactory.newFileURL((File)file));
        file = new File(dfltDir, DEFAULT_WORKSPACE_NAME);
        if (this.isSelected(2)) {
            url = (URL)inMap.get(DEFAULT_WORKSPACE_DIR);
            URLFileSystem.copy((URL)url, (File)file);
        }
        outMap.put(DEFAULT_WORKSPACE_DIR, URLFactory.newFileURL((File)file));
        outPrefs.setPreferencesMap(outMap);
        restoredSystem = outSys;
        Workspaces workspaces = Ide.getWorkspaces();
        if (workspaces != null && (migratedWorkspaces = (Workspaces)outSys.getChild(Workspaces.class)) != null) {
            migratedWorkspaces.copyTo(workspaces);
        }
        return super.adjustObject(sourceDir, destDir, outSys);
    }

    public static IdeSystem getRestoredSystem() {
        return restoredSystem;
    }

    private IdeSystem getSettings(File destDir) throws Exception {
        File file = this.getDestFile(null, destDir);
        URL url = URLFactory.newFileURL((File)file);
        return (IdeSystem)this.getObjectStore().toObject(url, this.getClass().getClassLoader());
    }

    @Override
    public String[] migrate(File sourceDir, File destDir) {
        this.getLogger().logInformation(ModelArb.getString(54));
        if (this.jdevProdSourceRootDir != null) {
            sourceDir = new File(this.jdevProdSourceRootDir, "o.jdeveloper");
        }
        destDir = new File(Ide.getSystemDirectory(), "o.jdeveloper");
        return super.migrate(sourceDir, destDir);
    }
}

