/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public final class TechnologyScope
implements Copyable {
    private final Set _technologySet = new LinkedHashSet();

    public TechnologyScope() {
    }

    public TechnologyScope(TechnologyScope scope) {
        this();
        if (scope != null) {
            scope.copyToImpl(this);
        }
    }

    public boolean add(TechId techId) {
        TechId[] dependencies = TechnologyRegistry.getInstance().getDependenciesFor(techId);
        boolean dependenciesAdded = false;
        for (int i = 0; i < dependencies.length; ++i) {
            TechId t = dependencies[i];
            if (!this._technologySet.add(t)) continue;
            dependenciesAdded = true;
        }
        return this._technologySet.add(techId) || dependenciesAdded;
    }

    public boolean remove(TechId techId) {
        if (this._technologySet.remove(techId)) {
            while (this.pruneOrphanedTechnologies()) {
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this._technologySet.clear();
    }

    public boolean contains(TechId techId) {
        return this._technologySet.contains(techId);
    }

    public boolean contains(TechnologyScope scope) {
        for (TechId id : scope._technologySet) {
            if (this.contains(id)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this._technologySet.isEmpty();
    }

    public TechId[] toArray() {
        return this._technologySet.toArray(new TechId[this._technologySet.size()]);
    }

    public String[] getTechnologyKeys() {
        String[] ret = new String[this._technologySet.size()];
        int idx = 0;
        for (TechId techId : this._technologySet) {
            ret[idx++] = techId.getKey();
        }
        return ret;
    }

    public void setTechnologyKeys(String[] keys) {
        for (String key : keys) {
            this.add(key);
        }
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && this.equalsImpl((TechnologyScope)object);
    }

    public Object copyTo(Object object) {
        TechnologyScope copy = object != null ? (TechnologyScope)object : new TechnologyScope();
        this.copyToImpl(copy);
        return copy;
    }

    protected final boolean equalsImpl(TechnologyScope scope) {
        return ModelUtil.areEqual((Object)this._technologySet, (Object)scope._technologySet);
    }

    protected final void copyToImpl(TechnologyScope scope) {
        scope.setTechnologySet(this._technologySet);
    }

    private boolean pruneOrphanedTechnologies() {
        boolean ret = false;
        Iterator it = this._technologySet.iterator();
        block0: while (it.hasNext()) {
            TechId nextTechId = (TechId)it.next();
            Set deps = nextTechId.getDependencies();
            if (deps.isEmpty()) continue;
            TechId[] dependencies = deps.toArray(new TechId[deps.size()]);
            for (int i = 0; i < dependencies.length; ++i) {
                TechId dependency = dependencies[i];
                if (this._technologySet.contains(dependency)) continue block0;
            }
            it.remove();
            ret = true;
        }
        return ret;
    }

    private void setTechnologySet(Set technologySet) {
        this._technologySet.clear();
        this._technologySet.addAll(technologySet);
    }

    private void add(String key) {
        TechId techId = TechnologyRegistry.getInstance().getTechId(key);
        if (techId != null) {
            this.add(techId);
        }
    }
}

