/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.UpdateMessage;
import oracle.ide.usages.UsageData;
import oracle.ide.usages.UsagesTracker;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;

public class TechnologyScopeConfiguration
extends HashStructureAdapter {
    public static final String DATA_KEY = TechnologyScopeConfiguration.class.getName();
    public static final String TECHNOLOGY_SCOPE_PROPERTY = "technologyScope";
    public static final String TECHNOLOGY_SCOPE_KEY = DATA_KEY + "/" + "technologyScope";
    private static ProjectChangeListener _listener;
    private static final Logger _sLogger;
    private static Comparator<String> TECH_DEP_COMPARATOR;

    private TechnologyScopeConfiguration(HashStructure hash) {
        super(hash);
    }

    public static TechnologyScopeConfiguration getInstance(PropertyStorage propertyData) {
        return new TechnologyScopeConfiguration(TechnologyScopeConfiguration.findOrCreate((PropertyStorage)propertyData, (String)DATA_KEY));
    }

    public static List<ChangeInfo> findAllTechScopeChangeInfos(ProjectChangeEvent e) {
        ArrayList<ChangeInfo> changeInfos = new ArrayList<ChangeInfo>();
        for (ChangeInfo changeInfo : e.getChangeDetails()) {
            if (!changeInfo.isEventForList(TECHNOLOGY_SCOPE_KEY)) continue;
            changeInfos.add(changeInfo);
        }
        return TechnologyScopeConfiguration.adjust(changeInfos);
    }

    private static List<ChangeInfo> adjust(List<ChangeInfo> changeDetails) {
        if (changeDetails.size() <= 1) {
            return changeDetails;
        }
        HashMap<String, ChangeInfo> toAdd = new HashMap<String, ChangeInfo>();
        HashMap<String, ChangeInfo> toRemove = new HashMap<String, ChangeInfo>();
        for (ChangeInfo detail : changeDetails) {
            switch (detail.getChangeType()) {
                case 1: 
                case 2: {
                    String key = detail.getNewValueAsString();
                    if (toRemove.remove(key) != null) break;
                    toAdd.put(key, detail);
                    break;
                }
                case 3: {
                    String key = detail.getOldValueAsString();
                    if (toAdd.remove(key) != null) break;
                    toRemove.put(key, detail);
                    break;
                }
            }
        }
        ArrayList<ChangeInfo> list = new ArrayList<ChangeInfo>();
        list.addAll(toRemove.values());
        list.addAll(toAdd.values());
        return list;
    }

    public static void init() {
        if (_listener == null) {
            _listener = new ProjectChangeListener(){

                @Override
                public void projectPropertiesChanged(ProjectChangeEvent e) {
                    List<ChangeInfo> infos = TechnologyScopeConfiguration.findAllTechScopeChangeInfos(e);
                    if (infos.size() > 0) {
                        TechnologyScope newScope = TechnologyScopeConfiguration.getNewTechnologyScopeValue(infos);
                        TechnologyScope oldScope = TechnologyScopeConfiguration.getOldTechnologyScopeValue(infos);
                        if (!oldScope.isEmpty() || !newScope.isEmpty()) {
                            this.reportTechnologyUsages(newScope.getTechnologyKeys());
                            final Project project = e.getProject();
                            PropertyChangeEvent pce = new PropertyChangeEvent(project, TechnologyScopeConfiguration.TECHNOLOGY_SCOPE_PROPERTY, oldScope, newScope);
                            final PropertyChangeEvent[] pces = new PropertyChangeEvent[]{pce};
                            NodeListener.invokeLaterIfNeeded(new Runnable(){

                                @Override
                                public void run() {
                                    UpdateMessage.firePropertiesChanged(project, pces, TechnologyScopeConfiguration.class);
                                }
                            });
                        }
                    }
                }

                private void reportTechnologyUsages(String ... technologies) {
                    if (technologies == null || technologies.length == 0) {
                        return;
                    }
                    UsagesTracker tracker = UsagesTracker.getUsagesTracker();
                    UsageData data = tracker.createUsageData();
                    data.setEventId("FEATURES");
                    data.setProperty("technology-keys", Arrays.asList(technologies));
                    tracker.report(data);
                }
            };
            Project.addProjectChangeListener(DATA_KEY + "/" + TECHNOLOGY_SCOPE_PROPERTY, _listener);
        }
    }

    public Collection<String> getUnknownTechnologies() {
        LinkedList<String> unknownTechs = new LinkedList<String>();
        for (String techKey : TechnologyScopeConfiguration.getTechScopesFromList(this.getTechnologies())) {
            if (TechnologyRegistry.getInstance().containsTechKey(techKey)) continue;
            unknownTechs.add(techKey);
        }
        return unknownTechs;
    }

    private ListStructure getTechnologies() {
        return this._hash.getOrCreateListStructure(TECHNOLOGY_SCOPE_PROPERTY);
    }

    private static List<String> getTechScopesFromList(ListStructure list) {
        ArrayList<String> techList = new ArrayList<String>();
        if (list.size() > 0) {
            for (Object val : list) {
                if (!(val instanceof String)) continue;
                techList.add((String)val);
            }
        }
        return techList;
    }

    private static TechnologyScope createTechScopeFromTechIds(List<String> techScopeIds) {
        TechnologyScope techScope = new TechnologyScope();
        for (String ts : techScopeIds) {
            TechId techId = TechnologyRegistry.getInstance().getTechId(ts);
            if (techId == null) continue;
            techScope.add(techId);
        }
        return techScope;
    }

    public static TechnologyScope getNewTechnologyScopeValue(List<ChangeInfo> changeInfos) {
        ArrayList<String> techScopeIds = new ArrayList<String>();
        for (ChangeInfo changeInfo : changeInfos) {
            Object newVal = changeInfo.getNewValue();
            if (newVal == null) continue;
            if (newVal instanceof String) {
                techScopeIds.add((String)newVal);
                continue;
            }
            if (!(newVal instanceof ListStructure)) continue;
            techScopeIds.addAll(TechnologyScopeConfiguration.getTechScopesFromList((ListStructure)newVal));
        }
        return TechnologyScopeConfiguration.createTechScopeFromTechIds(techScopeIds);
    }

    private static TechnologyScope getOldTechnologyScopeValue(List<ChangeInfo> changeInfos) {
        ArrayList<String> techScopeIds = new ArrayList<String>();
        for (ChangeInfo changeInfo : changeInfos) {
            Object oldVal = changeInfo.getOldValue();
            if (oldVal == null) continue;
            if (oldVal instanceof String) {
                techScopeIds.add((String)oldVal);
                continue;
            }
            if (!(oldVal instanceof ListStructure)) continue;
            techScopeIds.addAll(TechnologyScopeConfiguration.getTechScopesFromList((ListStructure)oldVal));
        }
        return TechnologyScopeConfiguration.createTechScopeFromTechIds(techScopeIds);
    }

    private static TechnologyScope getTechnologyScope(ListStructure techKeys) {
        TechnologyScope techScope = new TechnologyScope();
        if (techKeys != null) {
            techScope.setTechnologyKeys((String[])techKeys.toArray((Object[])new String[techKeys.size()]));
        }
        return techScope;
    }

    public TechnologyScope getTechnologyScope() {
        return TechnologyScopeConfiguration.getTechnologyScope(this.getTechnologies());
    }

    public boolean setTechnologyScope(final TechnologyScope scope) {
        final boolean[] ret = new boolean[1];
        this.getHashStructure().applyBatchChanges(new Runnable(){

            @Override
            public void run() {
                ret[0] = TechnologyScopeConfiguration.this._setTechnologyScope(scope);
            }
        });
        return ret[0];
    }

    private boolean _setTechnologyScope(TechnologyScope scope) {
        boolean result = false;
        ArrayList<String> toAdd = new ArrayList<String>();
        TechnologyScope oldScope = this.getTechnologyScope();
        if (ModelUtil.areDifferent((Object)oldScope, (Object)scope)) {
            TechnologyRegistry.getInstance().initializeOwningExtensions(scope);
            String[] keys = scope != null ? scope.getTechnologyKeys() : null;
            ListStructure techKeys = this.getTechnologies();
            if (keys != null && keys.length > 0) {
                List<String> keyList = Arrays.asList(keys);
                Iterator<String> iter = techKeys.iterator();
                while (iter.hasNext()) {
                    if (keyList.contains(iter.next())) continue;
                    iter.remove();
                    result = true;
                }
                for (String keyObj : keyList) {
                    if (keyObj == null || techKeys.contains((Object)keyObj)) continue;
                    toAdd.add(keyObj);
                    result = true;
                }
                if (result) {
                    this.ensureTechnologiesAreSorted2(techKeys, toAdd);
                }
            } else if (techKeys.size() > 0) {
                techKeys.clear();
                result = true;
            }
        }
        return result;
    }

    private void ensureTechnologiesAreSorted2(ListStructure techKeys, List<String> technologiesToAdd) {
        Collections.sort(technologiesToAdd, TECH_DEP_COMPARATOR);
        for (String technologyToAdd : technologiesToAdd) {
            String techKey;
            int compare;
            for (int index = 0; index < techKeys.size() && (compare = (techKey = (String)techKeys.get(index)).compareTo(technologyToAdd)) != 0; ++index) {
                if (compare > 0) {
                    techKeys.add(index, (Object)technologyToAdd);
                    break;
                }
                if (index != techKeys.size() - 1) continue;
                techKeys.add((Object)technologyToAdd);
                break;
            }
            if (!techKeys.isEmpty()) continue;
            techKeys.add((Object)technologyToAdd);
        }
    }

    public final boolean updateTechnologyScope(String[] technologyKeys) {
        boolean ret = false;
        TechnologyScope scope = this.getTechnologyScope();
        if (scope != null && technologyKeys != null) {
            TechnologyRegistry techRegistry = TechnologyRegistry.getInstance();
            for (int i = 0; i < technologyKeys.length; ++i) {
                TechId techId = techRegistry.getTechId(technologyKeys[i]);
                if (techId == null || techId.getCallback() != null || scope.contains(techId)) continue;
                if (techId.isObsolete()) {
                    _sLogger.log(Level.WARNING, "Warning: Illegal attempt to add obsolete technology key: " + techId.getKey() + " to scope");
                }
                scope.add(techId);
                ret = true;
            }
        }
        if (ret) {
            this.setTechnologyScope(scope);
        }
        return ret;
    }

    static {
        _sLogger = Logger.getLogger(TechnologyScopeConfiguration.class.getName());
        TECH_DEP_COMPARATOR = new TechDepComparator();
    }

    private static class TechDepComparator
    implements Comparator<String> {
        private TechDepComparator() {
        }

        @Override
        public int compare(String t1, String t2) {
            TechnologyRegistry reg = TechnologyRegistry.getInstance();
            TechId tech1 = reg.getTechId(t1);
            TechId tech2 = reg.getTechId(t2);
            if (Arrays.asList(reg.getDependenciesFor(tech1)).contains(tech2)) {
                return 1;
            }
            if (Arrays.asList(reg.getDependenciesFor(tech2)).contains(tech1)) {
                return -1;
            }
            return 0;
        }
    }
}

