/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.history.HistoryManager;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.FacadeBufferReference;
import oracle.ide.model.FacadeTextBuffer;
import oracle.ide.model.FacadeTextBufferListeners;
import oracle.ide.model.GuardedSupport;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.TextBufferStreamFactory;
import oracle.javatools.buffer.AbstractTextBuffer;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.buffer.Utilities;
import oracle.javatools.dialogs.ExceptionDialog;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.spi.editor.guards.GuardedEditorSupport;
import org.netbeans.spi.editor.guards.GuardedSectionsProvider;

public class TextNode
extends Node {
    private static final Logger LOG = Logger.getLogger(TextBuffer.class.getName());
    private AbstractTextBuffer realBuffer;
    private FacadeTextBuffer facadeBuffer;
    private FacadeBufferReference facadeBufferReference;
    private final Object facadeBufferLock = new Object();
    private StyledDocument guardedDocument;
    private GuardedSectionsProvider guardedProvider;
    private boolean guardedReaderUsed;
    private volatile boolean isDirty;
    private FacadeTextBufferListeners realBufferListener = new FacadeTextBufferListeners(this);
    private boolean isLoading = false;
    private boolean autoClosing = false;
    private AbstractTextBuffer.UndoState undoState;
    private AbstractTextBuffer.UndoState unmodifiedUndoState;
    private boolean lastReadOnly = false;
    private String _loadEncoding;
    private String _saveEncoding;

    public TextNode() {
        this(null);
    }

    public TextNode(URL url) {
        super(url);
        this.getAttributes().set(ElementAttributes.DELETEABLE | ElementAttributes.MOVEABLE | ElementAttributes.RENAMEABLE | ElementAttributes.SAVEABLE | ElementAttributes.EDITOR_SAVEABLE_AS | ElementAttributes.CLOSEABLE | ElementAttributes.PRINTABLE);
    }

    @Override
    protected void readUnlock() {
        if (!this.isDirty && this.lockCount() == 1) {
            this.clearFacadeBuffer();
        }
        super.readUnlock();
    }

    @Override
    protected void writeUnlock() {
        if (!this.isDirty && this.lockCount() == 1) {
            this.clearFacadeBuffer();
        }
        super.writeUnlock();
    }

    @Override
    protected void upgradeUnlock() {
        if (!this.isDirty && this.lockCount() == 1) {
            this.clearFacadeBuffer();
        }
        super.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FacadeTextBuffer facadeBuffer() {
        assert (this.isReadOrWriteLocked());
        if (this.realBuffer == null) {
            return null;
        }
        Object object = this.facadeBufferLock;
        synchronized (object) {
            if (this.facadeBuffer != null) {
                return this.facadeBuffer;
            }
            if (this.facadeBufferReference != null) {
                this.facadeBuffer = (FacadeTextBuffer)this.facadeBufferReference.get();
                if (this.facadeBuffer != null) {
                    return this.facadeBuffer;
                }
            }
            this.facadeBuffer = this.guardedProvider != null ? new FacadeTextBuffer.Guarded((TextBuffer)this.realBuffer, this.realBufferListener, this.nodeLock()) : new FacadeTextBuffer.Basic((TextBuffer)this.realBuffer, this.realBufferListener, this.nodeLock());
            this.facadeBufferReference = new FacadeBufferReference(this, this.facadeBuffer);
            return this.facadeBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFacadeBuffer() {
        Object object = this.facadeBufferLock;
        synchronized (object) {
            this.facadeBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTextBuffer() throws IOException {
        assert (this.isWriteLocked());
        this.initGuardedSupport1();
        FacadeTextBuffer buffer = this.facadeBuffer();
        buffer.throwIfExpired();
        this.isLoading = true;
        try {
            block21: {
                try {
                    URL url = this.getURL();
                    if (url == null) {
                        throw new NullPointerException("null URL, cannot load data");
                    }
                    Reader reader = this.createReader(url);
                    if (reader != null) {
                        try {
                            buffer.read(reader);
                            break block21;
                        }
                        finally {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {
                                Assert.println((String)"Exception in finally block closing streams");
                                Assert.printStackTrace((Throwable)e);
                            }
                        }
                    }
                    if (!buffer.isReadOnly()) {
                        buffer.removeToEnd(0);
                    }
                }
                catch (FileNotFoundException e) {
                }
                catch (UnknownHostException e) {
                }
                catch (IOException e) {
                    if (!buffer.isReadOnly()) {
                        buffer.removeToEnd(0);
                    }
                    throw e;
                }
            }
            boolean nodeReadOnly = super.isReadOnly();
            if (buffer.isReadOnly() != nodeReadOnly) {
                buffer.setReadOnly(nodeReadOnly);
            }
        }
        finally {
            this.initGuardedSupport2();
            buffer.clearModified();
            this.isLoading = false;
        }
        if (!Utilities.attachUndoState((AbstractTextBuffer)this.realBuffer, (AbstractTextBuffer.UndoState)this.undoState)) {
            Utilities.attachUndoState((AbstractTextBuffer)this.realBuffer, (AbstractTextBuffer.UndoState)this.unmodifiedUndoState);
        }
        this.unmodifiedUndoState = Utilities.copyUndoState((AbstractTextBuffer)this.realBuffer);
        this.undoState = null;
    }

    @Override
    protected void urlReadOnlyChanged() {
        LOG_READONLY.trace("node {0} read-only changed", (Object)this.getURL());
        this.isReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly() {
        boolean readOnly = super.isReadOnly();
        if (this.nodeLock().tryReadLock()) {
            try {
                if (this.realBuffer != null && this.realBuffer.isReadOnly() != readOnly) {
                    this.realBuffer.setReadOnly(readOnly);
                }
            }
            finally {
                this.readUnlock();
            }
        }
        Attributes attributes = null;
        if (readOnly != this.lastReadOnly) {
            this.lastReadOnly = readOnly;
            attributes = this.getAttributes();
            if (readOnly) {
                attributes.set(ElementAttributes.READ_ONLY);
            } else {
                attributes.unset(ElementAttributes.READ_ONLY);
            }
            attributes = this.getAttributes().duplicate();
        }
        if (attributes != null) {
            LOG_READONLY.trace("getting read-only, firing change to {0} for {1}", readOnly, (Object)this.getURL());
            UpdateMessage.fireAttributeChanged(this, attributes);
        }
        return readOnly;
    }

    @Override
    public boolean isDirty() {
        return super.isDirty();
    }

    @Override
    public void markDirty(boolean dirty) {
        super.markDirty(dirty);
    }

    @Override
    protected void markDirtyImpl(boolean dirty) {
        this.isDirty = dirty;
        if (!dirty && this.realBuffer != null) {
            this.realBuffer.clearModified();
        }
    }

    @Override
    protected void openImpl() throws IOException {
        assert (this.isWriteLocked());
        assert (this.realBuffer == null) : this.getClass().getName() + " " + this.getLongLabel() + ", facade " + this.facadeBuffer;
        this.realBuffer = (AbstractTextBuffer)TextBufferFactory.createTextBuffer((ReadWriteLock)this.nodeLock());
        this.setDefaultLineTerminator((TextBuffer)this.realBuffer);
        this.realBuffer.addTextBufferListener((TextBufferListener)this.realBufferListener);
        try {
            this.loadTextBuffer();
        }
        catch (IOException e) {
            this.realBuffer.removeTextBufferListener((TextBufferListener)this.realBufferListener);
            this.realBuffer = null;
            throw e;
        }
        catch (Throwable e) {
            this.realBuffer.removeTextBufferListener((TextBufferListener)this.realBufferListener);
            this.realBuffer = null;
            IOException ioe = new IOException("exception loading " + this.getLongLabel());
            ioe.initCause(e);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeImpl() throws IOException {
        assert (this.isWriteLocked());
        assert (this.realBuffer != null);
        this.realBufferListener.clear();
        this.realBuffer.removeTextBufferListener((TextBufferListener)this.realBufferListener);
        Object object = this.facadeBufferLock;
        synchronized (object) {
            FacadeTextBuffer facade = (FacadeTextBuffer)this.facadeBufferReference.get();
            if (facade != null) {
                facade.dispose(this.autoClosing);
            }
            this.facadeBufferReference.clear();
            this.facadeBufferReference = null;
            this.facadeBuffer = null;
        }
        this.undoState = Utilities.detachUndoState((AbstractTextBuffer)this.realBuffer);
        this.realBuffer = null;
        this.guardedDocument = null;
        this.guardedProvider = null;
        this.guardedReaderUsed = false;
    }

    @Override
    protected void saveImpl() throws IOException {
        assert (this.isWriteLocked());
        boolean isNew = this.isNew();
        if (this.isDirty() || isNew) {
            FacadeTextBuffer buffer;
            HistoryManager history = null;
            URL[] urls = null;
            if (Ide.isRunning()) {
                history = HistoryManager.getHistoryManager();
                urls = new URL[]{this.getURL()};
                if (history != null && !isNew) {
                    try {
                        history.persistInitialState(urls);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if ((buffer = this.facadeBuffer()) == null) {
                throw new IllegalStateException("on save, no buffer available");
            }
            buffer.throwIfExpired();
            OutputStream outputStream = null;
            Writer writer = null;
            try {
                outputStream = URLFileSystem.openOutputStream((URL)this.getURL());
                writer = this.createWriter(outputStream);
                buffer.write(writer);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    } else if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
            this.unmodifiedUndoState = Utilities.copyUndoState((AbstractTextBuffer)this.realBuffer);
            if (history != null) {
                try {
                    String historyText = isNew ? IdeArb.getString(23) : IdeArb.getString(58);
                    history.persist(urls, StringUtils.stripMnemonic((String)historyText));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    protected void revertImpl() throws IOException {
        assert (this.isWriteLocked());
        this.loadTextBuffer();
    }

    protected void setDefaultLineTerminator(TextBuffer textBuffer) {
        int terminator;
        try {
            EnvironOptions options = Ide.getEnvironOptions();
            terminator = options.getLineTerminator();
        }
        catch (NullPointerException e) {
            terminator = 0;
        }
        switch (terminator) {
            case 1: {
                textBuffer.setEOLType("\r\n");
                break;
            }
            case 2: {
                textBuffer.setEOLType("\n");
                break;
            }
            case 3: {
                textBuffer.setEOLType("\r");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TextBuffer acquireTextBuffer() {
        this.readLock();
        try {
            this.ensureOpen();
            FacadeTextBuffer buffer = this.facadeBuffer();
            if (buffer != null) {
                buffer.throwIfExpired();
            }
            FacadeTextBuffer facadeTextBuffer = buffer;
            return facadeTextBuffer;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TextBuffer acquireTextBufferInterruptibly() throws IOException, InterruptedException {
        this.readLockInterruptibly();
        try {
            this.open();
            FacadeTextBuffer buffer = this.facadeBuffer();
            if (buffer != null) {
                buffer.throwIfExpired();
            }
            FacadeTextBuffer facadeTextBuffer = buffer;
            return facadeTextBuffer;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TextBuffer acquireTextBufferOrThrow() throws IOException {
        this.readLock();
        try {
            this.open();
            FacadeTextBuffer buffer = this.facadeBuffer();
            if (buffer != null) {
                buffer.throwIfExpired();
            }
            FacadeTextBuffer facadeTextBuffer = buffer;
            return facadeTextBuffer;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TextBuffer tryAcquireTextBuffer() {
        ReadWriteLock lock = this.nodeLock();
        if (lock.tryReadLock()) {
            try {
                if (this.isOpen()) {
                    FacadeTextBuffer buffer = this.facadeBuffer();
                    if (buffer != null) {
                        buffer.throwIfExpired();
                    }
                    FacadeTextBuffer facadeTextBuffer = buffer;
                    return facadeTextBuffer;
                }
                if (lock.isWriteLockHeld()) {
                    this.ensureOpen();
                    FacadeTextBuffer buffer = this.facadeBuffer();
                    if (buffer != null) {
                        buffer.throwIfExpired();
                    }
                    FacadeTextBuffer facadeTextBuffer = buffer;
                    return facadeTextBuffer;
                }
            }
            finally {
                this.readUnlock();
            }
            if (!lock.isReadLockHeld() && lock.tryWriteLock()) {
                try {
                    this.ensureOpen();
                    FacadeTextBuffer buffer = this.facadeBuffer();
                    if (buffer != null) {
                        buffer.throwIfExpired();
                    }
                    FacadeTextBuffer facadeTextBuffer = buffer;
                    return facadeTextBuffer;
                }
                finally {
                    lock.writeUnlock();
                }
            }
        }
        return null;
    }

    public final void releaseTextBuffer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TextBuffer getTextBufferDirectly() {
        this.readLock();
        try {
            FacadeTextBuffer buffer = this.facadeBuffer();
            if (buffer != null) {
                buffer.throwIfExpired();
            }
            FacadeTextBuffer facadeTextBuffer = buffer;
            return facadeTextBuffer;
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean addTextBufferListener(TextBufferListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener null");
        }
        return this.realBufferListener.addIfAbsent(listener);
    }

    public void removeTextBufferListener(TextBufferListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener null");
        }
        this.realBufferListener.remove(listener);
    }

    public Reader getReader() throws IOException {
        TextBuffer textBuffer = this.acquireTextBuffer();
        if (textBuffer == null) {
            throw new IllegalStateException("getReader(): null text buffer");
        }
        return TextBufferFactory.createReader((ReadTextBuffer)textBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEmptyTextBuffer() {
        try {
            boolean bl = this.acquireTextBuffer().getLength() == 0;
            return bl;
        }
        finally {
            this.releaseTextBuffer();
        }
    }

    boolean isLoading() {
        return this.isLoading;
    }

    boolean isAutoClosing() {
        return this.autoClosing;
    }

    void setAutoClosing(boolean autoClosing) {
        this.autoClosing = autoClosing;
    }

    FacadeBufferReference getFacadeBufferReference() {
        return this.facadeBufferReference;
    }

    public String getLoadEncoding() {
        return this._loadEncoding != null ? this._loadEncoding : IdeUtil.getIdeEncoding();
    }

    public String getSaveEncoding() {
        return this._saveEncoding != null ? this._saveEncoding : IdeUtil.getIdeEncoding();
    }

    public void setLoadEncoding(String loadEncoding) {
        this._loadEncoding = loadEncoding;
    }

    public void setSaveEncoding(String saveEncoding) {
        this._saveEncoding = saveEncoding;
    }

    protected Reader createReader(URL url) throws IOException {
        Reader r = this.createGuardedReader();
        return r != null ? r : URLFileSystem.createReader((URL)url, (String)this.getLoadEncoding());
    }

    private Writer createWriter(OutputStream outStream) throws UnsupportedEncodingException {
        Writer w = this.createGuardedWriter(outStream);
        return w != null ? w : this.createOutputStreamWriter(outStream);
    }

    protected OutputStreamWriter createOutputStreamWriter(OutputStream outStream) throws UnsupportedEncodingException {
        return new OutputStreamWriter(outStream, this.getSaveEncoding());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getInputStream(true);
    }

    public InputStream getInputStream(boolean warn) throws IOException {
        TextBuffer textBuffer;
        if (warn) {
            Assert.println((String)"****  WARNING:  Use of TextNode.getInputStream() is highly discouraged because of the NLS issues raised by byte streams for text and the associated poor performance caused by char-to-byte conversion.  Use TextNode.getReader() instead whenever possible.");
            Assert.printStackTrace();
        }
        if ((textBuffer = this.acquireTextBuffer()) != null) {
            return TextBufferStreamFactory.getInputStream(textBuffer, this.getSaveEncoding());
        }
        throw new IllegalStateException("getInputStream(): null text buffer");
    }

    @Override
    protected void reportOpenException(final Exception e) {
        super.reportOpenException(e);
        final String message = ModelArb.format(50, this.getURL());
        if (!Ide.getIdeArgs().getCreateUI()) {
            System.err.println(message);
            e.printStackTrace();
            return;
        }
        Runnable showErrorRunnable = new Runnable(){

            @Override
            public void run() {
                ExceptionDialog.showExceptionDialog((Window)IdeUtil.getMainWindow(), (Exception)e, (String)ModelArb.getString(49), (String)message);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            showErrorRunnable.run();
        } else {
            SwingUtilities.invokeLater(showErrorRunnable);
        }
    }

    private GuardedSectionsProvider getGuardedSectionsProvider(GuardedEditorSupport document) {
        return GuardedSupport.getDefaultProvider(this.getURL(), document);
    }

    private Reader createGuardedReader() throws IOException {
        Reader r = null;
        if (this.guardedProvider != null && (r = GuardedSupport.createGuardedReader(this.guardedProvider, new BufferedInputStream(URLFileSystem.openInputStream((URL)this.getURL())), this.getLoadEncoding(), this.facadeBuffer)) != null) {
            this.guardedReaderUsed = true;
        }
        return r;
    }

    private Writer createGuardedWriter(OutputStream outputStream) {
        if (this.guardedProvider != null) {
            return GuardedSupport.createGuardedWriter(this.guardedProvider, outputStream, this.getSaveEncoding());
        }
        return null;
    }

    private void initGuardedSupport1() {
        this.guardedDocument = null;
        this.guardedProvider = this.getGuardedSectionsProvider(new GuardedDocProvider());
    }

    private void initGuardedSupport2() {
        Iterator i$;
        GuardedSectionManager gsm;
        boolean anythingGuarded = false;
        if (this.guardedDocument != null && (gsm = GuardedSectionManager.getInstance((StyledDocument)this.guardedDocument)) != null && (i$ = gsm.getGuardedSections().iterator()).hasNext()) {
            GuardedSection gs = (GuardedSection)i$.next();
            anythingGuarded = true;
            this.getTransientProperties().put(GuardedSectionManager.class, gsm);
            this.getTransientProperties().put("GuardedSectionManager.document", this.guardedDocument);
        }
        if (!anythingGuarded) {
            this.guardedDocument = null;
            if (this.guardedReaderUsed && !"\n".equals(this.realBuffer.getEOLType())) {
                this.guardedReaderUsed = false;
            }
            if (!this.guardedReaderUsed) {
                this.guardedProvider = null;
            }
        }
    }

    private class GuardedDocProvider
    implements GuardedEditorSupport {
        private GuardedDocProvider() {
        }

        public StyledDocument getDocument() {
            if (TextNode.this.guardedDocument == null) {
                TextNode.this.guardedDocument = GuardedSupport.createGuardedDocument(TextNode.this.facadeBuffer());
            }
            return TextNode.this.guardedDocument;
        }
    }
}

