/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.exception.ChangeVetoException;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.VetoableSubject;

public final class UpdateMessage {
    private static int _lastMessageID = -1;
    private static String[] _debugStrings = new String[30];
    public static final int NO_MESSAGE = UpdateMessage.newMessageID("UpdateMessage.NO_MESSAGE");
    public static final int CHILD_REMOVED = UpdateMessage.newMessageID("UpdateMessage.CHILD_REMOVED");
    public static final int CHILD_ADDED = UpdateMessage.newMessageID("UpdateMessage.CHILD_ADDED");
    public static final int STRUCTURE_CHANGED = UpdateMessage.newMessageID("UpdateMessage.STRUCTURE_CHANGED");
    public static final int PROPERTY_SET = UpdateMessage.newMessageID("UpdateMessage.PROPERTY_SET");
    public static final int OBJECT_RENAMED = UpdateMessage.newMessageID("UpdateMessage.OBJECT_RENAMED");
    public static final int CHILD_RENAMED = UpdateMessage.newMessageID("UpdateMessage.CHILD_RENAMED");
    public static final int OBJECT_CLOSED = UpdateMessage.newMessageID("UpdateMessage.OBJECT_CLOSED");
    public static final int OBJECT_OPENED = UpdateMessage.newMessageID("UpdateMessage.OBJECT_OPENED");
    public static final int OBJECT_RELOADED = UpdateMessage.newMessageID("UpdateMessage.OBJECT_RELOADED");
    public static final int ATTRIBUTE_CHANGED = UpdateMessage.newMessageID("UpdateMessage.ATTRIBUTE_CHANGED");
    public static final int OBJECT_CLOSING = UpdateMessage.newMessageID("UpdateMessage.OBJECT_CLOSING");
    public static final int CAN_REMOVE_CHILD = UpdateMessage.newMessageID("UpdateMessage.CAN_REMOVE_CHILD");
    public static final int CAN_ADD_CHILD = UpdateMessage.newMessageID("UpdateMessage.CAN_ADD_CHILD");
    public static final int CAN_RENAME_CHILD = UpdateMessage.newMessageID("UpdateMessage.CAN_RENAME_CHILD");
    public static final int CONTENT_MODIFIED = UpdateMessage.newMessageID("UpdateMessage.CONTENT_MODIFIED");
    public static final String COMMAND_ID_PROP = "Message.COMMAND_ID_PROP";
    private final int _messageID;
    private final Object _origin;
    private ArrayList _add;
    private ArrayList _remove;
    private ArrayList _modify;
    private Context _context;
    private final HashMap _hash = new HashMap();

    public UpdateMessage(int messageID, Object origin) {
        if (messageID < 0 || messageID > _lastMessageID) {
            new IllegalArgumentException("UpdateMessage message ID is out of range: " + messageID).printStackTrace();
        }
        this._messageID = messageID;
        this._origin = origin;
    }

    private UpdateMessage(UpdateMessage msg, int newMessageID, Object newOrigin) {
        this(newMessageID, newOrigin);
        this._add = UpdateMessage.copyList(msg._add);
        this._remove = UpdateMessage.copyList(msg._remove);
        this._modify = UpdateMessage.copyList(msg._modify);
        this._hash.putAll(msg._hash);
        this._context = msg._context != null ? new Context(msg._context) : null;
    }

    private static ArrayList copyList(ArrayList list) {
        return list != null ? new ArrayList(list) : null;
    }

    public final Object getProperty(String name) {
        return this._hash.get(name);
    }

    public final void setProperty(String name, Object value) {
        this._hash.put(name, value);
    }

    public final void removeProperty(String name) {
        this._hash.remove(name);
    }

    public final boolean containsProperty(String name) {
        return this._hash.containsKey(name);
    }

    public final int getMessageID() {
        return this._messageID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int newMessageID(String debugString) {
        Class<UpdateMessage> clazz = UpdateMessage.class;
        synchronized (UpdateMessage.class) {
            int id = ++_lastMessageID;
            int n = _debugStrings.length;
            if (id >= n) {
                String[] newDebugStrings = new String[n + 10];
                System.arraycopy(_debugStrings, 0, newDebugStrings, 0, n);
                _debugStrings = newDebugStrings;
            }
            UpdateMessage._debugStrings[id] = debugString;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return id;
        }
    }

    public final Object getOrigin() {
        return this._origin;
    }

    public final List getAddObjects() {
        if (this._add == null) {
            this._add = new ArrayList();
        }
        return this._add;
    }

    public final List getRemoveObjects() {
        if (this._remove == null) {
            this._remove = new ArrayList();
        }
        return this._remove;
    }

    public final List getModifyObjects() {
        if (this._modify == null) {
            this._modify = new ArrayList();
        }
        return this._modify;
    }

    public final Context getContext() {
        return this._context;
    }

    public final void setContext(Context context) {
        this._context = context;
    }

    public final UpdateMessage copyMessage() {
        return new UpdateMessage(this, this.getMessageID(), this.getOrigin());
    }

    public final UpdateMessage forNewMessageID(int newMessageID) {
        return new UpdateMessage(this, newMessageID, this.getOrigin());
    }

    public final UpdateMessage forNewOrigin(Object newOrigin) {
        return new UpdateMessage(this, this.getMessageID(), newOrigin);
    }

    public static void fireChildAdded(Subject subject, Element element) {
        UpdateMessage updateMessage = new UpdateMessage(CHILD_ADDED, null);
        updateMessage.getAddObjects().add(element);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireChildrenAdded(Subject subject, Collection childElements) {
        UpdateMessage updateMessage = new UpdateMessage(CHILD_ADDED, null);
        updateMessage.getAddObjects().addAll(childElements);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireChildRemoved(Subject subject, Element element) {
        UpdateMessage updateMessage = new UpdateMessage(CHILD_REMOVED, null);
        updateMessage.getRemoveObjects().add(element);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireChildrenRemoved(Subject subject, Collection childElements) {
        UpdateMessage updateMessage = new UpdateMessage(CHILD_REMOVED, null);
        updateMessage.getRemoveObjects().addAll(childElements);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireStructureChanged(Subject subject, Collection modifyObjects) {
        UpdateMessage updateMessage = new UpdateMessage(STRUCTURE_CHANGED, null);
        updateMessage.getModifyObjects().addAll(modifyObjects);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireStructureChanged(Subject subject) {
        UpdateMessage updateMessage = new UpdateMessage(STRUCTURE_CHANGED, null);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void firePropertiesChanged(Subject subject, PropertyChangeEvent[] propertyChangeEvents, Object origin) {
        UpdateMessage updateMessage = new UpdateMessage(PROPERTY_SET, origin);
        if (propertyChangeEvents != null && propertyChangeEvents.length > 0) {
            String propertyName;
            PropertyChangeEvent e;
            int i;
            int n = propertyChangeEvents.length;
            boolean hasNullPropertyName = false;
            for (i = 0; i < n; ++i) {
                e = propertyChangeEvents[i];
                propertyName = e.getPropertyName();
                if (propertyName != null) continue;
                hasNullPropertyName = true;
                break;
            }
            if (!hasNullPropertyName) {
                for (i = 0; i < n; ++i) {
                    e = propertyChangeEvents[i];
                    propertyName = e.getPropertyName();
                    updateMessage.setProperty(propertyName, e);
                }
            }
        }
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireObjectRenamed(Subject subject) {
        UpdateMessage updateMessage = new UpdateMessage(OBJECT_RENAMED, null);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireObjectOpened(Subject subject) {
        UpdateMessage updateMessage = new UpdateMessage(OBJECT_OPENED, null);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireObjectReloaded(Subject subject) {
        UpdateMessage updateMessage = new UpdateMessage(OBJECT_RELOADED, null);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireObjectClosed(Subject subject) {
        UpdateMessage updateMessage = new UpdateMessage(OBJECT_CLOSED, null);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireAttributeChanged(Subject subject, Attributes oldAttributes) {
        UpdateMessage updateMessage = new UpdateMessage(ATTRIBUTE_CHANGED, null);
        updateMessage.getModifyObjects().add(oldAttributes);
        UpdateMessage.notifyObserversOnEventThread(subject, updateMessage);
    }

    public static void fireCanAddChild(VetoableSubject subject, Object element) throws ChangeVetoException {
        UpdateMessage updateMessage = new UpdateMessage(CAN_ADD_CHILD, null);
        updateMessage.getAddObjects().add(element);
        subject.notifyVetoObservers(subject, updateMessage);
    }

    public static void fireCanAddChildren(VetoableSubject subject, Collection children) throws ChangeVetoException {
        UpdateMessage updateMessage = new UpdateMessage(CAN_ADD_CHILD, null);
        updateMessage.getAddObjects().addAll(children);
        subject.notifyVetoObservers(subject, updateMessage);
    }

    public static void fireCanRemoveChild(VetoableSubject subject, Object element) throws ChangeVetoException {
        UpdateMessage updateMessage = new UpdateMessage(CAN_REMOVE_CHILD, null);
        updateMessage.getRemoveObjects().add(element);
        subject.notifyVetoObservers(subject, updateMessage);
    }

    public static void fireCanRemoveChildren(VetoableSubject subject, Collection children) throws ChangeVetoException {
        UpdateMessage updateMessage = new UpdateMessage(CAN_REMOVE_CHILD, null);
        updateMessage.getRemoveObjects().addAll(children);
        subject.notifyVetoObservers(subject, updateMessage);
    }

    public static void fireCanRenameChild(VetoableSubject subject, Object child) throws ChangeVetoException {
        UpdateMessage updateMessage = new UpdateMessage(CAN_RENAME_CHILD, null);
        updateMessage.getModifyObjects().add(child);
        subject.notifyVetoObservers(subject, updateMessage);
    }

    private static void notifyObserversOnEventThread(final Subject subject, final UpdateMessage message) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    subject.notifyObservers(subject, message);
                }
            });
        } else {
            subject.notifyObservers(subject, message);
        }
    }

    private String debuggerString() {
        return _debugStrings[this._messageID];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UpdateMessage#");
        buffer.append(System.identityHashCode(this));
        buffer.append('{');
        if (this._messageID >= 0 && this._messageID < _debugStrings.length) {
            buffer.append(_debugStrings[this._messageID]);
        } else {
            buffer.append(this._messageID);
        }
        if (this._add != null) {
            buffer.append(',');
            buffer.append("added");
            buffer.append(this._add);
        }
        if (this._remove != null) {
            buffer.append(',');
            buffer.append("removed");
            buffer.append(this._remove);
        }
        if (this._modify != null) {
            buffer.append(',');
            buffer.append("modified");
            buffer.append(this._modify);
        }
        if (this._hash != null) {
            buffer.append(',');
            buffer.append("properties");
            buffer.append(this._hash);
        }
        buffer.append('}');
        return buffer.toString();
    }
}

