/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.model.ApplicationContent;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.WorkspaceChangeEvent;
import oracle.ide.model.WorkspaceChangeListener;
import oracle.ide.model.Workspaces;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.annotations.NotNull;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.ModelUtil;

public final class Workspace
extends HashStructureNode {
    public static final String DATA_KEY = "Application";
    public static final String EXT = ".jws";
    static final String NAMESPACE_URI = "http://xmlns.oracle.com/ide/project";
    static final String ROOT_QNAME = "jws:workspace";
    public static final String CREATED_BY_TEMPLATE_ID_PROPERTY = "appTemplateId";
    private transient Project _activeProject;
    private transient URL _activeProjectURL;
    private final transient ChangeSupport _changeSupport = new ChangeSupport();
    private static final Map<WorkspaceChangeListener, Set<String>> _listeners = new LinkedHashMap<WorkspaceChangeListener, Set<String>>();

    public Workspace() {
        this.getAttributes().set(ElementAttributes.BUILDABLE | ElementAttributes.DELETEABLE | ElementAttributes.SAVEABLE | ElementAttributes.RENAMEABLE | ElementAttributes.SAVEABLE_AS | ElementAttributes.NAVIGABLE | ElementAttributes.CLOSEABLE | ElementAttributes.NON_HISTORIED);
    }

    @Override
    public Icon getIcon() {
        return OracleIcons.getIcon((String)"application.png");
    }

    @Override
    public boolean canAdd(Element element) {
        return element instanceof Project;
    }

    @Override
    public boolean remove(Element doc, boolean notifyObservers) {
        boolean removeOk = super.remove(doc, notifyObservers);
        if (removeOk && (doc == this._activeProject || this.size() == 0)) {
            this._activeProject = null;
            this._activeProjectURL = null;
            this.markWorkspacesDirty();
        }
        return removeOk;
    }

    @Override
    protected final HashStructureIO newHashStructureIO() {
        HashStructureIO io = super.newHashStructureIO();
        io.addXpathToFlatten("/*[local-name()='workspace']/list[@n='listOfChildren']/hash");
        return io;
    }

    @Override
    protected final String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    @Override
    protected final String getRootQName() {
        return ROOT_QNAME;
    }

    @Override
    void loadImpl() throws IOException {
        super.loadImpl();
        ApplicationContent.initializeContentSets(this, false);
        Workspaces workspaces = Ide.getWorkspaces();
        if (workspaces != null) {
            workspaces.addToProjectMap(this);
        }
    }

    @Override
    protected void closeImpl() throws IOException {
        Workspaces workspaces = Ide.getWorkspaces();
        if (workspaces != null) {
            workspaces.removeFromProjectMap(this);
        }
        super.closeImpl();
        this._activeProject = null;
        this.markWorkspacesDirty();
    }

    @Override
    protected void saveImpl() throws IOException {
        ListStructure listOfChildren = this.getListOfChildrenListStructure();
        try {
            listOfChildren.internalPreprsist();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.saveImpl();
    }

    @Override
    public final Object copyTo(Object object) {
        Workspace copy = object != null ? (Workspace)object : new Workspace();
        this.copyToImpl(copy);
        return copy;
    }

    @Override
    public boolean isDefault() {
        return Ide.isRunning() && !Ide.isStarting() && this == Ide.getDefaultWorkspace();
    }

    public URL getActiveProjectURL() throws TransientMarker {
        return this._activeProjectURL;
    }

    public void setActiveProjectURL(URL activeProjectURL) {
        if (ModelUtil.areDifferent((Object)this._activeProjectURL, (Object)activeProjectURL)) {
            this._activeProjectURL = activeProjectURL;
            this._activeProject = (Project)NodeFactory.find(this._activeProjectURL);
        }
    }

    public Project currentActiveProject() {
        if (this._activeProject != null) {
            return this._activeProject;
        }
        if (this._activeProjectURL != null) {
            try {
                this._activeProject = (Project)NodeFactory.findOrCreate(this._activeProjectURL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this._activeProject;
    }

    public void setActiveProject(Project activeProject) {
        if (this._activeProject != activeProject && this.size() > 0) {
            this._activeProject = activeProject;
            if (this._activeProject != null) {
                if (ModelUtil.areDifferent((Object)this._activeProject.getURL(), (Object)this._activeProjectURL)) {
                    this._activeProjectURL = this._activeProject.getURL();
                }
            } else {
                this._activeProjectURL = null;
            }
            this.markWorkspacesDirty();
        }
    }

    public Project getActiveProject() {
        return this._activeProject;
    }

    @NotNull
    public Collection<Project> projects() {
        ArrayList<Project> projects = new ArrayList<Project>();
        Iterator<Element> i = this.getChildren();
        while (i.hasNext()) {
            Element e = i.next();
            if (!(e instanceof Project)) continue;
            projects.add((Project)e);
        }
        return Collections.unmodifiableCollection(projects);
    }

    public static synchronized void addWorkspaceChangeListener(String propertyName, WorkspaceChangeListener listener) {
        if (propertyName != null && listener != null) {
            Set<String> propertyNames = _listeners.get(listener);
            if (propertyNames == null) {
                propertyNames = new HashSet<String>();
                _listeners.put(listener, propertyNames);
            }
            propertyNames.add(propertyName);
        }
    }

    public static synchronized void removeWorkspaceChangeListener(String propertyName, WorkspaceChangeListener listener) {
        Set<String> propertyNames;
        if (propertyName != null && listener != null && (propertyNames = _listeners.get(listener)) != null) {
            propertyNames.remove(propertyName);
            if (propertyNames.isEmpty()) {
                _listeners.remove(listener);
            }
        }
    }

    public static synchronized void removeWorkspaceChangeListener(WorkspaceChangeListener listener) {
        if (listener != null) {
            _listeners.remove(listener);
        }
    }

    private void markWorkspacesDirty() {
        Workspaces wsps = Ide.getWorkspaces();
        if (wsps != null) {
            wsps.markDirty(true);
        }
    }

    @Override
    void handleCustomPropsOpened(HashStructure customProperties) {
        this._changeSupport.customPropsOpened(customProperties);
    }

    @Override
    void handleCustomPropsClosed() {
        this._changeSupport.customPropsClosed();
    }

    @Override
    void handleAttachStructureChangeListener(HashStructure hash) {
        this._changeSupport.attachStructureChangeListener(hash);
    }

    @Override
    void handleDetachStructureChangeListener() {
        this._changeSupport.detachStructureChangeListener();
    }

    private static synchronized Map<WorkspaceChangeListener, WorkspaceChangeEvent> getWorkspaceChangeEvents(StructureChangeEvent e, Workspace workspace) {
        LinkedHashMap<WorkspaceChangeListener, WorkspaceChangeEvent> events = new LinkedHashMap<WorkspaceChangeListener, WorkspaceChangeEvent>();
        for (Map.Entry<WorkspaceChangeListener, Set<String>> entry : _listeners.entrySet()) {
            ArrayList<ChangeInfo> chunkedDetails = new ArrayList<ChangeInfo>();
            for (String key : entry.getValue()) {
                for (ChangeInfo detail : e.getChangeDetails()) {
                    if (!Project.namesMatch(key, detail.getPropertyName())) continue;
                    chunkedDetails.add(detail);
                }
            }
            if (chunkedDetails.isEmpty()) continue;
            ChangeInfo[] array = chunkedDetails.toArray(new ChangeInfo[chunkedDetails.size()]);
            events.put(entry.getKey(), new WorkspaceChangeEvent(e.getSource(), workspace, array));
        }
        return events;
    }

    private final class ChangeSupport
    extends StructureChangeListener {
        private HashStructure _workspaceProps;
        private HashStructure _customProps;

        private ChangeSupport() {
        }

        private void attachStructureChangeListener(HashStructure hash) {
            this.detachStructureChangeListener();
            this._workspaceProps = hash;
            this._workspaceProps.addStructureChangeListener((StructureChangeListener)this);
        }

        private void detachStructureChangeListener() {
            if (this._workspaceProps != null) {
                this._workspaceProps.removeStructureChangeListener((StructureChangeListener)this);
                this._workspaceProps = null;
            }
        }

        private void customPropsOpened(HashStructure customProps) {
            this.customPropsClosed();
            this._customProps = customProps;
            this._customProps.addStructureChangeListener((StructureChangeListener)this);
        }

        private void customPropsClosed() {
            if (this._customProps != null) {
                this._customProps.removeStructureChangeListener((StructureChangeListener)this);
                this._customProps = null;
            }
        }

        public void structureValuesChanged(StructureChangeEvent e) {
            for (Map.Entry entry : Workspace.getWorkspaceChangeEvents(e, Workspace.this).entrySet()) {
                WorkspaceChangeListener listener = (WorkspaceChangeListener)entry.getKey();
                try {
                    long start = System.nanoTime();
                    listener.workspacePropertiesChanged((WorkspaceChangeEvent)((Object)entry.getValue()));
                    long end = System.nanoTime();
                    PerformanceLogger.get().log("WorkspaceChangeListener.workspacePropertiesChanged", listener.getClass().getName(), end - start);
                }
                catch (Exception ex) {
                    Logger.getLogger(Workspace.class.getName()).log(Level.SEVERE, "Exception in workspace change listener", e);
                }
            }
        }
    }
}

