/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.panels;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.TechnologyScopeManager;
import oracle.ide.resource.NavigatorArb;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.ListStructure;

public class ProgressBarTechnologyScanner
implements TechnologyScopeManager.Scanner {
    @Override
    public Collection<String> scanForNewTechnologies(Collection<URL> roots, Project project) {
        TechScanningSwingWorker worker = new TechScanningSwingWorker(roots, project);
        TechScanningProgressBar progressBar = new TechScanningProgressBar(worker);
        return progressBar.getTechnologies();
    }

    @Override
    public boolean canScan(ProjectChangeEvent pce) {
        int addedCounter = 0;
        if (!GraphicsEnvironment.isHeadless() && pce.getChangeDetails() != null) {
            for (ChangeInfo ci : pce.getChangeDetails()) {
                ListStructure ls;
                if (ci.getChangeType() != 1 && ci.getChangeType() != 0 || (addedCounter += (ls = ci.getNewValueAsListStructure()) != null ? ls.size() : 0) < 2) continue;
                return true;
            }
        }
        return false;
    }

    static class TechScanningSwingWorker
    extends SwingWorker<Collection<String>, Void> {
        private final Collection<URL> m_roots;
        private final Project m_project;

        TechScanningSwingWorker(Collection<URL> roots, Project project) {
            this.m_roots = roots;
            this.m_project = project;
        }

        @Override
        protected Collection<String> doInBackground() throws Exception {
            return TechnologyScopeManager.SAME_THREAD_SCANNER.scanForNewTechnologies(this.m_roots, this.m_project);
        }
    }

    static class TechScanningProgressBar
    implements Runnable {
        private ProgressBar m_progress;
        private final TechScanningSwingWorker m_worker;
        private final Collection<String> m_technologies = new ArrayList<String>(100);

        TechScanningProgressBar(TechScanningSwingWorker worker) {
            this.m_worker = worker;
            this.m_progress = new ProgressBar((Component)((Object)Ide.getMainWindow()), NavigatorArb.getString(19), this, true);
            this.m_progress.setCancelable(false);
        }

        public Collection<String> getTechnologies() {
            this.m_worker.execute();
            this.m_progress.start(NavigatorArb.getString(20), "");
            return this.m_technologies;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
                this.m_technologies.addAll((Collection)this.m_worker.get(300L, TimeUnit.SECONDS));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                this.m_progress.setDoneStatus();
            }
        }
    }
}

