/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controls.WaitCursor;
import oracle.ide.model.LazyLoadEvent;
import oracle.ide.model.LazyLoadListener;
import oracle.ide.model.LazyTraversable;
import oracle.ide.model.SharedPropertiesManager;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.ApplyNotifier;
import oracle.ide.panels.MDDAdapter;
import oracle.ide.panels.MDDEvent;
import oracle.ide.panels.MDDListener;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.TitledPanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ProjectPropertiesArb;
import oracle.ide.util.Assert;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;

final class ProjectPropertiesMDDPanel
extends MDDPanel {
    private JButton _editPrivateSettingsButton;
    private JButton _editWorkspaceSettingsButton;
    private JRadioButton _usePrivateSettingsOption;
    private JRadioButton _useProjectSettingsOption;
    private JRadioButton _useWorkspaceSettingsOption;
    private JPanel _persistanceOptionsPanel;
    private JPanel _propertiesPanel;
    private JPanel _borderPanel;
    private Border _lineBorder;
    private Namespace _propertyData;
    private boolean _traversableListenerEventIsFiring;
    private final Set<ProjectSettingsTraversablePanel> _visitedPanels = new HashSet<ProjectSettingsTraversablePanel>();
    private final Map<String, ProjectSettingsTraversablePanel.PersistenceLocation> _savedPersistenceLocations = new HashMap<String, ProjectSettingsTraversablePanel.PersistenceLocation>();
    private transient LazyLoadListener _lazyLoadListener = new LazyTraversableListener();
    private transient EnterTraversableHandler _traversableListener = new EnterTraversableHandler();

    ProjectPropertiesMDDPanel(Navigable[] rootNavigables, boolean useDetailTree, Namespace propertyData, String objectLabel) {
        super(rootNavigables, useDetailTree);
        this._propertyData = propertyData;
        this.addMDDListener((MDDListener)this._traversableListener);
        ResourceUtils.resButton((AbstractButton)this._useProjectSettingsOption, (String)ProjectPropertiesArb.format(4, objectLabel));
    }

    protected TitledPanel createTitledPanel(JPanel propertyPanel) {
        this._propertiesPanel = propertyPanel;
        this._lineBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(IdeConstants.COLOR_IDE_LINES), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._propertiesPanel.setBorder(this._lineBorder);
        this._borderPanel = new JPanel(new BorderLayout(0, 3));
        this._borderPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._borderPanel.add((Component)this.createPersistanceOptionsPanel(), "North");
        this._borderPanel.add((Component)this._propertiesPanel, "Center");
        TitledPanel tPanel = new TitledPanel((Component)this._borderPanel);
        tPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        return tPanel;
    }

    private boolean loadDialog(ProjectSettingsTraversablePanel.PersistenceLocation loc) {
        Assert.check((ProjectSettingsTraversablePanel.PersistenceLocation.PROJECT_SHARED != loc ? 1 : 0) != 0);
        Navigable navigable = this.getCurrentNavigable();
        Traversable traversable = navigable.newTraversable((ApplyNotifier)this);
        ProjectSettingsTraversablePanel.storePersistenceLocation(this._propertyData, loc);
        int resIdx = loc == ProjectSettingsTraversablePanel.PersistenceLocation.USER_PRIVATE ? 0 : 10;
        String title = ProjectPropertiesArb.format(resIdx, navigable.getShortLabel());
        TDialogLauncher launcher = new TDialogLauncher((Component)((Object)Ide.getMainWindow()), title, traversable, this._propertyData);
        JEWTDialog dlg = launcher.initDialog();
        dlg.pack();
        dlg.setMaximumInitialSize(500, 420);
        boolean okay = launcher.showDialog();
        launcher.dispose();
        ProjectSettingsTraversablePanel.storePersistenceLocation(this._propertyData, ProjectSettingsTraversablePanel.PersistenceLocation.PROJECT_SHARED);
        return okay;
    }

    private JPanel createPersistanceOptionsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this._persistanceOptionsPanel = new JPanel(gridBagLayout);
        this._usePrivateSettingsOption = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._usePrivateSettingsOption, (String)ProjectPropertiesArb.getString(3));
        this._editPrivateSettingsButton = new JButton();
        this._editPrivateSettingsButton.setEnabled(false);
        ResourceUtils.resButton((AbstractButton)this._editPrivateSettingsButton, (String)ProjectPropertiesArb.getString(1));
        this._editPrivateSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesMDDPanel.this.loadDialog(ProjectSettingsTraversablePanel.PersistenceLocation.USER_PRIVATE);
            }
        });
        this._useWorkspaceSettingsOption = new JRadioButton();
        this._useWorkspaceSettingsOption.setVisible(false);
        ResourceUtils.resButton((AbstractButton)this._useWorkspaceSettingsOption, (String)ProjectPropertiesArb.getString(8));
        this._editWorkspaceSettingsButton = new JButton();
        this._editWorkspaceSettingsButton.setEnabled(false);
        this._editWorkspaceSettingsButton.setVisible(false);
        ResourceUtils.resButton((AbstractButton)this._editWorkspaceSettingsButton, (String)ProjectPropertiesArb.getString(9));
        this._editWorkspaceSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesMDDPanel.this.loadDialog(ProjectSettingsTraversablePanel.PersistenceLocation.WORKSPACE_SHARED);
            }
        });
        this._useProjectSettingsOption = new JRadioButton();
        ButtonGroup group = new ButtonGroup();
        group.add(this._usePrivateSettingsOption);
        group.add(this._useProjectSettingsOption);
        group.add(this._useWorkspaceSettingsOption);
        this._useProjectSettingsOption.setSelected(true);
        OptionListener listener = new OptionListener();
        this._usePrivateSettingsOption.addItemListener(listener);
        this._useProjectSettingsOption.addItemListener(listener);
        this._useWorkspaceSettingsOption.addItemListener(listener);
        this._persistanceOptionsPanel.add((Component)this._usePrivateSettingsOption, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._persistanceOptionsPanel.add((Component)this._editPrivateSettingsButton, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 8, 0, 0), 0, 0));
        this._persistanceOptionsPanel.add((Component)this._useProjectSettingsOption, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
        this._persistanceOptionsPanel.add((Component)this._useWorkspaceSettingsOption, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._persistanceOptionsPanel.add((Component)this._editWorkspaceSettingsButton, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 8, 5, 0), 0, 0));
        return this._persistanceOptionsPanel;
    }

    private void setPanelEnabled(boolean enabled) {
        Component comp = this.getCurrentTraversable().getComponent();
        if (comp instanceof Container) {
            this.setPanelEnabled((Container)comp, enabled);
        }
    }

    private void setPanelEnabled(Container container, boolean enable) {
        Component[] children;
        for (Component child : children = container.getComponents()) {
            if (!(child instanceof Container)) continue;
            try {
                this.setPanelEnabled((Container)child, enable);
            }
            catch (Exception e) {
                // empty catch block
            }
            child.setEnabled(enable);
        }
    }

    private void setOptionsPanelVisible(boolean visible) {
        if (visible && this._propertiesPanel.getBorder() == null) {
            this._borderPanel.add((Component)this._persistanceOptionsPanel, "North");
            this._propertiesPanel.setBorder(this._lineBorder);
        } else if (!visible && this._propertiesPanel.getBorder() != null) {
            this._borderPanel.remove(this._persistanceOptionsPanel);
            this._propertiesPanel.setBorder(null);
        }
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        if (this._useProjectSettingsOption.isSelected()) {
            super.onExit(tc);
        }
        Iterator<ProjectSettingsTraversablePanel> iterator = this._visitedPanels.iterator();
        while (iterator.hasNext()) {
            ProjectSettingsTraversablePanel panel = iterator.next();
            String hashKey = panel.rootPropertiesHashKey();
            ProjectSettingsTraversablePanel.PersistenceLocation location = this._savedPersistenceLocations.get(hashKey);
            if (location == ProjectSettingsTraversablePanel.PersistenceLocation.USER_PRIVATE) {
                panel.activateProperties(tc, true);
            } else if (location == ProjectSettingsTraversablePanel.PersistenceLocation.PROJECT_SHARED) {
                panel.activateProperties(tc, false);
            }
            if (panel.supportsWorkspaceSharedProperties()) {
                boolean storePropertiesInWorkspace = location == ProjectSettingsTraversablePanel.PersistenceLocation.WORKSPACE_SHARED;
                SharedPropertiesManager.get().setUsesSharedProperties(ProjectSettingsTraversablePanel.getProject((Namespace)tc), panel.rootPropertiesHashKey(), storePropertiesInWorkspace);
            }
            iterator.remove();
            this._savedPersistenceLocations.remove(hashKey);
        }
    }

    private void selectRadioButton(ProjectSettingsTraversablePanel.PersistenceLocation location) {
        Assert.check((location != null ? 1 : 0) != 0);
        JRadioButton option = location == ProjectSettingsTraversablePanel.PersistenceLocation.USER_PRIVATE ? this._usePrivateSettingsOption : (location == ProjectSettingsTraversablePanel.PersistenceLocation.PROJECT_SHARED ? this._useProjectSettingsOption : this._useWorkspaceSettingsOption);
        option.setSelected(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRadioButtonsAndPanelState(ProjectSettingsTraversablePanel.PersistenceLocation target) {
        WaitCursor waitCursor = new WaitCursor((Component)((Object)this));
        try {
            waitCursor.show();
            Traversable currentTraversable = this.getCurrentTraversable();
            if (ProjectSettingsTraversablePanel.PersistenceLocation.USER_PRIVATE == target) {
                this.setPanelEnabled(false);
                this._editPrivateSettingsButton.setEnabled(true);
                this._editWorkspaceSettingsButton.setEnabled(false);
                try {
                    TraversableContext tc = this.newTraversableContext();
                    currentTraversable.onExit(tc);
                    ((ProjectSettingsTraversablePanel)currentTraversable).activateProperties(tc, true);
                }
                catch (TraversalException te) {
                    Assert.printStackTrace((Throwable)te);
                }
            } else if (ProjectSettingsTraversablePanel.PersistenceLocation.WORKSPACE_SHARED == target) {
                this.setPanelEnabled(false);
                this._editWorkspaceSettingsButton.setEnabled(true);
                this._editPrivateSettingsButton.setEnabled(false);
            } else {
                this._editWorkspaceSettingsButton.setEnabled(false);
                this._editPrivateSettingsButton.setEnabled(false);
                if (!this._traversableListenerEventIsFiring) {
                    this.setPanelEnabled(true);
                    currentTraversable.onEntry(this.newTraversableContext());
                }
            }
            this._savedPersistenceLocations.put(((ProjectSettingsTraversablePanel)currentTraversable).rootPropertiesHashKey(), target);
        }
        finally {
            waitCursor.hide();
        }
    }

    private class LazyTraversableListener
    implements LazyLoadListener {
        private LazyTraversableListener() {
        }

        @Override
        public void traversableLoaded(LazyLoadEvent event) {
            ((LazyTraversable)event.getSource()).removeLazyLoadListener(ProjectPropertiesMDDPanel.this._lazyLoadListener);
            Traversable t = event.getLoadedTraversable();
            ProjectPropertiesMDDPanel.this._traversableListener.traversableEntered(t);
        }
    }

    private class EnterTraversableHandler
    extends MDDAdapter {
        private Traversable _traversable;

        private EnterTraversableHandler() {
        }

        public void traversableEntered(MDDEvent e) {
            Traversable traversable = e.getTraversable();
            if (traversable != null) {
                this.traversableEntered(traversable);
            }
        }

        private void traversableEntered(Traversable t) {
            LazyTraversable lt;
            if (this._traversable instanceof LazyTraversable) {
                ((LazyTraversable)this._traversable).removeLazyLoadListener(ProjectPropertiesMDDPanel.this._lazyLoadListener);
            }
            this._traversable = t;
            if (!(t instanceof ProjectSettingsTraversablePanel)) {
                throw new RuntimeException("Error in: " + t.getClass().getName() + "\nProject Properties panels must extend oracle.ide.model.panels.ProjectSettingsTraversablePanel");
            }
            boolean actingLazy = false;
            if (t instanceof LazyTraversable && (lt = (LazyTraversable)t).isActingLazy()) {
                actingLazy = true;
                lt.addLazyLoadListener(ProjectPropertiesMDDPanel.this._lazyLoadListener);
            }
            ProjectSettingsTraversablePanel panel = (ProjectSettingsTraversablePanel)t;
            if (actingLazy || panel.isUserOnly()) {
                ProjectPropertiesMDDPanel.this.setOptionsPanelVisible(false);
            } else {
                ProjectSettingsTraversablePanel.PersistenceLocation location;
                String hashKey = panel.rootPropertiesHashKey();
                if (!ProjectPropertiesMDDPanel.this._savedPersistenceLocations.containsKey(hashKey)) {
                    location = panel.getPersistenceLocation();
                    ProjectPropertiesMDDPanel.this._savedPersistenceLocations.put(hashKey, location);
                    ProjectPropertiesMDDPanel.this._visitedPanels.add(panel);
                } else {
                    location = (ProjectSettingsTraversablePanel.PersistenceLocation)((Object)ProjectPropertiesMDDPanel.this._savedPersistenceLocations.get(hashKey));
                }
                boolean wsShared = panel.supportsWorkspaceSharedProperties();
                ProjectPropertiesMDDPanel.this._useWorkspaceSettingsOption.setVisible(wsShared);
                ProjectPropertiesMDDPanel.this._editWorkspaceSettingsButton.setVisible(wsShared);
                ProjectPropertiesMDDPanel.this.setOptionsPanelVisible(true);
                ProjectPropertiesMDDPanel.this._traversableListenerEventIsFiring = true;
                ProjectPropertiesMDDPanel.this.selectRadioButton(location);
                ProjectPropertiesMDDPanel.this.updateRadioButtonsAndPanelState(location);
            }
            ProjectPropertiesMDDPanel.this._traversableListenerEventIsFiring = false;
        }
    }

    private final class OptionListener
    implements ItemListener {
        private OptionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Object source = e.getSource();
                ProjectSettingsTraversablePanel.PersistenceLocation targetLoc = source == ProjectPropertiesMDDPanel.this._usePrivateSettingsOption ? ProjectSettingsTraversablePanel.PersistenceLocation.USER_PRIVATE : (source == ProjectPropertiesMDDPanel.this._useProjectSettingsOption ? ProjectSettingsTraversablePanel.PersistenceLocation.PROJECT_SHARED : ProjectSettingsTraversablePanel.PersistenceLocation.WORKSPACE_SHARED);
                ProjectPropertiesMDDPanel.this.updateRadioButtonsAndPanelState(targetLoc);
            }
        }
    }
}

