/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.panels;

import java.util.HashSet;
import oracle.ide.model.Project;
import oracle.ide.model.SharedPropertiesManager;
import oracle.ide.model.Workspace;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public abstract class ProjectSettingsTraversablePanel
extends DefaultTraversablePanel {
    private PersistenceLocation _location;
    private Boolean _wsPropertiesAreSupported;
    private static final String UNDEFINED_PROPERTY_DATA_KEY = "undefinedKey";
    private String _propertyDataKeyRoot = "undefinedKey";
    private int _propertiesAreOverridden = -1;
    private static final int OVERRIDDEN = 1;
    private static final int NOT_OVERRIDDEN = 0;
    private static final String EDITING_DEFAULT_PROJECT = "IsDefaultProject";
    private static final String PROPERTIES_DATA = "PropertyData";
    private static final String CHAINED_PROPERTY_DATA = "ChainedPropertyData";
    private static final String USER_ONLY_PROPERTY_DATA = "UserOnlyPropertyData";
    private static final String WORKSPACE_LEVEL_PROPERTY_DATA = "WorkspaceLevelPropertyData";
    private static final String PERSISTENCE_LOCATION = "PropertiesDataPersistenceLocation";
    private static final String PROJECT_OWNED_BY_WORKSPACE = "ProjectOwnedByWorkspace";
    @Deprecated
    public static final String DEFAULT_PROJECT_KEY = "IsDefaultProject";
    @Deprecated
    public static final String EDITING_CUSTOM_PROPERTIES_KEY = "IsUserPropertyData_Deprecated";
    @Deprecated
    public static final String PROPERTY_DATA_KEY = "PropertyData";
    @Deprecated
    public static final String CHAINED_PROPERTY_DATA_KEY = "ChainedPropertyData";
    @Deprecated
    public static final String USER_ONLY_PROPERTY_DATA_KEY = "UserOnlyPropertyData";

    public void onEntry(TraversableContext traversableContext) {
        if (traversableContext.contains("ChainedPropertyData") && this._location == null) {
            this._location = this.isUserOnly() ? PersistenceLocation.USER_PRIVATE : (this.supportsWorkspaceSharedProperties() && SharedPropertiesManager.get().isUsingSharedProperties(ProjectSettingsTraversablePanel.getProject((Namespace)traversableContext), this.rootPropertiesHashKey()) ? PersistenceLocation.WORKSPACE_SHARED : (this.projectPropertiesAreOverriden(traversableContext) ? PersistenceLocation.USER_PRIVATE : PersistenceLocation.PROJECT_SHARED));
        }
        this.onProjectPanelEntry(traversableContext);
    }

    public abstract void onProjectPanelEntry(TraversableContext var1);

    public abstract String getDataKey();

    public abstract String[] getPropertyKeys();

    protected static Workspace getProjectsOwningWorkspace(Namespace data) {
        return (Workspace)data.find(PROJECT_OWNED_BY_WORKSPACE);
    }

    protected static Project getProject(Namespace data) {
        return (Project)data.find("Project");
    }

    protected static PropertyStorage getPropertyData(Namespace data) {
        PersistenceLocation location = ProjectSettingsTraversablePanel.getPersistenceLocation(data);
        HashStructure properties = location == PersistenceLocation.WORKSPACE_SHARED ? (HashStructure)data.find(WORKSPACE_LEVEL_PROPERTY_DATA) : (HashStructure)data.find("PropertyData");
        return new PropertyData(properties);
    }

    protected boolean editsSharedProperties() {
        return false;
    }

    public static boolean isEditingSharedProperties(Namespace data) {
        PersistenceLocation location = (PersistenceLocation)((Object)data.find(PERSISTENCE_LOCATION));
        return location != null && PersistenceLocation.WORKSPACE_SHARED == location;
    }

    public final boolean supportsSharedProperties() {
        return this.editsSharedProperties() && SharedPropertiesManager.get().propertiesAreShareable(this.rootPropertiesHashKey());
    }

    public boolean isUserOnly() {
        return false;
    }

    public static final boolean isDefaultProject(Namespace data) {
        return Boolean.TRUE.equals(data.find("IsDefaultProject"));
    }

    public static final boolean editingUserProperties(Namespace data) {
        PersistenceLocation location = (PersistenceLocation)((Object)data.find(PERSISTENCE_LOCATION));
        return Boolean.TRUE.equals(PersistenceLocation.USER_PRIVATE == location);
    }

    public final void activateProperties(TraversableContext tc, boolean useCustom) {
        HashStructure allUserProperties = (HashStructure)tc.get("UserOnlyPropertyData");
        HashStructure user = this.getPanelProperties(allUserProperties);
        String[] propertyKeys = this.getPropertyKeys();
        if (useCustom) {
            user.recoverValues(propertyKeys);
        } else {
            user.hideValues(propertyKeys);
        }
    }

    @Deprecated
    public boolean arePropertiesOverridden() {
        return 1 == this._propertiesAreOverridden;
    }

    final boolean supportsWorkspaceSharedProperties() {
        if (this._wsPropertiesAreSupported == null) {
            String propertyDataKey = this.rootPropertiesHashKey();
            if (propertyDataKey == null) {
                this._wsPropertiesAreSupported = Boolean.FALSE;
            } else {
                boolean shareable = SharedPropertiesManager.get().propertiesAreShareable(propertyDataKey);
                this._wsPropertiesAreSupported = shareable;
            }
        }
        return this._wsPropertiesAreSupported;
    }

    final String rootPropertiesHashKey() {
        if (!UNDEFINED_PROPERTY_DATA_KEY.equals(this._propertyDataKeyRoot)) {
            return this._propertyDataKeyRoot;
        }
        this._propertyDataKeyRoot = this.getDataKey();
        String propertyDataKey = this._propertyDataKeyRoot;
        if (propertyDataKey == null) {
            String[] keys = this.getPropertyKeys();
            HashSet<String> set = new HashSet<String>();
            for (String key : keys) {
                int index = key.indexOf(47);
                if (index < 0 || index >= key.length()) {
                    set.add(key);
                    continue;
                }
                set.add(key.substring(0, index));
            }
            if (set.size() == 1) {
                propertyDataKey = (String)set.iterator().next();
            }
        }
        this._propertyDataKeyRoot = propertyDataKey;
        return this._propertyDataKeyRoot;
    }

    final PersistenceLocation getPersistenceLocation() {
        return this._location;
    }

    static final void storeSharedProperties(Namespace data, HashStructure sharedPropertiesHash) {
        data.put("PropertyData", (Object)sharedPropertiesHash);
    }

    static final void storeIsDefaultProject(Namespace data, Boolean isDefault) {
        data.put("IsDefaultProject", (Object)isDefault);
    }

    static final void storeChainedPropertiesData(Namespace data, HashStructure chainedPropertiesHash) {
        data.put("ChainedPropertyData", (Object)chainedPropertiesHash);
    }

    static final void storeUserPrivatePropertiesData(Namespace data, HashStructure userPropertiesHash) {
        data.put("UserOnlyPropertyData", (Object)userPropertiesHash);
    }

    static final void storeWorkspaceLevelProperties(Namespace data, HashStructure hashStructure) {
        data.put(WORKSPACE_LEVEL_PROPERTY_DATA, (Object)hashStructure);
    }

    static final void storePersistenceLocation(Namespace data, PersistenceLocation target) {
        data.put(PERSISTENCE_LOCATION, (Object)target);
    }

    static final PersistenceLocation getPersistenceLocation(Namespace data) {
        return (PersistenceLocation)((Object)data.get(PERSISTENCE_LOCATION));
    }

    static final void storeProjectsOwningWorkspace(Namespace data, Workspace workspace) {
        data.put(PROJECT_OWNED_BY_WORKSPACE, (Object)workspace);
    }

    private boolean projectPropertiesAreOverriden(TraversableContext traversableContext) {
        String[] propertyKeys = this.getPropertyKeys();
        if (this._propertiesAreOverridden < 0) {
            HashStructure allChainedProperties = (HashStructure)traversableContext.find("ChainedPropertyData");
            HashStructure chained = this.getPanelProperties(allChainedProperties);
            this._propertiesAreOverridden = chained.isAnyValueOverridden(propertyKeys) ? 1 : 0;
        }
        return 1 == this._propertiesAreOverridden;
    }

    private HashStructure getPanelProperties(HashStructure hash) {
        String dataKey = this.getDataKey();
        if (dataKey != null) {
            return hash.getOrCreateHashStructure(dataKey);
        }
        return hash;
    }

    static enum PersistenceLocation {
        USER_PRIVATE,
        PROJECT_SHARED,
        WORKSPACE_SHARED;

    }

    private static class PropertyData
    implements PropertyStorage {
        private HashStructure propertyData;

        public PropertyData(HashStructure hash) {
            if (hash == null) {
                throw new IllegalArgumentException("The HashStructure cannot be null.");
            }
            this.propertyData = hash;
        }

        public HashStructure getProperties() {
            return this.propertyData;
        }
    }
}

