/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTextArea;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.component.NewFilePanel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.ResourceUtils;

public class NewWorkspacePanel
extends DefaultTraversablePanel
implements VetoableChangeListener {
    private static final String HELP_TOPIC = "f1_idednewworkspace_html";
    private NewFilePanel _filePanel = new NewFilePanel();
    private JCheckBox _addProjectCheckBox;
    private JCheckBox _openNavigatorCheckBox;
    private JEWTDialog _dlg;
    private String _infoText;

    public NewWorkspacePanel(boolean showAddProject, boolean showOpenNavigator, boolean defaultWorkspaceFiles) {
        this(showAddProject, showOpenNavigator, defaultWorkspaceFiles, null);
    }

    public NewWorkspacePanel(boolean showAddProject, boolean showOpenNavigator, boolean defaultWorkspaceFiles, String infoText) {
        this.setLayout(new GridBagLayout());
        this.setFilePrompt(ComponentArb.getString(22));
        this._filePanel.setFileExtension(".jws");
        this._filePanel.setFileType(IdeArb.getString(274));
        this._filePanel.setShowExtension(false);
        if (defaultWorkspaceFiles) {
            URL wspDirURL = NewWorkspacePanel.getDefaultWorkspaceDirURL();
            String wspFileName = NewWorkspacePanel.getDefaultWorkspaceFileName(wspDirURL);
            this._filePanel.setDirectoryURL(wspDirURL);
            this._filePanel.setFileName(wspFileName);
        }
        this._infoText = infoText;
        this.add(this._filePanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (showAddProject) {
            this._addProjectCheckBox = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._addProjectCheckBox, (String)IdeArb.getString(263));
            this._addProjectCheckBox.setSelected(true);
            this.add(this._addProjectCheckBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        }
        if (showOpenNavigator) {
            this._openNavigatorCheckBox = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._openNavigatorCheckBox, (String)IdeArb.getString(262));
            this._openNavigatorCheckBox.setSelected(false);
            this.add(this._openNavigatorCheckBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        }
    }

    public static URL getDefaultWorkspaceDirURL() {
        URL wspDirURL;
        URL workDirURL;
        Workspaces workspaces = Ide.getWorkspaces();
        URL uRL = workDirURL = workspaces != null ? workspaces.getWorkDirectory() : null;
        if (workDirURL == null) {
            String dir = Ide.getWorkDirectory();
            workDirURL = URLFactory.newDirURL((String)dir);
        }
        String wspName = ModelArb.getString(6);
        int ctr = 1;
        while (URLFileSystem.exists((URL)(wspDirURL = URLFactory.newURL((URL)workDirURL, (String)(wspName + Integer.toString(ctr++)))))) {
        }
        return wspDirURL;
    }

    public static String getDefaultWorkspaceFileName(URL workspaceDirURL) {
        return URLFileSystem.getName((URL)workspaceDirURL) + ".jws";
    }

    public void defaultWorkspaceDirToURL(URL workspaceDirURL) {
        URL wspDirURL;
        if (workspaceDirURL == null) {
            String dir = Ide.getWorkDirectory();
            workspaceDirURL = URLFactory.newDirURL((String)dir);
        }
        String wspName = ModelArb.getString(6);
        int ctr = 1;
        while (URLFileSystem.exists((URL)(wspDirURL = URLFactory.newURL((URL)workspaceDirURL, (String)(wspName + Integer.toString(ctr++)))))) {
        }
        String wspFileName = NewWorkspacePanel.getDefaultWorkspaceFileName(wspDirURL);
        this._filePanel.setDirectoryURL(wspDirURL);
        this._filePanel.setFileName(wspFileName);
    }

    public void setDirectoryURL(URL directoryURL) {
        this._filePanel.setDirectoryURL(directoryURL);
    }

    public void setFileName(String fileName) {
        this._filePanel.setFileName(fileName);
    }

    public void setSupportsAutoFill(boolean supportsAutoFill) {
        this._filePanel.setSupportsAutoFill(supportsAutoFill);
    }

    public boolean runDialog() {
        return this.runDialog(IdeArb.getString(257));
    }

    public boolean runDialog(String title) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), HELP_TOPIC);
        this._dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)((Object)this), this._filePanel.getDefaultFocusComponent(), title);
        this._dlg.setDefaultButton(1);
        if (this._infoText != null) {
            this._dlg.setDialogHeader((Component)this.createInfoText(this._infoText));
        }
        this._dlg.addVetoableChangeListener((VetoableChangeListener)this);
        this._dlg.pack();
        return WizardLauncher.runDialog((JDialog)this._dlg);
    }

    public boolean validatePanel() {
        URL url = null;
        try {
            url = this._filePanel.getFileURL();
        }
        catch (TraversalException ex) {
            ex.showMessageDialog((Component)((Object)this));
        }
        return url != null;
    }

    public boolean isAddProject() {
        return this._addProjectCheckBox.isSelected();
    }

    public void setAddProject(boolean addProject) {
        this._addProjectCheckBox.setSelected(addProject);
    }

    public boolean isOpenNavigator() {
        return this._openNavigatorCheckBox.isSelected();
    }

    public void setOpenNavigator(boolean openNavigator) {
        this._openNavigatorCheckBox.setSelected(openNavigator);
    }

    public URL getFileURL() {
        try {
            return this._filePanel.getFileURL();
        }
        catch (TraversalException ex) {
            return null;
        }
    }

    public void setDirectoryPrompt(String directoryPrompt) {
        this._filePanel.setDirectoryPrompt(directoryPrompt);
    }

    public void setFilePrompt(String filePrompt) {
        this._filePanel.setFilePrompt(filePrompt);
    }

    public NewFilePanel getNewFilePanel() {
        return this._filePanel;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && !this.validatePanel()) {
            throw new PropertyVetoException("no", evt);
        }
    }

    private JTextArea createInfoText(String text) {
        JTextArea ta = new JTextArea();
        ta.setText(text);
        ta.setEditable(false);
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setFocusable(false);
        ta.setOpaque(false);
        ta.setRequestFocusEnabled(false);
        ta.setBorder(BorderFactory.createEmptyBorder(8, 10, 0, 10));
        return ta;
    }
}

