/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JScrollPane;
import oracle.ide.model.Element;
import oracle.ide.refactoring.DeleteActionHandler;
import oracle.ide.resource.DeleteDialogArb;

public class CompositeDeleteHandler<T extends Element>
extends DeleteActionHandler<T> {
    private Set<DeleteActionHandler> _delegates;
    private JScrollPane detailsPane = new JScrollPane();
    private DeleteActionHandler delegateInProgress;
    private Map<DeleteActionHandler, DeleteActionHandler.DeleteOption> _delegatesDecisions = new HashMap<DeleteActionHandler, DeleteActionHandler.DeleteOption>();
    private boolean callDelegatesDialogs = false;

    public CompositeDeleteHandler(Set<DeleteActionHandler> delegates, List<T> allNodes) {
        super(allNodes);
        this._delegates = delegates;
    }

    protected CompositeDeleteHandler() {
    }

    @Override
    public boolean doit() {
        boolean ret = true;
        Iterator<DeleteActionHandler> i$ = this._delegates.iterator();
        while (i$.hasNext()) {
            DeleteActionHandler d;
            this.delegateInProgress = d = i$.next();
            if (this.callDelegatesDialogs && this._delegatesDecisions.get(d) != DeleteActionHandler.DeleteOption.EraseFromDisk) continue;
            ret = ret && d.doit();
        }
        return ret;
    }

    @Override
    public DeleteActionHandler.DeleteOption clarifyToDeleteOrToRemoveFromParentContainer(Component dialogOwner) {
        if (this.callDelegatesDialogs) {
            DeleteActionHandler.DeleteOption option = DeleteActionHandler.DeleteOption.Cancelled;
            for (DeleteActionHandler d : this._delegates) {
                DeleteActionHandler.DeleteOption decision = d.clarifyToDeleteOrToRemoveFromParentContainer(dialogOwner);
                this._delegatesDecisions.put(d, decision);
                DeleteActionHandler.DetailsTextConfig config = d.getDetailsTextConfig();
                if (DeleteActionHandler.DeleteOption.EraseFromDisk != decision) continue;
                option = decision;
            }
            return option;
        }
        for (DeleteActionHandler d : this._delegates) {
            d.createDeleteConfirmationDialog(dialogOwner);
            d.preLaunchDialog();
        }
        return super.clarifyToDeleteOrToRemoveFromParentContainer(dialogOwner);
    }

    @Override
    protected DeleteActionHandler.DetailsTextConfig getDetailsTextConfig() {
        DeleteActionHandler.DetailsTextConfigBuilder builder = new DeleteActionHandler.DetailsTextConfigBuilder().title(DeleteDialogArb.getString(32)).showDetails(DeleteDialogArb.getString(42)).hideDetails(DeleteDialogArb.getString(34)).helpTopicId("f1_idedconfirmdelete_html");
        List nodes = this.getNodes();
        int numNodes = nodes.size();
        if (numNodes > 1) {
            builder.header(DeleteDialogArb.format(41, numNodes));
        } else if (numNodes == 1) {
            Element node = (Element)nodes.iterator().next();
            builder.description(node.getLongLabel()).header(DeleteDialogArb.format(35, node.getShortLabel()));
        } else {
            throw new IllegalStateException("No nodes to delete");
        }
        return builder.build();
    }

    @Override
    protected Component createDeleteDetailsComponent() {
        return this.detailsPane;
    }
}

