/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.jcip.annotations.ThreadSafe;
import oracle.ide.Context;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.dialogs.BaseUsageDialog;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.ActionDescriptionPanel;
import oracle.ide.refactoring.RefactoringActionHandler;
import oracle.ide.resource.DeleteDialogArb;
import oracle.ide.util.Assert;
import oracle.ide.vcs.VCSManager;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.ui.Colors;

public abstract class DeleteActionHandler<T extends Element>
extends RefactoringActionHandler {
    private BaseUsageDialog m_usageDialog = null;
    private boolean m_detailDialogOKed = false;
    private final List<T> m_nodes;
    private Context m_context = null;
    private boolean m_silentMode = false;
    private static final DeleteStrategy<Node> m_defaultNodeDeleteStrategy = new NodeDeleteStrategy();
    private DeleteStrategy m_deleteStrategy = new NodeDeleteStrategy();

    @Override
    public final void setSilentMode(boolean silent) {
        this.m_silentMode = silent;
    }

    @Override
    public final boolean isSilent() {
        return this.m_silentMode;
    }

    @Override
    public final Context getContext() {
        return this.m_context;
    }

    @Override
    public final void setContext(Context context) {
        this.m_context = context;
    }

    protected final List<T> getNodes() {
        return Collections.unmodifiableList(this.m_nodes);
    }

    protected abstract DetailsTextConfig getDetailsTextConfig();

    protected abstract Component createDeleteDetailsComponent();

    protected void preLaunchDialog() {
    }

    @Override
    public boolean doit() {
        UpdateMessage update = this.createUpdateMessage();
        final CloseNodeCommand clsCmd = new CloseNodeCommand(update);
        clsCmd.setContext(this.getContext());
        clsCmd.setNeedConfirm(false);
        final List<T> nodes = this.getNodes();
        if (!this.checkReadOnlyFiles(nodes)) {
            return false;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int status = clsCmd.close(nodes, false, false);
                if (status != 0) {
                    Assert.println((String)("Closing the nodes returned " + status + ". Continuing ..."));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException e) {
                Assert.println((String)"Close node operation interrupted.");
            }
            catch (InvocationTargetException e) {
                Assert.println((String)"Exception occured during closing nodes.");
            }
        }
        for (Element element : nodes) {
            if (this.getDeleteStrategy().delete(element) || !(element instanceof Node)) continue;
            this.getDeleteStrategy().addToNondeleted(((Node)element).getURL());
        }
        if (this.getDeleteStrategy().getNondeleted().size() > 0) {
            this.handleNonDeletedURLs(this.getDeleteStrategy().getNondeleted());
        }
        return true;
    }

    private boolean checkReadOnlyFiles(List<T> elements) {
        Element element;
        Iterator<T> i$ = elements.iterator();
        while (i$.hasNext() && (element = (Element)i$.next()) instanceof Node) {
            URL url = ((Node)element).getURL();
            if (!URLFileSystem.isReadOnly((URL)url) || VCSManager.getVCSManager().isVersioned(url)) continue;
            return MessageDialog.confirm(null, (Object)DeleteDialogArb.getString(46), (String)DeleteDialogArb.getString(45), null);
        }
        return true;
    }

    protected void handleNonDeletedURLs(List<URL> urls) {
        if (!this.m_silentMode) {
            DeleteActionHandler.raiseDeletionFailedDialog(urls);
        } else {
            Assert.println((String)("Failed to delete " + urls.size() + " files"));
            for (URL url : urls) {
                Assert.println((String)URLFileSystem.toDisplayString((URL)url));
            }
        }
    }

    public static void raiseDeletionFailedDialog(List<URL> urls) {
        DetailDialog nonDeleteDialog = DetailDialog.createDetailDialog(null, (String)DeleteDialogArb.getString(29), (int)1);
        JList<String> urlsContent = new JList<String>(DeleteActionHandler.convertAllToDisplayStrings(urls));
        urlsContent.setForeground(Colors.HINT_TEXT);
        MessagePanel messagePanel = new MessagePanel();
        messagePanel.setTitle(DeleteDialogArb.getString(30));
        messagePanel.setMessageText(DeleteDialogArb.getString(31));
        messagePanel.setMessageType(3);
        nonDeleteDialog.setContent((Component)messagePanel);
        nonDeleteDialog.setDetailContent((Component)new JScrollPane(urlsContent));
        nonDeleteDialog.runDialog();
    }

    private static String[] convertAllToDisplayStrings(List<URL> urls) {
        ArrayList<String> resultFiles = new ArrayList<String>(urls.size());
        for (URL url : urls) {
            resultFiles.add(url.getPath());
        }
        return resultFiles.toArray(new String[urls.size()]);
    }

    private UpdateMessage createUpdateMessage() {
        UpdateMessage message = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
        message.setProperty("Message.COMMAND_ID_PROP", 21);
        return message;
    }

    public boolean requireConfirm() {
        return this.getDetailsTextConfig().getConfirmTitle() != null && this.getDetailsTextConfig().getConfirmMessage() != null;
    }

    protected boolean hasOptions() {
        return false;
    }

    protected DeleteOption selectedOption(int optionIndex) {
        throw new UnsupportedOperationException("selectedOption(int) not supported");
    }

    public final void setSelectedOption(int index) {
        if (!this.hasOptions()) {
            throw new UnsupportedOperationException("setSelectedOption");
        }
        this.m_usageDialog.setSelectedOption(index);
    }

    public final void setStatus(String text, Icon icon) {
        this.m_usageDialog.setStatus(text, icon);
    }

    public final void clearStatus() {
        this.setStatus("", null);
    }

    protected void selectedOptionChanged(DeleteOption deleteOption) {
        if (!this.hasOptions()) {
            throw new UnsupportedOperationException("selectedOptionChanged() not supported");
        }
        this.deleteDetailsAvailable(deleteOption == DeleteOption.EraseFromDisk);
    }

    protected final void deleteDetailsAvailable(boolean detailsAvailable) {
        this.m_usageDialog.detailsAvailable(detailsAvailable);
    }

    public DeleteActionHandler(Context context) {
        this.m_context = context;
        this.m_nodes = ((SelectedNodesProvider)context.getProperty(SelectedNodesProvider.class.getName())).getSelectedNodes();
    }

    public DeleteActionHandler(List<T> nodes) {
        this.m_nodes = nodes;
    }

    protected DeleteActionHandler() {
        this.m_nodes = null;
    }

    public DetailDialog createDeleteConfirmationDialog(Component dialogOwner) {
        DetailsTextConfig textConfigs = this.getDetailsTextConfig();
        Component detailsComponent = this.createDeleteDetailsComponent();
        BaseUsageDialog dialog = new BaseUsageDialog();
        JComboBox comboBox = this.createScopeCombo();
        DetailDialog detailDialog = dialog.createUsageDialog(dialogOwner, textConfigs.getTitle(), textConfigs.getHeader(), textConfigs.getDescription(), textConfigs.getOptions(), textConfigs.getShowDetails(), textConfigs.getHideDetails(), textConfigs.getHelpTopicId(), detailsComponent, comboBox, this.createWorkingSetButton(comboBox), this.supportsPreview());
        this.m_usageDialog = dialog;
        if (this.hasOptions()) {
            this.m_usageDialog.addPanelSelectionListener(new ActionDescriptionPanel.OptionSelectionChangedListener(){

                @Override
                public void selectionChanged(ActionDescriptionPanel.OptionSelectionChangedEvent e) {
                    DeleteActionHandler.this.selectedOptionChanged(DeleteActionHandler.this.selectedOption(e.getSelectedIndex()));
                }
            });
        }
        return detailDialog;
    }

    protected boolean supportsPreview() {
        return false;
    }

    public boolean runDialog() {
        boolean ret;
        DetailDialog detailDialog = this.m_usageDialog.getDetailDialog();
        this.m_detailDialogOKed = detailDialog.runDialog();
        if (this.m_detailDialogOKed) {
            boolean hasPreview = this.m_usageDialog.hasPreview();
            if (this.runPostDialogTasks()) {
                this.m_usageDialog.saveSettings();
                if (hasPreview) {
                    this.showUsagesInLog();
                } else {
                    this.closeLogPageIfNecessary();
                }
                ret = !hasPreview;
            } else {
                this.closeLogPageIfNecessary();
                ret = false;
            }
        } else {
            this.closeLogPageIfNecessary();
            ret = false;
        }
        detailDialog.dispose();
        return ret;
    }

    protected JComboBox createScopeCombo() {
        return null;
    }

    protected JButton createWorkingSetButton(JComboBox comboBox) {
        return null;
    }

    protected JComboBox getScopeCombo() {
        return this.m_usageDialog.getScopeCombo();
    }

    protected void showUsagesInLog() {
    }

    protected void closeLogPageIfNecessary() {
    }

    public DeleteOption clarifyToDeleteOrToRemoveFromParentContainer(final Component dialogOwner) {
        final DeleteOption[] result = new DeleteOption[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DeleteActionHandler.this.createDeleteConfirmationDialog(dialogOwner);
                DeleteActionHandler.this.preLaunchDialog();
                if (DeleteActionHandler.this.runDialog()) {
                    if (DeleteOption.EraseFromDisk.equals((Object)DeleteActionHandler.this.getSelectedDeleteOption()) && DeleteActionHandler.this.requireConfirm()) {
                        if (DeleteActionHandler.this.askToConfirm(dialogOwner)) {
                            result[0] = DeleteActionHandler.this.getSelectedDeleteOption();
                            return;
                        }
                        result[0] = DeleteOption.Cancelled;
                        return;
                    }
                    result[0] = DeleteActionHandler.this.getSelectedDeleteOption();
                    return;
                }
                result[0] = DeleteOption.Cancelled;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                Assert.printStackTrace((Throwable)e);
                result[0] = DeleteOption.Cancelled;
            }
            catch (InvocationTargetException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Delete handler failed", e.getCause());
                result[0] = DeleteOption.Cancelled;
            }
        }
        return result[0];
    }

    public boolean askToConfirm(Component windowParent) {
        Boolean confirmed = MessageDialog.getPersistence().getConfirmed(this.getClass().getName());
        if (confirmed != null) {
            return true;
        }
        return MessageDialog.optionalConfirm((String)this.getClass().getName(), (Component)windowParent, (Object)this.getDetailsTextConfig().getConfirmMessage(), (String)this.getDetailsTextConfig().getConfirmTitle(), null);
    }

    public DeleteOption getSelectedDeleteOption() {
        if (this.m_usageDialog.getDetailDialog().isShowing() || this.m_detailDialogOKed) {
            if (this.hasOptions()) {
                return this.selectedOption(this.m_usageDialog.getSelectedOptionIndex());
            }
            return DeleteOption.EraseFromDisk;
        }
        return DeleteOption.Cancelled;
    }

    public static final DeleteStrategy<Node> getDefaultDeleteStrategy() {
        return m_defaultNodeDeleteStrategy;
    }

    public void setDeleteStrategy(DeleteStrategy deleteStrategy) {
        this.m_deleteStrategy = deleteStrategy;
    }

    public DeleteStrategy getDeleteStrategy() {
        return this.m_deleteStrategy;
    }

    public static interface SelectedNodesProvider<ElementType extends Element> {
        public List<ElementType> getSelectedNodes();
    }

    public static class NodeDeleteStrategy
    extends DeleteStrategy<Node> {
        @Override
        public boolean delete(Node node) {
            if (node.isOpen()) {
                try {
                    node.close();
                }
                catch (IOException e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
            boolean succeeded = URLFileSystem.delete((URL)node.getURL());
            return succeeded;
        }
    }

    @ThreadSafe
    public static abstract class DeleteStrategy<E extends Element> {
        private CopyOnWriteArrayList<URL> m_nondeleted = new CopyOnWriteArrayList();

        public abstract boolean delete(E var1);

        public final void addToNondeleted(URL url) {
            this.m_nondeleted.addIfAbsent(url);
        }

        public final void addAllToNondeleted(List<URL> urls) {
            this.m_nondeleted.addAllAbsent(urls);
        }

        public final List<URL> getNondeleted() {
            return this.m_nondeleted;
        }
    }

    public static class DetailsTextConfigBuilder {
        String m_showDetails = null;
        String m_hideDetails = null;
        String m_title = null;
        String m_header = null;
        String m_description = null;
        String[] m_options = null;
        String m_confirmTitle = null;
        String m_confirmMessage = null;
        String m_helpTopicId = null;

        public DetailsTextConfigBuilder title(String title) {
            this.m_title = title;
            return this;
        }

        public DetailsTextConfigBuilder header(String header) {
            this.m_header = header;
            return this;
        }

        public DetailsTextConfigBuilder description(String description) {
            this.m_description = description;
            return this;
        }

        public DetailsTextConfigBuilder showDetails(String showDetails) {
            this.m_showDetails = showDetails;
            return this;
        }

        public DetailsTextConfigBuilder hideDetails(String hideDetails) {
            this.m_hideDetails = hideDetails;
            return this;
        }

        public DetailsTextConfigBuilder options(String ... options) {
            this.m_options = options;
            return this;
        }

        public DetailsTextConfigBuilder confirmTitle(String confirmTitle) {
            this.m_confirmTitle = confirmTitle;
            return this;
        }

        public DetailsTextConfigBuilder confirmMessage(String confirmMessage) {
            this.m_confirmMessage = confirmMessage;
            return this;
        }

        public DetailsTextConfigBuilder helpTopicId(String helpTopicId) {
            this.m_helpTopicId = helpTopicId;
            return this;
        }

        public DetailsTextConfig build() {
            if (this.m_options == null || this.m_options.length == 0) {
                return new DetailsTextConfig(this.m_title, this.m_header, this.m_description, this.m_showDetails, this.m_hideDetails, this.m_confirmTitle, this.m_confirmMessage, this.m_helpTopicId, new String[0]);
            }
            return new DetailsTextConfig(this.m_title, this.m_header, this.m_description, this.m_showDetails, this.m_hideDetails, this.m_confirmTitle, this.m_confirmMessage, this.m_helpTopicId, this.m_options);
        }
    }

    public static final class DetailsTextConfig {
        final String m_showDetails;
        final String m_hideDetails;
        final String m_title;
        final String m_header;
        final String m_description;
        final String[] m_options;
        final String m_confirmTitle;
        final String m_confirmMessage;
        final String m_helpTopicId;

        DetailsTextConfig(String title, String header, String description, String showDetailsText, String hideDetailsText, String confirmTitle, String confirmMessage, String helpTopicId, String ... options) {
            this.m_showDetails = showDetailsText;
            this.m_hideDetails = hideDetailsText;
            this.m_title = title;
            this.m_header = header;
            this.m_description = description;
            this.m_options = options;
            this.m_confirmTitle = confirmTitle;
            this.m_confirmMessage = confirmMessage;
            this.m_helpTopicId = helpTopicId;
        }

        String getShowDetails() {
            return this.m_showDetails;
        }

        String getHideDetails() {
            return this.m_hideDetails;
        }

        String getTitle() {
            return this.m_title;
        }

        String getHeader() {
            return this.m_header;
        }

        String getDescription() {
            return this.m_description;
        }

        String[] getOptions() {
            return this.m_options;
        }

        String getConfirmTitle() {
            return this.m_confirmTitle;
        }

        String getConfirmMessage() {
            return this.m_confirmMessage;
        }

        String getHelpTopicId() {
            return this.m_helpTopicId;
        }
    }

    public static enum DeleteOption {
        EraseFromDisk,
        RemoveFromParent,
        Cancelled;

    }
}

