/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.model.Element;
import oracle.ide.refactoring.CompositeDeleteHandler;
import oracle.ide.refactoring.DeleteActionHandler;
import oracle.ide.refactoring.RefactoringActionHandler;
import oracle.ide.util.Assert;

public class DeleteHandlerService {
    private static Map<String, RefactoringActionHandler.HandlerLoadingInfo> m_element2HandlerMap = new HashMap<String, RefactoringActionHandler.HandlerLoadingInfo>();
    private static Map<String, Class<? extends RefactoringActionHandler>> m_handlerName2ClassMap = new HashMap<String, Class<? extends RefactoringActionHandler>>();
    private static ArrayList<RefactoringActionHandler.LookupHelper> m_lookupHelpers = new ArrayList<DefaultLookupHelper>(Collections.singletonList(new DefaultLookupHelper()));

    protected DeleteHandlerService() {
    }

    public static void registerActionHandler(String elementClassName, String refactoringActionHandlerClassName, String extensionId) {
        RefactoringActionHandler.HandlerLoadingInfo info = new RefactoringActionHandler.HandlerLoadingInfo(refactoringActionHandlerClassName, extensionId);
        m_element2HandlerMap.put(elementClassName, info);
    }

    public static void registerActionHandler(Class<? extends Element> classKey, Class<? extends RefactoringActionHandler> refactoringActionHandlerClass) {
        String elementClassName = classKey.getName();
        String refactoringActionHandlerClassName = refactoringActionHandlerClass.getName();
        RefactoringActionHandler.HandlerLoadingInfo info = new RefactoringActionHandler.HandlerLoadingInfo(refactoringActionHandlerClassName, null);
        m_element2HandlerMap.put(elementClassName, info);
        m_handlerName2ClassMap.put(refactoringActionHandlerClassName, refactoringActionHandlerClass);
    }

    public static Class<? extends RefactoringActionHandler> unregisterActionHandler(String elementClassName) {
        RefactoringActionHandler.HandlerLoadingInfo info = m_element2HandlerMap.remove(elementClassName);
        if (info != null) {
            return m_handlerName2ClassMap.remove(info.getHandlerClassName());
        }
        return null;
    }

    public static Class<? extends RefactoringActionHandler> unregisterActionHandler(Class<? extends Element> classKey) {
        String elementClassName = classKey.getName();
        return DeleteHandlerService.unregisterActionHandler(elementClassName);
    }

    public static DeleteActionHandler createDeleteHandler(Context context) {
        Element[] selections = context.getSelection();
        Assert.check((selections != null && selections.length > 0 ? 1 : 0) != 0);
        ArrayList<Element> stillActiveSelections = new ArrayList<Element>(Arrays.asList(selections));
        List<Class<? extends Element>> selectedSubtypes = DeleteHandlerService.getAllSelectedNodeSubtypes(context.getSelection());
        HashMap handlers = new HashMap();
        for (Class<? extends Element> nodeSubtype : selectedSubtypes) {
            if (stillActiveSelections.isEmpty()) break;
            Class<? extends RefactoringActionHandler> actionHandlerClass = DeleteHandlerService.getHandlerClass(nodeSubtype, context);
            if (actionHandlerClass == null) continue;
            ArrayList<Element> selectedNodes = new ArrayList<Element>();
            ListIterator iter = stillActiveSelections.listIterator();
            while (iter.hasNext()) {
                Element e = (Element)iter.next();
                if (nodeSubtype.isInstance(e)) {
                    selectedNodes.add(e);
                    iter.remove();
                    continue;
                }
                Class<? extends RefactoringActionHandler> nextElementHandlerClass = DeleteHandlerService.getHandlerClass(e.getClass(), context);
                if (nextElementHandlerClass == null || !actionHandlerClass.equals(nextElementHandlerClass)) continue;
                selectedNodes.add(e);
                iter.remove();
            }
            if (selectedNodes.isEmpty()) continue;
            handlers.put(actionHandlerClass, selectedNodes);
        }
        try {
            if (handlers.size() == 1) {
                Iterator iter = handlers.entrySet().iterator();
                final Map.Entry entry = iter.next();
                Constructor c = ((Class)entry.getKey()).getConstructor(Context.class);
                Context copy = new Context(context);
                copy.setProperty(DeleteActionHandler.SelectedNodesProvider.class.getName(), new DeleteActionHandler.SelectedNodesProvider(){

                    public List<? extends Element> getSelectedNodes() {
                        return (List)entry.getValue();
                    }
                });
                return (DeleteActionHandler)c.newInstance(new Context(copy));
            }
            if (handlers.size() > 1) {
                HashSet<DeleteActionHandler> actionHandlers = new HashSet<DeleteActionHandler>();
                ArrayList allNodes = new ArrayList();
                for (Map.Entry entry : handlers.entrySet()) {
                    Constructor c = ((Class)entry.getKey()).getConstructor(Context.class);
                    Context copy = new Context(context);
                    copy.setProperty(DeleteActionHandler.SelectedNodesProvider.class.getName(), new SelectedNodesProviderImpl((List)entry.getValue()));
                    DeleteActionHandler actionHandler = (DeleteActionHandler)c.newInstance(new Context(copy));
                    allNodes.addAll(actionHandler.getNodes());
                    actionHandlers.add(actionHandler);
                }
                CompositeDeleteHandler composite = new CompositeDeleteHandler(actionHandlers, allNodes);
                return composite;
            }
        }
        catch (InstantiationException e) {
            Assert.fail((Exception)e);
        }
        catch (NoSuchMethodException e) {
            Assert.fail((Exception)e);
        }
        catch (InvocationTargetException e) {
            Assert.fail((Exception)e);
        }
        catch (IllegalAccessException e) {
            Assert.fail((Exception)e);
        }
        return null;
    }

    public static void registerLookupHelper(RefactoringActionHandler.LookupHelper lookupHelper) {
        m_lookupHelpers.add(0, lookupHelper);
    }

    private static List<Class<? extends Element>> getAllSelectedNodeSubtypes(Element[] elements) {
        ArrayList<Class<? extends Element>> subtypes = new ArrayList<Class<? extends Element>>();
        for (Element e : elements) {
            if (subtypes.contains(e.getClass())) continue;
            subtypes.add(e.getClass());
        }
        Collections.sort(subtypes, new Comparator<Class<? extends Element>>(){

            @Override
            public int compare(Class<? extends Element> o1, Class<? extends Element> o2) {
                if (o2 != null && o2.isAssignableFrom(o1)) {
                    return -1;
                }
                if (o1 != null && o1.isAssignableFrom(o2)) {
                    return 1;
                }
                return 0;
            }
        });
        return subtypes;
    }

    private static Class<? extends RefactoringActionHandler> getHandlerClass(Class<? extends Element> elementClass, Context context) {
        for (RefactoringActionHandler.LookupHelper helper : m_lookupHelpers) {
            Class<? extends RefactoringActionHandler> c = helper.lookup(elementClass, context);
            if (c == null) continue;
            return c;
        }
        return new DefaultLookupHelper().lookup(elementClass, context);
    }

    private static class DefaultLookupHelper
    implements RefactoringActionHandler.LookupHelper {
        private DefaultLookupHelper() {
        }

        @Override
        public Class<? extends RefactoringActionHandler> lookup(Class<? extends Element> elementClass, Context context) {
            RefactoringActionHandler.HandlerLoadingInfo info = (RefactoringActionHandler.HandlerLoadingInfo)m_element2HandlerMap.get(elementClass.getName());
            Class<? extends Element> superClass = elementClass;
            while (info == null && superClass != null && !superClass.equals(Element.class)) {
                if ((superClass = superClass.getSuperclass()) == null) continue;
                info = (RefactoringActionHandler.HandlerLoadingInfo)m_element2HandlerMap.get(superClass.getName());
            }
            if (info != null) {
                String handlerClassName = info.getHandlerClassName();
                Class<Object> handlerClass = (Class<Object>)m_handlerName2ClassMap.get(handlerClassName);
                if (handlerClass == null) {
                    String extensionId = info.getExtensionId();
                    ClassLoader loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(extensionId);
                    MetaClass metaClass = new MetaClass(loader, handlerClassName);
                    try {
                        handlerClass = metaClass.toClass().asSubclass(Object.class);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                    if (handlerClass != null) {
                        m_handlerName2ClassMap.put(handlerClassName, handlerClass);
                    }
                }
                return handlerClass;
            }
            return null;
        }
    }

    private static class SelectedNodesProviderImpl
    implements DeleteActionHandler.SelectedNodesProvider {
        private List<Element> _elements;

        SelectedNodesProviderImpl(List<Element> elements) {
            this._elements = elements;
        }

        public List<Element> getSelectedNodes() {
            return this._elements;
        }
    }
}

