/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.jcip.annotations.ThreadSafe;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.BaseUsageDialog;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.refactoring.RefactoringActionHandler;
import oracle.ide.resource.MoveDialogArb;
import oracle.ide.resource.RenameDialogArb;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.ui.Colors;

public abstract class MoveActionHandler<T extends Element>
extends RefactoringActionHandler {
    private BaseUsageDialog m_usageDialog = null;
    private boolean m_detailDialogOKed = false;
    private final List<T> m_elements;
    private String m_destination;
    private JTextField m_destinationField;
    private Context m_context = null;
    private boolean m_silentMode = false;
    private static final MoveStrategy<Node> m_defaultNodeMoveStrategy = new NodeMoveStrategy();
    private MoveStrategy m_moveStrategy = new NodeMoveStrategy();

    @Override
    public final void setSilentMode(boolean silent) {
        this.m_silentMode = silent;
    }

    @Override
    public final boolean isSilent() {
        return this.m_silentMode;
    }

    @Override
    public final Context getContext() {
        return this.m_context;
    }

    @Override
    public final void setContext(Context context) {
        this.m_context = context;
    }

    protected final List<T> getElements() {
        return Collections.unmodifiableList(this.m_elements);
    }

    protected String getDestination() {
        if (this.m_destinationField != null) {
            this.m_destination = this.m_destinationField.getText();
        }
        return this.m_destination;
    }

    protected abstract Component createMoveDetailsComponent();

    protected boolean preLaunchDialog() {
        return true;
    }

    public boolean doit(boolean silently) {
        this.createMoveConfirmationDialog((JFrame)((Object)Ide.getMainWindow()));
        if (this.preLaunchDialog() && this.runDialog()) {
            return this.doit();
        }
        return false;
    }

    @Override
    public boolean doit() {
        List<T> elements = this.getElements();
        String destination = this.getDestination();
        boolean ret = false;
        for (Element element : elements) {
            boolean successful = this.getMoveStrategy().move(element, destination);
            if (successful && !ret) {
                ret = successful;
            }
            if (successful || !(element instanceof Node)) continue;
            this.getMoveStrategy().addToNonmoved(((Node)element).getURL());
        }
        this.runPostProcessingTasks();
        if (this.getMoveStrategy().getNonmoved().size() > 0) {
            this.handleNonMovedURLs(this.getMoveStrategy().getNonmoved());
        }
        return ret;
    }

    protected void runPostProcessingTasks() {
    }

    protected void handleNonMovedURLs(List<URL> urls) {
        if (!this.m_silentMode) {
            DetailDialog nonMoveDialog = DetailDialog.createDetailDialog(null, (String)MoveDialogArb.getString(4), (int)1);
            JList<String> urlsContent = new JList<String>(MoveActionHandler.convertAllToDisplayStrings(urls));
            urlsContent.setForeground(Colors.HINT_TEXT);
            MessagePanel messagePanel = new MessagePanel();
            messagePanel.setTitle(MoveDialogArb.getString(5));
            messagePanel.setMessageText(MoveDialogArb.getString(6));
            messagePanel.setMessageType(3);
            nonMoveDialog.setContent((Component)messagePanel);
            nonMoveDialog.setDetailContent((Component)new JScrollPane(urlsContent));
            nonMoveDialog.runDialog();
        } else {
            Assert.println((String)("Failed to move " + urls.size() + " elements"));
            for (URL url : urls) {
                Assert.println((String)URLFileSystem.toDisplayString((URL)url));
            }
        }
    }

    private static String[] convertAllToDisplayStrings(List<URL> urls) {
        ArrayList<String> resultFiles = new ArrayList<String>(urls.size());
        for (URL url : urls) {
            resultFiles.add(MoveActionHandler.urlToFile(url));
        }
        return resultFiles.toArray(new String[urls.size()]);
    }

    static String urlToFile(URL fileUrl) {
        File file;
        try {
            file = new File(fileUrl.toURI());
        }
        catch (URISyntaxException e) {
            file = new File(fileUrl.getPath());
        }
        return file.getPath();
    }

    public final void setStatus(String text, Icon icon) {
        this.m_usageDialog.setStatus(text, icon);
    }

    public final void clearStatus() {
        this.setStatus("", null);
    }

    protected final void moveDetailsAvailable(boolean detailsAvailable) {
        this.m_usageDialog.detailsAvailable(detailsAvailable);
    }

    public MoveActionHandler(Context context) {
        this.m_context = context;
        this.m_elements = ((SelectedElementProvider)context.getProperty(SelectedElementProvider.class.getName())).getSelectedElements();
        this.m_destination = ((SelectedElementProvider)context.getProperty(SelectedElementProvider.class.getName())).getDestination();
    }

    public MoveActionHandler(List<T> elements, String destination) {
        this.m_elements = elements;
        this.m_destination = destination;
    }

    public DetailDialog createMoveConfirmationDialog(JFrame dialogOwner) {
        this.m_usageDialog = new BaseUsageDialog();
        Component detailsComponent = null;
        if (this.hasDetails()) {
            detailsComponent = this.createMoveDetailsComponent();
        }
        String movedName = this.m_elements.size() == 1 ? ((Element)this.m_elements.get(0)).getShortLabel() : MoveDialogArb.getString(3);
        DetailDialog detailDialog = this.m_usageDialog.createBaseDialog(dialogOwner, MessageFormat.format(MoveDialogArb.getString(2), movedName), this.getDialogContent(), detailsComponent, this.supportsPreview());
        detailDialog.setButtonTextWhenDetailsHidden(RenameDialogArb.getString(3), true);
        detailDialog.setButtonTextWhenDetailsShown(RenameDialogArb.getString(4), false);
        return detailDialog;
    }

    protected boolean supportsPreview() {
        return false;
    }

    protected JPanel getDialogContent() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel moveToLbl = new JLabel();
        this.m_destinationField = new JTextField(30);
        ResourceUtils.resLabel((JLabel)moveToLbl, (Component)this.m_destinationField, (String)MoveDialogArb.getString(0));
        Insets insets = new Insets(2, 2, 2, 2);
        panel.add((Component)moveToLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        panel.add((Component)this.m_destinationField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        return panel;
    }

    public boolean runDialog() {
        boolean ret;
        DetailDialog detailDialog = this.m_usageDialog.getDetailDialog();
        this.m_detailDialogOKed = detailDialog.runDialog();
        if (this.m_detailDialogOKed) {
            boolean isPreview = this.m_usageDialog.hasPreview();
            if (this.runPostDialogTasks()) {
                this.m_usageDialog.saveSettings();
                if (isPreview) {
                    this.showUsagesInLog();
                } else {
                    this.continueSearchingAsNeeded();
                }
                ret = !isPreview;
            } else {
                this.closeLogPageIfNecessary();
                ret = false;
            }
        } else {
            this.closeLogPageIfNecessary();
            ret = false;
        }
        detailDialog.dispose();
        return ret;
    }

    protected JComboBox createScopeCombo() {
        return null;
    }

    protected JButton createWorkingSetButton(JComboBox comboBox) {
        return null;
    }

    protected void setOKButtonEnabled(boolean enabled) {
        DetailDialog detailDialog = this.m_usageDialog.getDetailDialog();
        if (detailDialog != null) {
            detailDialog.setOKButtonEnabled(enabled);
        }
    }

    protected void setPreviewButtonEnabled(boolean enabled) {
        this.m_usageDialog.setPreviewButtonEnabled(enabled);
    }

    protected JComboBox getScopeCombo() {
        return this.m_usageDialog.getScopeCombo();
    }

    protected boolean hasDetails() {
        return false;
    }

    protected void showUsagesInLog() {
    }

    protected void continueSearchingAsNeeded() {
    }

    protected void closeLogPageIfNecessary() {
    }

    public static final MoveStrategy<Node> getDefaultMoveStrategy() {
        return m_defaultNodeMoveStrategy;
    }

    public void setMoveStrategy(MoveStrategy moveStrategy) {
        this.m_moveStrategy = moveStrategy;
    }

    public MoveStrategy getMoveStrategy() {
        return this.m_moveStrategy;
    }

    public static interface SelectedElementProvider<ElementType extends Element> {
        public List<ElementType> getSelectedElements();

        public String getDestination();
    }

    public static class NodeMoveStrategy
    extends MoveStrategy<Node> {
        @Override
        public boolean move(Node node, String destination) {
            if (node.isOpen()) {
                try {
                    node.close();
                }
                catch (IOException e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
            URL oldUrl = node.getURL();
            String nameAndExtension = node.getShortLabel();
            if (nameAndExtension != null) {
                String newFilePath = new File(destination, nameAndExtension).getPath();
                URL newUrl = URLFactory.newFileURL((String)newFilePath);
                boolean succeeded = URLFileSystem.renameTo((URL)oldUrl, (URL)newUrl);
                return succeeded;
            }
            return false;
        }
    }

    @ThreadSafe
    public static abstract class MoveStrategy<E extends Element> {
        private CopyOnWriteArrayList<URL> m_nonmoved = new CopyOnWriteArrayList();

        public abstract boolean move(E var1, String var2);

        public final void addToNonmoved(URL url) {
            this.m_nonmoved.addIfAbsent(url);
        }

        public final void addAllToNonmoved(List<URL> urls) {
            this.m_nonmoved.addAllAbsent(urls);
        }

        public final List<URL> getNonmoved() {
            return this.m_nonmoved;
        }
    }
}

