/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.jcip.annotations.ThreadSafe;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.BaseUsageDialog;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.refactoring.RefactoringActionHandler;
import oracle.ide.resource.RenameDialogArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.DetailDialog;

public abstract class RenameActionHandler<T extends Element>
extends RefactoringActionHandler {
    private BaseUsageDialog m_usageDialog = null;
    private boolean m_detailDialogOKed = false;
    private final Element m_element;
    private String m_newName;
    private JTextField m_newNameField;
    private Context m_context = null;
    private boolean m_silentMode = false;
    private static final RenameStrategy<Node> m_defaultNodeRenameStrategy = new NodeRenameStrategy();
    private RenameStrategy m_renameStrategy = new NodeRenameStrategy();

    @Override
    public final void setSilentMode(boolean silent) {
        this.m_silentMode = silent;
    }

    @Override
    public final boolean isSilent() {
        return this.m_silentMode;
    }

    @Override
    public final Context getContext() {
        return this.m_context;
    }

    @Override
    public final void setContext(Context context) {
        this.m_context = context;
    }

    protected final Element getElement() {
        return this.m_element;
    }

    protected String getNewName() {
        if (this.m_newNameField != null) {
            this.m_newName = this.m_newNameField.getText();
        }
        return this.m_newName;
    }

    protected abstract String getOldName();

    protected abstract Component createRenameDetailsComponent();

    protected boolean preLaunchDialog() {
        return true;
    }

    public boolean doit(boolean silently) {
        this.createRenameConfirmationDialog((JFrame)((Object)Ide.getMainWindow()));
        if (this.preLaunchDialog() && this.runDialog()) {
            return this.doit();
        }
        return false;
    }

    @Override
    public boolean doit() {
        Element element = this.getElement();
        String newName = this.getNewName();
        return this.getRenameStrategy().rename(element, newName);
    }

    public final void setStatus(String text, Icon icon) {
        this.m_usageDialog.setStatus(text, icon);
    }

    public final void clearStatus() {
        this.setStatus("", null);
    }

    protected final void renameDetailsAvailable(boolean detailsAvailable) {
        this.m_usageDialog.detailsAvailable(detailsAvailable);
    }

    public RenameActionHandler(Context context) {
        this.m_context = context;
        this.m_element = ((SelectedElementProvider)context.getProperty(SelectedElementProvider.class.getName())).getSelectedElement();
        this.m_newName = ((SelectedElementProvider)context.getProperty(SelectedElementProvider.class.getName())).getNewName();
    }

    public RenameActionHandler(Element element, String newName) {
        this.m_element = element;
        this.m_newName = newName;
    }

    public DetailDialog createRenameConfirmationDialog(JFrame dialogOwner) {
        this.m_usageDialog = new BaseUsageDialog();
        Component detailsComponent = null;
        if (this.hasDetails()) {
            detailsComponent = this.createRenameDetailsComponent();
        }
        DetailDialog detailDialog = this.m_usageDialog.createBaseDialog(dialogOwner, RenameDialogArb.getString(1), this.getDialogContent(), detailsComponent, this.supportsPreview());
        detailDialog.setButtonTextWhenDetailsHidden(RenameDialogArb.getString(3), true);
        detailDialog.setButtonTextWhenDetailsShown(RenameDialogArb.getString(4), false);
        detailDialog.setHelpTopicId("f1_rename_html");
        return detailDialog;
    }

    protected boolean supportsPreview() {
        return false;
    }

    protected JPanel getDialogContent() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel renameToLbl = new JLabel();
        this.m_newNameField = new JTextField(30);
        ResourceUtils.resLabel((JLabel)renameToLbl, (Component)this.m_newNameField, (String)RenameDialogArb.getString(0));
        Insets insets = new Insets(2, 2, 2, 2);
        panel.add((Component)renameToLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        panel.add((Component)this.m_newNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        return panel;
    }

    public boolean runDialog() {
        boolean ret;
        DetailDialog detailDialog = this.m_usageDialog.getDetailDialog();
        this.m_detailDialogOKed = detailDialog.runDialog();
        if (this.m_detailDialogOKed) {
            boolean isPreview = this.m_usageDialog.hasPreview();
            if (this.runPostDialogTasks()) {
                this.m_usageDialog.saveSettings();
                if (isPreview) {
                    this.showUsagesInLog();
                } else {
                    this.continueSearchingAsNeeded();
                }
                ret = !isPreview;
            } else {
                this.closeLogPageIfNecessary();
                ret = false;
            }
        } else {
            this.closeLogPageIfNecessary();
            ret = false;
        }
        detailDialog.dispose();
        return ret;
    }

    protected JComboBox createScopeCombo() {
        return null;
    }

    protected JButton createWorkingSetButton(JComboBox comboBox) {
        return null;
    }

    protected void setOKButtonEnabled(boolean enabled) {
        DetailDialog detailDialog = this.m_usageDialog.getDetailDialog();
        if (detailDialog != null) {
            detailDialog.setOKButtonEnabled(enabled);
        }
    }

    protected void setPreviewButtonEnabled(boolean enabled) {
        this.m_usageDialog.setPreviewButtonEnabled(enabled);
    }

    protected JComboBox getScopeCombo() {
        return this.m_usageDialog.getScopeCombo();
    }

    protected boolean hasDetails() {
        return false;
    }

    protected void showUsagesInLog() {
    }

    protected void continueSearchingAsNeeded() {
    }

    protected void closeLogPageIfNecessary() {
    }

    public static final RenameStrategy<Node> getDefaultRenameStrategy() {
        return m_defaultNodeRenameStrategy;
    }

    public void setRenameStrategy(RenameStrategy renameStrategy) {
        this.m_renameStrategy = renameStrategy;
    }

    public RenameStrategy getRenameStrategy() {
        return this.m_renameStrategy;
    }

    public static interface SelectedElementProvider {
        public Element getSelectedElement();

        public String getNewName();
    }

    public static class NodeRenameStrategy
    extends RenameStrategy<Node> {
        @Override
        public boolean rename(Node node, String newName) {
            try {
                URL oldUrl = node.getURL();
                File file = new File(oldUrl.toURI());
                File parentFile = file.getParentFile();
                if (parentFile != null) {
                    String newFilePath = new File(parentFile, newName).getPath();
                    URL newUrl = URLFactory.newFileURL((String)newFilePath);
                    boolean succeeded = URLFileSystem.renameTo((URL)node.getURL(), (URL)newUrl);
                    return succeeded;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return false;
        }
    }

    @ThreadSafe
    public static abstract class RenameStrategy<E extends Element> {
        public abstract boolean rename(E var1, String var2);
    }
}

