/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.model.Element;
import oracle.ide.refactoring.RefactoringActionHandler;
import oracle.ide.refactoring.RenameActionHandler;
import oracle.ide.util.Assert;

public final class RenameHandlerService {
    private static Map<String, RefactoringActionHandler.HandlerLoadingInfo> m_element2HandlerMap = new HashMap<String, RefactoringActionHandler.HandlerLoadingInfo>();
    private static Map<String, Class<? extends RefactoringActionHandler>> m_handlerName2ClassMap = new HashMap<String, Class<? extends RefactoringActionHandler>>();
    private static ArrayList<RefactoringActionHandler.LookupHelper> m_lookupHelpers = new ArrayList<DefaultLookupHelper>(Collections.singletonList(new DefaultLookupHelper()));

    private RenameHandlerService() {
    }

    public static void registerActionHandler(String elementClassName, String refactoringActionHandlerClassName, String extensionId) {
        RefactoringActionHandler.HandlerLoadingInfo info = new RefactoringActionHandler.HandlerLoadingInfo(refactoringActionHandlerClassName, extensionId);
        m_element2HandlerMap.put(elementClassName, info);
    }

    public static void registerActionHandler(Class<? extends Element> classKey, Class<? extends RefactoringActionHandler> refactoringActionHandlerClass) {
        String elementClassName = classKey.getName();
        String refactoringActionHandlerClassName = refactoringActionHandlerClass.getName();
        RefactoringActionHandler.HandlerLoadingInfo info = new RefactoringActionHandler.HandlerLoadingInfo(refactoringActionHandlerClassName, null);
        m_element2HandlerMap.put(elementClassName, info);
        m_handlerName2ClassMap.put(refactoringActionHandlerClassName, refactoringActionHandlerClass);
    }

    public static Class<? extends RefactoringActionHandler> unregisterActionHandler(String elementClassName) {
        RefactoringActionHandler.HandlerLoadingInfo info = m_element2HandlerMap.remove(elementClassName);
        if (info != null) {
            return m_handlerName2ClassMap.remove(info.getHandlerClassName());
        }
        return null;
    }

    public static Class<? extends RefactoringActionHandler> unregisterActionHandler(Class<? extends Element> classKey) {
        String elementClassName = classKey.getName();
        return RenameHandlerService.unregisterActionHandler(elementClassName);
    }

    public static RenameActionHandler createRenameHandler(Context context) {
        Element[] selections = context.getSelection();
        Assert.check((selections != null && selections.length > 0 ? 1 : 0) != 0);
        final Element selection = selections[0];
        final String newName = null;
        Class<?> elementSubtype = selection.getClass();
        Class<? extends RefactoringActionHandler> actionHandlerClass = RenameHandlerService.getHandlerClass(elementSubtype, context);
        if (actionHandlerClass != null) {
            try {
                Constructor<? extends RefactoringActionHandler> c = actionHandlerClass.getConstructor(Context.class);
                context.setProperty(RenameActionHandler.SelectedElementProvider.class.getName(), new RenameActionHandler.SelectedElementProvider(){

                    @Override
                    public Element getSelectedElement() {
                        return selection;
                    }

                    @Override
                    public String getNewName() {
                        return newName;
                    }
                });
                return (RenameActionHandler)c.newInstance(context);
            }
            catch (InstantiationException e) {
                Assert.fail((Exception)e);
            }
            catch (NoSuchMethodException e) {
                Assert.fail((Exception)e);
            }
            catch (InvocationTargetException e) {
                Assert.fail((Exception)e);
            }
            catch (IllegalAccessException e) {
                Assert.fail((Exception)e);
            }
        }
        return null;
    }

    public static void registerLookupHelper(RefactoringActionHandler.LookupHelper lookupHelper) {
        m_lookupHelpers.add(0, lookupHelper);
    }

    private static Class<? extends RefactoringActionHandler> getHandlerClass(Class<? extends Element> elementClass, Context context) {
        for (RefactoringActionHandler.LookupHelper helper : m_lookupHelpers) {
            Class<? extends RefactoringActionHandler> c = helper.lookup(elementClass, context);
            if (c == null) continue;
            return c;
        }
        return new DefaultLookupHelper().lookup(elementClass, context);
    }

    private static class DefaultLookupHelper
    implements RefactoringActionHandler.LookupHelper {
        private DefaultLookupHelper() {
        }

        @Override
        public Class<? extends RefactoringActionHandler> lookup(Class<? extends Element> elementClass, Context context) {
            RefactoringActionHandler.HandlerLoadingInfo info = (RefactoringActionHandler.HandlerLoadingInfo)m_element2HandlerMap.get(elementClass.getName());
            Class<? extends Element> superClass = elementClass;
            while (info == null && superClass != null && !superClass.equals(Element.class)) {
                if ((superClass = superClass.getSuperclass()) == null) continue;
                info = (RefactoringActionHandler.HandlerLoadingInfo)m_element2HandlerMap.get(superClass.getName());
            }
            if (info != null) {
                String handlerClassName = info.getHandlerClassName();
                Class<Object> handlerClass = (Class<Object>)m_handlerName2ClassMap.get(handlerClassName);
                if (handlerClass == null) {
                    String extensionId = info.getExtensionId();
                    ClassLoader loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(extensionId);
                    MetaClass metaClass = new MetaClass(loader, handlerClassName);
                    try {
                        handlerClass = metaClass.toClass().asSubclass(Object.class);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                    if (handlerClass != null) {
                        m_handlerName2ClassMap.put(handlerClassName, handlerClass);
                    }
                }
                return handlerClass;
            }
            return null;
        }
    }
}

