/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.task.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.ide.task.event.ProgressEvent;
import oracle.ide.task.event.TaskAdapter;
import oracle.ide.task.event.TaskEvent;
import oracle.ide.task.ui.TaskManagerDialogConfiguration;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;

public class TaskManagerDialog
extends TaskAdapter {
    private static TaskManagerDialog INSTANCE = null;
    private static int s_referenceCounter = 0;
    private final Component m_dialogParent;
    private DeterminateProgressMonitor m_monitor;
    private static int ISDONE_CHECK_INTERVAL = 100;
    private AtomicLong m_startTimestamp;
    private State m_feedbackState;
    private volatile boolean m_taskComplete = false;
    private AtomicBoolean m_hourGlassOn = new AtomicBoolean(false);
    private static final int NOFEEDBACK_DURATION = 1000;
    private static final int HOURGLASS_DURATION = 3000;
    private static final int MODAL_UP_FOR_LESS_THAN_A_SECOND_DURATION = 4000;
    private Timer m_progressMonitor = new Timer(ISDONE_CHECK_INTERVAL, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TaskManagerDialog.this.m_monitor.isCanceled()) {
                TaskManagerDialog.this.m_monitor.close();
            } else if (TaskManagerDialog.this.m_taskComplete) {
                State state = TaskManagerDialog.this.updateAndGetState();
                switch (state) {
                    case NOFEEDBACK: 
                    case HOURGLASS: 
                    case MODAL_UP: {
                        if (TaskManagerDialog.this.m_hourGlassOn.get()) {
                            TaskManagerDialog.this.m_dialogParent.setCursor(Cursor.getDefaultCursor());
                        }
                        TaskManagerDialog.this.m_monitor.close();
                        TaskManagerDialog.this.m_progressMonitor.stop();
                    }
                }
            } else {
                State state = TaskManagerDialog.this.updateAndGetState();
                switch (state) {
                    case HOURGLASS: {
                        if (TaskManagerDialog.this.m_hourGlassOn.get()) break;
                        TaskManagerDialog.this.m_dialogParent.setCursor(Cursor.getPredefinedCursor(3));
                        TaskManagerDialog.this.m_hourGlassOn.set(true);
                        break;
                    }
                    case MODAL_UP: 
                    case MODAL_UP_FOR_LESS_THAN_A_SECOND: {
                        if (TaskManagerDialog.this.m_hourGlassOn.get()) break;
                        TaskManagerDialog.this.m_dialogParent.setCursor(Cursor.getPredefinedCursor(3));
                        TaskManagerDialog.this.m_hourGlassOn.set(true);
                    }
                }
            }
        }
    });

    private TaskManagerDialog(Component dialogParent) {
        this.m_dialogParent = dialogParent;
    }

    private synchronized State updateAndGetState() {
        long timePassed = System.currentTimeMillis() - this.m_startTimestamp.get();
        this.m_feedbackState = timePassed < 1000L ? State.NOFEEDBACK : (timePassed < 3000L ? State.HOURGLASS : (timePassed < 4000L ? State.MODAL_UP_FOR_LESS_THAN_A_SECOND : State.MODAL_UP));
        return this.m_feedbackState;
    }

    public static TaskManagerDialog createDialog(Component parent, TaskManagerDialogConfiguration config) {
        INSTANCE = new TaskManagerDialog(parent);
        INSTANCE.createDialog(config);
        return INSTANCE;
    }

    private void createDialog(TaskManagerDialogConfiguration config) {
        this.m_monitor = new DeterminateProgressMonitor(this.m_dialogParent, config.getTitle(), (Object)config.getMessage(), config.getDetailedMessage());
        this.m_monitor.setMaximum(config.getMaxSteps().intValue());
        this.m_monitor.setMillisToDecideToPopup(3000);
        this.m_monitor.setModal(true);
        this.m_monitor.setCancellable(false);
    }

    public void start() {
        if (s_referenceCounter == 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TaskManagerDialog.this.m_startTimestamp = new AtomicLong(System.currentTimeMillis());
                    Cursor preCursor = TaskManagerDialog.this.m_dialogParent.getCursor();
                    TaskManagerDialog.this.m_dialogParent.setCursor(Cursor.getPredefinedCursor(3));
                    TaskManagerDialog.this.m_hourGlassOn.set(true);
                    TaskManagerDialog.this.m_progressMonitor.start();
                    TaskManagerDialog.this.m_monitor.start();
                    TaskManagerDialog.this.m_dialogParent.setCursor(preCursor);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException e) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
        } else {
            TaskManagerDialog.incrementReferenceCounter();
        }
    }

    @Override
    public void taskException(TaskEvent e, Exception ex) {
        this.m_taskComplete = true;
        TaskManagerDialog.decrementReferenceCounter();
    }

    @Override
    public void taskProgress(ProgressEvent e) {
        this.m_monitor.setProgress(e.getCurrent());
        if (e.getMessage() != null && e.getMessage().length > 0) {
            this.m_monitor.getPanel().setNote(e.getMessage()[0]);
        }
    }

    @Override
    public void taskCancelled(TaskEvent e) {
        this.m_taskComplete = true;
        TaskManagerDialog.decrementReferenceCounter();
    }

    @Override
    public void taskComplete(TaskEvent e) {
        this.m_taskComplete = true;
        TaskManagerDialog.decrementReferenceCounter();
    }

    private static int decrementReferenceCounter() {
        if (s_referenceCounter >= 0) {
            return --s_referenceCounter;
        }
        System.err.println("reference counter was null");
        s_referenceCounter = 0;
        return s_referenceCounter;
    }

    private static int incrementReferenceCounter() {
        return ++s_referenceCounter;
    }

    @Override
    public void taskStarted(TaskEvent e) {
        super.taskStarted(e);
    }

    private static enum State {
        NOT_STARTED,
        NOFEEDBACK,
        HOURGLASS,
        MODAL_UP_FOR_LESS_THAN_A_SECOND,
        MODAL_UP;

    }
}

