/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.test;

import java.lang.reflect.Method;
import oracle.ide.test.Bundle;
import oracle.ide.test.BundleException;

public final class BundleContext {
    private final Object real;

    BundleContext(Object o) {
        if (o.getClass().getName().endsWith("BundleContextImpl")) {
            this.real = o;
        } else if (o.getClass().getName().endsWith("Netbinox")) {
            try {
                Class<?> c = o.getClass();
                Method m = c.getDeclaredMethod("getBundleContext", new Class[0]);
                m.setAccessible(true);
                this.real = m.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            System.out.println("Warning: suspicious init of BC.real from unknown type: " + o.getClass());
            this.real = o;
        }
    }

    public static BundleContext getSystemBundleContext(ClassLoader loader) {
        try {
            Object netIgso;
            Class<?> starter = Class.forName("org.netbeans.NetigsoFramework", true, loader);
            try {
                Method getDefault = starter.getDeclaredMethod("getDefault", new Class[0]);
                getDefault.setAccessible(true);
                netIgso = getDefault.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException ex) {
                loader = Thread.currentThread().getContextClassLoader();
                starter = Class.forName("org.netbeans.core.startup.Main", true, loader);
                Method getModuleSystem = starter.getMethod("getModuleSystem", new Class[0]);
                Object ms = getModuleSystem.invoke(null, new Object[0]);
                Method getManager = getModuleSystem.getReturnType().getMethod("getManager", new Class[0]);
                Object mgr = getManager.invoke(ms, new Object[0]);
                Method nm = mgr.getClass().getDeclaredMethod("netigso", new Class[0]);
                nm.setAccessible(true);
                netIgso = nm.invoke(mgr, new Object[0]);
            }
            Method getFramework = netIgso.getClass().getDeclaredMethod("getFramework", new Class[0]);
            getFramework.setAccessible(true);
            return new BundleContext(getFramework.invoke(netIgso, new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Bundle[] getBundles() {
        Object[] originals = (Object[])BundleContext.callMethod(this.real, "getBundles", new Object[0]);
        Bundle[] arr = new Bundle[originals.length];
        for (int i = 0; i < originals.length; ++i) {
            arr[i] = new Bundle(originals[i]);
        }
        return arr;
    }

    public Bundle installBundle(String location) throws BundleException {
        Object b = BundleContext.callMethod(this.real, "installBundle", location);
        return new Bundle(b);
    }

    static Object callMethod(Object aThis, String name, Object ... args) {
        try {
            Class[] types = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                types[i] = args[i].getClass();
            }
            Method m = aThis.getClass().getMethod(name, types);
            m.setAccessible(true);
            return m.invoke(aThis, args);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

