/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class OrderedProperties
extends Properties {
    ArrayList orderedKeys = new ArrayList();
    ArrayList keysAndComments = new ArrayList();
    private static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public OrderedProperties() {
    }

    public OrderedProperties(Properties defaults) {
        super(defaults);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (!this.orderedKeys.contains(key)) {
            this.orderedKeys.add(key);
        }
        if (!this.keysAndComments.contains(key)) {
            this.keysAndComments.add(key);
        }
        return super.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        if (this.orderedKeys.contains(key)) {
            this.orderedKeys.remove(key);
        }
        if (this.keysAndComments.contains(key)) {
            this.keysAndComments.remove(key);
        }
        return super.remove(key);
    }

    public synchronized Iterator keysAndData() {
        return this.keysAndComments.listIterator();
    }

    @Override
    public synchronized void load(InputStream is) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        int ch = in.read();
        StringBuffer key = new StringBuffer();
        StringBuffer val = new StringBuffer();
        block19: while (true) {
            key.setLength(0);
            val.setLength(0);
            switch (ch) {
                case -1: {
                    return;
                }
                case 33: 
                case 35: {
                    do {
                        key.append((char)ch);
                    } while ((ch = in.read()) >= 0 && ch != 10 && ch != 13);
                    this.keysAndComments.add(key.toString());
                    if (ch != 10 && ch != 13 || (ch = in.read()) != 10) continue block19;
                    ch = in.read();
                    continue block19;
                }
                case 10: {
                    this.keysAndComments.add(" ");
                    ch = in.read();
                    continue block19;
                }
                case 9: 
                case 13: 
                case 32: {
                    ch = in.read();
                    continue block19;
                }
            }
            if (key.length() > 0) {
                key.setLength(0);
            }
            while (ch >= 0 && ch != 61 && ch != 58 && ch != 32 && ch != 9 && ch != 10 && ch != 13) {
                key.append((char)ch);
                ch = in.read();
            }
            while (ch == 32 || ch == 9) {
                ch = in.read();
            }
            if (ch == 61 || ch == 58) {
                ch = in.read();
            }
            while (ch == 32 || ch == 9) {
                ch = in.read();
            }
            block24: while (ch >= 0 && ch != 10 && ch != 13) {
                int next = 0;
                if (ch == 92) {
                    ch = in.read();
                    switch (ch) {
                        case 13: {
                            ch = in.read();
                            if (ch != 10 && ch != 32 && ch != 9) continue block24;
                        }
                        case 10: {
                            while ((ch = in.read()) == 32 || ch == 9) {
                            }
                            continue block24;
                        }
                        case 116: {
                            ch = 9;
                            next = in.read();
                            break;
                        }
                        case 110: {
                            ch = 10;
                            next = in.read();
                            break;
                        }
                        case 114: {
                            ch = 13;
                            next = in.read();
                            break;
                        }
                        case 117: {
                            while ((ch = in.read()) == 117) {
                            }
                            int d = 0;
                            block27: for (int i = 0; i < 4; ++i) {
                                next = in.read();
                                switch (ch) {
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: 
                                    case 56: 
                                    case 57: {
                                        d = (d << 4) + ch - 48;
                                        break;
                                    }
                                    case 97: 
                                    case 98: 
                                    case 99: 
                                    case 100: 
                                    case 101: 
                                    case 102: {
                                        d = (d << 4) + 10 + ch - 97;
                                        break;
                                    }
                                    case 65: 
                                    case 66: 
                                    case 67: 
                                    case 68: 
                                    case 69: 
                                    case 70: {
                                        d = (d << 4) + 10 + ch - 65;
                                        break;
                                    }
                                    default: {
                                        break block27;
                                    }
                                }
                                ch = next;
                            }
                            ch = d;
                            break;
                        }
                        default: {
                            next = in.read();
                            break;
                        }
                    }
                } else {
                    next = in.read();
                }
                val.append((char)ch);
                ch = next;
            }
            this.put(key.toString(), val.toString());
            if (ch != 10 && ch != 13 || (ch = in.read()) != 10) continue;
            ch = in.read();
        }
    }

    @Override
    public synchronized void save(OutputStream out, String header) {
        try {
            this.store(out, header);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void store(OutputStream out, String header) throws IOException {
        String realHeader;
        PrintWriter prnt = new PrintWriter((Writer)new OutputStreamWriter(out, "UTF-8"), false);
        boolean localize = true;
        String string = realHeader = header != null ? "#" + header : null;
        if (realHeader != null && !this.keysAndComments.contains(realHeader)) {
            prnt.println(realHeader);
        }
        Iterator iter = this.keysAndData();
        while (iter.hasNext()) {
            try {
                String key = (String)iter.next();
                String val = (String)this.get(key);
                if (key.length() > 0 && (key.charAt(0) == '#' || key.charAt(0) == '!')) {
                    prnt.println(key);
                    continue;
                }
                if (key.length() == 1 && key.charAt(0) == ' ') {
                    prnt.println("");
                    continue;
                }
                if (val == null) continue;
                prnt.print(key);
                prnt.print('=');
                int len = val.length();
                boolean empty = false;
                for (int i = 0; i < len; ++i) {
                    char ch = val.charAt(i);
                    switch (ch) {
                        case '\\': {
                            prnt.print('\\');
                            prnt.print('\\');
                            break;
                        }
                        case '\t': {
                            prnt.print('\\');
                            prnt.print('t');
                            break;
                        }
                        case '\n': {
                            prnt.print('\\');
                            prnt.print('n');
                            break;
                        }
                        case '\r': {
                            prnt.print('\\');
                            prnt.print('r');
                            break;
                        }
                        default: {
                            if (ch < ' ' || ch >= '\u007f' || empty && ch == ' ') {
                                if (ch > '\u007f' && localize) {
                                    prnt.print(ch);
                                    break;
                                }
                                prnt.print('\\');
                                prnt.print('u');
                                prnt.print(OrderedProperties.toHex(ch >> 12 & 0xF));
                                prnt.print(OrderedProperties.toHex(ch >> 8 & 0xF));
                                prnt.print(OrderedProperties.toHex(ch >> 4 & 0xF));
                                prnt.print(OrderedProperties.toHex(ch >> 0 & 0xF));
                                break;
                            }
                            prnt.print(ch);
                        }
                    }
                    empty = false;
                }
                prnt.print(System.getProperty("line.separator"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        prnt.flush();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

