/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.ArrayList;
import oracle.ide.util.PatternFilter;

public class PatternFiltersOptimizer {
    private ArrayList<Evaluator> m_evaluators = new ArrayList();

    public void setPatternFilters(PatternFilter[] filters) {
        this.m_evaluators.clear();
        if (filters == null) {
            return;
        }
        for (PatternFilter filter : filters) {
            this.m_evaluators.add(this.createEvaluator(filter));
        }
    }

    public PatternFilter getMatchingFilter(String target) {
        if (target == null) {
            return null;
        }
        for (Evaluator evaluator : this.m_evaluators) {
            if (!evaluator.matches(target)) continue;
            return evaluator.getFilter();
        }
        return null;
    }

    private Evaluator createEvaluator(PatternFilter filter) {
        int first = 0;
        String pattern = filter.getPattern();
        int length = pattern.length();
        if (first == length) {
            return new TrueEvaluator(filter);
        }
        if (pattern.charAt(first) != '*') {
            return new DefaultEvaluator(filter);
        }
        if (++first == length) {
            return new SingleLevelEvaluator(filter);
        }
        if (pattern.charAt(first) != '*') {
            return new DefaultEvaluator(filter);
        }
        if (++first == length) {
            return new TrueEvaluator(filter);
        }
        if (pattern.charAt(first) != '/') {
            return new DefaultEvaluator(filter);
        }
        if (++first == length) {
            return new TrueEvaluator(filter);
        }
        if (pattern.charAt(first) == '*' && first + 1 == length) {
            return new TrueEvaluator(filter);
        }
        assert (first < length);
        int last = length - 1;
        switch (pattern.charAt(last)) {
            case '*': {
                if (first == --last) {
                    return new DefaultEvaluator(filter);
                }
                if (pattern.charAt(last) == '*') {
                    if (first == --last) {
                        return new DefaultEvaluator(filter);
                    }
                    if (pattern.charAt(last) != '/') {
                        return new DefaultEvaluator(filter);
                    }
                    if (first == --last) {
                        return new DefaultEvaluator(filter);
                    }
                    for (int i = first; i <= last; ++i) {
                        char c = pattern.charAt(i);
                        if (c != '/' && c != '*' && c != '?') continue;
                        return new DefaultEvaluator(filter);
                    }
                    return new ContainsEvaluator(filter, pattern.substring(first, last + 1));
                }
                switch (pattern.charAt(first)) {
                    case '*': {
                        for (int i = first + 1; i <= last; ++i) {
                            char c = pattern.charAt(i);
                            if (c != '/' && c != '*' && c != '?') continue;
                            return new DefaultEvaluator(filter);
                        }
                        return new LastLevelContainsEvaluator(filter, pattern.substring(first + 1, last + 1));
                    }
                    case '/': 
                    case '?': {
                        return new DefaultEvaluator(filter);
                    }
                }
                for (int i = first; i <= last; ++i) {
                    char c = pattern.charAt(i);
                    if (c != '/' && c != '*' && c != '?') continue;
                    return new DefaultEvaluator(filter);
                }
                return new LastLevelStartsWithEvaluator(filter, pattern.substring(first, last + 1));
            }
            case '/': {
                if (first == --last) {
                    return new DefaultEvaluator(filter);
                }
                for (int i = first; i <= last; ++i) {
                    char c = pattern.charAt(i);
                    if (c != '*' && c != '?') continue;
                    return new DefaultEvaluator(filter);
                }
                return new ContainsEvaluator(filter, pattern.substring(first, last + 1));
            }
            case '?': {
                return new DefaultEvaluator(filter);
            }
        }
        switch (pattern.charAt(first)) {
            case '*': {
                for (int i = first + 1; i < last; ++i) {
                    char c = pattern.charAt(i);
                    if (c != '*' && c != '?') continue;
                    return new DefaultEvaluator(filter);
                }
                return new EndsWithEvaluator(filter, pattern.substring(first + 1, last + 1));
            }
            case '/': 
            case '?': {
                return new DefaultEvaluator(filter);
            }
        }
        for (int i = first; i <= last; ++i) {
            char c = pattern.charAt(i);
            if (c != '*' && c != '?') continue;
            return new DefaultEvaluator(filter);
        }
        return new EndsWithLevelsEvaluator(filter, pattern.substring(first, last + 1));
    }

    static class DefaultEvaluator
    extends Evaluator {
        DefaultEvaluator(PatternFilter filter) {
            super(filter);
        }

        @Override
        public boolean matches(String target) {
            return this.getFilter().matches(target);
        }
    }

    static class TrueEvaluator
    extends Evaluator {
        TrueEvaluator(PatternFilter filter) {
            super(filter);
        }

        @Override
        boolean matches(String target) {
            return true;
        }
    }

    static class ContainsEvaluator
    extends Evaluator {
        private String text;

        public ContainsEvaluator(PatternFilter filter, String text) {
            super(filter);
            this.text = text;
        }

        @Override
        public boolean matches(String target) {
            int size = this.text.length();
            int start = 0;
            int index;
            while ((index = target.indexOf(this.text, start)) >= 0) {
                if (!(index != 0 && target.charAt(index - 1) != '/' || index + size != target.length() && target.charAt(index + size) != '/')) {
                    return true;
                }
                start = index + 1;
            }
            return false;
        }
    }

    static class LastLevelStartsWithEvaluator
    extends Evaluator {
        private final String text;

        private LastLevelStartsWithEvaluator(PatternFilter filter, String text) {
            super(filter);
            this.text = text;
        }

        @Override
        public boolean matches(String target) {
            int slash = target.lastIndexOf(47);
            return target.regionMatches(slash + 1, this.text, 0, this.text.length());
        }
    }

    static class LastLevelContainsEvaluator
    extends Evaluator {
        private final String text;

        private LastLevelContainsEvaluator(PatternFilter filter, String text) {
            super(filter);
            this.text = text;
        }

        @Override
        public boolean matches(String target) {
            int slash = target.lastIndexOf(47);
            int index = target.indexOf(this.text, slash + 1);
            return index >= 0;
        }
    }

    static class EndsWithLevelsEvaluator
    extends Evaluator {
        private final String text;

        private EndsWithLevelsEvaluator(PatternFilter filter, String text) {
            super(filter);
            this.text = text;
        }

        @Override
        public boolean matches(String target) {
            int tail = target.length() - this.text.length();
            if (tail < 0) {
                return false;
            }
            return (tail == 0 || target.charAt(tail - 1) == '/') && target.endsWith(this.text);
        }
    }

    static class EndsWithEvaluator
    extends Evaluator {
        private final String text;

        private EndsWithEvaluator(PatternFilter filter, String text) {
            super(filter);
            this.text = text;
        }

        @Override
        public boolean matches(String target) {
            return target.endsWith(this.text);
        }
    }

    static class SingleLevelEvaluator
    extends Evaluator {
        private SingleLevelEvaluator(PatternFilter filter) {
            super(filter);
        }

        @Override
        public boolean matches(String target) {
            return target.indexOf(47) < 0;
        }
    }

    static abstract class Evaluator {
        private final PatternFilter filter;

        Evaluator(PatternFilter filter) {
            this.filter = filter;
        }

        PatternFilter getFilter() {
            return this.filter;
        }

        abstract boolean matches(String var1);

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.filter.getPattern() + "]";
        }
    }
}

