/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.dialogs.ExceptionDialog;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.log.LogManager;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.IntHashMap;
import oracle.ide.util.MenuSpec;
import oracle.ide.wizard.Invokable;
import oracle.ide.wizard.Wizard;

public final class WizardManager {
    private static final Logger LOG = Logger.getLogger(WizardManager.class.getName());
    public static final int OPEN_WIZARD_CMD_ID = Ide.findOrCreateCmdID("OpenWizardCommand");
    public static final String OPEN_WIZARD_CMD = "oracle.ide.cmd.OpenWizardCommand";
    private static WizardManager _instance = new WizardManager();
    private final ArrayList _wizards = new ArrayList();
    private WizardKeyContext _keyContext;
    private IntHashMap _actionHash = new IntHashMap();
    private final Controller _controller = new L();

    public static WizardManager getInstance() {
        return _instance;
    }

    public Invokable getInvokable(ClassLoader loader, String className) {
        if (loader == null) {
            throw new NullPointerException("loader is null");
        }
        if (className == null) {
            throw new NullPointerException("className is null");
        }
        try {
            MetaClass mc = new MetaClass(loader, className);
            return (Invokable)mc.newInstance();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Failed to create Invokable, " + className + ", with classloader " + loader, t);
            return null;
        }
    }

    public synchronized Wizard getWizard(Class clazz) {
        String wizName = clazz.getName();
        try {
            int numWizards = this._wizards.size();
            for (int i = 0; i < numWizards; ++i) {
                Wizard candidate = (Wizard)this._wizards.get(i);
                Class<?> cls = candidate.getClass();
                if (cls == null || !cls.getName().equals(wizName)) continue;
                return candidate;
            }
            Wizard newWiz = (Wizard)AddinManager.getAddinManager().getAddin(clazz);
            if (null == newWiz) {
                try {
                    newWiz = (Wizard)clazz.newInstance();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    return null;
                }
            }
            this.registerWizard(newWiz);
            return newWiz;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Failed to create wizard " + wizName, t);
            return null;
        }
    }

    @Deprecated
    public Wizard getWizard(String className) {
        try {
            return this.getWizard(Class.forName(className));
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Failed to create wizard " + className, t);
            return null;
        }
    }

    public Wizard getWizard(ClassLoader loader, String className) {
        if (loader == null) {
            throw new NullPointerException("loader is null");
        }
        if (className == null) {
            throw new NullPointerException("className is null");
        }
        try {
            MetaClass mc = new MetaClass(loader, className);
            return (Wizard)mc.newInstance();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Failed to create wizard, " + className + ", with classloader " + loader, t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWizard(Wizard wizard) {
        if (wizard != null) {
            ArrayList arrayList = this._wizards;
            synchronized (arrayList) {
                if (!this._wizards.contains(wizard)) {
                    this._wizards.add(wizard);
                }
            }
            this.addToToolsMenuIfNonNullMenuSpec(wizard);
        }
    }

    private void addToToolsMenuIfNonNullMenuSpec(Wizard wizard) {
        MenuSpec menuSpec = wizard.getMenuSpecification();
        if (menuSpec == null) {
            return;
        }
        Menubar menuBar = Ide.getMenubar();
        ResourceBundle bundle = menuSpec.getResourceBundle();
        String cmd = wizard.getClass().getName();
        int id = Ide.findOrCreateCmdID(cmd);
        this._actionHash.put(id, cmd);
        IdeAction action = bundle != null ? (bundle instanceof ArrayResourceBundle ? IdeAction.get(id, cmd, menuSpec.label, IdeMainWindow.ACTION_CATEGORY_TOOLS, menuSpec.mnemonic, (ArrayResourceBundle)bundle, (Integer)menuSpec.getBundleKey(), (Object)wizard, false) : IdeAction.get(id, cmd, menuSpec.label, IdeMainWindow.ACTION_CATEGORY_TOOLS, menuSpec.mnemonic, bundle, (String)menuSpec.getBundleKey(), (Object)wizard, false)) : IdeAction.get(id, cmd, menuSpec.label, IdeMainWindow.ACTION_CATEGORY_TOOLS, menuSpec.mnemonic, menuSpec.getIcon(), wizard, false);
        if (this._keyContext == null) {
            this._keyContext = new WizardKeyContext();
            Ide.getKeyStrokeContextRegistry().addContext(this._keyContext);
        }
        this._keyContext.addAction(action);
        action.addController(this._controller);
        JMenuItem menuItem = menuBar.createMenuItem(action);
        if (menuItem != null) {
            JMenu toolsMenu = MenuManager.getJMenu("Tools");
            menuBar.add(menuItem, toolsMenu, MenuConstants.SECTION_TOOLS_ADDINS);
        }
    }

    public boolean invokeWizard(Invokable invokable, Context context, String[] params, String[] technologyKeys) {
        return this.invokeWizard(invokable, context, null, params, technologyKeys);
    }

    public boolean invokeWizard(Invokable invokable, Context context, String wizardId, String[] params, String[] technologyKeys) {
        boolean ret = false;
        if (invokable != null) {
            try {
                HashSet<String> techScopeIds;
                Project project;
                Wizard.setWizardId(context, wizardId);
                Wizard.setLegacyParams(context, params);
                if (Boolean.valueOf(System.getProperty("docWriter")).booleanValue()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("object being invoked=");
                    sb.append(invokable.getClass().getName());
                    sb.append("\n");
                    if (params != null && params.length > 0) {
                        int counter = 0;
                        for (String paramString : params) {
                            sb.append("Param");
                            sb.append(counter++);
                            sb.append(":");
                            sb.append(paramString);
                            sb.append("\n");
                        }
                    }
                    LogManager.getIdeLogWindow().getPage().log(sb.toString());
                }
                if ((ret = invokable.invoke(context)) && context != null && technologyKeys != null && (project = context.getProject()) != null && !(techScopeIds = new HashSet<String>(Arrays.asList(technologyKeys))).isEmpty()) {
                    Collection<String> extensionIds = TechnologyRegistry.getInstance().getOwningExtensionIds(techScopeIds);
                    Collection<String> extensionGroupTechIds = TechnologyRegistry.getInstance().getTechnologiesOfGroupByMemberExtension(extensionIds);
                    techScopeIds.addAll(extensionGroupTechIds);
                    TechnologyScopeConfiguration.getInstance(project).updateTechnologyScope(techScopeIds.toArray(new String[techScopeIds.size()]));
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                ExceptionDialog.showExceptionDialog(context, t);
            }
        }
        return ret;
    }

    public void invokeSecondaryWizard(Invokable invokable, Context context, String[] params, String[] technologyKeys) {
        this.invokeSecondaryWizard(invokable, context, null, params, technologyKeys);
    }

    public void invokeSecondaryWizard(final Invokable invokable, final Context context, final String wizardId, final String[] params, final String[] technologyKeys) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WizardManager.this.invokeWizard(invokable, context, wizardId, params, technologyKeys);
            }
        });
    }

    private WizardManager() {
    }

    private boolean isWizardAction(IdeAction action) {
        return this._actionHash.containsKey(action.getCommandId());
    }

    private class L
    implements Controller {
        private L() {
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            Command command = null;
            if (WizardManager.this.isWizardAction(action)) {
                MetaClass mc = new MetaClass(this.getClass().getClassLoader(), WizardManager.OPEN_WIZARD_CMD);
                command = CommandProcessor.createCommandFromMeta(mc, context);
                command.setData(action.getValue("UserData"));
            }
            if (command != null) {
                try {
                    CommandProcessor cmdProc = CommandProcessor.getInstance();
                    cmdProc.invoke(command);
                }
                catch (Exception e) {
                    ExceptionDialog.showExceptionDialog(context, (Throwable)e);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            if (WizardManager.this.isWizardAction(action)) {
                Object value = action.getValue("UserData");
                Wizard wizard = (Wizard)value;
                action.setEnabled(wizard.isAvailable(context));
                action.putValue("controller-handling-update", wizard.getClass().getName());
                return true;
            }
            return false;
        }
    }

    private static class WizardKeyContext
    implements KeyStrokeContext {
        private static final String KEY = WizardKeyContext.class.getName();
        private HashSet _actions = new HashSet();

        private WizardKeyContext() {
        }

        @Override
        public String getAcceleratorFile() {
            return null;
        }

        @Override
        public List getAllPresets() {
            return null;
        }

        @Override
        public String getName() {
            return KEY;
        }

        @Override
        public KeyStrokeMap getPresetKeyStrokeMap(Object preset, boolean bGlobal) {
            return null;
        }

        @Override
        public Set getAllActions(boolean bGlobal) {
            return bGlobal ? this._actions : null;
        }

        void addAction(IdeAction action) {
            this._actions.add(action);
        }
    }
}

