/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.lang.reflect.Method;
import javax.naming.Context;
import javax.naming.InitialContext;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.ContentType;
import oracle.ide.model.DeployableTextNode;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectMigrator;
import oracle.ide.model.Recognizer;
import oracle.ide.model.UnrecognizedTextNode;
import oracle.ide.model.Workspace;
import oracle.ide.model.WorkspaceMigrator;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.Assert;
import oracle.ideimpl.IdeMenus;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.jndi.Names;

public final class CoreIdeAddin
implements Addin {
    @Override
    public void initialize() {
        Recognizer.mapExtensionToClass(".txt", DeployableTextNode.class);
        Recognizer.mapExtensionToClass(".text", DeployableTextNode.class);
        Recognizer.registerConversion(UnrecognizedTextNode.class, DeployableTextNode.class);
        Recognizer.mapExtensionToContentType(".stf", ContentType.BINARY);
        Recognizer.mapExtensionToContentType(".Jks", ContentType.BINARY);
        Recognizer.mapExtensionToContentType(".Pem", ContentType.BINARY);
        Recognizer.mapExtensionToContentType(".Der", ContentType.BINARY);
        Recognizer.registerDocumentInfo(Project.class, new DocumentInfo(ModelArb.getString(70), OracleIcons.getIcon((String)"project.png")));
        Recognizer.registerDocumentInfo(Workspace.class, new DocumentInfo(ModelArb.getString(71), OracleIcons.getIcon((String)"application.png")));
        Recognizer.registerDocumentInfo(DeployableTextNode.class, new DocumentInfo(ModelArb.getString(72)));
        if (Ide.getIdeArgs().getCreateUI()) {
            String version;
            this.loadMenus();
            DefaultURLFilter textFileFilter = new DefaultURLFilter(IdeArb.getString(535), ".txt");
            DialogUtil.addURLFilter((URLFilter)textFileFilter);
            if (Version.DEBUG_BUILD != 0 && Boolean.valueOf(System.getProperty("ide.awtHangCheck")).booleanValue() && (version = System.getProperty("java.version")) != null && version.startsWith("1.5")) {
                Assert.println((String)"Enabling the Java 1.5 EventThreadHangMonitor");
                try {
                    Class<?> cls = Class.forName("oracle.javatools.internal.ui.EventThreadHangMonitor");
                    Method method = cls.getMethod("initMonitoring", new Class[0]);
                    method.invoke(null, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        GlobalIgnoreList.registerExcludeFilter("**/*.DS_Store");
        InitialContext ic = Names.newInitialContext();
        Names.bind((Context)ic, (String)WorkspaceMigrator.MIGRATOR_NAME, (Object)new WorkspaceMigrator());
        ProjectMigrator projectMigrator = new ProjectMigrator();
        Names.bind((Context)ic, (String)ProjectMigrator.MIGRATOR_NAME, (Object)projectMigrator);
    }

    private void loadMenus() {
        IdeMenus.loadFileMenu();
        IdeMenus.loadEditMenu();
        IdeMenus.loadSearchMenu();
        IdeMenus.loadViewMenu();
        IdeMenus.loadNavigateMenu();
        IdeMenus.loadToolsMenu();
        IdeMenus.loadHelpMenu();
    }
}

