/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.adapters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.javaxide.Util;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ClassHierarchy;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Pair;

public class AdapterFactoryHookListener
implements HashStructureHookListener {
    static final String FACTORY_ELMT = "factory";
    static final String TARGET_TYPE_ATTR = "adapt-to";
    static final String ADAPTABLE_TYPE_ATTR = "adapt-from";
    static final String FACTORY_IMPL_ATTR = "impl";
    private Map<String, Map<String, HashStructure>> unresolvedFactoriesByTargetTypeAndAdaptableType = Collections.synchronizedMap(new HashMap());

    @Override
    public void elementVisited(HashStructureHookEvent e) {
        this.registerAdapterFactories(e.getNewElementHashStructure());
    }

    @Override
    public void listenerAttached(HashStructureHookEvent e) {
        this.registerAdapterFactories(e.getCombinedHashStructure());
    }

    private void registerAdapterFactories(HashStructure hashStructure) {
        if (null == hashStructure) {
            return;
        }
        List list = hashStructure.getAsList(FACTORY_ELMT);
        if (null == list) {
            return;
        }
        for (Object obj : list) {
            String factoryTypeName;
            String adaptableTypeName;
            HashStructure hash;
            String targetTypeName;
            if (!(obj instanceof HashStructure) || !ModelUtil.hasLength((String)(targetTypeName = (hash = (HashStructure)obj).getString(TARGET_TYPE_ATTR))) || !ModelUtil.hasLength((String)(adaptableTypeName = hash.getString(ADAPTABLE_TYPE_ATTR))) || !ModelUtil.hasLength((String)(factoryTypeName = hash.getString(FACTORY_IMPL_ATTR)))) continue;
            this.registerFactory(targetTypeName, adaptableTypeName, hash);
        }
    }

    private void registerFactory(String targetType, String adaptableType, HashStructure hash) {
        Map<String, Object> factoriesByAdaptableType = this.unresolvedFactoriesByTargetTypeAndAdaptableType.get(targetType);
        if (null == factoriesByAdaptableType) {
            factoriesByAdaptableType = Collections.synchronizedMap(new HashMap());
            this.unresolvedFactoriesByTargetTypeAndAdaptableType.put(targetType, factoriesByAdaptableType);
        }
        factoriesByAdaptableType.put(adaptableType, hash);
    }

    Pair<Integer, AdapterFactory> getUnresolvedAdapterFactory(Object adaptable, Class<?> targetType) {
        String targetTypeName = targetType.getName();
        Map<String, HashStructure> factoriesByAdaptableType = this.unresolvedFactoriesByTargetTypeAndAdaptableType.get(targetTypeName);
        if (null == factoriesByAdaptableType) {
            return new Pair((Object)Integer.MAX_VALUE, null);
        }
        Class<?> adaptableType = adaptable.getClass();
        String adaptableTypeName = adaptableType.getName();
        HashStructure hash = factoriesByAdaptableType.get(adaptableTypeName);
        if (null != hash) {
            return new Pair((Object)Integer.MIN_VALUE, (Object)AdapterFactoryHookListener.getFactoryInstance(hash));
        }
        int current = Integer.MAX_VALUE;
        List classOrder = ClassHierarchy.getClassOrder(adaptableType);
        ArrayList<String> classOrderNames = new ArrayList<String>();
        for (Class clazz : classOrder) {
            classOrderNames.add(clazz.getName());
        }
        for (Map.Entry entry : factoriesByAdaptableType.entrySet()) {
            String typeName = (String)entry.getKey();
            int rank = classOrderNames.indexOf(typeName);
            if (rank < 0 || rank >= current) continue;
            current = rank;
            hash = (HashStructure)entry.getValue();
        }
        if (null == hash) {
            return new Pair((Object)Integer.MAX_VALUE, null);
        }
        return new Pair((Object)current, (Object)AdapterFactoryHookListener.getFactoryInstance(hash));
    }

    private static AdapterFactory getFactoryInstance(HashStructure hash) {
        if (null == hash) {
            return null;
        }
        AdapterFactory factory = LazyClassAdapter.getInstance(hash).createInstance(AdapterFactory.class, FACTORY_IMPL_ATTR);
        if (null != factory) {
            return factory;
        }
        MetaClass mclass = new MetaClass(ClassLoader.getSystemClassLoader(), hash.getString(FACTORY_IMPL_ATTR));
        return Util.createInstance(mclass, AdapterFactory.class);
    }
}

