/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import oracle.ide.Ide;
import oracle.ide.IdeUIManager;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.SettingsPageCustomizationHelper;
import oracle.ide.config.SettingsUIRegistry;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.EnvironOptionsArb;
import oracle.ide.util.Assert;
import oracle.ide.util.Encodings;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.Colors;
import oracle.javatools.util.ModelUtil;

public class EnvironOptionsPanel
extends DefaultTraversablePanel
implements ActionListener {
    private static final String PAGE_ID = "/preferences/environment";
    private static final String SAVE_DEACTIVATION = "saveOnDeactivate";
    private static final String RELOAD_FIELD_GROUP = "reloadFieldGroup";
    private static final String VERIFY_FILE_DATA_FIELD = "verifyFileData";
    private static final String LINE_TERMINATOR_FIELD = "lineTerminator";
    private static final String ENCODING_FIELD = "encoding";
    private static boolean _lafChanged;
    private static IdeUIManager.ThemeInfo _selectedTheme;
    private JCheckBox _jcbAutoReloadExtMod;
    private JCheckBox _jcbSilentReload;
    private JCheckBox _jcbVerifyFileData;
    private JCheckBox _jcbSaveOnDeactivation;
    private JLabel _lblLaf;
    private JComboBox _cmbLaf;
    private JLabel _lblLafTheme;
    private JComboBox _cmbLafTheme;
    private JTextField _jtfUndoLevel;
    private JTextField _jtfNavigationLevel;
    private JLabel _lblEncoding;
    private JComboBox _cmbEncoding;
    private JComboBox _jcbLineTerminator;
    private JButton _resetSkippedMessages;
    private JLabel _lblLineTerminator;
    private JLabel _lblLineTerminatorHint;
    private UIManager.LookAndFeelInfo[] _lafInfo = UIManager.getInstalledLookAndFeels();
    private boolean _askExit;

    public EnvironOptionsPanel() {
        this.setHelpID("f1_idedidesetenvironment_html");
        this.initComponents();
        SettingsPageCustomizationHelper helper = SettingsUIRegistry.getHelper((Traversable)this, PAGE_ID);
        helper.setFieldId(this._jcbSaveOnDeactivation, SAVE_DEACTIVATION);
        helper.setFieldId(this._jcbAutoReloadExtMod, RELOAD_FIELD_GROUP);
        helper.setFieldId(this._jcbSilentReload, RELOAD_FIELD_GROUP);
        helper.setFieldId(this._jcbVerifyFileData, VERIFY_FILE_DATA_FIELD);
        helper.setFieldId(this._jcbLineTerminator, LINE_TERMINATOR_FIELD);
        helper.setFieldId(this._lblLineTerminator, LINE_TERMINATOR_FIELD);
        helper.setFieldId(this._lblLineTerminatorHint, LINE_TERMINATOR_FIELD);
        helper.setFieldId(this._lblEncoding, ENCODING_FIELD);
        helper.setFieldId(this._cmbEncoding, ENCODING_FIELD);
        helper.customizeComponents();
    }

    public void onEntry(TraversableContext tc) {
        EnvironOptions envOpts = EnvironOptions.getInstance(tc.getPropertyStorage());
        this.load(envOpts);
    }

    public void onExit(TraversableContext tc) {
        EnvironOptions envOpts = EnvironOptions.getInstance(tc.getPropertyStorage());
        this.commit(envOpts);
        if (this._askExit) {
            IdeSettings settings = (IdeSettings)tc.find("ide-options");
            settings.setAskExit(this._askExit);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this._jcbAutoReloadExtMod) {
            this.actionPerformed_AutoReloadExtMod();
        } else if (obj == this._cmbLaf) {
            this.actionPerformed_LookAndFeelChanged();
        } else if (obj == this._cmbLafTheme) {
            this.actionPerformed_ThemeChanged();
        } else if (obj == this._resetSkippedMessages) {
            MessageDialog.resetSkippedMessages();
        }
    }

    private void initComponents() {
        IdeUIManager uiManager = IdeUIManager.getUIManager();
        this.setLayout(new GridBagLayout());
        JLabel lblUndoLevel = new JLabel();
        JLabel lblNavigationLevel = new JLabel();
        this._jcbAutoReloadExtMod = new JCheckBox();
        this._jcbSilentReload = new JCheckBox();
        this._jcbVerifyFileData = new JCheckBox();
        this._jcbSaveOnDeactivation = new JCheckBox();
        this._jtfUndoLevel = new WholeNumberField(0, 6);
        this._jtfNavigationLevel = new WholeNumberField(0, 6);
        if (uiManager != null) {
            this._lblLaf = new JLabel();
            this._cmbLaf = new JComboBox(new SortedComboBoxModel());
            this._lblLafTheme = new JLabel();
            this._cmbLafTheme = new JComboBox(new SortedComboBoxModel());
        }
        this._lblEncoding = new JLabel();
        this._cmbEncoding = new JComboBox();
        this._resetSkippedMessages = new JButton();
        this._resetSkippedMessages.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._jcbAutoReloadExtMod, (String)EnvironOptionsArb.getString(3));
        ResourceUtils.resButton((AbstractButton)this._jcbSilentReload, (String)EnvironOptionsArb.getString(4));
        ResourceUtils.resButton((AbstractButton)this._jcbVerifyFileData, (String)EnvironOptionsArb.getString(34));
        ResourceUtils.resButton((AbstractButton)this._jcbSaveOnDeactivation, (String)EnvironOptionsArb.getString(15));
        ResourceUtils.resLabel((JLabel)lblUndoLevel, (Component)this._jtfUndoLevel, (String)EnvironOptionsArb.getString(12));
        ResourceUtils.resLabel((JLabel)lblNavigationLevel, (Component)this._jtfNavigationLevel, (String)EnvironOptionsArb.getString(32));
        if (uiManager != null) {
            ResourceUtils.resLabel((JLabel)this._lblLaf, (Component)this._cmbLaf, (String)EnvironOptionsArb.getString(5));
            ResourceUtils.resLabel((JLabel)this._lblLafTheme, (Component)this._cmbLafTheme, (String)EnvironOptionsArb.getString(6));
        }
        ResourceUtils.resLabel((JLabel)this._lblEncoding, (Component)this._cmbEncoding, (String)EnvironOptionsArb.getString(18));
        ResourceUtils.resButton((AbstractButton)this._resetSkippedMessages, (String)EnvironOptionsArb.getString(33));
        if (uiManager != null) {
            this._initLafCombo();
            this._initThemeCombo();
            this._cmbLaf.addActionListener(this);
            this._cmbLafTheme.addActionListener(this);
        }
        this._jcbAutoReloadExtMod.addActionListener(this);
        this.actionPerformed_AutoReloadExtMod();
        Object[] lineTypes = new Object[]{EnvironOptionsArb.getString(22), EnvironOptionsArb.getString(23), EnvironOptionsArb.getString(24), EnvironOptionsArb.getString(25)};
        NonNullableComboBoxModel ltModel = new NonNullableComboBoxModel(lineTypes);
        this._jcbLineTerminator = new JComboBox(ltModel);
        this._jcbLineTerminator.setSelectedItem(lineTypes[0]);
        this._lblLineTerminator = new JLabel();
        String _terminatorText = EnvironOptionsArb.getString(20);
        ResourceUtils.resLabel((JLabel)this._lblLineTerminator, (Component)this._jcbLineTerminator, (String)_terminatorText);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.add(this._jcbSaveOnDeactivation, gbc);
        ++gbc.gridy;
        this.add(this._jcbAutoReloadExtMod, gbc);
        ++gbc.gridy;
        gbc.insets.left += 24;
        this.add(this._jcbSilentReload, gbc);
        gbc.insets.left -= 24;
        ++gbc.gridy;
        this.add(this._jcbVerifyFileData, gbc);
        gbc.insets.top = 5;
        gbc.insets.right = 12;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.insets.top += 5;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add(lblUndoLevel, gbc);
        ++gbc.gridx;
        this.add(this._jtfUndoLevel, gbc);
        gbc.insets.top -= 5;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add(lblNavigationLevel, gbc);
        ++gbc.gridx;
        this.add(this._jtfNavigationLevel, gbc);
        gbc.fill = 2;
        if (IdeUIManager.getUIManager() != null) {
            String requiresRestart = EnvironOptionsArb.getString(7);
            gbc.insets.top = 20;
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 2;
            this.add(this._lblLaf, gbc);
            ++gbc.gridx;
            this.add(this._cmbLaf, gbc);
            gbc.insets.top = 5;
            gbc.insets.bottom = 15;
            ++gbc.gridy;
            gbc.insets.bottom = 15;
            gbc.insets.top = 0;
            JLabel rr = new JLabel(requiresRestart);
            rr.setForeground(Colors.HINT_TEXT);
            gbc.insets.top = 5;
            gbc.insets.bottom = 0;
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add(this._lblLineTerminator, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 2;
        this.add(this._jcbLineTerminator, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        this._lblLineTerminatorHint = new JLabel(EnvironOptionsArb.getString(21));
        this._lblLineTerminatorHint.setForeground(Colors.HINT_TEXT);
        this.add(this._lblLineTerminatorHint, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add(this._lblEncoding, gbc);
        gbc.weightx = 1.0;
        ++gbc.gridx;
        gbc.gridwidth = 3;
        this.add(this._cmbEncoding, gbc);
        gbc.insets.top += 5;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 4;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add(this._resetSkippedMessages, gbc);
        gbc.weighty = 0.0;
        gbc.insets.top -= 5;
    }

    private void actionPerformed_AutoReloadExtMod() {
        this._jcbSilentReload.setEnabled(this._jcbAutoReloadExtMod.isSelected());
    }

    private void load(EnvironOptions options) {
        this._jcbAutoReloadExtMod.setSelected(options.getAutoReloadExtMod());
        this._jcbSilentReload.setSelected(options.getSilentReload());
        this._jcbVerifyFileData.setSelected(options.getVerifyCachedFileData());
        this._jcbSaveOnDeactivation.setSelected(options.getSaveOnDeactivation());
        this.actionPerformed_AutoReloadExtMod();
        this._jtfUndoLevel.setText(Integer.toString(options.getUndoLevel()));
        this._jtfNavigationLevel.setText(Integer.toString(options.getNavigationLevel()));
        if (IdeUIManager.getUIManager() != null) {
            String lafClass = _lafChanged ? options.getLafClass() : UIManager.getLookAndFeel().getClass().getName();
            String lafName = this._getLafName(lafClass);
            this._cmbLaf.setSelectedItem(lafName);
            IdeUIManager.ThemeInfo theme = this._getThemeInfo(lafClass, options.getLafThemeClass());
            this._cmbLafTheme.setSelectedItem(theme);
        }
        this._jcbLineTerminator.setSelectedIndex(options.getLineTerminator());
        Encodings.initComboBox((JComboBox)this._cmbEncoding, (boolean)false, (String)options.getInternalEncoding());
    }

    private void commit(EnvironOptions options) {
        int i;
        options.setAutoReloadExtMod(this._jcbAutoReloadExtMod.isSelected());
        this.showOrHideReloadMenu(this._jcbAutoReloadExtMod.isSelected());
        options.setSilentReload(this._jcbSilentReload.isSelected());
        options.setVerifyCachedFileData(this._jcbVerifyFileData.isSelected());
        options.setSaveOnDeactivation(this._jcbSaveOnDeactivation.isSelected());
        options.setLineTerminator(this._jcbLineTerminator.getSelectedIndex());
        try {
            i = Integer.parseInt(this._jtfUndoLevel.getText());
            options.setUndoLevel(i);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        try {
            i = Integer.parseInt(this._jtfNavigationLevel.getText());
            options.setNavigationLevel(i);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (IdeUIManager.getUIManager() != null) {
            String selectedThemeClass;
            IdeUIManager.ThemeInfo currentTheme;
            String currentLafClass = UIManager.getLookAndFeel().getClass().getName();
            String oldLafClass = options.getLafClass();
            String selectedLafClass = this._getSelectedLafClass();
            if (_lafChanged || ModelUtil.areDifferent((Object)selectedLafClass, (Object)currentLafClass)) {
                _lafChanged = true;
                options.setLafClass(selectedLafClass);
                if (ModelUtil.areDifferent((Object)selectedLafClass, (Object)oldLafClass)) {
                    this._askExit = true;
                }
            }
            String currentThemeClass = (currentTheme = IdeUIManager.getUIManager().getCurrentTheme(currentLafClass)) != null ? currentTheme.getClassName() : "";
            String oldThemeClass = options.getLafThemeClass();
            String string = selectedThemeClass = _selectedTheme != null ? _selectedTheme.getClassName() : "";
            if (ModelUtil.areDifferent((Object)selectedThemeClass, (Object)oldThemeClass)) {
                boolean themeChanging = ModelUtil.areDifferent((Object)selectedThemeClass, (Object)currentThemeClass);
                if (ModelUtil.hasLength((String)oldThemeClass) || themeChanging) {
                    options.setLafThemeClass(selectedThemeClass);
                    if (themeChanging && this._isThemeAvailable(_selectedTheme)) {
                        this._askExit = true;
                    }
                }
            }
        }
        if (Boolean.TRUE.equals(this._cmbEncoding.getClientProperty("encodings-loaded"))) {
            String enc = (String)this._cmbEncoding.getSelectedItem();
            if ("Default".equals(enc)) {
                enc = Encodings.getDefaultEncoding();
            }
            options.setInternalEncoding(enc);
        }
    }

    private void showOrHideReloadMenu(boolean autoReload) {
        JMenu fileMenu = MenuManager.getJMenu("File");
        Menubar menuMgr = Ide.getMenubar();
        Component reloadMenuItem = menuMgr.getChildById(fileMenu, 72);
        if (reloadMenuItem instanceof JMenuItem) {
            ((JMenuItem)reloadMenuItem).setVisible(!autoReload);
        }
    }

    private void _initLafCombo() {
        this._cmbLaf.removeAllItems();
        int numLaf = this._lafInfo.length;
        for (int i = 0; i < numLaf; ++i) {
            String className = this._lafInfo[i].getClassName();
            try {
                LookAndFeel plaf = (LookAndFeel)Class.forName(className).newInstance();
                if (!plaf.isSupportedLookAndFeel()) continue;
                this._cmbLaf.addItem(this._lafInfo[i].getName());
                continue;
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
            }
        }
    }

    private String _getSelectedLafClass() {
        String lafName = this._cmbLaf.getSelectedItem().toString();
        int numLaf = this._lafInfo.length;
        for (int i = 0; i < numLaf; ++i) {
            if (!this._lafInfo[i].getName().equals(lafName)) continue;
            return this._lafInfo[i].getClassName();
        }
        return UIManager.getSystemLookAndFeelClassName();
    }

    private String _getLafName(String lafClass) {
        int numLaf = this._lafInfo.length;
        for (int i = 0; i < numLaf; ++i) {
            if (!this._lafInfo[i].getClassName().equals(lafClass)) continue;
            return this._lafInfo[i].getName();
        }
        String lafName = UIManager.getLookAndFeel().getName();
        String macLafName = "Mac OS X";
        return lafName.startsWith("Mac OS X") ? "Mac OS X" : lafName;
    }

    private void actionPerformed_LookAndFeelChanged() {
        this._cmbLafTheme.removeActionListener(this);
        this._initThemeCombo();
        if (this._cmbLafTheme.isEnabled() && !this._isThemeAvailable(_selectedTheme)) {
            String lafClass = this._getSelectedLafClass();
            _selectedTheme = IdeUIManager.getUIManager().getDefaultTheme(lafClass);
            this._cmbLafTheme.setSelectedItem(_selectedTheme);
        }
        this._cmbLafTheme.addActionListener(this);
    }

    private boolean _isThemeAvailable(IdeUIManager.ThemeInfo theme) {
        SortedComboBoxModel themeModel = (SortedComboBoxModel)this._cmbLafTheme.getModel();
        return themeModel.getIndexOf(theme) >= 0;
    }

    private void actionPerformed_ThemeChanged() {
        IdeUIManager.ThemeInfo theme = (IdeUIManager.ThemeInfo)this._cmbLafTheme.getSelectedItem();
        if (theme != null) {
            _selectedTheme = theme;
        }
    }

    private void _initThemeCombo() {
        this._cmbLafTheme.removeAllItems();
        String lafClass = this._getSelectedLafClass();
        IdeUIManager.ThemeInfo[] themes = IdeUIManager.getUIManager().getInstalledThemes(lafClass);
        if (themes != null && themes.length > 0) {
            for (int i = 0; i < themes.length; ++i) {
                this._cmbLafTheme.addItem(themes[i]);
            }
            this._cmbLafTheme.setEnabled(true);
            this._lblLafTheme.setEnabled(true);
            if (_selectedTheme == null) {
                _selectedTheme = IdeUIManager.getUIManager().getDefaultTheme(lafClass);
            }
            this._cmbLafTheme.setSelectedItem(_selectedTheme);
        } else {
            this._cmbLafTheme.setEnabled(false);
            this._lblLafTheme.setEnabled(false);
        }
    }

    private IdeUIManager.ThemeInfo _getThemeInfo(String lafClass, String themeClass) {
        int i = this._cmbLafTheme.getItemCount();
        while (i-- > 0) {
            IdeUIManager.ThemeInfo theme = (IdeUIManager.ThemeInfo)this._cmbLafTheme.getItemAt(i);
            if (!ModelUtil.areEqual((Object)themeClass, (Object)theme.getClassName())) continue;
            return theme;
        }
        return IdeUIManager.getUIManager().getCurrentTheme(lafClass);
    }
}

