/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.config.EnvironOptions;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.EnvironOptionsArb;
import oracle.ide.util.ResourceUtils;

public class LogOptionsPanel
extends DefaultTraversablePanel
implements ActionListener {
    private JCheckBox _jcbSaveLogToFile;
    private URLTextField _jtfLogFilePrefix;
    private JLabel _lblLogFilePrefix;
    private JButton _butLogFilePrefix;
    private JTextField _jtfMaxLogLines;
    private CustomColorChoice _ccLogHrefColor;
    private CustomColorChoice _ccLogSystemOutColor;
    private CustomColorChoice _ccLogSystemErrColor;
    private CustomColorChoice _ccLogSystemInColor;

    public LogOptionsPanel() {
        this.setHelpID("f1_idedidesetlog_html");
        this.initComponents();
    }

    public void onEntry(TraversableContext tc) {
        EnvironOptions envOpts = EnvironOptions.getInstance(tc.getPropertyStorage());
        this.load(envOpts);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        EnvironOptions envOpts = EnvironOptions.getInstance(tc.getPropertyStorage());
        this.commit(envOpts);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this._jcbSaveLogToFile) {
            this.actionPerformed_SaveLogToFile();
        }
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setLayout(new GridBagLayout());
        this._jcbSaveLogToFile = new JCheckBox();
        this._jtfLogFilePrefix = new URLTextField(null, true, false);
        this._lblLogFilePrefix = new JLabel();
        this._butLogFilePrefix = new JButton();
        this._butLogFilePrefix.addActionListener(this._jtfLogFilePrefix);
        JLabel lblMaxLogLines = new JLabel();
        this._jtfMaxLogLines = new WholeNumberField(0, 6);
        JLabel lblLogHrefColor = new JLabel();
        this._ccLogHrefColor = new CustomColorChoice();
        JLabel lblLogSystemOutColor = new JLabel();
        this._ccLogSystemOutColor = new CustomColorChoice();
        JLabel lblLogSystemErrColor = new JLabel();
        this._ccLogSystemErrColor = new CustomColorChoice();
        JLabel lblLogSystemInColor = new JLabel();
        this._ccLogSystemInColor = new CustomColorChoice();
        ResourceUtils.resLabel((JLabel)lblMaxLogLines, (Component)this._jtfMaxLogLines, (String)EnvironOptionsArb.getString(11));
        ResourceUtils.resButton((AbstractButton)this._jcbSaveLogToFile, (String)EnvironOptionsArb.getString(8));
        ResourceUtils.resLabel((JLabel)this._lblLogFilePrefix, (Component)((Object)this._jtfLogFilePrefix), (String)EnvironOptionsArb.getString(9));
        ResourceUtils.resButton((AbstractButton)this._butLogFilePrefix, (String)EnvironOptionsArb.getString(10));
        ResourceUtils.resLabel((JLabel)lblLogHrefColor, (Component)((Object)this._ccLogHrefColor), (String)EnvironOptionsArb.getString(26));
        ResourceUtils.resLabel((JLabel)lblLogSystemOutColor, (Component)((Object)this._ccLogSystemOutColor), (String)EnvironOptionsArb.getString(27));
        ResourceUtils.resLabel((JLabel)lblLogSystemErrColor, (Component)((Object)this._ccLogSystemErrColor), (String)EnvironOptionsArb.getString(28));
        ResourceUtils.resLabel((JLabel)lblLogSystemInColor, (Component)((Object)this._ccLogSystemInColor), (String)EnvironOptionsArb.getString(29));
        this._jcbSaveLogToFile.addActionListener(this);
        this.actionPerformed_SaveLogToFile();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.anchor = 17;
        this.add(this._jcbSaveLogToFile, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.insets.left += 23;
        this.add(this._lblLogFilePrefix, gbc);
        gbc.insets.left -= 23;
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.insets.left += 4;
        gbc.fill = 2;
        this.add((Component)((Object)this._jtfLogFilePrefix), gbc);
        gbc.insets.left -= 4;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 4;
        gbc.insets.left += 8;
        this.add(this._butLogFilePrefix, gbc);
        gbc.insets.left -= 8;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.insets.top = 5;
        gbc.insets.left = 4;
        gbc.insets.right = 4;
        this.add(lblMaxLogLines, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        this.add(this._jtfMaxLogLines, gbc);
        gbc.fill = 0;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.insets.top = 5;
        gbc.insets.left = 4;
        gbc.insets.right = 4;
        this.add(lblLogHrefColor, gbc);
        gbc.gridx = 1;
        this.add((Component)((Object)this._ccLogHrefColor), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.insets.top = 5;
        gbc.insets.left = 4;
        gbc.insets.right = 4;
        this.add(lblLogSystemOutColor, gbc);
        gbc.gridx = 1;
        this.add((Component)((Object)this._ccLogSystemOutColor), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.insets.top = 5;
        gbc.insets.left = 4;
        gbc.insets.right = 4;
        this.add(lblLogSystemErrColor, gbc);
        gbc.gridx = 1;
        this.add((Component)((Object)this._ccLogSystemErrColor), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.insets.top = 5;
        gbc.insets.left = 4;
        gbc.insets.right = 4;
        this.add(lblLogSystemInColor, gbc);
        gbc.gridx = 1;
        this.add((Component)((Object)this._ccLogSystemInColor), gbc);
        gbc.gridx = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 5;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(new JLabel(), gbc);
    }

    private void actionPerformed_SaveLogToFile() {
        boolean selected = this._jcbSaveLogToFile.isSelected();
        this._jtfLogFilePrefix.setEnabled(selected);
        this._lblLogFilePrefix.setEnabled(selected);
        this._butLogFilePrefix.setEnabled(selected);
    }

    private void load(EnvironOptions options) {
        this._jtfLogFilePrefix.setURL(options.getLogFilePrefix());
        this._jcbSaveLogToFile.setSelected(options.isSaveLogToFile());
        this.actionPerformed_SaveLogToFile();
        this._jtfMaxLogLines.setText(Integer.toString(options.getMaxLogLines()));
        this._ccLogHrefColor.setClosestSelectedColor(new Color(options.getLogHrefColor()));
        this._ccLogSystemOutColor.setClosestSelectedColor(new Color(options.getLogSystemOutColor()));
        this._ccLogSystemErrColor.setClosestSelectedColor(new Color(options.getLogSystemErrColor()));
        this._ccLogSystemInColor.setClosestSelectedColor(new Color(options.getLogSystemInColor()));
    }

    private void commit(EnvironOptions options) throws TraversalException {
        URL url = this._jtfLogFilePrefix.getURL();
        boolean useLogFile = this._jcbSaveLogToFile.isSelected();
        if (useLogFile) {
            if (url != null && !URLFileSystem.canCreate((URL)url)) {
                this._jtfLogFilePrefix.requestFocus();
                String msg = EnvironOptionsArb.format(37, this._jtfLogFilePrefix.getText().trim());
                String title = EnvironOptionsArb.getString(36);
                throw new TraversalException(msg, title);
            }
            if (url == null && !this._jtfLogFilePrefix.getText().isEmpty()) {
                String msg = EnvironOptionsArb.format(39, this._jtfLogFilePrefix.getText().trim());
                String title = EnvironOptionsArb.getString(38);
                throw new TraversalException(msg, title);
            }
            options.setLogFilePrefix(URLFileSystem.canonicalize((URL)url));
        }
        options.setSaveLogToFile(useLogFile);
        try {
            int i = Integer.parseInt(this._jtfMaxLogLines.getText());
            options.setMaxLogLines(i);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        options.setLogHrefColor(this._ccLogHrefColor.getSelectedColor().getRGB());
        options.setLogSystemOutColor(this._ccLogSystemOutColor.getSelectedColor().getRGB());
        options.setLogSystemErrColor(this._ccLogSystemErrColor.getSelectedColor().getRGB());
        options.setLogSystemInColor(this._ccLogSystemInColor.getSelectedColor().getRGB());
    }
}

