/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controller;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.extension.OnDemandElementVisitorListener;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.MetaClass;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextAwareLabelUpdater;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.LabelUpdater;
import oracle.ide.controller.PropertyResolver;
import oracle.ide.extension.IsolatedClassloaderSupport;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.util.Assert;
import oracle.ideimpl.condition.ConditionSpec;
import oracle.ideimpl.controller.MetaClassController;
import oracle.ideimpl.extension.IDEExtension;

public final class IdeActionHook
extends ExtensionHook {
    private static final Logger LOGGER = Logger.getLogger(IdeActionHook.class.getName());
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "actions");
    private static final ElementName ACTION = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "action");
    private static final ElementName ACTIONS_MENU = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "menu-actions");
    private static final String MENU_HAS_DEFAULT_ACTION = "has-default-action";
    private static final ElementName PROPERTIES = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "properties");
    private static final ElementName PROPERTY = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "property");
    private static final ElementName CONTROLLER_CLASS = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "controller-class");
    private static final ElementName COMMAND_CLASS = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "command-class");
    private static final ElementName COMMANDS = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "commands");
    private static final ElementName LABEL_UPDATER = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "label-updater");
    private static final ElementName LABEL_WHEN_ENABLED = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "when-enabled");
    private static final ElementName LABEL_WHEN_DISABLED = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "when-disabled");
    private static final String KEY_ACTION = "oide_action";
    private static final String KEY_RESOLVER = "oide_action_resolver";
    private static final String KEY_COMMAND = "oide_action_command";
    private static final String KEY_UPDATER_INFO = "oide_action_label_updater";
    private static final String KEY_LABEL_WHEN_ENABLED_FORMAT = "oide_action_label_when_enabled_format";
    private static final String KEY_LABEL_WHEN_DISABLED_FORMAT = "oide_action_label_when_disabled_format";
    private static final String KEY_MENU_ACTIONS = "oide_action_menu_actions";
    private static final String KEY_MENU_HAS_DEFAULT_ACTION = "oide_action_menu_has_default_action";
    private final ElementVisitor _actionVisitor = new ActionVisitor();
    private final ElementVisitor _propertiesVisitor = new PropertiesVisitor();
    private final ElementVisitor _propertyVisitor = new PropertyVisitor();
    private final ElementVisitor _controllerVisitor = new ControllerVisitor();
    private final ElementVisitor _commandClassVisitor = new CommandClassVisitor();
    private final ElementVisitor _actionsMenuVisitor = new ActionsMenuVistor();
    private final ElementVisitor _actionsMenuActionVisitor = new ActionsMenuActionVistor();
    private final ElementVisitor _commandsVisitor = new CommandsVisitor();
    private final ElementVisitor _labelUpdaterVisitor = new LabelUpdaterVisitor();
    private final ElementVisitor _labelWhenEnabledVisitor = new LabelActionVisitor("oide_action_label_when_enabled_format");
    private final ElementVisitor _labelWhenDisabledVisitor = new LabelActionVisitor("oide_action_label_when_disabled_format");
    private Map<String, DeclarativeAction> _actions = new HashMap<String, DeclarativeAction>();
    private boolean _ideInitialized;
    private transient ArrayList<OnDemandElementVisitorListener> _regListeners;

    public void start(ElementStartContext context) {
        this.notifyRegListeners(context.getExtension().getID(), true);
        context.registerChildVisitor(ACTION, this._actionVisitor);
    }

    public void end(ElementEndContext context) {
        if (this._ideInitialized) {
            this.installActions();
        }
        this.notifyRegListeners(context.getExtension().getID(), false);
    }

    private boolean isLoadingTriggerHooks(ElementContext context) {
        IDEExtension.State state = ((IDEExtension)this.getExtension(context)).getState();
        return IDEExtension.State.TRIGGERS_LOADING == state;
    }

    public synchronized void addActionsRegListener(OnDemandElementVisitorListener listener) {
        if (this._regListeners == null) {
            this._regListeners = new ArrayList(2);
        }
        Assert.println((this._regListeners.size() > 1 ? 1 : 0) != 0, (String)("Not expecting more than 2 attached registration listeners to IdeActionHook: " + listener.getClass().getName()));
        this._regListeners.add(listener);
    }

    public synchronized void removeActionsRegListener(OnDemandElementVisitorListener listener) {
        if (this._regListeners != null) {
            this._regListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRegListeners(String extensionId, boolean isStarting) {
        List list;
        IdeActionHook ideActionHook = this;
        synchronized (ideActionHook) {
            if (this._regListeners == null) {
                return;
            }
            list = (List)this._regListeners.clone();
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            OnDemandElementVisitorListener listener = (OnDemandElementVisitorListener)list.get(i);
            if (isStarting) {
                listener.starting(extensionId);
                continue;
            }
            listener.ended(extensionId);
        }
    }

    public void installActions() {
        for (DeclarativeAction action : this._actions.values()) {
            action.installAction();
        }
        this._actions.clear();
        this._ideInitialized = true;
    }

    private static class DefaultLabelUpdater
    implements LabelUpdater {
        private MetaClass _labelUpdaterClass;
        private LabelUpdater _labelUpdater;
        private String _enabledFormat;
        private String _disabledFormat;

        public DefaultLabelUpdater(MetaClass labelUpdaterClass) {
            this._labelUpdaterClass = labelUpdaterClass;
        }

        @Override
        public String labelWhenEnabled(Context context, IdeAction action, String originalLabel) {
            if (this._labelUpdater == null) {
                this.createLabelUpdater();
            }
            this.setFormatsOnLabelUpdaterDelegate();
            return this._labelUpdater.labelWhenEnabled(context, action, originalLabel);
        }

        @Override
        public String labelWhenDisabled(Context context, IdeAction action, String originalLabel) {
            if (this._labelUpdater == null) {
                this.createLabelUpdater();
            }
            this.setFormatsOnLabelUpdaterDelegate();
            return this._labelUpdater.labelWhenDisabled(context, action, originalLabel);
        }

        @Override
        public void setEnabledFormat(String format) {
            this._enabledFormat = format;
        }

        @Override
        public void setDisabledFormat(String format) {
            this._disabledFormat = format;
        }

        private void createLabelUpdater() {
            try {
                Class klass = this._labelUpdaterClass.toClass();
                this._labelUpdater = (LabelUpdater)klass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        private void setFormatsOnLabelUpdaterDelegate() {
            this._labelUpdater.setEnabledFormat(this._enabledFormat);
            this._labelUpdater.setDisabledFormat(this._disabledFormat);
        }
    }

    private static class ConditionCommandSpec
    implements IsolatedClassloaderSupport {
        private ConditionSpec conditionSpec;
        private String commandClass;
        private ClassLoader classLoader;

        private ConditionCommandSpec() {
        }

        public void setCommandClass(String commandClass) {
            this.commandClass = commandClass;
        }

        public String getCommandClass() {
            return this.commandClass;
        }

        public void setConditionSpec(ConditionSpec conditionSpec) {
            this.conditionSpec = conditionSpec;
        }

        public ConditionSpec getConditionSpec() {
            return this.conditionSpec;
        }

        @Override
        public ClassLoader getClassloader() {
            return this.classLoader;
        }

        @Override
        public void setClassloader(ClassLoader cl) {
            this.classLoader = cl;
        }
    }

    private class DeclarativeAction
    implements IsolatedClassloaderSupport {
        private String _id;
        private PropertyResolver _resolver;
        private Collection<Controller> _controllers = new ArrayList<Controller>();
        private String _commandClass;
        private LabelUpdater _labelUpdater;
        private ClassLoader _classloader;

        DeclarativeAction(String id) {
            this._id = id;
        }

        public void setPropertyResolver(PropertyResolver pr) {
            this._resolver = pr;
        }

        public void setLabelUpdater(LabelUpdater labelUpdater) {
            this._labelUpdater = labelUpdater;
        }

        public void addController(Controller c) {
            this._controllers.add(c);
        }

        public void setCommandClass(String commandClass) {
            this._commandClass = commandClass;
        }

        void installAction() {
            int cmdId = Ide.findOrCreateCmdID(this._id);
            IdeAction action = IdeAction.get(cmdId);
            action.addPropertyResolver(this._resolver);
            action.setEnabled(true);
            for (Controller c : this._controllers) {
                action.addController(c);
            }
            if (this._commandClass != null) {
                action.setCommand(this._commandClass);
            }
            if (this._classloader != null) {
                action.setClassloader(this._classloader);
            }
            if (action.getLabelUpdater() == null) {
                action.setLabelUpdater(this._labelUpdater);
            } else {
                LOGGER.log(Level.WARNING, "Tried to override previous value for labelUpdater");
            }
        }

        @Override
        public ClassLoader getClassloader() {
            return this._classloader;
        }

        @Override
        public void setClassloader(ClassLoader cl) {
            this._classloader = cl;
        }

        public String toString() {
            return this._id != null ? this._id : super.toString();
        }
    }

    private final class LabelActionVisitor
    extends ElementVisitor {
        private String _formatKey;

        public LabelActionVisitor(String formatKey) {
            this._formatKey = formatKey;
        }

        public void start(ElementStartContext context) {
            String format = context.getAttributeValue("format");
            if (format == null) {
                this.log((ElementContext)context, Level.SEVERE, "Attribute 'format' must be specified.");
                return;
            }
            if ((format = format.trim()).isEmpty()) {
                this.log((ElementContext)context, Level.SEVERE, "Attribute 'format' has an invalid value.");
                return;
            }
            Map labelUpdateInfo = (Map)context.getScopeData().get(IdeActionHook.KEY_UPDATER_INFO);
            labelUpdateInfo.put(this._formatKey, format);
        }
    }

    private final class LabelUpdaterVisitor
    extends ElementVisitor {
        private String _labelUpdaterClass;

        private LabelUpdaterVisitor() {
        }

        public void start(ElementStartContext context) {
            this._labelUpdaterClass = context.getAttributeValue("class");
            if (this._labelUpdaterClass != null) {
                this._labelUpdaterClass = this._labelUpdaterClass.trim();
                if (this._labelUpdaterClass.isEmpty()) {
                    this._labelUpdaterClass = null;
                } else if (IdeActionHook.this.isLoadingTriggerHooks((ElementContext)context)) {
                    this.log((ElementContext)context, Level.SEVERE, "The [class] attribute is not valid for actions in the trigger-hooks hook.");
                    this._labelUpdaterClass = null;
                }
            }
            context.getScopeData().put(IdeActionHook.KEY_UPDATER_INFO, new HashMap());
            context.registerChildVisitor(LABEL_WHEN_ENABLED, IdeActionHook.this._labelWhenEnabledVisitor);
            context.registerChildVisitor(LABEL_WHEN_DISABLED, IdeActionHook.this._labelWhenDisabledVisitor);
        }

        public void end(ElementEndContext context) {
            Map labelUpdateInfo = (Map)context.getScopeData().get(IdeActionHook.KEY_UPDATER_INFO);
            String enabledFmt = (String)labelUpdateInfo.get(IdeActionHook.KEY_LABEL_WHEN_ENABLED_FORMAT);
            String disabledFmt = (String)labelUpdateInfo.get(IdeActionHook.KEY_LABEL_WHEN_DISABLED_FORMAT);
            if (enabledFmt == null || disabledFmt == null) {
                this.log((ElementContext)context, Level.SEVERE, "The [format] attribute's value cannot be null");
                return;
            }
            LabelUpdater labelUpdater = null;
            if (this._labelUpdaterClass != null) {
                ClassLoader loader = (ClassLoader)context.getScopeData().get("classLoader") != null ? (ClassLoader)context.getScopeData().get("classLoader") : Thread.currentThread().getContextClassLoader();
                labelUpdater = new DefaultLabelUpdater(new MetaClass(loader, this._labelUpdaterClass));
            } else {
                labelUpdater = new ContextAwareLabelUpdater();
            }
            labelUpdater.setEnabledFormat(enabledFmt);
            labelUpdater.setDisabledFormat(disabledFmt);
            DeclarativeAction action = (DeclarativeAction)context.getScopeData().get(IdeActionHook.KEY_ACTION);
            action.setLabelUpdater(labelUpdater);
        }
    }

    private final class CommandClassVisitor
    extends MetaClassVisitor {
        private CommandClassVisitor() {
        }

        protected void metaClass(ElementContext context, MetaClass mc) {
            DeclarativeAction action = (DeclarativeAction)context.getScopeData().get(IdeActionHook.KEY_ACTION);
            ConditionCommandSpec command = (ConditionCommandSpec)context.getScopeData().get(IdeActionHook.KEY_COMMAND);
            if (command != null && command.getCommandClass() == null) {
                command.setCommandClass(mc.getClassName());
                command.setClassloader(mc.getClassLoader());
            } else {
                action.setCommandClass(mc.getClassName());
                action.setClassloader(mc.getClassLoader());
            }
        }
    }

    private final class ControllerVisitor
    extends MetaClassVisitor {
        private ControllerVisitor() {
        }

        protected void metaClass(ElementContext context, MetaClass mc) {
            boolean callControllerDirectly;
            boolean processingTriggers = IdeActionHook.this.isLoadingTriggerHooks(context);
            boolean bl = callControllerDirectly = !processingTriggers;
            if (processingTriggers) {
                this.log(context, Level.SEVERE, "The <controller-class> tag is not valid for actions in the trigger-hooks hook; use the controllers hook.");
                return;
            }
            DeclarativeAction action = (DeclarativeAction)context.getScopeData().get(IdeActionHook.KEY_ACTION);
            MetaClassController controller = new MetaClassController(mc, context.getExtension().getID(), callControllerDirectly);
            action.addController(controller);
        }
    }

    private static final class DeclarativeResolver
    extends PropertyResolver {
        private ClassLoader _resLoader = null;
        private String _resBundleClass = null;
        private final Map _properties = new HashMap();

        DeclarativeResolver(ClassLoader resLoader, String resClass) {
            this._resLoader = resLoader;
            this._resBundleClass = resClass;
        }

        @Override
        public Object get(String propertyName) {
            Object value = this._properties.get(propertyName);
            if (value instanceof ResString) {
                value = ((ResString)value).get();
            }
            if ("SmallIcon".equals(propertyName) && !(value instanceof Icon)) {
                if (value == null) {
                    return null;
                }
                ImageIcon result = null;
                if (value instanceof URL) {
                    ImageIcon icon = new ImageIcon((URL)value);
                    if (icon.getImageLoadStatus() != 8) {
                        LOGGER.severe("Failed to load icon for URL: " + value);
                    } else {
                        result = icon;
                    }
                }
                return result;
            }
            if (("CanBePlacedOnMainToolbar".equals(propertyName) || "Check".equals(propertyName) || "State".equals(propertyName) || "Radio".equals(propertyName)) && !(value instanceof Boolean)) {
                Boolean booleanValue = Boolean.valueOf((String)value);
                return booleanValue;
            }
            if ("MnemonicKey".equals(propertyName) && !(value instanceof Integer)) {
                if (value == null) {
                    Object label = this._properties.get("Name");
                    if (label instanceof ResString) {
                        label = ((ResString)label).get();
                    }
                    if (label != null) {
                        int keycode = StringUtils.getMnemonicKeyCode((String)label.toString());
                        if (keycode == 0) {
                            return 0;
                        }
                        return keycode;
                    }
                } else {
                    if (!((String)value).isEmpty()) {
                        char c = ((String)value).charAt(0);
                        value = (int)c;
                        return value;
                    }
                    return 0;
                }
            }
            if ("Name".equals(propertyName)) {
                return StringUtils.stripMnemonic((String)((String)value));
            }
            if ("ActionMenuActions".equals(propertyName) && value instanceof Object[]) {
                Object[] ids = (Object[])value;
                ArrayList<IdeAction> actions = new ArrayList<IdeAction>(ids.length);
                for (Object id : ids) {
                    try {
                        actions.add(IdeAction.get(Ide.findCmdID((String)id)));
                    }
                    catch (Exception e) {
                        LOGGER.severe("Failed to load menu action " + id + "; action is not registered");
                    }
                }
                return actions.toArray(new Action[actions.size()]);
            }
            return value;
        }

        private void put(Object key, Object value) {
            this._properties.put(key, value);
        }

        private ResourceBundle getBundle() {
            if (this._resLoader == null) {
                this._resLoader = Thread.currentThread().getContextClassLoader();
            }
            return ElementVisitor.getResourceBundleProvider().getResourceBundle(this._resBundleClass, Locale.getDefault(), this._resLoader);
        }

        ResString createResString(String key) {
            return new ResString(key);
        }

        private class ResString {
            private final String _key;

            ResString(String key) {
                this._key = key;
            }

            public String get() {
                ResourceBundle bundle = DeclarativeResolver.this.getBundle();
                return bundle.getString(this._key);
            }
        }
    }

    private final class PropertyVisitor
    extends ElementVisitor {
        private String _rskey = null;
        private String _name = null;

        private PropertyVisitor() {
        }

        public void start(ElementStartContext context) {
            this._rskey = null;
            this._name = null;
            String name = context.getAttributeValue("name");
            if (name == null || (name = name.trim()).isEmpty()) {
                this.log((ElementContext)context, Level.SEVERE, "Missing required attribute 'name'.");
                return;
            }
            this._name = name;
            this._rskey = context.getAttributeValue("rskey");
            if (this._rskey != null) {
                this._rskey = this._rskey.trim();
            }
        }

        public void end(ElementEndContext context) {
            if (this._name != null) {
                this.checkToggleRadioProperty((ElementContext)context, this._name);
                DeclarativeResolver resolver = (DeclarativeResolver)context.getScopeData().get(IdeActionHook.KEY_RESOLVER);
                if (this._rskey != null) {
                    resolver.put(this._name, resolver.createResString(this._rskey));
                } else {
                    String propText = context.getText();
                    if (propText == null || (propText = propText.trim()).isEmpty()) {
                        this.log((ElementContext)context, Level.WARNING, "Value expected for property '" + this._name + "'.");
                    } else {
                        String text = propText;
                        if (text.startsWith("uri:") && text.length() > 4) {
                            URI uri = URIFactory.newURI((String)text.substring(4));
                            try {
                                resolver.put(this._name, VirtualFileSystem.getVirtualFileSystem().toURL(uri));
                            }
                            catch (MalformedURLException e) {
                                FeedbackManager.reportException("Unexpected MalformedURLException", e);
                            }
                        } else {
                            resolver.put(this._name, propText);
                        }
                    }
                }
            }
        }

        private void checkToggleRadioProperty(ElementContext context, String propertyName) {
            if (IdeActionHook.this.isLoadingTriggerHooks(context) && ("Check".equals(propertyName) || "State".equals(propertyName) || "Radio".equals(propertyName))) {
                this.log(context, Level.SEVERE, "Toggle or radio actions should not be registered as trigger actions because their state cannot be restored without loading the extension; action = " + context.getScopeData().get(IdeActionHook.KEY_ACTION) + ".");
            }
        }
    }

    private final class CommandsVisitor
    extends ElementVisitor {
        private CommandsVisitor() {
        }

        public void start(ElementStartContext context) {
            this.log((ElementContext)context, Level.WARNING, "The <commands> tag has been deprecated and is no longer supported.");
        }
    }

    private final class PropertiesVisitor
    extends ElementVisitor {
        private PropertiesVisitor() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(PROPERTY, IdeActionHook.this._propertyVisitor);
        }
    }

    private final class ActionsMenuActionVistor
    extends ElementVisitor {
        private ActionsMenuActionVistor() {
        }

        public void end(ElementEndContext context) {
            String actionId = context.getText();
            if (actionId == null || (actionId = actionId.trim()).isEmpty()) {
                this.log((ElementContext)context, Level.SEVERE, "Action id missing from menu-actions element");
                return;
            }
            ArrayList menuActions = (ArrayList)context.getScopeData().get(IdeActionHook.KEY_MENU_ACTIONS);
            menuActions.add(actionId);
        }
    }

    private final class ActionsMenuVistor
    extends ElementVisitor {
        ArrayList<String> _actions = new ArrayList();

        private ActionsMenuVistor() {
        }

        public void start(ElementStartContext context) {
            String txt = context.getAttributeValue(IdeActionHook.MENU_HAS_DEFAULT_ACTION);
            Boolean hasDefaultAction = txt == null || txt.isEmpty() ? Boolean.TRUE : Boolean.valueOf(Boolean.parseBoolean(txt));
            context.getScopeData().put(IdeActionHook.KEY_MENU_HAS_DEFAULT_ACTION, hasDefaultAction);
            this._actions.clear();
            context.getScopeData().put(IdeActionHook.KEY_MENU_ACTIONS, this._actions);
            context.registerChildVisitor(ACTION, IdeActionHook.this._actionsMenuActionVisitor);
        }

        public void end(ElementEndContext context) {
            DeclarativeResolver resolver;
            ArrayList menuActions = (ArrayList)context.getScopeData().get(IdeActionHook.KEY_MENU_ACTIONS);
            if (menuActions != null && !menuActions.isEmpty() && (resolver = (DeclarativeResolver)context.getScopeData().get(IdeActionHook.KEY_RESOLVER)) != null) {
                Object[] actionIds = menuActions.toArray(new Object[menuActions.size()]);
                resolver.put("ActionMenuActions", actionIds);
                Boolean hasDefaultAction = (Boolean)context.getScopeData().get(IdeActionHook.KEY_MENU_HAS_DEFAULT_ACTION);
                resolver.put("ActionMenuHasDefaultAction", hasDefaultAction);
            }
        }
    }

    private final class ActionVisitor
    extends ElementVisitor {
        private ActionVisitor() {
        }

        public void start(ElementStartContext context) {
            String id = context.getAttributeValue("id");
            if (id == null || (id = id.trim()).isEmpty()) {
                this.log((ElementContext)context, Level.SEVERE, "Missing required attribute 'id'.");
                return;
            }
            if (IdeActionHook.this._actions.containsKey(id)) {
                this.log((ElementContext)context, Level.SEVERE, "Duplicate action id: " + id);
                return;
            }
            Integer cmdIdInteger = Ide.findCmdID(id);
            if (cmdIdInteger != null && cmdIdInteger > 90) {
                this.log((ElementContext)context, Level.SEVERE, "Duplicate action id: " + id);
                return;
            }
            DeclarativeAction action = new DeclarativeAction(id);
            IdeActionHook.this._actions.put(id, action);
            ClassLoader cl = (ClassLoader)context.getScopeData().get("classLoader") != null ? (ClassLoader)context.getScopeData().get("classLoader") : Thread.currentThread().getContextClassLoader();
            String bundleClass = (String)context.getScopeData().get("rsbundleclass");
            DeclarativeResolver resolver = new DeclarativeResolver(cl, bundleClass);
            action.setPropertyResolver(resolver);
            context.getScopeData().put(IdeActionHook.KEY_RESOLVER, resolver);
            context.getScopeData().put(IdeActionHook.KEY_ACTION, action);
            String canAddToMainToolbar = context.getAttributeValue("canBePlacedOnMainToolbar");
            if (canAddToMainToolbar != null && !(canAddToMainToolbar = canAddToMainToolbar.trim()).isEmpty()) {
                if (IdeActionHook.this.isLoadingTriggerHooks((ElementContext)context)) {
                    resolver.put("CanBePlacedOnMainToolbar", Boolean.valueOf(canAddToMainToolbar));
                } else {
                    this.log((ElementContext)context, Level.WARNING, "The canBePlacedOnMainToolbar attribute can only be used for trigger actions. Action " + id + " is not a trigger action.");
                }
            }
            context.registerChildVisitor(PROPERTIES, IdeActionHook.this._propertiesVisitor);
            context.registerChildVisitor(COMMANDS, IdeActionHook.this._commandsVisitor);
            context.registerChildVisitor(CONTROLLER_CLASS, IdeActionHook.this._controllerVisitor);
            context.registerChildVisitor(COMMAND_CLASS, IdeActionHook.this._commandClassVisitor);
            context.registerChildVisitor(LABEL_UPDATER, IdeActionHook.this._labelUpdaterVisitor);
            context.registerChildVisitor(ACTIONS_MENU, IdeActionHook.this._actionsMenuVisitor);
        }

        public void end(ElementEndContext context) {
            super.end(context);
        }
    }
}

