/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controller;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.JDK;
import oracle.ide.view.View;
import oracle.javatools.ui.themes.ThemeEvent;
import oracle.javatools.ui.themes.ThemeListener;
import oracle.javatools.ui.themes.Themes;

public final class MenubarImpl
extends Menubar {
    private View view = null;
    private JMenuBar gui = null;
    private JMenuBar _savedGui = null;
    private JMenu _activeMenu;
    private Component _wasFocused;
    private boolean _bIsActive = true;
    private final L _listener = new L();
    private static boolean _mustWorkAround4647105 = MenubarImpl.mustWorkAround4647105();

    private static boolean mustWorkAround4647105() {
        Rectangle[] screenBounds;
        if (JDK.HAS_BUG_4647105 && (screenBounds = GraphicsUtils.getScreenBounds()).length > 1) {
            System.setProperty("javax.swing.adjustPopupLocationToFit", Boolean.toString(false));
            return true;
        }
        return false;
    }

    private JMenuBar createThemedMenuBar() {
        JMenuBar bar = new JMenuBar();
        if (Themes.isThemed()) {
            bar.setOpaque(false);
            bar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        return bar;
    }

    @Override
    protected void applyGlobalFilterImpl(MenuFilter filter) {
        JMenuBar newMenuBar = this.createThemedMenuBar();
        for (int i = 0; i < this.gui.getMenuCount(); ++i) {
            JMenu menu = this.gui.getMenu(i);
            if (!filter.accept(menu)) continue;
            JMenu newMenu = this.createMenuClone(menu);
            this.applyFilterToMenu(menu, filter, newMenu);
            if (newMenu.getMenuComponentCount() <= 0) continue;
            newMenuBar.add(newMenu);
        }
        JFrame frame = (JFrame)this.view.getGUI();
        this._savedGui = frame.getJMenuBar();
        frame.setJMenuBar(newMenuBar);
        this.gui = newMenuBar;
    }

    private void applyFilterToMenu(JMenu menu, MenuFilter filter, JMenu newMenu) {
        for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            JMenuItem childMenuItem;
            Component menuComponent = menu.getMenuComponent(i);
            if (menuComponent instanceof JSeparator) continue;
            if (menuComponent instanceof JMenu) {
                JMenu childMenu = (JMenu)menuComponent;
                if (!filter.accept(childMenu)) continue;
                JMenu childMenuClone = this.createMenuClone(childMenu);
                this.applyFilterToMenu(childMenu, filter, childMenuClone);
                if (childMenuClone.getMenuComponentCount() <= 0) continue;
                newMenu.add(childMenuClone);
                continue;
            }
            if (!(menuComponent instanceof JMenuItem) || !filter.accept(childMenuItem = (JMenuItem)menuComponent)) continue;
            newMenu.add(this.createMenuItemClone(childMenuItem));
        }
    }

    private JMenuItem createMenuItemClone(JMenuItem source) {
        JMenuItem newMenuItem = source.getAction() instanceof ToggleAction ? this.createMenuItem((ToggleAction)source.getAction()) : new JMenuItem(source.getAction());
        this.transferClientProperties(source, newMenuItem);
        return newMenuItem;
    }

    private JMenu createMenuClone(JMenu source) {
        JMenu newMenu = this.createMenu(source.getText(), (float)source.getMnemonic());
        this.transferClientProperties(source, newMenu);
        return newMenu;
    }

    @Override
    protected void clearGlobalFilterImpl() {
        if (this._savedGui != null) {
            this.gui = this._savedGui;
            ((JFrame)this.view.getGUI()).setJMenuBar(this.gui);
        }
    }

    private void transferClientProperties(JComponent source, JComponent target) {
        this.transferClientProperty(source, target, "menu-weight");
        this.transferClientProperty(source, target, "menu-section-id");
        this.transferClientProperty(source, target, "menu-addin-section-id");
    }

    private void transferClientProperty(JComponent source, JComponent target, String id) {
        Object value = source.getClientProperty(id);
        if (value != null) {
            target.putClientProperty(id, value);
        }
    }

    public MenubarImpl(View view) {
        this.view = view;
    }

    @Override
    public synchronized Container getGUI(boolean create) {
        if (this.gui == null && create) {
            Component component;
            Component component2 = component = this.view != null ? this.view.getGUI() : null;
            if (component != null && component instanceof JFrame) {
                JFrame frame = (JFrame)component;
                this.gui = frame.getJMenuBar();
                if (this.gui == null) {
                    this.gui = JDK.SEARCH_ACCELERATORS_IN_MENUS ? this.createThemedMenuBar() : new JMenuBar(){
                        private final MenuElement[] NOMENUS = new MenuElement[0];
                        private boolean _returnNoMenus = false;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                            this._returnNoMenus = true;
                            try {
                                boolean bl = super.processKeyBinding(ks, e, condition, pressed);
                                return bl;
                            }
                            finally {
                                this._returnNoMenus = false;
                            }
                        }

                        @Override
                        public MenuElement[] getSubElements() {
                            if (this._returnNoMenus) {
                                return this.NOMENUS;
                            }
                            return super.getSubElements();
                        }
                    };
                    if (Themes.isThemed()) {
                        this.gui.setOpaque(false);
                        this.gui.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                    } else {
                        Themes.addThemeListener((ThemeListener)new ThemeListener(){

                            public void themeChanged(ThemeEvent e) {
                                MenubarImpl.this.gui.setOpaque(false);
                                MenubarImpl.this.gui.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                            }
                        });
                    }
                    frame.setJMenuBar(this.gui);
                }
                if (JDK.HAS_BUG_4336775 || JDK.HAS_BUG_4776532) {
                    frame.addWindowListener(this._listener);
                }
                this.gui.addContainerListener(this.getContainerListener());
            }
        }
        return this.gui;
    }

    @Override
    public JMenu createMenu(String caption, Integer mnemonic) {
        if (JDK.HAS_BUG_4336775 || JDK.HAS_BUG_4647105) {
            JTopMenu menu = new JTopMenu(caption);
            if (mnemonic != null) {
                menu.setMnemonic(mnemonic);
            }
            return menu;
        }
        return super.createMenu(caption, mnemonic);
    }

    private class L
    implements WindowListener {
        private L() {
        }

        @Override
        public void windowOpened(WindowEvent p0) {
        }

        @Override
        public void windowClosing(WindowEvent p0) {
        }

        @Override
        public void windowClosed(WindowEvent p0) {
        }

        @Override
        public void windowIconified(WindowEvent p0) {
        }

        @Override
        public void windowDeiconified(WindowEvent p0) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            MenubarImpl.this._bIsActive = true;
            if (MenubarImpl.this._wasFocused != null) {
                SwingUtilities.invokeLater(new TryLater(e.getWindow()));
            }
        }

        @Override
        public void windowDeactivated(WindowEvent p0) {
            MenubarImpl.this._bIsActive = false;
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }
    }

    class JTopMenu
    extends JMenu {
        JTopMenu(String caption) {
            super(caption);
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            Window w;
            if (!JDK.HAS_BUG_4336775) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }
            JMenu wasActiveMenu = MenubarImpl.this._activeMenu;
            boolean bRet = super.processKeyBinding(ks, e, condition, pressed);
            if (bRet && wasActiveMenu != null && MenubarImpl.this._activeMenu == null && MenubarImpl.this._wasFocused != null && MenubarImpl.this._bIsActive && (w = (Window)SwingUtilities.getAncestorOfClass(Window.class, this)) != null) {
                SwingUtilities.invokeLater(new TryLater(w));
            }
            return bRet;
        }

        @Override
        public void setSelected(boolean b) {
            if (JDK.HAS_BUG_4336775) {
                if (b) {
                    JComponent jcWasFocused;
                    Component wasFocused;
                    Window w;
                    if (MenubarImpl.this._activeMenu == null && MenubarImpl.this._wasFocused == null && (w = (Window)SwingUtilities.getAncestorOfClass(Window.class, this)) != null && (wasFocused = w.getFocusOwner()) instanceof JComponent && (jcWasFocused = (JComponent)wasFocused).getRootPane() != this.getRootPane()) {
                        MenubarImpl.this._wasFocused = wasFocused;
                    }
                    MenubarImpl.this._activeMenu = this;
                } else {
                    MenubarImpl.this._activeMenu = null;
                }
            }
            super.setSelected(b);
        }

        @Override
        protected Point getPopupMenuOrigin() {
            if (_mustWorkAround4647105 && !(this.getParent() instanceof JPopupMenu)) {
                Rectangle[] screenBounds = GraphicsUtils.getScreenBounds();
                Point position = this.getLocationOnScreen();
                for (int i = 0; i < screenBounds.length; ++i) {
                    Rectangle screenBound = screenBounds[i];
                    if (!screenBound.contains(position)) continue;
                    int x = 0;
                    int y = 0;
                    JPopupMenu pm = this.getPopupMenu();
                    Dimension s = this.getSize();
                    Dimension pmSize = pm.getSize();
                    if (pmSize.width == 0) {
                        pmSize = pm.getPreferredSize();
                    }
                    x = this.getComponentOrientation().isLeftToRight() ? (position.x + pmSize.width < screenBound.x + screenBound.width ? 0 : s.width - pmSize.width) : (position.x + s.width < pmSize.width ? 0 : s.width - pmSize.width);
                    y = position.y + s.height + pmSize.height < screenBound.y + screenBound.height ? s.height : 0 - pmSize.height;
                    return new Point(x, y);
                }
            }
            return super.getPopupMenuOrigin();
        }
    }

    private class TryLater
    implements Runnable {
        private Window _w;

        TryLater(Window w) {
            this._w = w;
        }

        @Override
        public void run() {
            if (MenubarImpl.this._wasFocused != null && MenubarImpl.this._bIsActive) {
                Component c;
                Container parent = MenubarImpl.this.getGUI(false);
                if (parent != null && parent.isAncestorOf(c = this._w.getFocusOwner())) {
                    MenubarImpl.this._wasFocused.requestFocus();
                }
                MenubarImpl.this._wasFocused = null;
            }
        }
    }
}

