/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.extension.Extension;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DrawerLayoutUtil;
import oracle.ide.docking.WindowManagerStartingController;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.docking.DockableHook;
import oracle.ideimpl.docking.ProxyDockableFactory;
import oracle.ideimpl.layout.LayoutsImpl;
import oracle.javatools.data.HashStructure;

public final class DockableFactoryHook
extends HashStructureHook {
    private Map<String, MetaClass<DockableFactory>> idToDockableFactoryClass = new HashMap<String, MetaClass<DockableFactory>>();
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "dockable-factory-hook");

    DockableFactoryHook() {
        this.addHashStructureHookListener(new HashStructureHookListener(){

            @Override
            public void elementVisited(HashStructureHookEvent e) {
                DockableFactoryHook.this.addFactories(e.getNewElementHashStructure());
            }

            @Override
            public void listenerAttached(HashStructureHookEvent e) {
                DockableFactoryHook.this.addFactories(e.getNewElementHashStructure());
            }
        });
    }

    public static DockableFactoryHook get() {
        return (DockableFactoryHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
    }

    public void ensureDockableFactoryLoaded(String id) {
        if (IdeUtil.isHeadless()) {
            return;
        }
        MetaClass<DockableFactory> metaClass = this.idToDockableFactoryClass.remove(id);
        if (metaClass == null) {
            return;
        }
        DockableFactory dockableFactory = null;
        try {
            if (WindowManagerStartingController.getInstance() == null) {
                LayoutsImpl layoutsImpl = LayoutsImpl.getInstance();
                dockableFactory = this.isExtensionFullyLoaded(id) || layoutsImpl.isVisible(id) || DrawerLayoutUtil.isDrawerExpanded(id) ? (DockableFactory)metaClass.newInstance() : new ProxyDockableFactory(metaClass, id);
                DockStation.getDockStation().registerDockableFactory(id, dockableFactory);
            } else if (this.isExtensionFullyLoaded(id)) {
                dockableFactory = (DockableFactory)metaClass.newInstance();
                DockStation.getDockStation().registerDockableFactory(id, dockableFactory);
            } else {
                DockStation.getDockStation().registerDockableFactory(id, metaClass);
            }
        }
        catch (InstantiationException e) {
            Logger.getLogger("global").log(Level.SEVERE, "Cannot instantiate class for dockableFactory factory id: " + id + ", class: " + metaClass.getClassName());
        }
        catch (IllegalAccessException e) {
            Logger.getLogger("global").log(Level.SEVERE, "Cannot access class for dockableFactory factory id: " + id + ", class: " + metaClass.getClassName());
        }
        catch (ClassNotFoundException e) {
            Logger.getLogger("global").log(Level.SEVERE, "Cannot find class for dockableFactory factory id: " + id + ", class: " + metaClass.getClassName());
        }
        catch (ClassCastException e) {
            Logger.getLogger("global").log(Level.SEVERE, "ClassCastException. DockableFactory for factory id: " + id + ", class: " + metaClass.getClassName() + ", is not of type DockableFactory");
        }
        catch (Throwable t) {
            FeedbackManager.reportException(t);
        }
    }

    private void addFactories(HashStructure hs) {
        if (hs == null) {
            return;
        }
        List list = hs.getAsList("factory");
        if (list == null) {
            return;
        }
        for (Object obj : list) {
            HashStructure factoryHash = (HashStructure)obj;
            String id = factoryHash.getString("id");
            MetaClass factoryClass = LazyClassAdapter.getInstance(factoryHash).getMetaClass("class");
            if (id == null) {
                Logger.getLogger("global").log(Level.SEVERE, "extension " + DockableFactoryHook.getExtensionId(hs) + " is attempting to register a docakble with no id");
            }
            if (factoryClass == null) {
                Logger.getLogger("global").log(Level.SEVERE, "extension " + DockableFactoryHook.getExtensionId(hs) + " is attempting to register a docakble with no factory");
            }
            if (this.idToDockableFactoryClass.containsKey(id)) {
                Logger.getLogger("global").log(Level.SEVERE, "DockableFactoryHook. Error, extension \"" + DockableFactoryHook.getExtensionId(hs) + "\" attempting to register DockableFactory " + factoryClass.getClassName() + " with id: \"" + id + "\". ID already registered to DockableFactory: \"" + this.idToDockableFactoryClass.get(id).getClassName() + "\"");
                continue;
            }
            this.idToDockableFactoryClass.put(id, factoryClass);
        }
    }

    public boolean isExtensionFullyLoaded(String dockableFactoryId) {
        String extensionID = DockableHook.get().getDocakableExtensionID(dockableFactoryId);
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        Extension extension = registry.findExtension(extensionID);
        if (extension != null) {
            return registry.isFullyLoaded(extension);
        }
        return false;
    }
}

