/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.UIManager;
import oracle.javatools.util.SwingUtils;

public final class AcceleratorIcon
implements Icon {
    private static final boolean TRANSPARENT_BACKGROUND = false;
    private Icon _baseIcon;
    private String _sLink;
    private Rectangle2D _rectLink;
    private static final int STYLE_ON_TOP = 0;
    private static final int STYLE_RIGHT = 1;
    private static final int GAP = 1;
    private static Font _fntLink;
    private static final int DEFAULT_ICON_HEIGHT = 10;
    private static final int DEFAULT_ICON_WIDTH = 10;

    public AcceleratorIcon(Icon baseIcon, int nLink) {
        this.setBaseIcon(baseIcon);
        this.setLink(nLink);
    }

    public boolean equals(Object other) {
        if (other instanceof Icon) {
            Icon otherIcon = (Icon)other;
            return otherIcon.equals(this._baseIcon);
        }
        return false;
    }

    private void setBaseIcon(Icon baseIcon) {
        this._baseIcon = baseIcon;
    }

    private void setLink(int nLink) {
        this._sLink = Integer.toString(nLink);
        this._rectLink = null;
    }

    @Override
    public void paintIcon(Component component, Graphics g0, int x, int y) {
        int nBaseHeight;
        int nBaseWidth;
        Graphics2D g = (Graphics2D)g0;
        if (this._baseIcon != null) {
            nBaseWidth = this._baseIcon.getIconWidth();
            nBaseHeight = this._baseIcon.getIconHeight();
            this._baseIcon.paintIcon(component, g, x, y);
        } else {
            nBaseWidth = 10;
            nBaseHeight = 10;
        }
        Font fntRestore = g.getFont();
        Color clrRestore = g.getColor();
        Color clrBackRestore = g.getBackground();
        Rectangle2D bounds = this.getLinkRect(g);
        g.setColor(component.getForeground());
        g.setBackground(component.getBackground());
        Font linkFont = AcceleratorIcon.getLinkFont(g);
        g.setFont(linkFont);
        switch (0) {
            case 1: {
                SwingUtils.drawString((Graphics)g, (String)this._sLink, (int)(x + nBaseWidth + 1), (int)((int)(-bounds.getY())));
                break;
            }
            case 0: {
                int xPos = (int)((double)x + ((double)nBaseWidth - bounds.getWidth()) / 2.0);
                int yTop = (int)((double)y + ((double)nBaseHeight - bounds.getHeight()) / 2.0);
                int yBaseLine = (int)((double)yTop - bounds.getY());
                g.clearRect(xPos, yTop, (int)bounds.getWidth(), (int)bounds.getHeight());
                SwingUtils.drawString((Graphics)g, (String)this._sLink, (int)xPos, (int)yBaseLine);
                SwingUtils.drawString((Graphics)g, (String)this._sLink, (int)xPos, (int)yBaseLine);
            }
        }
        g.setFont(fntRestore);
        g.setColor(clrRestore);
        g.setBackground(clrBackRestore);
    }

    @Override
    public int getIconWidth() {
        int ret;
        if (this._baseIcon != null) {
            ret = this._baseIcon.getIconWidth();
            switch (0) {
                case 1: {
                    ++ret;
                    Rectangle2D r = this.getLinkRect(null);
                    if (r == null) {
                        ret += 5;
                        break;
                    }
                    ret += (int)r.getWidth();
                    break;
                }
            }
        } else {
            ret = 10;
        }
        return ret;
    }

    @Override
    public int getIconHeight() {
        int iconHeight = this._baseIcon != null ? this._baseIcon.getIconHeight() : 10;
        return iconHeight;
    }

    private Rectangle2D getLinkRect(Graphics2D g) {
        if (this._rectLink == null && g != null) {
            FontRenderContext frc = g.getFontRenderContext();
            this._rectLink = AcceleratorIcon.getLinkFont(g).getStringBounds(this._sLink, frc);
        }
        return this._rectLink;
    }

    private static Font getLinkFont(Graphics2D g) {
        if (_fntLink == null) {
            Font baseFont = UIManager.getFont("Button.font");
            if (baseFont == null) {
                baseFont = g.getFont();
            }
            if (baseFont != null) {
                float baseSize = baseFont.getSize2D();
                float linkSize = baseSize * 0.8f;
                _fntLink = baseFont.deriveFont(linkSize);
            }
        }
        return _fntLink;
    }
}

