/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.javatools.icons.OracleIcons;
import org.openide.util.ImageUtilities;

public final class LazyIconsCacheUtil {
    private static final URL SYS_URL = ExtensionRegistry.getOracleRegistry().getSystemDirectory("oracle.ide");
    private static final Map<String, BufferedImage> iconCache = new HashMap<String, BufferedImage>();

    private LazyIconsCacheUtil() {
    }

    public static void saveIconCache() {
        if (!Ide.isQuitting()) {
            return;
        }
        for (String iconName : iconCache.keySet()) {
            LazyIconsCacheUtil.saveIcon(iconName);
        }
    }

    private static void saveIcon(String iconName) {
        if (iconName == null) {
            return;
        }
        File iconFile = new File(SYS_URL.getPath(), iconName);
        if (iconFile.exists()) {
            return;
        }
        BufferedImage imageIcon = iconCache.get(iconName);
        if (imageIcon != null) {
            try {
                ImageIO.write((RenderedImage)imageIcon, "png", iconFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Image loadIcon(String layout) {
        if (layout == null) {
            return null;
        }
        String iconName = LazyIconsCacheUtil.getIconName(layout);
        if (iconName == null) {
            return null;
        }
        BufferedImage imageIcon = iconCache.get(iconName);
        if (imageIcon == null) {
            URL url = ExtensionRegistry.getOracleRegistry().getSystemDirectory("oracle.ide");
            File iconFile = new File(url.getPath(), iconName);
            if (iconFile == null || !iconFile.exists()) {
                return null;
            }
            try {
                imageIcon = ImageIO.read(iconFile);
                iconCache.put(iconName, imageIcon);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return imageIcon;
    }

    public static String getIconName(String layout) {
        if (layout == null) {
            return null;
        }
        Pattern p = Pattern.compile("nodeClass=\\\".+?\\\"");
        Matcher m = p.matcher(layout);
        if (m.find()) {
            String withQ = m.group().replace("nodeClass=", "");
            return withQ.length() < 3 ? null : withQ.substring(1, withQ.length() - 1) + ".png";
        }
        return null;
    }

    public static Image getIcon(String layout) {
        if (layout == null) {
            return null;
        }
        String iconName = LazyIconsCacheUtil.getIconName(layout);
        Image imageIcon = iconCache.get(iconName);
        if (imageIcon == null) {
            imageIcon = iconCache.get(layout);
        }
        if (imageIcon == null) {
            imageIcon = ImageUtilities.icon2Image((Icon)OracleIcons.getIcon((String)"file.png"));
        }
        return imageIcon;
    }

    public static void addIcon(String layout, Icon icon, boolean saveItToFile) {
        if (icon == null) {
            return;
        }
        String iconName = LazyIconsCacheUtil.getIconName(layout);
        if (iconName != null && iconCache.get(iconName) == null) {
            BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Image image = ImageUtilities.icon2Image((Icon)icon);
            bufferedImage.getGraphics().drawImage(image, 0, 0, null);
            iconCache.put(iconName, bufferedImage);
            if (saveItToFile) {
                LazyIconsCacheUtil.saveIcon(iconName);
            }
        }
    }
}

