/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.MissingResourceException;
import java.util.logging.Level;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.ExtensionSource;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.Role;
import oracle.ide.extension.RoleManager;
import oracle.ideimpl.extension.IDEExtension;
import oracle.ideimpl.extension.RoleExtensionSource;
import oracle.ideimpl.extension.SimpleTableModel;
import oracle.ideimpl.help.AboutTablePage;
import oracle.ideimpl.resource.ExtensionManagerArb;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.ui.table.GenericTable;

public final class ExtensionInfo
extends AboutTablePage {
    public ExtensionInfo() {
        this.setName(ExtensionManagerArb.getString(19));
    }

    @Override
    protected void configureTable(GenericTable table) {
        JTableHeader jth = table.getTableHeader();
        TableColumnModel tcm = jth.getColumnModel();
        TableColumn tc1 = tcm.getColumn(4);
        String tc1Total = this.getTotal((JTable)table, 4);
        tc1.setHeaderValue(tc1.getHeaderValue() + " (" + tc1Total + ")");
        TableColumn tc2 = tcm.getColumn(5);
        String tc2Total = this.getTotal((JTable)table, 5);
        tc2.setHeaderValue(tc2.getHeaderValue() + " (" + tc2Total + ")");
        TableColumn tc3 = tcm.getColumn(6);
        String tc3Total = this.getTotal((JTable)table, 6);
        tc3.setHeaderValue(tc3.getHeaderValue() + " (" + tc3Total + ")");
        table.setSortColumn(6, false);
    }

    private String getTotal(JTable table, int col) {
        int time = 0;
        if (table.getColumnClass(col).equals(Integer.class)) {
            TableModel tm = table.getModel();
            for (int i = 0; i < tm.getRowCount(); ++i) {
                time += ((Integer)tm.getValueAt(i, col)).intValue();
            }
        }
        return this.getTimeSecondsMillis(time);
    }

    @Override
    protected void configureTableRenderers(GenericTable table) {
        table.setDefaultRenderer(Object.class, (TableCellRenderer)new ExtensionTableCellRenderer());
        table.setDefaultRenderer(Integer.class, (TableCellRenderer)new ExtensionLoadingTimeTableCellRenderer());
    }

    @Override
    protected TableModel buildTableModel() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        this._addEnabledExtensions(registry, data);
        this._addDisabledExtensions(registry, data);
        String[] colNames = new String[]{ExtensionManagerArb.getString(20), ExtensionManagerArb.getString(23), ExtensionManagerArb.getString(21), ExtensionManagerArb.getString(22), ExtensionManagerArb.getString(30), ExtensionManagerArb.getString(31), ExtensionManagerArb.getString(32)};
        return new SimpleTableModel(data, colNames){

            public Class getColumnClass(int column) {
                if (column == 4 || column == 5 || column == 6) {
                    return Integer.class;
                }
                return super.getColumnClass(column);
            }
        };
    }

    private void _addEnabledExtensions(ExtensionRegistry registry, List<Object[]> data) {
        Collection extensions = registry.getExtensions();
        String ROLE_PREFIX = "_role.";
        for (Extension ext : extensions) {
            ExtensionSource extSource;
            Object[] row = new Object[7];
            String name = null;
            try {
                if (!ext.getID().startsWith("_role.")) {
                    name = ext.getName();
                } else {
                    RoleManager roleManager = registry.getRoleManager();
                    name = roleManager.getActiveRole().getName() + " " + IdeImplArb.getString(96);
                }
            }
            catch (MissingResourceException mre) {
                registry.getLogger().log(Level.WARNING, "Did not find name for extension " + ext.getID(), mre);
            }
            catch (NumberFormatException nfe) {
                registry.getLogger().log(Level.WARNING, "Did not find name for extension " + ext.getID(), nfe);
            }
            if (name == null) {
                name = IdeImplArb.getString(95);
            } else if (name.startsWith("${") && ext instanceof DefaultExtension && (extSource = ((DefaultExtension)ext).getSource()) instanceof RoleExtensionSource) {
                RoleManager roleMgr = ExtensionRegistry.getExtensionRegistry().getRoleManager();
                Role activeRole = roleMgr.getActiveRole();
                if (ext.getID().contains(activeRole.getId())) {
                    name = activeRole.getName();
                }
            }
            row[0] = name;
            row[1] = ext.getID();
            row[2] = ext.getVersion();
            row[3] = registry.isFullyLoaded(ext) ? ExtensionManagerArb.getString(29) : ExtensionManagerArb.getString(28);
            if (ext instanceof IDEExtension) {
                IDEExtension ie = (IDEExtension)ext;
                row[4] = (int)(ie.getRegTime() / 1000000L);
                row[5] = (int)(ie.getInitTime() / 1000000L);
                row[6] = (Integer)row[4] + (Integer)row[5];
            } else {
                row[4] = 0;
                row[5] = 0;
                row[6] = 0;
            }
            data.add(row);
        }
    }

    private void _addDisabledExtensions(ExtensionRegistry registry, List<Object[]> data) {
        Collection<String> disabledExtensionIds = registry.getDisabledExtensions();
        for (String extensionId : disabledExtensionIds) {
            DefaultExtension minimalExtension = (DefaultExtension)registry.findMinimalExtension(extensionId);
            String name = minimalExtension.getName();
            if (name == null) {
                name = "(Name Unavailable)";
            }
            Object[] row = new Object[]{name, minimalExtension.getID(), minimalExtension.getVersion(), registry.getNotLoadedReason(extensionId), 0, 0, 0};
            data.add(row);
        }
    }

    private String getTimeSecondsMillis(int time) {
        if (time > 1000) {
            int timeMS = time % 1000;
            return (time /= 1000) + "s " + timeMS + "ms";
        }
        return time + "ms";
    }

    private final class ExtensionLoadingTimeTableCellRenderer
    extends ExtensionTableCellRenderer {
        private ExtensionLoadingTimeTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int time = (Integer)value;
            Component comp = super.getTableCellRendererComponent(table, value = ExtensionInfo.this.getTimeSecondsMillis(time), isSelected, hasFocus, row, column);
            if (comp instanceof JLabel) {
                ((JLabel)comp).setHorizontalAlignment(4);
            }
            return comp;
        }
    }

    private class ExtensionTableCellRenderer
    extends DefaultTableCellRenderer {
        private ExtensionTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component label = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            TableModel model = table.getModel();
            String id = (String)model.getValueAt(row, 1);
            if (id != null && ExtensionRegistry.getExtensionRegistry().findExtension(id) == null) {
                label.setForeground(isSelected ? table.getSelectionForeground() : Color.GRAY);
            }
            return label;
        }
    }
}

