/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.ide.IDE;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.extension.UnrecognizedElementException;
import javax.ide.extension.spi.BaseExtensionVisitor;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.DefaultHookVisitorFactory;
import javax.ide.extension.spi.DependencyTree;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.ExtensionVisitor;
import javax.ide.extension.spi.JARExtensionSource;
import javax.ide.extension.spi.MinimalExtensionVisitor;
import javax.ide.extension.spi.PullManifestParser;
import javax.ide.model.DocumentFactory;
import javax.ide.net.VirtualFileSystem;
import javax.ide.progress.ProgressManager;
import javax.ide.util.Graph;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.Version;
import oracle.ide.extension.ExtensionProcessorPlugin;
import oracle.ide.extension.ExtensionQueue;
import oracle.ide.extension.ExtensionQueueLoadStrategy;
import oracle.ide.extension.PropertiesExtensionProcessorPlugin;
import oracle.ide.extension.Role;
import oracle.ide.extension.RoleManager;
import oracle.ide.extension.feature.Feature;
import oracle.ide.extension.feature.FeatureRegistry;
import oracle.ide.help.AboutBoxFactory;
import oracle.ide.migration.MigrationManager;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ideimpl.extension.AddinInfo;
import oracle.ideimpl.extension.AddinManagerImpl;
import oracle.ideimpl.extension.AddinsAboutPage;
import oracle.ideimpl.extension.AddinsHook;
import oracle.ideimpl.extension.Bridge;
import oracle.ideimpl.extension.BridgeExtensionRegistry;
import oracle.ideimpl.extension.DefaultExtensionQueue;
import oracle.ideimpl.extension.DefaultIdeExtensionSearchStrategy;
import oracle.ideimpl.extension.DisabledReason;
import oracle.ideimpl.extension.ExtensionGroups;
import oracle.ideimpl.extension.ExtensionInfo;
import oracle.ideimpl.extension.ExtensionLogSimpleFormatter;
import oracle.ideimpl.extension.ExtensionSearchStrategy;
import oracle.ideimpl.extension.IDEElementContext;
import oracle.ideimpl.extension.IDEExtension;
import oracle.ideimpl.extension.IDEMinimalExtensionVisitor;
import oracle.ideimpl.extension.LayerCache;
import oracle.ideimpl.extension.LayerCacheSupport;
import oracle.ideimpl.extension.LayerHookRegistry;
import oracle.ideimpl.extension.LayerReader;
import oracle.ideimpl.extension.LocatorImpl;
import oracle.ideimpl.extension.MessagePresenter;
import oracle.ideimpl.extension.RoleExtensionSource;
import oracle.ideimpl.extension.RoleManagerImpl;
import oracle.ideimpl.extension.RolePreferences;
import oracle.ideimpl.extension.RoleSelectionPanel;
import oracle.ideimpl.extension.SameThreadExtensionQueueLoadStrategy;
import oracle.ideimpl.extension.TriggerHookRegistry;
import oracle.ideimpl.extension.config.ProductStartupFeatures;
import oracle.ideimpl.extension.feature.FeatureRegistryImpl;
import oracle.ideimpl.extension.preference.ExtensionPreferences;
import oracle.ideimpl.extension.util.ExtensionLoadingDiagnostics;
import oracle.ideimpl.extension.util.ExtensionLoadingLogRecord;
import oracle.ideimpl.resource.ExtensionManagerArb;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ClosureException;
import oracle.javatools.util.Pair;
import oracle.javatools.util.SwingClosure;
import oracle.javatools.util.SwingUtils;

public abstract class ExtensionManagerImpl
extends ExtensionRegistry {
    private ExtensionSearchStrategy searchStrategy;
    private ExtensionSet _extensionSet;
    private Set _newlyInstalledIds = new HashSet();
    private final Set<String> m_disabledExtensionIdsOnly = new HashSet<String>();
    private final Set _disabledExtensionIds = new HashSet();
    private final Map<String, Pair<DisabledReason, String>> _disabledReasons = new HashMap<String, Pair<DisabledReason, String>>();
    private RoleManagerImpl _roleManager;
    private Collection<File> _extensionSearchPath;
    private DefaultHookVisitorFactory _hookVisitor;
    private Collection<ExtensionProcessorPlugin> _processorPlugins = new ArrayList<ExtensionProcessorPlugin>();
    private static final HooksProcessingMode _DEFAULT_HOOKS_PROCESSING_MODE = HooksProcessingMode.EAGER;
    private static volatile HooksProcessingMode _sHooksProcessingMode = null;
    private final TriggerHookRegistry _triggerHookRegistry;
    private final Object _deferredExtensionLoadingLock = new Object();
    private volatile Thread _currentExtensionLoadingThread;
    private volatile boolean _inDeferredExtensionLoadingLockSection = false;
    private final List<AfterExtensionLoadingRunnable> _runnablesToInvokeAfterExtensionLoading = new ArrayList<AfterExtensionLoadingRunnable>();
    private final Object _runnablesToInvokeAfterExtensionLoadingLock = new Object();
    private volatile ExtensionQueue _currentDeferredExtensionLoadingQueue = null;
    private final ExtensionLoadingDiagnostics _extensionLoadingDiagnostics = ExtensionLoadingDiagnostics.getInstance();
    private static volatile Logger _sManifestLogger = null;
    static final boolean caching = !Boolean.getBoolean("oracle.ideimpl.extension.no.caching");
    private CachingSorter cachingSorter;
    private Map<String, IDEExtension> allExts;
    private Map<String, IDEExtension> allRoles;
    private LayerHookRegistry hooksRegistry;
    private static LayerCache layerCache;
    private boolean noRoles;
    private HashSet<String> _productCoreExtensionIds;
    private ExtensionQueueLoadStrategy m_extLoadStrategy;

    public ExtensionManagerImpl() {
        ServiceLoader<LayerCache> lcsl = ServiceLoader.load(LayerCache.class);
        if (caching) {
            Iterator<LayerCache> i$ = lcsl.iterator();
            if (i$.hasNext()) {
                LayerCache lc;
                layerCache = lc = i$.next();
            }
            this.hooksRegistry = new LayerHookRegistry(this);
            this._triggerHookRegistry = this.hooksRegistry;
        } else {
            this._triggerHookRegistry = new TriggerHookRegistry();
        }
    }

    private ExtensionSearchStrategy getSearchStrategy() {
        if (this.searchStrategy != null) {
            return this.searchStrategy;
        }
        String strategyType = System.getProperty("ide.extension.search.strategy");
        if (strategyType != null) {
            try {
                this.searchStrategy = (ExtensionSearchStrategy)Class.forName(strategyType).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.searchStrategy == null) {
            this.searchStrategy = new DefaultIdeExtensionSearchStrategy();
        }
        this.searchStrategy.setExtensionRegistry(this);
        return this.searchStrategy;
    }

    public final TriggerHookRegistry getTriggerHookRegistry() {
        return this._triggerHookRegistry;
    }

    protected ElementVisitorFactory createHookVisitorFactory() {
        this._hookVisitor = new DefaultHookVisitorFactory(){

            protected void validateExtensionHasDependencyOnHookProvider(ElementContext context, ElementName name, ExtensionHook hook, Extension extension) throws UnrecognizedElementException {
                boolean isRoleExtension = false;
                if (extension instanceof DefaultExtension) {
                    isRoleExtension = ((DefaultExtension)extension).getSource() instanceof RoleExtensionSource;
                }
                if (!isRoleExtension) {
                    super.validateExtensionHasDependencyOnHookProvider(context, name, hook, extension);
                }
            }
        };
        return this._hookVisitor;
    }

    @Override
    public final Collection<ExtensionHook> getAllHooks() {
        if (caching) {
            return this.hooksRegistry.getAllHooks();
        }
        if (this._hookVisitor == null) {
            throw new IllegalStateException("Hook visitor factory not yet initialized");
        }
        return this._hookVisitor.getHooks();
    }

    private Collection<File> getRoleSearchPath() {
        LinkedHashSet<File> searchPath = new LinkedHashSet<File>();
        File ideRoles = new File(this.oracleHome() + "/ide/roles");
        if (ideRoles.isDirectory()) {
            searchPath.add(ideRoles);
        }
        String baseDir = this.oracleHome();
        String systemPropPaths = System.getProperty("ide.extension.role.search.path");
        if (systemPropPaths != null) {
            for (String token : ExtensionManagerImpl.pathElements(systemPropPaths)) {
                File f = new File((baseDir != null ? baseDir + "/" : "") + token);
                if (f.isDirectory()) {
                    searchPath.add(f);
                    continue;
                }
                File file = new File(token);
                if (!file.isDirectory()) continue;
                searchPath.add(file);
            }
        }
        return searchPath;
    }

    private void addRoleResourcesToClasspath(Collection<File> roleSearchPath) {
        ArrayList<URL> pathEntries = new ArrayList<URL>();
        for (File f : roleSearchPath) {
            pathEntries.add(URLFactory.newDirURL((String)new File(f, "res").getAbsolutePath()));
        }
        if (!pathEntries.isEmpty()) {
            this.addURLToClassPath(pathEntries);
        }
    }

    protected final void cycleEncountered(Collection extensions) {
        StringBuffer cycle = new StringBuffer();
        for (Extension e : extensions) {
            cycle.append(e.getID());
            cycle.append("->");
        }
        if (cycle.length() > 2) {
            cycle.setLength(cycle.length() - 2);
        }
        Extension lastExtension = (Extension)extensions.toArray()[extensions.size() - 1];
        this.createExtensionLogger().log((LogRecord)new ExtensionLogRecord(Level.SEVERE, "Cyclic extension dependencies: " + cycle.toString(), lastExtension, 0));
    }

    protected String oracleHome() {
        return Ide.getOracleHomeDirectory();
    }

    protected String productHome() {
        return Ide.getProductHomeDirectory();
    }

    @Override
    public Collection<File> getExtensionSearchPath() {
        if (this._extensionSearchPath == null) {
            this._extensionSearchPath = new LinkedHashSet<File>();
            File ideExtensions = new File(this.oracleHome() + "/ide", "extensions");
            if (ideExtensions.isDirectory()) {
                this._extensionSearchPath.add(ideExtensions);
            }
            this.addPathEntries("ide.extension.search.path", this._extensionSearchPath);
            this.addPathEntries("ide.extension.extra.search.path", this._extensionSearchPath, null);
        }
        return this._extensionSearchPath;
    }

    private void addPathEntries(String systemProperty, Collection<File> paths) {
        this.addPathEntries(systemProperty, paths, this.oracleHome());
    }

    static Collection<String> pathElements(String path) {
        ArrayList<String> elements = new ArrayList<String>();
        StringBuilder currentElement = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == ':' && currentElement.length() == 1) {
                currentElement.append(c);
                continue;
            }
            if (c == ':' || c == ';' || c == ',') {
                elements.add(currentElement.toString());
                currentElement.setLength(0);
                continue;
            }
            currentElement.append(c);
        }
        if (currentElement.length() > 0) {
            elements.add(currentElement.toString());
        }
        return Collections.unmodifiableCollection(elements);
    }

    private void addPathEntries(String systemProperty, Collection<File> paths, String baseDir) {
        String systemPropPaths = System.getProperty(systemProperty);
        if (systemPropPaths != null) {
            for (String token : ExtensionManagerImpl.pathElements(systemPropPaths)) {
                File f = new File((baseDir != null ? baseDir + "/" : "") + token);
                if (!f.isDirectory()) continue;
                paths.add(f);
            }
        }
    }

    @Override
    public URL getSystemDirectory(String extensionId) {
        if (extensionId == null) {
            throw new NullPointerException("extensionId is null");
        }
        Extension ext = this.findExtension(extensionId);
        if (ext == null && (ext = this.findMinimalExtension(extensionId)) == null) {
            throw new IllegalArgumentException("Unrecognized extension id " + extensionId);
        }
        return this.getSystemDirectory(extensionId, ext.getVersion());
    }

    @Override
    public URL getSystemDirectory(String extensionId, javax.ide.util.Version version) {
        if (extensionId == null) {
            throw new NullPointerException("extensionId is null");
        }
        if (version == null) {
            throw new NullPointerException("version is null");
        }
        String dirName = this.compactExtensionId(extensionId);
        if (!new javax.ide.util.Version(Version.VER_FULL).equals((Object)version)) {
            dirName = dirName + "." + version.toCanonicalString();
        }
        return URLFactory.newDirURL((URL)URLFactory.newDirURL((String)Ide.getSystemDirectory()), (String)dirName);
    }

    private String compactExtensionId(String extensionId) {
        if (extensionId.startsWith("oracle.") && extensionId.length() > "oracle.".length()) {
            return "o." + extensionId.substring("oracle.".length());
        }
        return extensionId;
    }

    @Override
    public boolean isUserExtension(String extensionId) {
        if (extensionId == null) {
            throw new NullPointerException("extensionId is null");
        }
        try {
            ExtensionSource src = ((DefaultExtension)this.findExtension(extensionId)).getSource();
            if (src instanceof JARExtensionSource) {
                JARExtensionSource jarSource = (JARExtensionSource)src;
                String path = URLFileSystem.getPlatformPathName((URL)VirtualFileSystem.getVirtualFileSystem().toURL(jarSource.getURI()));
                return !Ide.getProductHomeDirectory().equals(Ide.getUserSettingsDirectory()) && path.startsWith(Ide.getUserSettingsDirectory());
            }
            return false;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
    }

    private String ideExtensionsValue() {
        return System.getProperty("ide.extensions");
    }

    private String prohibitedExtensionsValue() {
        return System.getProperty("ide.prohibited.extensions");
    }

    protected Collection loadExtensions() {
        if (caching) {
            PerformanceLogger.get().startTiming(((Object)((Object)this)).getClass().getName() + ".instantiate");
            List<IDEExtension> exts = LayerReader.readExtensions(this);
            PerformanceLogger.get().stopTiming(((Object)((Object)this)).getClass().getName() + ".instantiate", " instantiating " + exts.size() + " extensions");
            PerformanceLogger.get().startTiming(((Object)((Object)this)).getClass().getName() + ".topoSort");
            HashMap<Extension, ExtensionSource> ext2src = new HashMap<Extension, ExtensionSource>(exts.size());
            this.allExts = new HashMap<String, IDEExtension>(exts.size());
            this.allRoles = new HashMap<String, IDEExtension>(exts.size());
            ProgressManager.finalizeProgress((String)"extensions", (int)exts.size());
            ProgressManager.updateProgressTitle((String)"extensions", (String)IdeArb.getString(514));
            for (IDEExtension ext : exts) {
                if (!ext.isRole()) {
                    this.allExts.put(ext.getID(), ext);
                    if (!this.isExtensionEnabled(ext.getID(), ext.getVersion())) continue;
                    ext2src.put((Extension)ext, ext.getSource());
                    continue;
                }
                this.allRoles.put(ext.getID(), ext);
            }
            this.cachingSorter = new CachingSorter(ext2src);
            this.cachingSorter.handleCycles();
            this.cachingSorter.handleUnsatisfiedDependencies();
            PerformanceLogger.get().stopTiming(((Object)((Object)this)).getClass().getName() + ".topoSort", " sorting " + exts.size() + " extensions");
            return this.cachingSorter.getSortedExtensions();
        }
        try {
            this.expandExtensionClosure();
            this.checkForProhibitedExtensions();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PerformanceLogger.get().startTiming(((Object)((Object)this)).getClass().getName() + ".minimalParse");
        Collection l = super.loadExtensions();
        PerformanceLogger.get().stopTiming(((Object)((Object)this)).getClass().getName() + ".minimalParse", "Minimal Parse");
        return l;
    }

    protected MinimalExtensionVisitor createMinimalExtensionVisitor() {
        return new IDEMinimalExtensionVisitor();
    }

    private void checkForProhibitedExtensions() throws IOException {
        Set<String> enabled = ExtensionManagerImpl.stringToSet(this.ideExtensionsValue());
        Set<String> prohibited = ExtensionManagerImpl.stringToSet(this.prohibitedExtensionsValue());
        enabled.retainAll(prohibited);
        if (!enabled.isEmpty()) {
            throw new IllegalArgumentException("The ide cannot start because extensions on the ide.prohibited.extensions list are enabled via the closure of ide.extensions. Prohibited: " + enabled);
        }
    }

    private void expandExtensionClosure() throws IOException {
        Set<String> enabledIds = ExtensionManagerImpl.stringToSet(this.ideExtensionsValue());
        if (enabledIds.isEmpty()) {
            return;
        }
        ArrayList failed = new ArrayList();
        Map extensions = DependencyTree.loadMinimal((DefaultElementContext)this.createInitialContext(), this.findAllExtensionSources(), failed);
        DependencyTree.removeDuplicates((Map)extensions);
        HashMap<String, Extension> extensionsById = new HashMap<String, Extension>();
        for (Extension e : extensions.keySet()) {
            extensionsById.put(e.getID(), e);
        }
        Graph graph = new Graph();
        for (Extension e : extensions.keySet()) {
            if (!graph.contains((Object)e)) {
                graph.add((Object)e);
            }
            Collection deps = e.getDependencies();
            for (ExtensionDependency d : deps) {
                String id = d.getID();
                Extension depExtension = (Extension)extensionsById.get(id);
                if (depExtension == null) continue;
                if (!graph.contains((Object)depExtension)) {
                    graph.add((Object)depExtension);
                }
                graph.connect((Object)depExtension, (Object)e);
            }
        }
        HashSet<String> closure = new HashSet<String>(enabledIds);
        for (String enabledId : enabledIds) {
            Extension enabledExtension = (Extension)extensionsById.get(enabledId);
            try {
                if (enabledExtension == null) {
                    System.err.println("Extension id " + enabledId + " specified in ide.extensions does not exist!");
                    continue;
                }
                List closureForThis = graph.getVerticesConnectedTo((Object)enabledExtension);
                for (Extension e : closureForThis) {
                    closure.add(e.getID());
                }
            }
            catch (Graph.CycleException ce) {
                ce.printStackTrace();
            }
        }
        StringBuilder closureString = new StringBuilder();
        for (String id : closure) {
            closureString.append(id);
            closureString.append(",");
        }
        if (!closure.isEmpty()) {
            closureString.setLength(closureString.length() - 1);
        }
        System.setProperty("ide.extensions", closureString.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection loadExtensions(Collection orderedSources) {
        PerformanceLogger.get().startTiming(((Object)((Object)this)).getClass().getName() + ".loadExtensions");
        ArrayList<RoleExtensionSource> updatedSources = new ArrayList<RoleExtensionSource>(orderedSources.size() + 1);
        updatedSources.addAll(orderedSources);
        Role activeRole = this.getRoleManager().getActiveRole();
        if (RoleManager.NO_ROLE != activeRole) {
            File roleFile = ((RoleManagerImpl)this.getRoleManager()).getRoleFile(activeRole);
            RoleExtensionSource roleSource = new RoleExtensionSource(roleFile);
            updatedSources.add(roleSource);
        }
        ProgressManager.finalizeProgress((String)"extensions", (int)updatedSources.size());
        ProgressManager.updateProgressTitle((String)"extensions", (String)IdeArb.getString(514));
        Collection extensions = super.loadExtensions(updatedSources);
        ArrayList<AfterExtensionLoadingRunnable> localRunnablesToInvokeAfter = new ArrayList<AfterExtensionLoadingRunnable>();
        Object object = this._runnablesToInvokeAfterExtensionLoadingLock;
        synchronized (object) {
            localRunnablesToInvokeAfter.addAll(this._runnablesToInvokeAfterExtensionLoading);
            this._runnablesToInvokeAfterExtensionLoading.clear();
        }
        this._invokeRunnablesAfterExtensionLoading(localRunnablesToInvokeAfter);
        PerformanceLogger.get().stopTiming(((Object)((Object)this)).getClass().getName() + ".loadExtensions", " loading all extensions");
        return extensions;
    }

    @Override
    public Collection<String> getDisabledExtensions() {
        return this.m_disabledExtensionIdsOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadExtension(PullManifestParser parser, Logger logger, ExtensionSource source, int totalCount, int currentCount) {
        String name = source.getName();
        int lastSlash = name.lastIndexOf(47);
        if (lastSlash > 0) {
            name = name.substring(lastSlash + 1);
        }
        this._currentExtensionLoadingThread = Thread.currentThread();
        try {
            super.loadExtension(parser, logger, source, totalCount, currentCount);
        }
        finally {
            this._currentExtensionLoadingThread = null;
        }
        ProgressManager.updateProgressDescription((String)"extensions", (String)name, (int)1);
    }

    List<File> findExtensionJars(String id) {
        ArrayList<File> results = new ArrayList<File>();
        for (File dir : this.getExtensionSearchPath()) {
            File f = new File(dir, id + ".jar");
            if (!f.isFile()) continue;
            results.add(f);
        }
        return results;
    }

    protected IDEElementContext createInitialContext() {
        IDEElementContext context = new IDEElementContext();
        context.setMessageReporter(this.createExtensionLogger());
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Logger createExtensionLogger() {
        if (_sManifestLogger == null) {
            ExtensionManagerImpl extensionManagerImpl = this;
            synchronized (extensionManagerImpl) {
                if (_sManifestLogger == null) {
                    Logger manifestLogger = super.createExtensionLogger();
                    manifestLogger.setUseParentHandlers(false);
                    this.addConsoleLogHandler(manifestLogger);
                    this.addLogWindowLogHandler(manifestLogger);
                    _sManifestLogger = manifestLogger;
                }
            }
        }
        return _sManifestLogger;
    }

    private void addConsoleLogHandler(Logger manifestLogger) {
        String logToConsoleProp = System.getProperty("ide.extension.log.to.console", "default");
        boolean logToConsole = !"none".equals(logToConsoleProp);
        final boolean verbose = "verbose".equals(logToConsoleProp);
        if (logToConsole) {
            ConsoleHandler handler = new ConsoleHandler(){

                @Override
                public void publish(LogRecord record) {
                    if (record instanceof ExtensionLoadingLogRecord && !verbose) {
                        return;
                    }
                    super.publish(record);
                }
            };
            handler.setFormatter(new ExtensionLogSimpleFormatter());
            manifestLogger.addHandler(handler);
        }
    }

    private void addLogWindowLogHandler(Logger manifestLogger) {
        if (Ide.isRunning() && Ide.getIdeArgs().getCreateUI() && !GraphicsEnvironment.isHeadless()) {
            Level messagePresenterLevel = this.getDefaultLevelForLogWindowHandler();
            String logToWindowProp = System.getProperty("ide.extension.log.to.window");
            if (logToWindowProp != null) {
                if ("verbose".equals(logToWindowProp)) {
                    messagePresenterLevel = Level.INFO;
                } else if ("default".equals(logToWindowProp)) {
                    messagePresenterLevel = Level.WARNING;
                }
            }
            MessagePresenter messagePresenter = MessagePresenter.getInstance(messagePresenterLevel);
            manifestLogger.addHandler(messagePresenter);
        }
    }

    protected Level getDefaultLevelForLogWindowHandler() {
        return Level.INFO;
    }

    protected Collection<ExtensionSource> findAllExtensionSources() {
        return this.getSearchStrategy().findExtensionSources();
    }

    @Override
    public RoleManager getRoleManager() {
        if (this._roleManager == null) {
            this._roleManager = new RoleManagerImpl();
        }
        return this._roleManager;
    }

    public final void initializeExtensionRegistry() {
        if (caching) {
            if (!layerCache.isCacheLoaded()) {
                PerformanceLogger.get().startTiming(((Object)((Object)this)).getClass().getName() + ".parse");
                ArrayList<ExtensionSource> sources = new ArrayList<ExtensionSource>(this.findAllExtensionSources());
                RoleManagerImpl rm = (RoleManagerImpl)this.getRoleManager();
                if (this.noRoles) {
                    rm.loadRoles(this.getRoleSearchPath());
                }
                for (Role r : rm.getRoles()) {
                    sources.add(new RoleExtensionSource(rm.getRoleFile(r)));
                }
                LayerCacheSupport.initCache(layerCache, sources);
                PerformanceLogger.get().stopTiming(((Object)((Object)this)).getClass().getName() + ".parse", " parsing extension.xml files");
            }
            super.initialize();
            PerformanceLogger.get().startTiming(((Object)((Object)this)).getClass().getName() + ".initHooksRegistry");
            this.hooksRegistry.initialize();
            this.loadExtensions(this.cachingSorter.getSortedExtensions());
            PerformanceLogger.get().stopTiming(((Object)((Object)this)).getClass().getName() + ".initHooksRegistry", " Init LayerHookRegistry");
        } else {
            super.initialize();
        }
    }

    protected void initialize() {
        this.runRoleSelectionDialog();
        ProgressManager.updateProgressDescription((String)"extensions", (String)IdeArb.getString(513), (int)1);
        this.loadProcessorPlugins();
        this.initializeExtensionRegistry();
        this.postLoadedExtensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProcessorPlugins() {
        PerformanceLogger.get().startTiming("loadProcessorPlugins");
        try {
            this.loadProcessorPlugins(new File(this.productHome(), "macros"));
            this.loadProcessorPlugins(new File(this.oracleHome(), "ide/macros"));
        }
        finally {
            PerformanceLogger.get().stopTiming("loadProcessorPlugins", "Loaded ExtensionProcessorPlugins", 250);
        }
    }

    private void loadProcessorPlugins(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            this.loadProcessorPluginsProperties(files, this._processorPlugins);
        }
    }

    protected void loadProcessorPluginsProperties(File[] files, Collection<ExtensionProcessorPlugin> plugins) {
        for (File file : files) {
            try {
                String name = file.getName().toLowerCase();
                if (!name.endsWith(".properties") && !name.endsWith(".xml")) continue;
                plugins.add(new PropertiesExtensionProcessorPlugin(file));
            }
            catch (Throwable t) {
                this.getLogger().log(Level.SEVERE, "Exception loading macro definitions from " + file, t);
            }
        }
    }

    public Collection<ExtensionProcessorPlugin> getProcessorPlugins() {
        return this._processorPlugins;
    }

    protected void runRoleSelectionDialog() {
        boolean showDialog;
        boolean headless = !Ide.getIdeArgs().getCreateUI();
        String roleId = Ide.getIdeArgs().getRole();
        if (roleId == null) {
            if (Boolean.getBoolean("ide.extension.noroles") || headless) {
                this.noRoles = true;
                return;
            }
            roleId = System.getProperty("ide.role");
        }
        Collection<File> roleSearchPath = this.getRoleSearchPath();
        this.addRoleResourcesToClasspath(roleSearchPath);
        final RoleManagerImpl rm = (RoleManagerImpl)this.getRoleManager();
        rm.loadRoles(roleSearchPath);
        List<Role> roles = rm.getRoles();
        if (headless) {
            for (Role r : roles) {
                if (!roleId.equals(r.getId())) continue;
                rm.setActiveRole(r);
                return;
            }
            System.out.println("Role " + roleId + " not found.");
            return;
        }
        final RolePreferences prefs = rm.getRolePreferences();
        if (roles.size() == 0) {
            if (prefs.getSelectedRoleId() != null && !RoleManager.NO_ROLE.getId().equals(prefs.getSelectedRoleId())) {
                System.out.println("Role " + prefs.getSelectedRoleId() + " is no longer available.");
            }
            return;
        }
        boolean bl = showDialog = prefs.isStartupRoleUIEnabled() && !Ide.getIdeArgs().hasArg("-nonag") && roleId == null;
        if (prefs.isRestartBecauseNewRoleSelected()) {
            showDialog = false;
            prefs.setRestartBecauseNewRoleSelected(false);
            rm.saveRolePreferences();
        }
        Role selectedRole = null;
        if (roleId == null && prefs.getSelectedRoleId() != null && !RoleManager.NO_ROLE.getId().equals(prefs.getSelectedRoleId())) {
            roleId = prefs.getSelectedRoleId();
        }
        if (roleId != null) {
            for (Role r : roles) {
                if (!roleId.equals(r.getId())) continue;
                selectedRole = r;
            }
            if (selectedRole == null && roleId.equals(RoleManager.NO_ROLE.getId())) {
                selectedRole = RoleManager.NO_ROLE;
            }
            if (selectedRole == null) {
                System.out.println("Role " + roleId + " is no longer available.");
                showDialog = true;
            }
        }
        if (showDialog) {
            final ArrayList<Role> allRoles = new ArrayList<Role>();
            allRoles.add(RoleManager.NO_ROLE);
            allRoles.addAll(roles);
            try {
                new SwingClosure(false){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void runImpl() {
                        RoleSelectionPanel rsp = new RoleSelectionPanel();
                        rsp.setSelectOnStartupChecked(prefs.isFresh() ? true : prefs.isStartupRoleUIEnabled());
                        rsp.setRoles(allRoles);
                        if (prefs.getSelectedRoleId() != null) {
                            rsp.setSelectedRole(prefs.getSelectedRoleId());
                        }
                        final JEWTDialog dlg = JEWTDialog.createDialog((Component)SwingUtils.getToplevelWindow(), (String)ExtensionManagerArb.getString(43), (int)3);
                        DialogHeader header = new DialogHeader();
                        header.setHeaderImage(OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/person.png")));
                        header.setHeaderDescription(ExtensionManagerArb.getString(44));
                        dlg.setDialogHeader((Component)header);
                        dlg.setContent((Component)rsp);
                        dlg.setResizable(true);
                        dlg.pack();
                        rsp.addDoubleClickActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                dlg.closeDialog(false);
                            }
                        });
                        Dimension size = dlg.getPreferredSize();
                        dlg.setPreferredSize(new Dimension(Math.max(size.width, 450), size.height));
                        if (dlg.runDialog()) {
                            prefs.setStartupRoleUIEnabled(rsp.isSelectOnStartupChecked());
                            rm.setActiveRole(rsp.getSelectedRole());
                            rm.saveRolePreferences();
                        } else {
                            System.exit(0);
                        }
                    }
                }.run();
            }
            catch (ClosureException e) {
                e.printStackTrace();
            }
        } else if (selectedRole != null) {
            rm.setActiveRole(selectedRole);
        }
    }

    private static javax.ide.util.Version getVersionFromFilename(String filename) {
        String parts = ExtensionManagerImpl.getParts(filename, true);
        if (parts.length() == 0) {
            return null;
        }
        return new javax.ide.util.Version(parts);
    }

    static String getExtensionIdFromFilename(String filename) {
        return ExtensionManagerImpl.getParts(filename, false);
    }

    private static String getParts(String filename, boolean numeric) {
        StringTokenizer tok = new StringTokenizer(filename, ".");
        StringBuffer sb = new StringBuffer();
        while (tok.hasMoreTokens()) {
            char c;
            String token = tok.nextToken();
            boolean number = false;
            for (int i = 0; i < token.length() && ((number = Character.isDigit(c = token.charAt(i))) || i == 0 || c == '-'); ++i) {
            }
            if (number) {
                if (!numeric) continue;
                sb.append(token);
                sb.append('.');
                continue;
            }
            if (numeric || "jar".equalsIgnoreCase(token)) continue;
            sb.append(token);
            sb.append('.');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    protected void postLoadedExtensions() {
        Assert.startTiming((String)"postLoadedExtensions", null, (boolean)false);
        for (Extension ext : this.getExtensions()) {
            ExtensionSource src;
            boolean squashWarning;
            URL systemDir = this.getSystemDirectory(ext.getID());
            if (!URLFileSystem.exists((URL)systemDir)) {
                this._newlyInstalledIds.add(ext.getID());
            }
            if ((squashWarning = Boolean.getBoolean("ide.extension.badname.nowarn")) || !(ext instanceof DefaultExtension) || !((src = ((DefaultExtension)ext).getSource()) instanceof JARExtensionSource)) continue;
            URI jarURI = ((JARExtensionSource)src).getURI();
            String filename = VirtualFileSystem.getVirtualFileSystem().getFileName(jarURI);
            int lastDot = filename.lastIndexOf(46);
            if (lastDot > 1) {
                filename = filename.substring(0, lastDot);
            }
            if (filename.equals(ext.getID())) continue;
            javax.ide.util.Version v = ExtensionManagerImpl.getVersionFromFilename(filename);
            if (v != null) {
                if (ext.getVersion().toString().startsWith(v.toString())) {
                    this.getManifestLogger().log(Level.INFO, ExtensionManagerArb.getString(36), new LocatorImpl(src.getManifestURI().toString()));
                    continue;
                }
                this.getManifestLogger().log(Level.SEVERE, ExtensionManagerArb.format(37, ext.getID(), filename, ext.getVersion().toString()), new LocatorImpl(src.getManifestURI().toString()));
                continue;
            }
            this.getManifestLogger().log(Level.SEVERE, ExtensionManagerArb.format(38, ext.getID(), filename), new LocatorImpl(src.getManifestURI().toString()));
        }
        if (Ide.getIdeArgs().getCreateUI()) {
            Ide.addIdeListener(new IdeListener(){

                @Override
                public void addinsLoaded(IdeEvent e) {
                }

                @Override
                public void mainWindowOpened(IdeEvent e) {
                    Ide.removeIdeListener(this);
                    AboutBoxFactory.getAboutBoxFactory().addPage(ExtensionInfo.class);
                    if (Version.DEBUG_BUILD == 1 || Boolean.getBoolean("ide.extension.about.addins")) {
                        AboutBoxFactory.getAboutBoxFactory().addPage(AddinsAboutPage.class);
                    }
                }

                @Override
                public void mainWindowClosing(IdeEvent e) {
                }
            });
        }
        IDE.getIDE();
        DocumentFactory.getDocumentFactory();
        Assert.endTiming((String)"postLoadedExtensions", (String)"Initialized extension manager", (String)"  ", (boolean)false);
    }

    final void registerJDeveloperHook(ElementName elementName, ExtensionHook hook) {
        super.registerIdeHook(elementName, hook);
    }

    final boolean isJDeveloperHookRegistered(ElementName elementName) {
        return super.isIdeHookRegistered(elementName);
    }

    @Override
    public String getNotLoadedReason(String id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        if (this.findExtension(id) != null) {
            return "";
        }
        Pair<DisabledReason, String> reason = this._disabledReasons.get(id);
        if (reason == null) {
            return ExtensionManagerArb.getString(39);
        }
        return String.format(((DisabledReason)((Object)reason.getFirst())).getMessageTemplate(), reason.getSecond());
    }

    public DisabledReason getDisabledReason(String id) {
        Pair<DisabledReason, String> reason = this._disabledReasons.get(id);
        if (reason == null) {
            return DisabledReason.ERROR;
        }
        return (DisabledReason)((Object)reason.getFirst());
    }

    protected void unsatisfiedExtensionDependencies(Extension ext, Collection deps) {
        Pair thisExtension = new Pair((Object)ext.getID(), (Object)ext.getVersion());
        this._disabledExtensionIds.add(thisExtension);
        this.m_disabledExtensionIdsOnly.add(ext.getID());
        StringBuffer missingDeps = new StringBuffer();
        Iterator i = deps.iterator();
        while (i.hasNext()) {
            ExtensionDependency dep = (ExtensionDependency)i.next();
            missingDeps.append(dep.getID());
            if (!i.hasNext()) continue;
            missingDeps.append(", ");
        }
        this._disabledReasons.put(ext.getID(), (Pair<DisabledReason, String>)new Pair((Object)DisabledReason.MISSING_DEPENDENCIES, (Object)missingDeps.toString()));
    }

    protected boolean isExtensionEnabled(String id, javax.ide.util.Version version) {
        RoleManagerImpl rm;
        FeatureRegistry featureRegistry;
        Feature feature;
        boolean enabled;
        if (this._extensionSet == null) {
            try {
                this._extensionSet = new ExtensionSet();
                this._extensionSet.load();
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                this._extensionSet = new NullExtensionSet();
            }
        }
        if (!(enabled = this._extensionSet.isExtensionEnabled(id, version))) {
            this._disabledReasons.put(id, (Pair<DisabledReason, String>)new Pair((Object)DisabledReason.USER_DISABLED, (Object)""));
        }
        if ((feature = (featureRegistry = this.getFeatureRegistry()).getFeatureForExtension(id)) != null && !this._extensionSet.isExtensionEnabled(feature.getId(), version)) {
            enabled = false;
            this._disabledReasons.put(id, (Pair<DisabledReason, String>)new Pair((Object)DisabledReason.USER_DISABLED, (Object)""));
        }
        if ((rm = (RoleManagerImpl)this.getRoleManager()) != null && rm.getActiveRole() != RoleManager.NO_ROLE && rm.getDisabledExtensions(rm.getActiveRole()).contains(id)) {
            enabled = false;
            this._disabledReasons.put(id, (Pair<DisabledReason, String>)new Pair((Object)DisabledReason.ROLE_DISABLED, (Object)rm.getActiveRole().getName()));
        }
        if (!enabled) {
            this._disabledExtensionIds.add(new Pair((Object)id, (Object)version));
            this.m_disabledExtensionIdsOnly.add(id);
        }
        return enabled;
    }

    private void addURLToClassPath(Collection jarFiles) {
        if (jarFiles == null || jarFiles.isEmpty()) {
            return;
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader instanceof URLClassLoader) {
                this.addToURLClassLoader(jarFiles, (URLClassLoader)loader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addToURLClassLoader(Collection jarFiles, URLClassLoader loader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> c = Class.forName("java.net.URLClassLoader");
        Class[] parameterTypes = new Class[]{Class.forName("java.net.URL")};
        Method m = c.getDeclaredMethod("addURL", parameterTypes);
        m.setAccessible(true);
        HashSet<URL> existingEntries = new HashSet<URL>();
        existingEntries.addAll(Arrays.asList(loader.getURLs()));
        for (URL url : jarFiles) {
            if (existingEntries.contains(url)) continue;
            Object[] args = new Object[]{url};
            try {
                m.invoke((Object)loader, args);
                URL userDir = URLFactory.newDirURL((String)System.getProperty("user.dir"));
                String relativePath = URLFileSystem.toRelativeSpec((URL)url, (URL)userDir);
                if (File.separatorChar != '/') {
                    relativePath = relativePath.replace('/', File.separatorChar);
                }
                String cp = System.getProperty("java.class.path") + File.pathSeparator + relativePath;
                System.setProperty("java.class.path", cp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ExtensionHook getHook(ElementName elementName) {
        if (caching) {
            return this.hooksRegistry.getHook(elementName);
        }
        ExtensionHook hook = super.getHook(elementName);
        if (hook == null) {
            hook = this._triggerHookRegistry.getTriggerHook(elementName);
        }
        return hook;
    }

    @Override
    public FeatureRegistry getFeatureRegistry() {
        return FeatureRegistryImpl.getInstance();
    }

    public boolean isProductCoreExtension(Extension extension) {
        if (this._productCoreExtensionIds == null) {
            LinkedHashSet<String> productCoreExtensionIds = new LinkedHashSet<String>();
            FeatureRegistry featureRegistry = this.getFeatureRegistry();
            LinkedHashSet<Feature> startupFeatureSet = new LinkedHashSet<Feature>();
            startupFeatureSet.addAll(ProductStartupFeatures.getStartupFeatures(featureRegistry));
            RoleManagerImpl rm = (RoleManagerImpl)this.getRoleManager();
            Role activeRole = rm.getActiveRole();
            if (activeRole != null && activeRole != RoleManager.NO_ROLE) {
                List<String> roleStartupFeatureIds = rm.getRoleStartupFeatures(activeRole);
                for (String featureId : roleStartupFeatureIds) {
                    Feature feature = featureRegistry.getFeature(featureId);
                    if (feature != null) {
                        startupFeatureSet.add(feature);
                        continue;
                    }
                    this.getLogger().log(Level.SEVERE, "Error: Feature'" + featureId + "' is listed as a startup feature in the active role, but no feature with that id was found");
                }
            }
            LinkedHashSet<Extension> productCoreMinimalExtensions = new LinkedHashSet<Extension>();
            for (Feature feature : startupFeatureSet) {
                for (String extId : feature.getMembers()) {
                    Extension minimalExtension = this.findMinimalExtension(extId);
                    if (minimalExtension == null) continue;
                    productCoreMinimalExtensions.add(minimalExtension);
                }
            }
            if (!productCoreMinimalExtensions.isEmpty()) {
                productCoreMinimalExtensions = this._getAllExtensionsFromDependenciesAndGroups(productCoreMinimalExtensions, true, true, false);
                for (Extension fakeExtension : productCoreMinimalExtensions) {
                    productCoreExtensionIds.add(fakeExtension.getID());
                }
            }
            this._productCoreExtensionIds = productCoreExtensionIds;
        }
        return this._productCoreExtensionIds.contains(extension.getID());
    }

    private boolean isRoleExtension(Extension extension) {
        if (extension instanceof IDEExtension) {
            return ((IDEExtension)extension).getSource() instanceof RoleExtensionSource;
        }
        return false;
    }

    public boolean shouldEagerlyLoadExtensionHooks(Extension extension) {
        if (this.isProductCoreExtension(extension) || this.isRoleExtension(extension)) {
            return true;
        }
        switch (ExtensionManagerImpl.getHooksProcessingMode()) {
            case EAGER: {
                return true;
            }
            case LAZY: {
                return false;
            }
            case LAZY_IF_HAS_TRIGGERS: {
                IDEExtension ideExtension = (IDEExtension)extension;
                return ideExtension.getState() != IDEExtension.State.TRIGGERS_LOADED;
            }
        }
        throw new IllegalStateException("Unknown HooksProcessingMode encountered");
    }

    @Override
    public boolean isFullyLoaded(Extension extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Null passed to isFullyLoaded()");
        }
        IDEExtension ideExtension = (IDEExtension)extension;
        return ideExtension.getState() == IDEExtension.State.FULLY_LOADED;
    }

    @Override
    public boolean isFullyLoaded(String extensionId) {
        if (extensionId == null) {
            throw new IllegalArgumentException("Null passed to isFullyLoaded()");
        }
        Extension extension = this.findExtension(extensionId);
        return extension != null && this.isFullyLoaded(extension);
    }

    private final ExtensionQueueLoadStrategy getExtensionQueueLoadStrategy() {
        ServiceLoader<ExtensionQueueLoadStrategy> extQLoader;
        Iterator<ExtensionQueueLoadStrategy> queueLoadStrategyIter;
        if (this.m_extLoadStrategy == null && !GraphicsEnvironment.isHeadless() && !"onEDT".equals(System.getProperty(ExtensionQueueLoadStrategy.class.getName())) && (queueLoadStrategyIter = (extQLoader = ServiceLoader.load(ExtensionQueueLoadStrategy.class)).iterator()).hasNext()) {
            this.m_extLoadStrategy = queueLoadStrategyIter.next();
        }
        if (this.m_extLoadStrategy == null) {
            this.m_extLoadStrategy = new SameThreadExtensionQueueLoadStrategy();
        }
        return this.m_extLoadStrategy;
    }

    public boolean isCurrentThreadFullyLoadingExtension(String extensionId) {
        if (Thread.currentThread().equals(this._currentExtensionLoadingThread)) {
            Extension extension = this.findExtension(extensionId);
            if (this._currentDeferredExtensionLoadingQueue != null && extension != null && this._currentDeferredExtensionLoadingQueue.contains(extension)) {
                IDEExtension ideExtension = (IDEExtension)extension;
                IDEExtension.State state = ideExtension.getState();
                return state == IDEExtension.State.FULLY_LOADED || state == IDEExtension.State.HOOKS_LOADING;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeAfterExtensionLoading(Runnable runnable, boolean invokeOnEDT) {
        AfterExtensionLoadingRunnable wrapper = new AfterExtensionLoadingRunnable(runnable, invokeOnEDT);
        if (Thread.currentThread().equals(this._currentExtensionLoadingThread)) {
            Object object = this._runnablesToInvokeAfterExtensionLoadingLock;
            synchronized (object) {
                this._runnablesToInvokeAfterExtensionLoading.add(wrapper);
            }
        } else {
            wrapper.run();
        }
    }

    private void _invokeRunnablesAfterExtensionLoading(List<AfterExtensionLoadingRunnable> runnables) {
        for (Runnable runnable : runnables) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                this.getLogger().log(Level.SEVERE, "Unexpected throwable encountered while invoking runnable", t);
            }
        }
    }

    @Override
    public final void fullyLoadExtension(Extension extension) {
        this.fullyLoadExtension(extension, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void fullyLoadExtension(Extension extension, String reason) {
        IDEExtension ideExtension = (IDEExtension)extension;
        if (ideExtension.getState() == IDEExtension.State.FULLY_LOADED) {
            return;
        }
        if (Thread.currentThread().equals(this._currentExtensionLoadingThread)) {
            if (ideExtension.getState() == IDEExtension.State.TRIGGERS_LOADING || ideExtension.getState() == IDEExtension.State.HOOKS_LOADING) {
                return;
            }
            throw new IllegalStateException("Illegal attempt to load extension: " + ideExtension.getID() + ". Extension loading code (such as hook handlers) " + "cannot execute a code path that requires fully loading a different extension " + "outside of the dependency chain.");
        }
        AddinManagerImpl addinManager = (AddinManagerImpl)AddinManagerImpl.createInstance();
        if (addinManager.isInitializingProductAndUserAddins()) {
            IllegalStateException e = new IllegalStateException("Illegal attempt to load deferred extension: " + ideExtension.getID() + ".  Extension loading code (such as Addin.initialize()) " + "cannot execute a code path that requires fully loading a different extension outside of the dependency chain.");
            this.getLogger().log(Level.SEVERE, "Illegal attempt to load a deferred extension while initializing the product core Addins", e);
            return;
        }
        ArrayList<AfterExtensionLoadingRunnable> localRunnablesToInvokeAfter = new ArrayList<AfterExtensionLoadingRunnable>();
        Object object = this._deferredExtensionLoadingLock;
        synchronized (object) {
            if (this._inDeferredExtensionLoadingLockSection) {
                throw new IllegalStateException("Illegal attempt to re-enter fullyLoadExtension. The extension for which fully loading is requested: " + ideExtension.toString() + "\n" + "The state of the extension loading queue at this moment is: \n" + this._currentDeferredExtensionLoadingQueue.toString());
            }
            this._inDeferredExtensionLoadingLockSection = true;
            try {
                if (ideExtension.getState() == IDEExtension.State.FULLY_LOADED) {
                    return;
                }
                this._extensionLoadingDiagnostics.setTriggerReason((Extension)ideExtension, reason);
                ExtensionQueue.Builder extensionQueueBuilder = DefaultExtensionQueue.createBuilder();
                LinkedHashSet<Extension> requiredExtensionSet = this._getAllExtensionsFromDependenciesAndGroups(Collections.singleton(extension), true, false, true);
                HashMap<Extension, ExtensionSource> requiredExtensionToSourceMap = new HashMap<Extension, ExtensionSource>();
                for (Extension requiredExtension : requiredExtensionSet) {
                    requiredExtensionToSourceMap.put(requiredExtension, ((IDEExtension)requiredExtension).getSource());
                }
                DependencyTree tree = DependencyTree.buildTree(requiredExtensionToSourceMap);
                List sortedRequiredExtensions = tree.getSortedExtensions();
                for (Extension sortedRequiredExtension : sortedRequiredExtensions) {
                    IDEExtension sortedIdeRequiredExtension = (IDEExtension)sortedRequiredExtension;
                    if (sortedIdeRequiredExtension.getState() == IDEExtension.State.FULLY_LOADED) continue;
                    extensionQueueBuilder.add((Extension)sortedIdeRequiredExtension);
                    this._extensionLoadingDiagnostics.setLoadingSet((Extension)sortedIdeRequiredExtension, ideExtension.getID());
                }
                ExtensionQueue extensionLoadingQueue = extensionQueueBuilder.build();
                if (extensionLoadingQueue.size() > 0) {
                    this._currentDeferredExtensionLoadingQueue = extensionLoadingQueue;
                    this.getLogger().fine("fullyLoaded queue: \n\n" + this._currentDeferredExtensionLoadingQueue.toString());
                    try {
                        this.getExtensionQueueLoadStrategy().load(extensionLoadingQueue);
                    }
                    finally {
                        this._currentDeferredExtensionLoadingQueue = null;
                    }
                }
                Object object2 = this._runnablesToInvokeAfterExtensionLoadingLock;
                synchronized (object2) {
                    localRunnablesToInvokeAfter.addAll(this._runnablesToInvokeAfterExtensionLoading);
                    this._runnablesToInvokeAfterExtensionLoading.clear();
                }
            }
            finally {
                this._inDeferredExtensionLoadingLockSection = false;
            }
        }
        this._invokeRunnablesAfterExtensionLoading(localRunnablesToInvokeAfter);
        MigrationManager.getMigrationManager().migrateRecentlyInitializedExtension();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fullyLoadExtensions(Map<Extension, String> extension2reason) {
        ArrayList<Extension> copyOfExtensions = new ArrayList<Extension>(extension2reason.keySet());
        for (Extension extension : extension2reason.keySet()) {
            AddinManagerImpl addinManager;
            IDEExtension ideExtension = (IDEExtension)extension;
            if (ideExtension.getState() == IDEExtension.State.FULLY_LOADED) {
                copyOfExtensions.remove(extension);
                if (copyOfExtensions.size() == 0) {
                    return;
                }
            }
            if (Thread.currentThread().equals(this._currentExtensionLoadingThread)) {
                if (ideExtension.getState() == IDEExtension.State.TRIGGERS_LOADING || ideExtension.getState() == IDEExtension.State.HOOKS_LOADING) {
                    copyOfExtensions.remove(extension);
                    if (copyOfExtensions.size() == 0) {
                        return;
                    }
                } else {
                    throw new IllegalStateException("Illegal attempt to load extension: " + ideExtension.getID() + ". Extension loading code (such as hook handlers) " + "cannot execute a code path that requires fully loading a different extension " + "outside of the dependency chain.");
                }
            }
            if (!(addinManager = (AddinManagerImpl)AddinManagerImpl.createInstance()).isInitializingProductAndUserAddins()) continue;
            IllegalStateException e = new IllegalStateException("Illegal attempt to load deferred extension: " + ideExtension.getID() + ".  Extension loading code (such as Addin.initialize()) " + "cannot execute a code path that requires fully loading a different extension outside of the dependency chain.");
            this.getLogger().log(Level.SEVERE, "Illegal attempt to load a deferred extension while initializing the product core Addins", e);
            return;
        }
        ArrayList<AfterExtensionLoadingRunnable> localRunnablesToInvokeAfter = new ArrayList<AfterExtensionLoadingRunnable>();
        Object object = this._deferredExtensionLoadingLock;
        synchronized (object) {
            if (this._inDeferredExtensionLoadingLockSection) {
                throw new IllegalStateException("Illegal attempt to re-enter fullyLoadExtension. ");
            }
            this._inDeferredExtensionLoadingLockSection = true;
            try {
                ExtensionQueue.Builder extensionQueueBuilder = DefaultExtensionQueue.createBuilder();
                HashMap<Extension, ExtensionSource> requiredExtensionToSourceMap = new HashMap<Extension, ExtensionSource>();
                HashMap<Extension, Extension> reverseDepenencyMap = new HashMap<Extension, Extension>();
                for (Extension extension : copyOfExtensions) {
                    IDEExtension ideExtension = (IDEExtension)extension;
                    this._extensionLoadingDiagnostics.setTriggerReason((Extension)ideExtension, extension2reason.get((Object)ideExtension));
                    LinkedHashSet<Extension> requiredExtensionSet = this._getAllExtensionsFromDependenciesAndGroups(Collections.singleton(extension), true, false, true);
                    if (!requiredExtensionSet.contains((Object)ideExtension)) {
                        System.err.println("BAh BAH BAH");
                    }
                    for (Extension e : requiredExtensionSet) {
                        if (reverseDepenencyMap.containsKey(e)) continue;
                        reverseDepenencyMap.put(e, extension);
                    }
                    for (Extension requiredExtension : requiredExtensionSet) {
                        requiredExtensionToSourceMap.put(requiredExtension, ((IDEExtension)requiredExtension).getSource());
                    }
                }
                DependencyTree tree = DependencyTree.buildTree(requiredExtensionToSourceMap);
                List sortedRequiredExtensions = tree.getSortedExtensions();
                for (Extension sortedRequiredExtension : sortedRequiredExtensions) {
                    IDEExtension sortedIdeRequiredExtension = (IDEExtension)sortedRequiredExtension;
                    if (sortedIdeRequiredExtension.getState() == IDEExtension.State.FULLY_LOADED) continue;
                    extensionQueueBuilder.add((Extension)sortedIdeRequiredExtension);
                    this._extensionLoadingDiagnostics.setLoadingSet((Extension)sortedIdeRequiredExtension, ((Extension)reverseDepenencyMap.get((Object)sortedIdeRequiredExtension)).getID());
                }
                ExtensionQueue extensionLoadingQueue = extensionQueueBuilder.build();
                if (extensionLoadingQueue.size() > 0) {
                    this._currentDeferredExtensionLoadingQueue = extensionLoadingQueue;
                    try {
                        this.getExtensionQueueLoadStrategy().load(extensionLoadingQueue);
                    }
                    finally {
                        this._currentDeferredExtensionLoadingQueue = null;
                    }
                }
                Object object2 = this._runnablesToInvokeAfterExtensionLoadingLock;
                synchronized (object2) {
                    localRunnablesToInvokeAfter.addAll(this._runnablesToInvokeAfterExtensionLoading);
                    this._runnablesToInvokeAfterExtensionLoading.clear();
                }
            }
            finally {
                this._inDeferredExtensionLoadingLockSection = false;
            }
        }
        this._invokeRunnablesAfterExtensionLoading(localRunnablesToInvokeAfter);
        MigrationManager.getMigrationManager().migrateRecentlyInitializedExtension();
    }

    private LinkedHashSet<Extension> _getAllExtensionsFromDependenciesAndGroups(Collection<Extension> extensions, boolean includeGroups, boolean useMinimalExtensionLookup, boolean reportLoadingDiagnostics) {
        LinkedList<Extension> processingQueue = new LinkedList<Extension>();
        LinkedHashSet<Extension> discoveredSet = new LinkedHashSet<Extension>();
        HashSet<String> seenGroupIds = new HashSet<String>();
        ExtensionGroups groups = ExtensionGroups.getInstance();
        BridgeExtensionRegistry bridgeRegistry = BridgeExtensionRegistry.getInstance();
        processingQueue.addAll(extensions);
        discoveredSet.addAll(extensions);
        while (!processingQueue.isEmpty()) {
            boolean notSeenGroupBefore;
            Extension current = (Extension)processingQueue.removeFirst();
            Collection dependencies = current.getDependencies();
            for (ExtensionDependency dep : dependencies) {
                String id = dep.getID();
                Extension depExt = null;
                depExt = useMinimalExtensionLookup ? this.findMinimalExtension(id) : this.findExtension(id);
                if (depExt == null) continue;
                boolean notSeenBefore = discoveredSet.add(depExt);
                if (notSeenBefore) {
                    processingQueue.add(depExt);
                }
                if (!reportLoadingDiagnostics) continue;
                this._extensionLoadingDiagnostics.reportIncomingDependency(depExt, current.getID());
            }
            if (!includeGroups) continue;
            String groupId = groups.getExtensionGroupOfMember(current.getID());
            if (!"*NOT_IN_EXTENSION_GROUP*".equals(groupId) && (notSeenGroupBefore = seenGroupIds.add(groupId))) {
                List<String> memberIds = groups.getExtensionGroupMembers(groupId);
                for (String memberId : memberIds) {
                    boolean notSeenBefore;
                    Extension memberExtension = null;
                    memberExtension = useMinimalExtensionLookup ? this.findMinimalExtension(memberId) : this.findExtension(memberId);
                    if (memberExtension == null || !(notSeenBefore = discoveredSet.add(memberExtension))) continue;
                    processingQueue.add(memberExtension);
                    if (!reportLoadingDiagnostics) continue;
                    this._extensionLoadingDiagnostics.reportReasonTypeIfUnset(memberExtension, (short)3);
                }
            }
            List<Bridge> bridgeList = bridgeRegistry.getBridgesWithEndpoint(current);
            for (Bridge bridge : bridgeList) {
                Extension bridgeExtension;
                boolean notSeenBefore;
                Extension fromExtension = bridge.getFromExtension();
                Extension toExtension = bridge.getToExtension();
                if (!this.isFullyLoaded(fromExtension) && !discoveredSet.contains(fromExtension) || !this.isFullyLoaded(toExtension) && !discoveredSet.contains(toExtension) || !(notSeenBefore = discoveredSet.add(bridgeExtension = bridge.getBridgeExtension()))) continue;
                processingQueue.add(bridgeExtension);
                if (!reportLoadingDiagnostics) continue;
                this._extensionLoadingDiagnostics.reportLoadedViaBridge(bridgeExtension, bridge);
            }
        }
        return discoveredSet;
    }

    final void __loadExtensionHooks(Extension extension) {
        IDEExtension ideExtension = (IDEExtension)extension;
        this._loadExtensionHooks(ideExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadExtensionHooks(IDEExtension ideExtension) {
        if (ideExtension.getState() == IDEExtension.State.FULLY_LOADED) {
            throw new IllegalStateException("_loadExtensionHooks called with already loaded extension " + ideExtension.toString());
        }
        Logger logger = this.createExtensionLogger();
        if (!ideExtension.hasHooksSection()) {
            ideExtension.setState(IDEExtension.State.FULLY_LOADED);
            this._extensionLoadingDiagnostics.logExtensionLoadingDiagnostics((Extension)ideExtension, logger);
            return;
        }
        this._currentExtensionLoadingThread = Thread.currentThread();
        try {
            AddinManagerImpl addinManager = (AddinManagerImpl)AddinManagerImpl.createInstance();
            AddinsHook addinsHook = (AddinsHook)this.getHook(AddinsHook.ELEMENT);
            int beforeAddinsSize = addinsHook.getAddinInfos().size();
            if (caching) {
                this._loadExtHooksCached(ideExtension);
            } else {
                this._loadExtHooksClassic(ideExtension);
            }
            ArrayList<AddinInfo> addinInfoList = new ArrayList<AddinInfo>();
            addinInfoList.addAll(addinsHook.getAddinInfos());
            int afterAddinsSize = addinInfoList.size();
            if (afterAddinsSize > beforeAddinsSize) {
                for (int i = beforeAddinsSize; i < afterAddinsSize; ++i) {
                    AddinInfo info = (AddinInfo)addinInfoList.get(i);
                    try {
                        addinManager.initializeAddin(info);
                        continue;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to initialize addin: " + info.getClassName(), e);
                    }
                }
            }
            this._extensionLoadingDiagnostics.logExtensionLoadingDiagnostics((Extension)ideExtension, logger);
        }
        finally {
            this._currentExtensionLoadingThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadExtHooksClassic(IDEExtension ideExtension) {
        ideExtension.setState(IDEExtension.State.HOOKS_LOADING);
        PullManifestParser minimalParser = new PullManifestParser((DefaultElementContext)this.createInitialContext());
        JustHooksExtensionVisitor visitor = new JustHooksExtensionVisitor(ideExtension);
        minimalParser.getContext().registerChildVisitor(ExtensionVisitor.ELEMENT, (ElementVisitor)visitor);
        ExtensionSource source = ideExtension.getSource();
        minimalParser.getContext().getScopeData().put("extSource", source);
        InputStream inputStream = null;
        try {
            inputStream = source.getInputStream();
            minimalParser.parse(inputStream, source.getManifestURI().toString());
        }
        catch (ParserConfigurationException pce) {
            throw new IllegalStateException("JAXP is misconfigured", pce);
        }
        catch (XMLStreamException xmlSE) {
            minimalParser.getContext().getLogger().log(Level.SEVERE, "Failed to process extension source: " + source.getManifestURI(), xmlSE);
        }
        catch (FileNotFoundException fnf) {
            minimalParser.getContext().getLogger().log(Level.SEVERE, source.getName() + " does not contain an extension manifest.", fnf);
        }
        catch (IOException ioe) {
            minimalParser.getContext().getLogger().log(Level.SEVERE, "Failed to process extension source " + source.getName() + ": " + ioe.getLocalizedMessage(), ioe);
        }
        finally {
            ideExtension.setState(IDEExtension.State.FULLY_LOADED);
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ioe) {
                minimalParser.getContext().getLogger().log(Level.SEVERE, "Exception closing stream", ioe);
            }
        }
    }

    private void _loadExtHooksCached(IDEExtension ext) {
        this.hooksRegistry.fullyLoad(ext);
    }

    protected static HooksProcessingMode getHooksProcessingMode() {
        if (_sHooksProcessingMode == null) {
            String value = null;
            try {
                value = System.getProperty("oracle.ide.extension.HooksProcessingMode");
            }
            catch (Throwable t) {
                value = null;
            }
            _sHooksProcessingMode = "EAGER".equalsIgnoreCase(value) ? HooksProcessingMode.EAGER : ("LAZY".equalsIgnoreCase(value) ? HooksProcessingMode.LAZY : ("LAZY_IF_HAS_TRIGGERS".equalsIgnoreCase(value) ? HooksProcessingMode.LAZY_IF_HAS_TRIGGERS : _DEFAULT_HOOKS_PROCESSING_MODE));
        }
        return _sHooksProcessingMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> stringToSet(String propValue) throws IOException {
        HashSet<String> list = new HashSet<String>();
        if (propValue == null) {
            return list;
        }
        if (propValue.charAt(0) == '@') {
            String filename = propValue.substring(1);
            File f = new File(filename);
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(f));
                String line = br.readLine();
                while (line != null) {
                    if ((line = line.trim()).length() > 0 && line.charAt(0) != '#') {
                        list.add(line);
                    }
                    line = br.readLine();
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        }
        StringTokenizer tok = new StringTokenizer(propValue, ", ");
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken());
        }
        return list;
    }

    @Override
    public boolean isNewlyInstalled(String extensionId) {
        return this._newlyInstalledIds.contains(extensionId);
    }

    @Override
    public Extension findExtensionByClassLoader(ClassLoader classLoader) {
        return null;
    }

    protected List<ExtensionDependency> findExtensionDependencies(String id) {
        return Collections.emptyList();
    }

    static LayerCache getLayerCache() {
        return layerCache;
    }

    protected ExtensionSource getExtensionSourceById(String id) {
        throw new IllegalStateException("Should be overriden");
    }

    private void printExtStats() {
        int count = 0;
        int countFL = 0;
        int countI = 0;
        int countTL = 0;
        int countOther = 0;
        block5: for (Extension e : this.cachingSorter.getSortedExtensions()) {
            IDEExtension ie = (IDEExtension)e;
            ++count;
            switch (ie.getState()) {
                case FULLY_LOADED: {
                    ++countFL;
                    continue block5;
                }
                case TRIGGERS_LOADED: {
                    ++countTL;
                    continue block5;
                }
                case INITIAL: {
                    ++countI;
                    continue block5;
                }
            }
            ++countOther;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadExtensions(List<Extension> exts) {
        LayerCache.TIMERS.reset();
        PerformanceLogger.get().startTiming(((Object)((Object)this)).getClass().getName() + ".loadExtensions");
        ArrayList<Object> uExts = new ArrayList<Object>(exts.size() + 1);
        uExts.addAll(exts);
        Role activeRole = this.getRoleManager().getActiveRole();
        if (RoleManager.NO_ROLE != activeRole) {
            File roleFile = ((RoleManagerImpl)this.getRoleManager()).getRoleFile(activeRole);
            RoleExtensionSource roleSource = new RoleExtensionSource(roleFile);
            IDEExtension rex = this.allRoles.get("_role." + activeRole.getId());
            rex.setSource(roleSource);
            uExts.add((Object)rex);
        }
        int totalCount = uExts.size();
        int currentCount = 1;
        for (Extension object : uExts) {
            this.loadExtension((IDEExtension)object, totalCount, currentCount);
            ++currentCount;
        }
        this.printExtStats();
        ArrayList<AfterExtensionLoadingRunnable> localRunnablesToInvokeAfter = new ArrayList<AfterExtensionLoadingRunnable>();
        Object object = this._runnablesToInvokeAfterExtensionLoadingLock;
        synchronized (object) {
            localRunnablesToInvokeAfter.addAll(this._runnablesToInvokeAfterExtensionLoading);
            this._runnablesToInvokeAfterExtensionLoading.clear();
        }
        this._invokeRunnablesAfterExtensionLoading(localRunnablesToInvokeAfter);
        LayerCache.TIMERS.print();
        PerformanceLogger.get().stopTiming(((Object)((Object)this)).getClass().getName() + ".loadExtensions", " loading all extensions");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtension(IDEExtension ie, int totalCount, int currentCount) {
        String name = ie.getID();
        int lastSlash = name.lastIndexOf(47);
        if (lastSlash > 0) {
            name = name.substring(lastSlash + 1);
        }
        this._currentExtensionLoadingThread = Thread.currentThread();
        try {
            if (this.shouldEagerlyLoadExtensionHooks((Extension)ie)) {
                ExtensionLoadingDiagnostics.getInstance().reportReasonTypeIfUnset((Extension)ie, (short)5);
                ExtensionLoadingDiagnostics.getInstance().setLoadingSet((Extension)ie, "Startup");
                this.hooksRegistry.initExtension(ie, IDEExtension.State.FULLY_LOADED);
            } else {
                this.hooksRegistry.initExtension(ie, IDEExtension.State.TRIGGERS_LOADED);
            }
        }
        finally {
            this._currentExtensionLoadingThread = null;
        }
        ProgressManager.updateProgressDescription((String)"extensions", (String)name, (int)1);
    }

    public Extension findMinimalExtension(String extensionId) {
        return caching ? (Extension)this.allExts.get(extensionId) : super.findMinimalExtension(extensionId);
    }

    protected ExtensionRegistry.Sorter createExtensionSorter(Map<Extension, ExtensionSource> minimalExtensionsToSources) {
        return caching ? this.cachingSorter : super.createExtensionSorter(minimalExtensionsToSources);
    }

    private class CachingSorter
    implements ExtensionRegistry.Sorter {
        private DependencyTree _dependencyTree;

        CachingSorter(Map<Extension, ExtensionSource> ext2src) {
            this._dependencyTree = DependencyTree.buildTree(ext2src);
        }

        public List<ExtensionSource> getOrderedExtensionSources() {
            ArrayList<ExtensionSource> orderedSources = new ArrayList<ExtensionSource>();
            for (String id : this._dependencyTree.getSortedExtensionIDs()) {
                orderedSources.add(this._dependencyTree.getSource(id));
            }
            return orderedSources;
        }

        public void handleCycles() {
            Iterator i = this._dependencyTree.getCycles().iterator();
            while (i.hasNext()) {
                ExtensionManagerImpl.this.cycleEncountered((Collection)i.next());
            }
        }

        public void handleUnsatisfiedDependencies() {
            for (Extension unsatisfied : this._dependencyTree.getUnsatisfiedExtensions()) {
                Collection deps = this._dependencyTree.getUnsatisfiedDependencies(unsatisfied);
                ExtensionManagerImpl.this.unsatisfiedExtensionDependencies(unsatisfied, deps);
            }
        }

        public List<Extension> getSortedExtensions() {
            return this._dependencyTree.getSortedExtensions();
        }
    }

    private class ExtensionSet {
        private Set _disabledExtensions;
        private Set _enabledExtensions;

        private ExtensionSet() {
        }

        public boolean isExtensionEnabled(String id, javax.ide.util.Version version) {
            if (this._disabledExtensions != null) {
                return !this._disabledExtensions.contains(id);
            }
            if (this._enabledExtensions != null) {
                return this._enabledExtensions.contains(id);
            }
            return true;
        }

        public void load() throws Exception {
            String enabled = System.getProperty("ide.extensions");
            String disabled = System.getProperty("ide.noextensions");
            if (enabled != null && disabled != null) {
                throw new Exception("Must set only one of ide.noextensions or ide.extensions");
            }
            if (enabled != null) {
                this._enabledExtensions = ExtensionManagerImpl.stringToSet(enabled.trim());
            } else if (disabled != null) {
                this._disabledExtensions = ExtensionManagerImpl.stringToSet(disabled.trim());
            } else {
                ExtensionPreferences prefs = ExtensionPreferences.getInstance();
                this._disabledExtensions = new HashSet<String>(prefs.getDisabledIds());
            }
        }
    }

    private final class NullExtensionSet
    extends ExtensionSet {
        @Override
        public boolean isExtensionEnabled(String id, javax.ide.util.Version version) {
            return true;
        }
    }

    private class JustHooksExtensionVisitor
    extends BaseExtensionVisitor {
        private final IDEExtension _extension;
        private final ElementVisitor _hooksVisitor;

        public JustHooksExtensionVisitor(IDEExtension extension) {
            this._extension = extension;
            this._hooksVisitor = this.createHooksVisitor();
            this.setHookVisitorFactory((ElementVisitorFactory)ExtensionManagerImpl.this._hookVisitor);
        }

        public void start(ElementStartContext context) {
            context.getScopeData().putAll(this._extension.getHooksParsingContext());
            context.getScopeData().put("classLoader", ExtensionManagerImpl.this.getClassLoader(this._extension.getID()));
            context.registerChildVisitor(HOOKS, this._hooksVisitor);
        }

        protected void addToClasspath(ElementContext context, Extension ext, URI entry) {
        }
    }

    private class AfterExtensionLoadingRunnable
    implements Runnable {
        private final Runnable _runnable;
        private final boolean _invokeOnEDT;

        public AfterExtensionLoadingRunnable(Runnable runnable, boolean invokeOnEDT) {
            this._runnable = runnable;
            this._invokeOnEDT = invokeOnEDT;
        }

        @Override
        public void run() {
            if (this._invokeOnEDT) {
                if (SwingUtilities.isEventDispatchThread() && !ExtensionManagerImpl.this._inDeferredExtensionLoadingLockSection) {
                    this._runnable.run();
                } else {
                    SwingUtilities.invokeLater(this);
                }
            } else {
                this._runnable.run();
            }
        }
    }

    protected static enum HooksProcessingMode {
        EAGER,
        LAZY,
        LAZY_IF_HAS_TRIGGERS;

    }
}

