/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.LoaderType;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.LocationAdapter;
import javax.ide.extension.spi.MacroExpander;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.MetaResourceString;
import javax.ide.util.Version;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import oracle.ide.Ide;
import oracle.ide.extension.Role;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import oracle.ideimpl.extension.IDEElementContext;
import oracle.ideimpl.extension.IDEExtension;
import oracle.ideimpl.extension.LayerCache;
import oracle.ideimpl.extension.LayerRegistrationHook;
import oracle.ideimpl.extension.LayerRegistrations;
import oracle.ideimpl.extension.RoleExtensionSource;
import oracle.ideimpl.extension.RoleManagerImpl;
import oracle.ideimpl.extension.feature.FeatureCategoryVisitor;
import oracle.ideimpl.extension.feature.FeatureImpl;
import oracle.ideimpl.extension.feature.FeatureVisitor;
import org.openide.filesystems.FileObject;

class LayerReader {
    private static FileObject jdevRoot;
    private static final Comparator<FileObject> FOC;
    private static final String UNDEFINED = "";

    LayerReader() {
    }

    static synchronized FileObject getJDevRoot() {
        if (jdevRoot == null) {
            jdevRoot = ExtensionManagerImpl.getLayerCache().getRoot().getFileObject("JDev");
        }
        return jdevRoot;
    }

    static List<FileObject> getOrderedChildren(FileObject fo) {
        return LayerReader.getOrder(fo.getChildren());
    }

    static List<FileObject> getOrder(FileObject[] fos) {
        Arrays.sort(fos, FOC);
        return Arrays.asList(fos);
    }

    static String getXmlAttribute(FileObject fo, String attrName) {
        return (String)fo.getAttribute("A." + attrName);
    }

    public static List<IDEExtension> readExtensions(ExtensionManagerImpl em) {
        LayerCache.TIMERS.reset();
        long s = LayerCache.TIMERS.nanoTime();
        RoleManagerImpl rm = (RoleManagerImpl)em.getRoleManager();
        String roleId = Ide.getIdeArgs().getRole();
        boolean noRoles = roleId == null && (Boolean.getBoolean("ide.extension.noroles") || !Ide.getIdeArgs().getCreateUI());
        LinkedList<IDEExtension> exts = new LinkedList<IDEExtension>();
        for (FileObject fo : LayerReader.getOrderedChildren(LayerReader.getJDevRoot())) {
            String rawOwner;
            String rawName;
            FileObject extfo = fo.getFileObject("extension", null);
            LayerExtension le = LayerRegistrations.createAnnotation(extfo, LayerExtension.class);
            IDEExtension ie = new IDEExtension(le.id());
            ie.setRole(le.isRole());
            ie.setClassLoader(em.getClassLoader(le.id()));
            ie.setVersion(new Version(le.version()));
            ie.setEDKVersion(new Version(le.esdkVersion()));
            if (le.isRole()) {
                Role fr = null;
                if (noRoles) continue;
                for (Role r : rm.getRoles()) {
                    String rexName = "_role." + r.getId();
                    if (!rexName.equals(le.id())) continue;
                    fr = r;
                    break;
                }
                if (fr == null) continue;
                ie.setSource(new RoleExtensionSource(rm.getRoleFile(fr)));
            } else {
                ie.setSource(em.getExtensionSourceById(le.sourceId()));
            }
            ie.setRsBundleClass(le.rsBundleClass());
            ie.setHasHooksSection(fo.getFileObject("hooks") != null || fo.getFileObject("jdev-hooks") != null || fo.getFileObject("hook-handlers/hooks") != null || fo.getFileObject("hook-handlers/jdev-hooks") != null);
            String string = rawName = le.labelRsKey().isEmpty() ? le.label() : le.labelRsKey();
            if (MacroExpander.containsMacro((String)rawName)) {
                ie.setName(new MetaResourceString(LayerReader.getResourceBundle(ie), MacroExpander.stripOffBrackets((String)rawName)));
            } else {
                ie.setName(rawName);
            }
            String string2 = rawOwner = le.ownerRsKey().isEmpty() ? le.owner() : le.ownerRsKey();
            if (MacroExpander.containsMacro((String)rawOwner)) {
                ie.setOwner(new MetaResourceString(LayerReader.getResourceBundle(ie), MacroExpander.stripOffBrackets((String)rawOwner)));
            } else {
                ie.setOwner(rawOwner);
            }
            if (!ie.isRole()) {
                for (ExtensionDependency ed : em.findExtensionDependencies(le.id())) {
                    ie.addDependency(ed);
                }
            }
            FileObject ffo = fo.getFileObject("features", null);
            IDEElementContext ctx = em.createInitialContext();
            ctx.getScopeData().put("extension", ie);
            ctx.getScopeData().put("extSource", ie.getSource());
            ctx.getScopeData().put("classLoader", ie.getClassLoader());
            ctx.getScopeData().put("rsbundleclass", ie.getRsBundleClass());
            ctx.getScopeData().put("xml.locator", new FakeLocator(null, ie.getSource().getManifestURI().toString()));
            if (ffo != null) {
                ctx.registerChildVisitor(FeatureVisitor.FEATURE_ELEMENT, new FeatureVisitor());
                ctx.registerChildVisitor(FeatureCategoryVisitor.FEATURE_CATEGORY_ELEMENT, new FeatureCategoryVisitor());
                LayerReader.scanChildren(ffo, ctx);
            }
            if (!le.featureMember().isEmpty()) {
                FeatureImpl.addMemberRef((ElementContext)ctx, le.featureMember(), ie.getID());
            }
            exts.add(ie);
        }
        LayerCache.TIMERS.addCurrentNanos("Extension read", s);
        LayerCache.TIMERS.print();
        return exts;
    }

    private static ResourceBundle getResourceBundle(IDEExtension ie) {
        String resClass = ie.getRsBundleClass();
        if (resClass == null) {
            return null;
        }
        try {
            return ElementVisitor.getResourceBundleProvider().getResourceBundle(resClass, Locale.getDefault(), ie.getClassLoader());
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    static void extToContext(IDEElementContext ctx, IDEExtension ext) {
        Map scopeData = ctx.getScopeData();
        scopeData.put("extension", ext);
        scopeData.put("extSource", ext.getSource());
        scopeData.put("classLoader", ext.getClassLoader());
        scopeData.put("rsbundleclass", ext.getRsBundleClass());
        scopeData.put("xml.locator", new FakeLocator(null, ext.getSource().getManifestURI().toString()));
    }

    static void setFileObjectToCtx(FileObject fo, IDEElementContext ctx) {
        Object locator = ctx.getScopeData().get("xml.locator");
        if (locator != null && locator instanceof FakeLocator) {
            ((FakeLocator)locator).setFileObject(fo);
        }
    }

    public static void scan(FileObject fo, IDEElementContext ctx) {
        FakeLocator locator = (FakeLocator)ctx.getScopeData().get("xml.locator");
        LayerReader.scan(fo, -1, ctx, null, locator);
    }

    public static void scanChildren(FileObject fo, IDEElementContext ctx) {
        FakeLocator locator = (FakeLocator)ctx.getScopeData().get("xml.locator");
        for (FileObject c : LayerReader.getOrderedChildren(fo)) {
            LayerReader.scan(c, -1, ctx, null, locator);
        }
    }

    private static void scan(FileObject fo, int depth, IDEElementContext ctx, String lastURI, FakeLocator locator) {
        String tURI = (String)fo.getAttribute("#U");
        String string = lastURI = tURI == null ? lastURI : tURI;
        if (lastURI == null) {
            System.out.println(" ! ERROR - unknown namespace " + fo.getPath());
        }
        locator.setFileObject(fo);
        ElementName el = new ElementName(lastURI, (String)fo.getAttribute("#T"));
        LayerReader.callElementStart(fo, ctx, el);
        if (depth != 0) {
            for (FileObject c : LayerReader.getOrderedChildren(fo)) {
                LayerReader.scan(c, depth - 1, ctx, lastURI, locator);
            }
        }
        LayerReader.callElementEnd(fo, ctx, el);
    }

    private static void callElementStart(FileObject fo, IDEElementContext ctx, ElementName el) {
        long s = LayerCache.TIMERS.nanoTime();
        ElementVisitor visitor = ctx.getVisitorForStartElement(el);
        ctx.beginElement(el.getNamespaceURI(), el.getLocalName(), new DelegatingAttributes(fo));
        LayerCache.TIMERS.addCurrentNanos("Legacy Hook Context Prepare", s);
        if (visitor != null) {
            s = LayerCache.TIMERS.nanoTime();
            visitor.start((ElementStartContext)ctx);
            LayerCache.TIMERS.addCurrentNanos("Legacy hooks processing", s);
        }
        s = LayerCache.TIMERS.nanoTime();
        ctx.postBeginElement();
        LayerCache.TIMERS.addCurrentNanos("Legacy hooks post processing", s);
    }

    private static void callElementEnd(FileObject fo, IDEElementContext ctx, ElementName el) {
        long s = LayerCache.TIMERS.nanoTime();
        String text = (String)fo.getAttribute("#C");
        if (text != null) {
            ctx.appendCharacters(text.toCharArray(), 0, text.length());
        }
        ctx.endElement(el.getNamespaceURI(), el.getLocalName());
        ElementVisitor visitor = ctx.getVisitorForEndElement();
        LayerCache.TIMERS.addCurrentNanos("Legacy Hook Context Prepare", s);
        if (visitor != null) {
            s = LayerCache.TIMERS.nanoTime();
            visitor.end((ElementEndContext)ctx);
            LayerCache.TIMERS.addCurrentNanos("Legacy hooks processing", s);
        }
        s = LayerCache.TIMERS.nanoTime();
        ctx.postEndElement();
        LayerCache.TIMERS.addCurrentNanos("Legacy hooks post processing", s);
    }

    private static LoaderType loaderTypeFromString(String loaderTypeString) {
        if (loaderTypeString == null) {
            return LoaderType.GLOBAL;
        }
        if ((loaderTypeString = loaderTypeString.trim()).length() == 0) {
            return LoaderType.GLOBAL;
        }
        try {
            return LoaderType.valueOf((String)loaderTypeString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return LoaderType.GLOBAL;
        }
    }

    static {
        FOC = new Comparator<FileObject>(){

            @Override
            public int compare(FileObject o1, FileObject o2) {
                Integer i1 = (Integer)o1.getAttribute("position");
                Integer i2 = (Integer)o2.getAttribute("position");
                if (i1 == null && i2 == null) {
                    return 0;
                }
                return i1.compareTo(i2);
            }
        };
    }

    static @interface LayerExtension {
        @LayerRegistrationHook.Attr(value="id")
        public String id();

        @LayerRegistrationHook.Attr(value="source-id")
        public String sourceId();

        @LayerRegistrationHook.Attr(value="label")
        public String label() default "";

        @LayerRegistrationHook.Attr(value="label-rs-key")
        public String labelRsKey() default "";

        @LayerRegistrationHook.Attr(value="owner")
        public String owner() default "";

        @LayerRegistrationHook.Attr(value="owner-rs-key")
        public String ownerRsKey() default "";

        @LayerRegistrationHook.Attr(value="rsbundle-class")
        public String rsBundleClass() default "";

        @LayerRegistrationHook.Attr(value="esdk-version")
        public String esdkVersion() default "";

        @LayerRegistrationHook.Attr(value="version")
        public String version() default "";

        @LayerRegistrationHook.Attr(value="feature-member")
        public String featureMember() default "";

        @LayerRegistrationHook.Attr(value="is-role")
        public boolean isRole() default false;
    }

    static class FakeLocator
    implements LocationAdapter {
        private static final Map<String, String> _systemIdCache = new ConcurrentHashMap<String, String>();
        private FileObject fo;
        private String systemId;

        FakeLocator(FileObject fo, String systemId) {
            this.fo = fo;
            this.systemId = systemId;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            String cachedSystemId = _systemIdCache.get(this.systemId);
            if (cachedSystemId == null) {
                URI uri = null;
                try {
                    uri = new URI(this.systemId);
                }
                catch (URISyntaxException e) {
                    Logger logger = Logger.getLogger(LayerReader.class.getName());
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                cachedSystemId = VirtualFileSystem.getVirtualFileSystem().getPlatformPathName(uri);
                _systemIdCache.put(this.systemId, cachedSystemId);
            }
            return cachedSystemId;
        }

        public int getLineNumber() {
            Integer ln = (Integer)this.fo.getAttribute("location");
            return ln == null ? 0 : ln;
        }

        public int getColumnNumber() {
            return 0;
        }

        public int getCharacterOffset() {
            return 0;
        }

        public LocationAdapter copyMe() {
            return new FakeLocator(this.fo, this.systemId);
        }

        private void setFileObject(FileObject fo) {
            this.fo = fo;
        }

        private void setSystemId(String systemId) {
            this.systemId = systemId;
        }
    }

    private static class DelegatingAttributes
    implements DefaultElementContext.Attributes {
        private FileObject foDelegate;
        private Map<String, Attribute> attrs;

        DelegatingAttributes(FileObject fo) {
            long s = LayerCache.TIMERS.nanoTime();
            this.foDelegate = fo;
            Enumeration attrNames = fo.getAttributes();
            this.attrs = new HashMap<String, Attribute>();
            while (attrNames.hasMoreElements()) {
                String an = (String)attrNames.nextElement();
                if (!an.startsWith("A.")) continue;
                String n = an.substring(2);
                this.attrs.put(n, new AttributeImpl(an, n));
            }
            LayerCache.TIMERS.addCurrentNanos("Init delegating attributes", s);
        }

        public String getValue(String qName) {
            Attribute a = this.attrs.get(qName);
            return a == null ? null : a.getValue();
        }

        public Iterator<Attribute> iterator() {
            return this.attrs.values().iterator();
        }

        private class AttributeImpl
        implements Attribute {
            private final String o_name;
            private final String m_name;
            private final QName m_qname;
            private final String CDATA = "CDATA";

            AttributeImpl(String oname, String name) {
                this.o_name = oname;
                this.m_name = name;
                this.m_qname = new QName(this.m_name);
            }

            @Override
            public QName getName() {
                return this.m_qname;
            }

            @Override
            public String getValue() {
                return (String)DelegatingAttributes.this.foDelegate.getAttribute(this.o_name);
            }

            @Override
            public String getDTDType() {
                return "CDATA";
            }

            @Override
            public boolean isSpecified() {
                return true;
            }

            @Override
            public int getEventType() {
                return 10;
            }

            @Override
            public Location getLocation() {
                return null;
            }

            @Override
            public boolean isStartElement() {
                return false;
            }

            @Override
            public boolean isAttribute() {
                return true;
            }

            @Override
            public boolean isNamespace() {
                return false;
            }

            @Override
            public boolean isEndElement() {
                return false;
            }

            @Override
            public boolean isEntityReference() {
                return false;
            }

            @Override
            public boolean isProcessingInstruction() {
                return false;
            }

            @Override
            public boolean isCharacters() {
                return false;
            }

            @Override
            public boolean isStartDocument() {
                return false;
            }

            @Override
            public boolean isEndDocument() {
                return false;
            }

            @Override
            public StartElement asStartElement() {
                return null;
            }

            @Override
            public EndElement asEndElement() {
                return null;
            }

            @Override
            public Characters asCharacters() {
                return null;
            }

            @Override
            public QName getSchemaType() {
                return null;
            }

            @Override
            public void writeAsEncodedUnicode(Writer writer) {
            }
        }
    }
}

