/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.util.HashSet;
import java.util.Set;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.spi.ExtensionSource;
import oracle.ideimpl.extension.IDEHookHandlerHook;
import oracle.ideimpl.extension.LayerBuilder;
import oracle.ideimpl.extension.LayerVisitor;
import oracle.ideimpl.extension.RoleExtensionSource;
import oracle.ideimpl.extension.TriggerHooksVisitor;
import oracle.ideimpl.extension.feature.FeatureCategoryVisitor;
import oracle.ideimpl.extension.feature.FeatureVisitor;

class LayerVisitorExtensions
extends LayerVisitor {
    static final String PATH_JDEV = "JDev/";
    static final String PATH = "/extension";
    static final String PATH_DEFAULT = "/all";
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "extension");
    private static final String FID = "extension";
    public static final String ATTR_ID = "id";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_LABEL_RS_KEY = "label-rs-key";
    public static final String ATTR_OWNER = "owner";
    public static final String ATTR_OWNER_RS_KEY = "owner-rs-key";
    public static final String ATTR_RSBUNDLE_CLASS = "rsbundle-class";
    public static final String ATTR_ESDK_VERSION = "esdk-version";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_LOADER = "loader";
    public static final String ATTR_SOURCE_ID = "source-id";
    public static final String ATTR_FEATURE_MEMBER = "feature-member";
    public static final String ATTR_IS_ROLE = "is-role";
    public static final String SD_EXTENSION_ID = "SD_EXTENSION_ID";
    public static final String SD_EXTENSION_PATH = "SD_EXTENSTION_PATH";
    private ExtensionSource source;
    private int position;
    private String extId;
    private static Set<String> handler_names = new HashSet<String>();

    public LayerVisitorExtensions(ExtensionSource source, int position) {
        super(new ElementName("http://jcp.org/jsr/198/extension-manifest", FID), new Dependencies(), new Name(), new Owner(), new FeatureMember(), new TriggerHooks(), new RequiredBundles(), new Classpaths(), new Hooks(), new Feature(), new FeatureCategory());
        this.source = source;
        this.position = position;
        handler_names.clear();
    }

    @Override
    public void elementStart(ElementStartContext ctx) {
        this.extId = ctx.getAttributeValue(ATTR_ID);
        ctx.registerVisitorFactory((ElementVisitorFactory)new LayerVisitor.GenericElementVisitorFactory(PATH_JDEV + this.extId + PATH_DEFAULT));
        this.getBuilder((ElementContext)ctx).folder(PATH_JDEV + this.extId).intvalue("position", this.position).write();
        this.createFolder(FID, (ElementContext)ctx, PATH_JDEV + this.extId + PATH);
        this.addAttributes(FID, (ElementContext)ctx, new LayerVisitor.Attr(ATTR_SOURCE_ID, this.source.getName()));
        if (this.source instanceof RoleExtensionSource) {
            this.addAttributes(FID, (ElementContext)ctx, new LayerVisitor.Attr(ATTR_IS_ROLE, "true"));
        }
        this.addAttributes(FID, ctx, ATTR_ID, ATTR_RSBUNDLE_CLASS, ATTR_ESDK_VERSION, ATTR_VERSION, ATTR_LOADER);
        ctx.getScopeData().put(SD_EXTENSION_ID, this.extId);
    }

    @Override
    public void elementEnd(ElementEndContext ctx) {
        this.attributeFile(FID, (ElementContext)ctx, true);
    }

    public String getExtensionId() {
        return this.extId;
    }

    static class FeatureCategory
    extends LayerVisitor {
        static final String PATH = "/features/";
        public static final ElementName ELEMENT = FeatureCategoryVisitor.FEATURE_CATEGORY_ELEMENT;

        FeatureCategory() {
            super(ELEMENT, new LayerVisitor[0]);
        }

        @Override
        public void elementStart(ElementStartContext ctx) {
            String extId = (String)ctx.getScopeData().get(LayerVisitorExtensions.SD_EXTENSION_ID);
            LayerBuilder.File fldr = this.getBuilder((ElementContext)ctx).folder(LayerVisitorExtensions.PATH_JDEV + extId + PATH + "feature-category");
            fldr.stringvalue("#T", ctx.getElementName().getLocalName());
            fldr.stringvalue("#U", ctx.getElementName().getNamespaceURI());
            fldr.intvalue("location", this.getLocationAdapter((ElementContext)ctx).getLineNumber());
            fldr.stringvalue("A.xmlns", ctx.getElementName().getNamespaceURI());
            fldr.stringvalue("A.id", ctx.getAttributeValue(LayerVisitorExtensions.ATTR_ID));
            fldr.write();
            ctx.registerVisitorFactory((ElementVisitorFactory)new HookElementVisitorFactory(LayerVisitorExtensions.PATH_JDEV + extId + PATH + "feature-category", false));
        }
    }

    static class Feature
    extends LayerVisitor {
        static final String PATH = "/features/";
        public static final ElementName ELEMENT = FeatureVisitor.FEATURE_ELEMENT;

        Feature() {
            super(ELEMENT, new LayerVisitor[0]);
        }

        @Override
        public void elementStart(ElementStartContext ctx) {
            String extId = (String)ctx.getScopeData().get(LayerVisitorExtensions.SD_EXTENSION_ID);
            LayerBuilder.File fldr = this.getBuilder((ElementContext)ctx).folder(LayerVisitorExtensions.PATH_JDEV + extId + PATH + "feature");
            fldr.stringvalue("#T", ctx.getElementName().getLocalName());
            fldr.stringvalue("#U", ctx.getElementName().getNamespaceURI());
            fldr.intvalue("location", this.getLocationAdapter((ElementContext)ctx).getLineNumber());
            fldr.stringvalue("A.xmlns", ctx.getElementName().getNamespaceURI());
            fldr.stringvalue("A.id", ctx.getAttributeValue(LayerVisitorExtensions.ATTR_ID));
            fldr.write();
            ctx.registerVisitorFactory((ElementVisitorFactory)new HookElementVisitorFactory(LayerVisitorExtensions.PATH_JDEV + extId + PATH + "feature", false));
        }
    }

    static class JDeveloperHook
    extends LayerVisitor {
        static final String PATH = "/jdev-hooks/";

        JDeveloperHook() {
            super(IDEHookHandlerHook.ELEMENT, new HookHandler(false, true));
        }

        @Override
        public void elementStart(ElementStartContext ctx) {
            ctx.registerVisitorFactory((ElementVisitorFactory)new HookElementVisitorFactory(LayerVisitorExtensions.PATH_JDEV + (String)ctx.getScopeData().get(LayerVisitorExtensions.SD_EXTENSION_ID) + PATH));
        }
    }

    static class Rules
    extends LayerVisitor {
        static final String PATH = "/rules";
        public static final ElementName ELEMENT = TriggerHooksVisitor.RULES_ELEMENT;

        Rules() {
            super(ELEMENT, new LayerVisitor[0]);
        }

        @Override
        public void elementStart(ElementStartContext ctx) {
            ctx.registerVisitorFactory((ElementVisitorFactory)new HookElementVisitorFactory(LayerVisitorExtensions.PATH_JDEV + (String)ctx.getScopeData().get(LayerVisitorExtensions.SD_EXTENSION_ID) + PATH, false));
        }
    }

    static class Triggers
    extends LayerVisitor {
        static final String PATH = "/triggers/";
        public static final ElementName ELEMENT = TriggerHooksVisitor.TRIGGERS_ELEMENT;
        private int position = 0;

        Triggers() {
            super(ELEMENT, new LayerVisitor[0]);
        }

        @Override
        public void elementStart(ElementStartContext ctx) {
            ctx.registerVisitorFactory((ElementVisitorFactory)new HookElementVisitorFactory(LayerVisitorExtensions.PATH_JDEV + (String)ctx.getScopeData().get(LayerVisitorExtensions.SD_EXTENSION_ID) + PATH));
        }
    }

    static class Registry
    extends LayerVisitor {
        public static final ElementName ELEMENT = TriggerHooksVisitor.REGISTRY_ELEMENT;

        Registry() {
            super(ELEMENT, new HookHandler(true, false));
        }
    }

    static class TriggerHooks
    extends LayerVisitor {
        public static final ElementName ELEMENT = TriggerHooksVisitor.ELEMENT;

        TriggerHooks() {
            super(ELEMENT, new Registry(), new Triggers(), new Rules());
        }
    }

    static class HookElementVisitor
    extends LayerVisitor.GenericElementVisitor {
        private boolean elName;
        private String pathPrefix;
        private int position = 0;

        HookElementVisitor(String pathPrefix, boolean elName) {
            super(pathPrefix);
            this.pathPrefix = pathPrefix;
            this.elName = elName;
        }

        @Override
        protected void initFolder(ElementStartContext ctx) {
            if (this.elName) {
                LayerBuilder.File fldr = this.getBuilder((ElementContext)ctx).folder(this.pathPrefix + ctx.getElementName().getLocalName());
                fldr.stringvalue("#U", ctx.getElementName().getNamespaceURI());
                fldr.intvalue("position", this.position++);
                fldr.write();
            }
        }

        @Override
        protected String getPath(ElementContext ctx) {
            if (this.dPath.size() == 1) {
                this.path = this.elName ? this.pathPrefix + ctx.getElementName().getLocalName() : this.pathPrefix;
            }
            return super.getPath(ctx);
        }
    }

    static class HookElementVisitorFactory
    implements ElementVisitorFactory {
        HookElementVisitor gev;

        HookElementVisitorFactory(String path) {
            this.gev = new HookElementVisitor(path, true);
        }

        HookElementVisitorFactory(String path, boolean elName) {
            this.gev = new HookElementVisitor(path, elName);
        }

        public ElementVisitor getVisitor(ElementName name) {
            return this.gev;
        }
    }

    static class TriggerHookParameter
    extends LayerVisitor {
        private static final String HPID = "hook-handler-parameter";
        private static final String PATH = "parameter";
        public static final String ATTR_NAME = "name";
        public static final String ATTR_VALUE = "value";

        TriggerHookParameter() {
            super(TriggerHooksVisitor.PARAM_ELEMENT, new LayerVisitor[0]);
        }

        @Override
        public void elementStart(ElementStartContext ctx) {
            int[] count = (int[])ctx.getScopeData().get("hook-handler-parameter-count");
            String path = (String)ctx.getScopeData().get("handler-path");
            this.createFolder(HPID, (ElementContext)ctx, path + "/param." + count[0]);
            count[0] = count[0] + 1;
            this.addAttributes(HPID, ctx, ATTR_NAME, ATTR_VALUE);
            this.attributeFile(HPID, (ElementContext)ctx, true);
        }
    }

    static class TriggerHookParameters
    extends LayerVisitor {
        private static final String PARAM_COUNT_SD = "hook-handler-parameter-count";
        int[] count = new int[]{0};

        TriggerHookParameters() {
            super(TriggerHooksVisitor.PARAMETERS_ELEMENT, new TriggerHookParameter());
        }

        @Override
        public void elementStart(ElementStartContext ctx) {
            ctx.getScopeData().put(PARAM_COUNT_SD, this.count);
        }
    }

    static class HookHandler
    extends LayerVisitor {
        static final String PATH = "/hook-handlers/";
        private static final String HHID = "hook-handler";
        private static final String HANDLER_PATH_SD = "handler-path";
        public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "hook-handler");
        public static final ElementName TRIGGER_ELEMENT = TriggerHooksVisitor.TRIGGER_HOOK_HANDLER_ELEMENT;
        public static final ElementName JDEV_ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "hook-handler");
        public static final String ATTR_PROVIDER = "provider";
        public static final String ATTR_TAG_NAME = "tag-name";
        public static final String ATTR_HANDLER_CLASS = "handler-class";
        public static final String ATTR_NAMESPACE = "namespace";
        public static final String ATTR_SCHEMA_LOCATION = "schema-location";
        public static final String ATTR_REGISTER_AS_HOOK = "register-as-hook";
        public static final String ATTR_REGISTER_AS_JDEVELOPER_HOOK = "register-as-jdeveloper-hook";
        public static final String ATTR_IS_TRIGGER = "isTrigger";
        public static final String ATTR_IS_JDEVELOPER = "isJdeveloper";
        private static int position = 1;
        private boolean isTrigger;
        private boolean isJdeveloper;

        HookHandler(boolean isTrigger, boolean isJdeveloper) {
            super(isTrigger ? TRIGGER_ELEMENT : (isJdeveloper ? JDEV_ELEMENT : ELEMENT), new TriggerHookParameters());
            this.isTrigger = isTrigger;
            this.isJdeveloper = isJdeveloper;
        }

        @Override
        public void elementStart(ElementStartContext ctx) {
            String extId = (String)ctx.getScopeData().get(LayerVisitorExtensions.SD_EXTENSION_ID);
            String tagName = ctx.getAttributeValue(ATTR_TAG_NAME);
            String path = LayerVisitorExtensions.PATH_JDEV + extId + PATH;
            path = this.isTrigger ? path + "triggers/" : (this.isJdeveloper ? path + "jdev-hooks/" : path + "hooks/");
            path = path + tagName;
            if (!handler_names.add(tagName)) {
                System.out.println("ERROR " + path + " " + extId);
            }
            this.createFolder(HHID, (ElementContext)ctx, path);
            ctx.getScopeData().put(HANDLER_PATH_SD, path);
            this.addAttributes(HHID, (ElementContext)ctx, new LayerVisitor.Attr("position", position++), new LayerVisitor.Attr(ATTR_PROVIDER, extId));
            this.addAttributes(HHID, ctx, ATTR_TAG_NAME, ATTR_HANDLER_CLASS, ATTR_NAMESPACE, ATTR_SCHEMA_LOCATION);
            if (this.isTrigger) {
                this.addAttributes(HHID, ctx, ATTR_REGISTER_AS_HOOK, ATTR_REGISTER_AS_JDEVELOPER_HOOK);
            }
        }

        @Override
        public void elementEnd(ElementEndContext ctx) {
            this.attributeFile(HHID, (ElementContext)ctx, true);
        }
    }

    static class HookHandlerHook
    extends LayerVisitor {
        public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "hook-handler-hook");

        HookHandlerHook() {
            super(ELEMENT, new HookHandler(false, false));
        }
    }

    static class Hooks
    extends LayerVisitor {
        static final String PATH = "/hooks/";
        public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "hooks");

        Hooks() {
            super(ELEMENT, new HookHandlerHook(), new JDeveloperHook());
        }

        @Override
        public void elementStart(ElementStartContext ctx) {
            ctx.registerVisitorFactory((ElementVisitorFactory)new HookElementVisitorFactory(LayerVisitorExtensions.PATH_JDEV + (String)ctx.getScopeData().get(LayerVisitorExtensions.SD_EXTENSION_ID) + PATH));
        }
    }

    static class Classpaths
    extends LayerVisitor {
        public static final String TAG = "classpaths";
        public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "classpaths");

        Classpaths() {
            super(ELEMENT, new LayerVisitor[0]);
        }

        @Override
        public void elementStart(ElementStartContext ctx) {
            String extId = (String)ctx.getScopeData().get(LayerVisitorExtensions.SD_EXTENSION_ID);
            LayerBuilder.File fldr = this.getBuilder((ElementContext)ctx).folder(LayerVisitorExtensions.PATH_JDEV + extId + LayerVisitorExtensions.PATH + "/" + TAG);
            fldr.intvalue("location", this.getLocationAdapter((ElementContext)ctx).getLineNumber());
            fldr.write();
        }
    }

    static class RequiredBundle
    extends LayerVisitor {
        public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "bundle");

        RequiredBundle() {
            super(ELEMENT, new LayerVisitor[0]);
        }
    }

    static class RequiredBundles
    extends LayerVisitor {
        public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "required-bundles");

        RequiredBundles() {
            super(ELEMENT, new RequiredBundle());
        }
    }

    static class Import
    extends LayerVisitor {
        public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "import");

        Import() {
            super(ELEMENT, new LayerVisitor[0]);
        }
    }

    static class Dependencies
    extends LayerVisitor {
        static final String TAG = "dependencies";
        public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "dependencies");

        Dependencies() {
            super(ELEMENT, new Import());
        }

        @Override
        public void elementStart(ElementStartContext ctx) {
            String extId = (String)ctx.getScopeData().get(LayerVisitorExtensions.SD_EXTENSION_ID);
            LayerBuilder.File fldr = this.getBuilder((ElementContext)ctx).folder(LayerVisitorExtensions.PATH_JDEV + extId + LayerVisitorExtensions.PATH + "/" + TAG);
            fldr.intvalue("location", this.getLocationAdapter((ElementContext)ctx).getLineNumber());
            fldr.write();
        }
    }

    static class FeatureMember
    extends LayerVisitor {
        private static final String ATTR_ID = "id";
        public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "feature-member");

        FeatureMember() {
            super(ELEMENT, new LayerVisitor[0]);
        }

        @Override
        public void elementStart(ElementStartContext ctx) {
            this.addAttributes(LayerVisitorExtensions.FID, (ElementContext)ctx, new LayerVisitor.Attr(LayerVisitorExtensions.ATTR_FEATURE_MEMBER, ctx.getAttributeValue("id")));
        }
    }

    static class Owner
    extends LayerVisitor {
        public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "owner");

        Owner() {
            super(ELEMENT, new LayerVisitor[0]);
        }

        @Override
        public void elementStart(ElementStartContext ctx) {
            String rsKey = ctx.getAttributeValue("rskey");
            if (rsKey != null && !rsKey.trim().isEmpty()) {
                this.addAttributes(LayerVisitorExtensions.FID, (ElementContext)ctx, new LayerVisitor.Attr(LayerVisitorExtensions.ATTR_OWNER_RS_KEY, "${" + rsKey + "}"));
            }
        }

        @Override
        public void elementEnd(ElementEndContext ctx) {
            String text = ctx.getText();
            if (text != null && !text.trim().isEmpty()) {
                this.addAttributes(LayerVisitorExtensions.FID, (ElementContext)ctx, new LayerVisitor.Attr(LayerVisitorExtensions.ATTR_OWNER, text));
            }
        }
    }

    static class Name
    extends LayerVisitor {
        public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "name");

        Name() {
            super(ELEMENT, new LayerVisitor[0]);
        }

        @Override
        public void elementStart(ElementStartContext ctx) {
            String rsKey = ctx.getAttributeValue("rskey");
            if (rsKey != null && !rsKey.trim().isEmpty()) {
                this.addAttributes(LayerVisitorExtensions.FID, (ElementContext)ctx, new LayerVisitor.Attr(LayerVisitorExtensions.ATTR_LABEL_RS_KEY, "${" + rsKey + "}"));
            }
        }

        @Override
        public void elementEnd(ElementEndContext ctx) {
            String text = ctx.getText();
            if (text != null && !text.trim().isEmpty()) {
                this.addAttributes(LayerVisitorExtensions.FID, (ElementContext)ctx, new LayerVisitor.Attr(LayerVisitorExtensions.ATTR_LABEL, text));
            }
        }
    }
}

