/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.spi.MacroExpander;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.extension.Role;
import oracle.ide.extension.RoleManager;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ideimpl.extension.RolePreferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.xml.esax.ElementEndContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.ElementStartContext;
import oracle.javatools.xml.esax.HandlerException;
import oracle.javatools.xml.esax.XMLLocator;
import oracle.javatools.xml.esax.spi.ExtensibleSAXParser;
import org.xml.sax.InputSource;

final class RoleManagerImpl
extends RoleManager {
    private final List<RoleDefinition> _roles = new ArrayList<RoleDefinition>();
    private boolean _rolesLoaded = false;
    private static final String XMLNS = "http://xmlns.oracle.com/ide/roles";
    private RolePreferences _rolePreferences;
    private Role _activeRole = RoleManager.NO_ROLE;

    RoleManagerImpl() {
    }

    void setActiveRole(Role role) {
        this._activeRole = role;
        if (this._rolePreferences != null) {
            this._rolePreferences.setSelectedRoleId(role.getId());
        }
        System.setProperty("ide.role", role.getId());
        PerformanceLogger.get().logConfigurationProperty("Role", role.getId());
    }

    private URL getRolePreferencesURL() {
        File rolePrefsFile = new File(Ide.getSystemDirectory() + "/_oracle.ide.rolemgr." + Version.VER_FULL + "/", "roleprefs.xml");
        return URLFactory.newURL((String)rolePrefsFile.getPath());
    }

    RolePreferences getRolePreferences() {
        if (this._rolePreferences == null) {
            URL rolePrefs = this.getRolePreferencesURL();
            if (URLFileSystem.exists((URL)rolePrefs)) {
                try {
                    HashStructure hs = (HashStructure)new HashStructureIO(XMLNS, "role-preferences").load(rolePrefs);
                    this._rolePreferences = RolePreferences.getInstance(hs);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            } else {
                this._rolePreferences = RolePreferences.getInstance();
            }
        }
        return this._rolePreferences;
    }

    void saveRolePreferences() {
        try {
            new HashStructureIO(XMLNS, "role-preferences").save(this.getRolePreferencesURL(), (Object)this._rolePreferences.getHash());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void loadRoles(Collection<File> rolesPath) {
        if (rolesPath == null) {
            throw new NullPointerException("rolesDirectory is null");
        }
        if (this._rolesLoaded) {
            throw new IllegalStateException("Roles already loaded");
        }
        this._rolesLoaded = true;
        for (File rolesDirectory : rolesPath) {
            File[] files;
            for (File file : files = rolesDirectory.listFiles()) {
                if (!file.getName().toLowerCase().endsWith(".xml")) continue;
                try {
                    RoleDefinition def = RoleManagerImpl.loadRole(file);
                    this._roles.add(def);
                }
                catch (IOException ioe) {
                    Logger LOG = Logger.getLogger(RoleManagerImpl.class.getName());
                    LOG.log(Level.SEVERE, "Failed to load role file " + file);
                }
            }
        }
    }

    List<Role> getRoles() {
        if (!this._rolesLoaded) {
            throw new IllegalStateException("Must load roles first.");
        }
        ArrayList<Role> roles = new ArrayList<Role>(this._roles.size());
        for (RoleDefinition rd : this._roles) {
            roles.add(rd.getRole());
        }
        return Collections.unmodifiableList(roles);
    }

    List<String> getDisabledExtensions(Role role) {
        if (role == null) {
            throw new NullPointerException("role is null");
        }
        for (RoleDefinition rd : this._roles) {
            if (rd.getRole() != role) continue;
            return rd.getDisabledExtensions();
        }
        throw new IllegalArgumentException("Unknown role; " + role);
    }

    List<String> getRoleStartupFeatures(Role role) {
        if (role == null) {
            throw new NullPointerException("role is null");
        }
        for (RoleDefinition rd : this._roles) {
            if (rd.getRole() != role) continue;
            return rd.getRoleStartupFeatures();
        }
        throw new IllegalArgumentException("Unknown role; " + role);
    }

    File getRoleFile(Role role) {
        for (RoleDefinition rd : this._roles) {
            if (rd.getRole() != role) continue;
            return rd.getFile();
        }
        return null;
    }

    @Override
    public Role getActiveRole() {
        return this._activeRole;
    }

    static RoleDefinition loadRole(final File roleFile) throws IOException {
        try {
            ExtensibleSAXParser parser = new ExtensibleSAXParser();
            RoleVisitor rv = new RoleVisitor(roleFile);
            parser.getContext().registerChildHandler(XMLNS, "role", (ElementHandler)rv);
            parser.parse(new XMLLocator(null){

                public InputSource createInputSource() throws IOException {
                    return new InputSource(new FileInputStream(roleFile));
                }
            });
            if (rv.getRole() == null) {
                throw new IOException(roleFile + ": role does not specify an id");
            }
            if (!"1.0".equals(rv.getVersion())) {
                throw new IOException(roleFile + ": role version '" + rv.getVersion() + "' not recognized.");
            }
            return new RoleDefinition(rv.getRole(), roleFile, rv.getExtensions(), rv.getRoleStartupFeatures());
        }
        catch (Exception e) {
            IOException ioe = new IOException("Failed to parse role " + roleFile);
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public boolean canSwitchRoles() {
        return !this.getRoles().isEmpty();
    }

    static final class RoleDefinition {
        private final Role _role;
        private final File _roleFile;
        private final List<String> _disabledExtensions;
        private final List<String> _roleStartupFeatures;

        private RoleDefinition(Role role, File file, List<String> disabledExtensions, List<String> roleStartupFeatures) {
            this._role = role;
            this._roleFile = file;
            this._disabledExtensions = disabledExtensions;
            this._roleStartupFeatures = roleStartupFeatures;
        }

        public Role getRole() {
            return this._role;
        }

        public File getFile() {
            return this._roleFile;
        }

        public List<String> getDisabledExtensions() {
            return this._disabledExtensions;
        }

        public List<String> getRoleStartupFeatures() {
            return this._roleStartupFeatures;
        }
    }

    private static final class RoleVisitor
    extends ElementHandler {
        private String _id;
        private String _name;
        private String _description;
        private String _version;
        private final List<String> _extensions = new ArrayList<String>();
        private final List<String> _roleStartupFeatures = new ArrayList<String>();
        private Role _role = null;
        private String _rsBundleClass;
        private File _source;

        private RoleVisitor(File source) {
            this._source = source;
        }

        private InputStream getPropertiesFileInputStream() throws FileNotFoundException {
            File f = new File(this._source.getParent() + File.separator + "res", this._rsBundleClass + ".properties");
            return new FileInputStream(f);
        }

        private ClassLoader getRoleClassLoader() {
            ArrayList<URL> urls = new ArrayList<URL>(1);
            urls.add(URLFactory.newDirURL((String)(this._source.getParent() + File.separator + "res")));
            URLClassLoader classloader = new URLClassLoader(urls.toArray(new URL[urls.size()]), String.class.getClassLoader());
            return classloader;
        }

        private ResourceBundle getResourceBundle() {
            try {
                return ResourceBundle.getBundle(this._rsBundleClass, Locale.getDefault(), this.getRoleClassLoader());
            }
            catch (MissingResourceException me) {
                try {
                    return new PropertyResourceBundle(this.getPropertiesFileInputStream());
                }
                catch (IOException e) {
                    return null;
                }
            }
        }

        private String expandMacros(String text) {
            if (text == null) {
                return null;
            }
            return new MacroExpander(){

                protected String getMacroValue(String macroText) {
                    if (RoleVisitor.this._rsBundleClass != null) {
                        ResourceBundle rb = RoleVisitor.this.getResourceBundle();
                        return rb != null ? rb.getString(macroText) : null;
                    }
                    return null;
                }
            }.substituteMacros(text);
        }

        public void handleStart(ElementStartContext context) {
            this._id = context.getAttributeValue("id");
            this._version = context.getAttributeValue("version");
            this._rsBundleClass = context.getAttributeValue("rsbundle-class");
            context.registerChildHandler(RoleManagerImpl.XMLNS, "name", new ElementHandler(){

                public void handleEnd(ElementEndContext context) {
                    RoleVisitor.this._name = RoleVisitor.this.expandMacros(context.getText().trim());
                }
            });
            context.registerChildHandler(RoleManagerImpl.XMLNS, "description", new ElementHandler(){

                public void handleEnd(ElementEndContext context) {
                    RoleVisitor.this._description = RoleVisitor.this.expandMacros(context.getText().trim());
                }
            });
            final ElementHandler extensionHandler = new ElementHandler(){

                public void handleStart(ElementStartContext context) {
                    String extensionId = context.getAttributeValue("refid");
                    if (extensionId != null) {
                        RoleVisitor.this._extensions.add(extensionId);
                    }
                }
            };
            context.registerChildHandler(RoleManagerImpl.XMLNS, "disabled-extensions", new ElementHandler(){

                public void handleStart(ElementStartContext context) {
                    context.registerChildHandler(RoleManagerImpl.XMLNS, "extension", extensionHandler);
                }
            });
            context.registerChildHandler(RoleManagerImpl.XMLNS, "role-startup-features", new ElementHandler(){

                public void handleStart(ElementStartContext context) {
                    context.registerChildHandler(RoleManagerImpl.XMLNS, "role-startup-feature", new ElementHandler(){

                        public void handleStart(ElementStartContext context) throws HandlerException {
                            String featureId = context.getAttributeValue("feature-id");
                            if (featureId != null && (featureId = featureId.trim()).length() > 0) {
                                RoleVisitor.this._roleStartupFeatures.add(featureId);
                            }
                        }
                    });
                }
            });
        }

        public void handleEnd(ElementEndContext context) {
            if (this._id != null) {
                String name = this._name == null ? this._id : this._name;
                String description = this._description == null ? "" : this._description;
                this._role = new Role(this._id, name, description);
            }
        }

        public String getVersion() {
            return this._version;
        }

        public Role getRole() {
            return this._role;
        }

        public List<String> getExtensions() {
            return this._extensions;
        }

        public List<String> getRoleStartupFeatures() {
            return this._roleStartupFeatures;
        }
    }
}

