/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.extension.Role;
import oracle.ide.extension.RoleManager;
import oracle.ide.osgi.boot.api.CacheUtil;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.MnemonicSolver;
import oracle.ideimpl.extension.RoleManagerImpl;
import oracle.ideimpl.extension.RolePreferences;
import oracle.ideimpl.resource.RoleSelectionArb;
import oracle.javatools.dialogs.MessageDialog;

class RoleSelectionAddin
implements Addin {
    private static final float SECTION_SELECT_ROLE_STUDIO = 1.0f;
    private static final float SECTION_SELECT_ROLE_OTHERS = MenuConstants.increment(1.0f);
    private static final float SECTION_SHOW_ROLE_PROMPT = MenuConstants.increment(SECTION_SELECT_ROLE_OTHERS);
    private static final String ROLE_ACTION_ID_PREFIX = "oracle.ide.role.";
    private static final int PROMPT_AT_STARTUP_CMDID = Ide.findOrCreateCmdID("oracle.ide.role.promptAtStartup");
    private static final String SWITCH_ROLES_SUBMENU_KEY = "switch.roles.submenu";
    private RoleSwitchController _roleSwitchController = new RoleSwitchController();
    private final HashMap<String, Integer> _roleActionMap = new HashMap();

    RoleSelectionAddin() {
    }

    @Override
    public void initialize() {
        List<Role> list;
        if (!Boolean.getBoolean("ide.extension.noroles") && !(list = RoleSelectionAddin.getRoleManagerImpl().getRoles()).isEmpty()) {
            ArrayList<Role> roles = new ArrayList<Role>(list);
            roles.add(RoleManager.NO_ROLE);
            Collections.sort(roles);
            this.createRoleActions(roles);
            this.createPromptAction();
            new MnemonicSolver(this.getOrCreateSwitchRolesMenu()).solve();
        }
    }

    private void createRoleActions(List<Role> roles) {
        float weight = 1.0f;
        for (Role role : roles) {
            int cmdId = Ide.findOrCreateCmdID(ROLE_ACTION_ID_PREFIX + role.getId());
            this._roleActionMap.put(role.getId(), cmdId);
            IdeAction action = IdeAction.get(cmdId);
            action.addController(this._roleSwitchController);
            this.createRoleMenuItem(role, action, weight);
            weight += 0.1f;
        }
    }

    private void createRoleMenuItem(Role role, IdeAction action, float weight) {
        action.setName(role.getName());
        action.putValue("Category", "Tools");
        action.putValue("Radio", Boolean.TRUE);
        Menubar menubar = Ide.getMenubar();
        JMenuItem menuItem = menubar.createMenuItem(action, weight);
        action.putValue("ShortDescription", role.getDescription());
        float section = RoleManager.NO_ROLE == role ? 1.0f : SECTION_SELECT_ROLE_OTHERS;
        menubar.add(menuItem, this.getOrCreateSwitchRolesMenu(), section);
    }

    private void createPromptAction() {
        IdeAction showPromptAction = IdeAction.get(PROMPT_AT_STARTUP_CMDID);
        showPromptAction.addController(new PromtController());
        showPromptAction.setName(RoleSelectionArb.getString(1));
        showPromptAction.putValue("Category", "Tools");
        showPromptAction.putValue("Check", Boolean.TRUE);
        Menubar menubar = Ide.getMenubar();
        JMenuItem menuItem = menubar.createMenuItem(showPromptAction);
        menubar.add(menuItem, this.getOrCreateSwitchRolesMenu(), SECTION_SHOW_ROLE_PROMPT);
    }

    private JMenu getOrCreateSwitchRolesMenu() {
        Menubar menubar = Ide.getMenubar();
        JMenu switchMenu = Menubar.getJMenu(SWITCH_ROLES_SUBMENU_KEY);
        if (switchMenu == null) {
            String label = RoleSelectionArb.getString(0);
            float weight = MenuConstants.WEIGHT_TOOLS_PREFERENCES - 0.5f;
            switchMenu = menubar.createMenu(label, weight);
            Menubar.putJMenu(SWITCH_ROLES_SUBMENU_KEY, switchMenu);
            JMenu toolsMenu = Menubar.getJMenu("Tools");
            menubar.add(switchMenu, toolsMenu, Float.MAX_VALUE);
        }
        return switchMenu;
    }

    private void showExitRestartPrompt(Role newRole) {
        if (RoleSelectionAddin.confirmRestart(newRole)) {
            try {
                CacheUtil.invalidateCache(null);
                Ide.restart();
            }
            catch (UnsupportedOperationException uoe) {
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)IdeArb.getString(452), (String)IdeArb.getString(451), null);
            }
        }
    }

    private static boolean confirmRestart(Role newRole) {
        String prompt = RoleSelectionArb.format(2, newRole.getName());
        String help = RoleSelectionAddin.messageDetails(RoleSelectionArb.getString(3), newRole);
        return MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)RoleSelectionAddin.confirmation(prompt, help), (String)IdeArb.getString(449), null, (boolean)true);
    }

    private static String messageDetails(String message, Role newRole) {
        if (!RoleManager.NO_ROLE.equals(newRole)) {
            return message + RoleSelectionArb.getString(4);
        }
        return message;
    }

    private static JPanel confirmation(String message, String detail) {
        JLabel msgLabel = new JLabel(message);
        msgLabel.setFont(msgLabel.getFont().deriveFont(1));
        JMultiLineLabel detailMsgLabel = new JMultiLineLabel(detail);
        detailMsgLabel.setMaximumColumns(50);
        JPanel p = new JPanel(new BorderLayout(0, 20));
        p.add((Component)msgLabel, "North");
        p.add((Component)((Object)detailMsgLabel), "Center");
        return p;
    }

    private static RoleManagerImpl getRoleManagerImpl() {
        return (RoleManagerImpl)ExtensionRegistry.getExtensionRegistry().getRoleManager();
    }

    private String getActiveRoleId() {
        RolePreferences preferences = RoleSelectionAddin.getRoleManagerImpl().getRolePreferences();
        return preferences.getSelectedRoleId() != null ? preferences.getSelectedRoleId() : RoleManager.NO_ROLE.getId();
    }

    private static class PromtController
    implements Controller {
        private PromtController() {
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            if (PROMPT_AT_STARTUP_CMDID == action.getCommandId()) {
                RolePreferences rolePrefs;
                RoleManagerImpl roleManager = RoleSelectionAddin.getRoleManagerImpl();
                boolean showPrompt = (rolePrefs = roleManager.getRolePreferences()).isStartupRoleUIEnabled();
                rolePrefs.setStartupRoleUIEnabled(!showPrompt);
                roleManager.saveRolePreferences();
                return true;
            }
            return false;
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            if (PROMPT_AT_STARTUP_CMDID == action.getCommandId()) {
                action.setState(RoleSelectionAddin.getRoleManagerImpl().getRolePreferences().isStartupRoleUIEnabled());
                action.setEnabled(true);
                return true;
            }
            return false;
        }
    }

    private class RoleSwitchController
    implements Controller {
        private RoleSwitchController() {
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            if (RoleSelectionAddin.this._roleActionMap.values().contains(action.getCommandId())) {
                for (String roleId : RoleSelectionAddin.this._roleActionMap.keySet()) {
                    Integer roleCmdId = (Integer)RoleSelectionAddin.this._roleActionMap.get(roleId);
                    if (!Integer.valueOf(roleCmdId).equals(action.getCommandId())) continue;
                    if (!RoleSelectionAddin.this.getActiveRoleId().equals(roleId)) {
                        RoleManagerImpl roleManager = RoleSelectionAddin.getRoleManagerImpl();
                        roleManager.getRolePreferences().setSelectedRoleId(roleId);
                        roleManager.getRolePreferences().setRestartBecauseNewRoleSelected(true);
                        roleManager.saveRolePreferences();
                        RoleSelectionAddin.this.showExitRestartPrompt(this.lookupRoleName(roleId));
                    }
                    return true;
                }
            }
            return false;
        }

        private Role lookupRoleName(String roleId) {
            if (RoleManager.NO_ROLE.getId().equals(roleId)) {
                return RoleManager.NO_ROLE;
            }
            List<Role> roles = RoleSelectionAddin.getRoleManagerImpl().getRoles();
            for (Role role : roles) {
                if (!role.getId().equals(roleId)) continue;
                return role;
            }
            return null;
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            if (RoleSelectionAddin.this._roleActionMap.values().contains(action.getCommandId())) {
                String selectedRoleId = RoleSelectionAddin.this.getActiveRoleId();
                for (String role : RoleSelectionAddin.this._roleActionMap.keySet()) {
                    Integer roleCmdId = (Integer)RoleSelectionAddin.this._roleActionMap.get(role);
                    if (!Integer.valueOf(roleCmdId).equals(action.getCommandId())) continue;
                    boolean state = selectedRoleId.equals(role);
                    action.setState(state);
                    break;
                }
                action.setEnabled(true);
                return true;
            }
            return false;
        }
    }
}

