/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.help;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.TableModel;
import oracle.ideimpl.help.AboutTablePage;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class AboutPropertiesPage
extends AboutTablePage {
    public AboutPropertiesPage() {
        this.setName(IdeImplArb.getString(90));
    }

    @Override
    protected TableModel buildTableModel() {
        Vector data = new Vector(90);
        Vector<String> colNames = new Vector<String>(2);
        colNames.add(IdeImplArb.getString(91));
        colNames.add(IdeImplArb.getString(92));
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String propName = e.nextElement().toString();
            if (!this.isShown(propName)) continue;
            Vector<String> row = new Vector<String>(2);
            row.add(propName);
            String prop = System.getProperty(propName);
            if (propName.equals("line.separator") && prop != null) {
                StringBuffer newValue = new StringBuffer();
                block5: for (int i = 0; i < prop.length(); ++i) {
                    switch (prop.charAt(i)) {
                        case '\n': {
                            newValue.append("\\n");
                            continue block5;
                        }
                        case '\r': {
                            newValue.append("\\r");
                            continue block5;
                        }
                        default: {
                            newValue.append(prop.charAt(i));
                        }
                    }
                }
                prop = newValue.toString();
            }
            row.add(prop != null ? prop : IdeImplArb.getString(93));
            data.add(row);
        }
        this.buildRuntimeMemoryValues(data);
        return new GenericBaseTableModel(data, colNames){

            public Comparator getColumnSortComparator(int column) {
                return String.CASE_INSENSITIVE_ORDER;
            }
        };
    }

    private void buildRuntimeMemoryValues(Vector data) {
        Runtime runtime = Runtime.getRuntime();
        for (int i = 0; i < 3; ++i) {
            runtime.gc();
            runtime.runFinalization();
        }
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        memoryBean.gc();
        MemoryUsage mUsage = memoryBean.getHeapMemoryUsage();
        this.addData(data, "java.memory.heap.init", Long.toString(mUsage.getInit()));
        this.addData(data, "java.memory.heap.max", Long.toString(mUsage.getMax()));
        this.addData(data, "java.memory.heap.used", Long.toString(mUsage.getUsed()));
        mUsage = memoryBean.getNonHeapMemoryUsage();
        this.addData(data, "java.memory.nonheap.init", Long.toString(mUsage.getInit()));
        this.addData(data, "java.memory.nonheap.max", Long.toString(mUsage.getMax()));
        this.addData(data, "java.memory.nonheap.used", Long.toString(mUsage.getUsed()));
    }

    private void addData(Vector data, String name, Object value) {
        Vector<Object> row = new Vector<Object>(2);
        row.add(name);
        row.add(value);
        data.add(row);
    }

    private boolean isShown(String propertyName) {
        return !propertyName.toLowerCase().contains("password");
    }
}

