/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.property.PropertyPage;
import javax.ide.property.PropertyPageRegistry;
import javax.ide.property.spi.PropertyHook;
import javax.ide.property.spi.PropertyPageInfo;
import oracle.ide.config.IdeSettings;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ideimpl.jsr198.Util;
import oracle.ideimpl.jsr198.prefs.JavaxIdePreferences;
import oracle.ideimpl.jsr198.property.JavaxIdeNavigable;

public final class OraclePropertyPageRegistry
extends PropertyPageRegistry {
    public PropertyPage[] getPropertyPages(String objectClassName) {
        PropertyHook hook = (PropertyHook)ExtensionRegistry.getExtensionRegistry().getHook(PropertyHook.ELEMENT);
        Collection infos = hook.getPropertyPageInfos();
        ArrayList<PropertyPage> matchingPages = new ArrayList<PropertyPage>();
        for (PropertyPageInfo ppi : infos) {
            if (!objectClassName.equals(ppi.getObjectClass())) continue;
            PropertyPage page = (PropertyPage)Util.createInstance(ppi.getPageClass(), PropertyPage.class, "property page");
            matchingPages.add(page);
        }
        return matchingPages.toArray(new PropertyPage[matchingPages.size()]);
    }

    protected void initialize() {
        PropertyHook hook = (PropertyHook)ExtensionRegistry.getExtensionRegistry().getHook(PropertyHook.ELEMENT);
        Collection infos = hook.getPropertyPageInfos();
        HashMap<String, JavaxIdeNavigable> pages = new HashMap<String, JavaxIdeNavigable>();
        ArrayList<JavaxIdeNavigable> unresolvedChildren = new ArrayList<JavaxIdeNavigable>();
        ArrayList<JavaxIdeNavigable> topLevelPages = new ArrayList<JavaxIdeNavigable>();
        for (PropertyPageInfo info : infos) {
            JavaxIdeNavigable navigable = new JavaxIdeNavigable(info);
            pages.put(info.getPageClass().getClassName(), navigable);
            String parentClass = info.getParentPage();
            if (parentClass == null) {
                topLevelPages.add(navigable);
                continue;
            }
            JavaxIdeNavigable parent = (JavaxIdeNavigable)((Object)pages.get(parentClass));
            if (parent == null) {
                unresolvedChildren.add(navigable);
                continue;
            }
            parent.addChild(navigable);
        }
        for (JavaxIdeNavigable thisPage : unresolvedChildren) {
            String parentClass = thisPage.getInfo().getParentPage();
            JavaxIdeNavigable parent = (JavaxIdeNavigable)((Object)pages.get(parentClass));
            if (parent == null) {
                topLevelPages.add(thisPage);
                continue;
            }
            parent.addChild(thisPage);
        }
        for (JavaxIdeNavigable thisPage : topLevelPages) {
            if (thisPage.isProject()) {
                ProjectPropertiesDialog.addPanel(thisPage);
                continue;
            }
            IdeSettings.registerUI(thisPage);
        }
        JavaxIdePreferences.getPreferences();
    }
}

