/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.memwatch;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.util.IdeUtil;

final class ConfFileUtils {
    ConfFileUtils() {
    }

    private static boolean getDirectiveAndValue(String s, String[] directiveAndValue) {
        if ((s = s.trim()).length() > 0 && s.charAt(0) != '#') {
            int space = s.indexOf(32);
            int tab = s.indexOf(9);
            int i = space == -1 ? tab : (tab == -1 ? space : Math.min(space, tab));
            if (i != -1) {
                directiveAndValue[0] = s.substring(0, i).toLowerCase();
                directiveAndValue[1] = s.substring(i + 1).trim();
                return true;
            }
        }
        return false;
    }

    private static int skipWs(String s, int pos) {
        for (int i = pos; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> getConfIncludes(File file) {
        FileInputStream fis = null;
        ArrayList<String> incls = new ArrayList<String>();
        try {
            try {
                String s;
                fis = new FileInputStream(file);
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                String[] directiveAndValue = new String[2];
                while ((s = br.readLine()) != null) {
                    int pos = ConfFileUtils.skipWs(s, 0);
                    if (pos < 0 || !s.startsWith("IncludeConfFile", pos)) continue;
                    incls.add(s.substring(pos += "IncludeConfFile".length()).trim());
                }
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        catch (IOException e) {
            System.err.println("Failed to read " + file);
            e.printStackTrace();
        }
        return incls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String>[] getConfSettings(File file, String[] flags) {
        ArrayList[] settings = new ArrayList[flags.length];
        for (int i = 0; i < settings.length; ++i) {
            settings[i] = new ArrayList();
        }
        FileInputStream fis = null;
        try {
            try {
                String s;
                fis = new FileInputStream(file);
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                String[] directiveAndValue = new String[2];
                block6: while ((s = br.readLine()) != null) {
                    if (!ConfFileUtils.getDirectiveAndValue(s, directiveAndValue)) continue;
                    String directive = directiveAndValue[0];
                    String value = directiveAndValue[1];
                    if (!"addvmoption".equals(directive)) continue;
                    int i = 0;
                    while (true) {
                        if (i >= flags.length) continue block6;
                        if (value.startsWith(flags[i])) {
                            settings[i].add(value);
                            continue block6;
                        }
                        ++i;
                    }
                    break;
                }
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        catch (IOException e) {
            System.err.println("Failed to read " + file);
            e.printStackTrace();
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean updateConfSettings(File file, String flag, String newValue) {
        boolean success = false;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        BufferedWriter bw = null;
        try {
            String filePath = file.getAbsolutePath();
            File newFile = new File(filePath + ".new");
            try {
                String s;
                fis = new FileInputStream(file);
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                fos = new FileOutputStream(newFile);
                bw = new BufferedWriter(new OutputStreamWriter(fos));
                String[] directiveAndValue = new String[2];
                while ((s = br.readLine()) != null) {
                    if (ConfFileUtils.getDirectiveAndValue(s, directiveAndValue)) {
                        String directive = directiveAndValue[0];
                        String value = directiveAndValue[1];
                        if ("addvmoption".equals(directive) && value.startsWith(flag)) {
                            s = s.replace(value, newValue);
                        }
                    }
                    bw.write(s);
                    bw.newLine();
                }
                bw.flush();
                success = true;
            }
            catch (Throwable throwable) {
                IdeUtil.close(fis);
                IdeUtil.close(fos);
                IdeUtil.close(bw);
                throw throwable;
            }
            IdeUtil.close(fis);
            IdeUtil.close(fos);
            IdeUtil.close(bw);
            if (success) {
                success = file.delete();
            }
            if (success) {
                success = newFile.renameTo(file);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to update " + file);
            e.printStackTrace();
        }
        return success;
    }
}

