/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.memwatch;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;

final class JavaChecker {
    private static final String JAVA_CHECKER_STRING = "JAVAseemsTOwork";

    JavaChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkJava(String ... args) {
        boolean javaWorks = false;
        BufferedReader in = null;
        InputStreamReader err = null;
        try {
            URL topdir = URLFactory.newDirURL((String)System.getProperty("java.home"));
            URL dir = URLFactory.newDirURL((URL)topdir, (String)"bin");
            URL exec = JavaChecker.getJavaExecutableNoConsole(dir);
            URL classpath = JavaChecker.class.getProtectionDomain().getCodeSource().getLocation();
            URLPath cPath = new URLPath(classpath);
            String cName = JavaChecker.class.getName();
            if (!JavaChecker._pathValid(exec, cPath, cName)) {
                boolean bl = javaWorks;
                return bl;
            }
            ArrayList<String> argsList = new ArrayList<String>();
            argsList.add(URLFileSystem.getPlatformPathName((URL)exec));
            for (String arg : args) {
                argsList.add(arg);
            }
            argsList.add("-classpath");
            argsList.add(cPath.toString());
            argsList.add(cName);
            Process proc = Runtime.getRuntime().exec(argsList.toArray(new String[argsList.size()]));
            in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            err = new InputStreamReader(proc.getErrorStream());
            while (true) {
                if (err.ready()) {
                    char[] buf = new char[256];
                    int count = err.read(buf);
                    if (count <= 0) continue;
                    Assert.print((String)new String(buf, 0, count));
                    continue;
                }
                String line = in.readLine();
                if (JAVA_CHECKER_STRING.equals(line)) {
                    javaWorks = true;
                }
                if (line == null) break;
            }
        }
        catch (Throwable t) {
            System.err.println("Failed to create Java process");
            t.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ex) {}
            }
            if (err != null) {
                try {
                    err.close();
                }
                catch (Exception ex) {}
            }
        }
        return javaWorks;
    }

    private static URL getJavaExecutableNoConsole(URL dir) {
        String[] possibleJava = new String[]{"javaw.exe", "javaw", "java.exe", "java"};
        int length = possibleJava.length;
        for (int i = 0; i < length; ++i) {
            URL javaURL = URLFactory.newURL((URL)dir, (String)possibleJava[i]);
            if (!URLFileSystem.exists((URL)javaURL)) continue;
            return javaURL;
        }
        return null;
    }

    private static boolean _pathValid(URL exec, URLPath cPath, String cName) {
        return URLFileSystem.exists((URL)exec) && URLFileSystem.isRegularFile((URL)exec) && cPath.toQualifiedURL(cName.replace('.', '/') + ".class") != null;
    }

    public static void main(String[] args) {
        System.out.println(JAVA_CHECKER_STRING);
    }
}

